/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.index.generate.strategy;

import java.util.List;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.index.generate.bean.DimensionInfo;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.AggregateIndexTreeGenerateStrategy;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.AnalysisIndexTreeStrategy;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.CompleteSubjectIndexTreeStrategy;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.DetailPeriodStrategy;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.DimensionMemberScopeIndexTreeStrategy;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategy;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.InternalOffsetIndexTreeStrategy;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.MultiAnalysisOrgScopeStrategy;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.ReferencePeriodStrategy;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.ReportDataIndexTreeStrategy;
import kd.tmc.fpm.business.domain.model.report.AnalysisReport;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;

public class IndexTreeGenerateStrategyFactory {
    public static IndexTreeGenerateStrategy createReportDataStrategy(ReportDataSource reportDataSource, FundPlanSystem system) {
        Report report;
        IndexTreeGenerateStrategy strategy = new ReportDataIndexTreeStrategy(reportDataSource, system);
        if (reportDataSource.getReportPeriodType().getDetailPeriodType() != null) {
            strategy = new DetailPeriodStrategy(reportDataSource, system, strategy);
        }
        if (reportDataSource instanceof Report && (report = (Report)reportDataSource).getReferencePeriodMember() != null) {
            strategy = new ReferencePeriodStrategy(report, strategy);
        }
        return strategy;
    }

    public static IndexTreeGenerateStrategy createAggregateStrategy(List<DimensionInfo> dimensionInfos) {
        return new AggregateIndexTreeGenerateStrategy(dimensionInfos);
    }

    public static IndexTreeGenerateStrategy createDimensionMemberScopeStrategy(List<TemplateDim> dimMemberScope, FundPlanSystem system) {
        return new DimensionMemberScopeIndexTreeStrategy(dimMemberScope, system);
    }

    public static IndexTreeGenerateStrategy createCompleteSubjectStrategy(ReportDataSource reportDataSource, FundPlanSystem system) {
        Report report;
        IndexTreeGenerateStrategy strategy = new CompleteSubjectIndexTreeStrategy(reportDataSource, system);
        if (reportDataSource.getReportPeriodType().getDetailPeriodType() != null) {
            strategy = new DetailPeriodStrategy(reportDataSource, system, strategy);
        }
        if (reportDataSource instanceof Report && (report = (Report)reportDataSource).getReferencePeriodMember() != null) {
            strategy = new ReferencePeriodStrategy(report, strategy);
        }
        return strategy;
    }

    public static IndexTreeGenerateStrategy createInternalOffsetIndexTreeStrategy(FundPlanSystem fundPlanSystem) {
        return new InternalOffsetIndexTreeStrategy(fundPlanSystem);
    }

    public static IndexTreeGenerateStrategy getAnalysisReportDataStrategy(ReportDataSource reportDataSource, FundPlanSystem system) {
        IndexTreeGenerateStrategy analysisIndexTreeStrategy = new AnalysisIndexTreeStrategy(reportDataSource, system);
        if (reportDataSource.getReportPeriodType().getDetailPeriodType() != null) {
            analysisIndexTreeStrategy = new DetailPeriodStrategy(reportDataSource, system, analysisIndexTreeStrategy);
        }
        if (!(reportDataSource instanceof AnalysisReport)) {
            return analysisIndexTreeStrategy;
        }
        AnalysisReport analysisReport = (AnalysisReport)reportDataSource;
        if (analysisReport.getAnalysisReportType().isMulti()) {
            return new MultiAnalysisOrgScopeStrategy(analysisIndexTreeStrategy, analysisReport);
        }
        return analysisIndexTreeStrategy;
    }
}

