/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.index.generate.strategy;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.generate.bean.DimensionInfo;
import kd.tmc.fpm.business.domain.model.index.generate.bean.MemberInfo;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.AbstractTreeStrategy;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategy;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateReportType;

public class ReferencePeriodStrategy
extends AbstractTreeStrategy {
    private List<DimMember> referenceMemberList;
    private Report report;

    public ReferencePeriodStrategy(Report report, IndexTreeGenerateStrategy strategy) {
        super(strategy);
        PeriodMember referencePeriodMember = report.getReferencePeriodMember();
        this.referenceMemberList = Objects.isNull(referencePeriodMember) ? Collections.emptyList() : Collections.singletonList(referencePeriodMember);
        this.report = report;
    }

    @Override
    public List<List<DimensionInfo>> getDimensionGroupList() {
        return this.strategy.getDimensionGroupList();
    }

    @Override
    public List<MemberInfo> getDimMemberList(DimensionInfo dimension) {
        List<MemberInfo> memberList = this.strategy.getDimMemberList(dimension);
        if (dimension.getDimType() == DimensionType.PERIOD) {
            List referMemberInfoList = this.referenceMemberList.stream().map(MemberInfo::buildMember).collect(Collectors.toList());
            memberList.addAll(referMemberInfoList);
        }
        if (dimension.getDimType() == DimensionType.METRIC) {
            PeriodMember referencePeriodMember = this.report.getReferencePeriodMember();
            if (EmptyUtil.isEmpty((Object)referencePeriodMember)) {
                return memberList;
            }
            Long periodTypeId = referencePeriodMember.getPeriodTypeId();
            ReportTemplate template = this.report.getTemplate();
            List<TemplateReportType> reportTypeList = template.getReportTypeList();
            List memberInfoList = reportTypeList.stream().filter(rt -> Objects.equals(periodTypeId, rt.getReferenceReportTypeId())).map(TemplateReportType::getReferencePosList).filter(Objects::nonNull).flatMap(Collection::stream).map(MemberInfo::buildMember).collect(Collectors.toList());
            memberList.addAll(memberInfoList.stream().filter(memberInfo -> !memberList.contains(memberInfo)).collect(Collectors.toList()));
        }
        return memberList;
    }

    @Override
    public boolean buildSummaryReference() {
        return this.strategy.buildSummaryReference();
    }

    @Override
    public boolean isSummaryNode(MemberInfo memberInfo) {
        return this.strategy.isSummaryNode(memberInfo);
    }
}

