/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.inspection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;
import kd.tmc.fpm.business.utils.DataSetUtil;

public class BatchDataSet<T>
implements AutoCloseable {
    private DataSet dataSet;
    private int batchSize;
    private Class<T> clazz;

    public BatchDataSet(Class<T> clazz) {
        this(clazz, null);
    }

    public BatchDataSet(Class<T> clazz, DataSet dataSet) {
        this(clazz, dataSet, 1000);
    }

    public BatchDataSet(Class<T> clazz, DataSet dataSet, int batchSize) {
        this.dataSet = dataSet;
        this.batchSize = batchSize;
        this.clazz = clazz;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public void close() {
        DataSetUtil.closeDataSet(this.dataSet);
    }

    public List<T> getBatchData() {
        if (Objects.isNull(this.dataSet)) {
            return Collections.emptyList();
        }
        ArrayList<T> rowList = new ArrayList<T>(this.batchSize);
        for (int i = 0; i < this.batchSize && this.dataSet.hasNext(); ++i) {
            Row row = this.dataSet.next();
            rowList.add(ConverterUtils.convert(this.clazz, row));
        }
        return rowList;
    }

    public boolean hasNext() {
        return Objects.nonNull(this.dataSet) && this.dataSet.hasNext();
    }
}

