/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.inspection;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.inspection.PlanRecordInfo;

public class InspectControlResult {
    private String entityType;
    private PlanExecuteOpType planExecuteOpType;
    private Set<BillBizInfo> billBizInfos;
    private Set<PlanRecordInfo> planRecordInfos;

    public InspectControlResult(String entityType, PlanExecuteOpType planExecuteOpType) {
        this.entityType = entityType;
        this.planExecuteOpType = planExecuteOpType;
        this.billBizInfos = new HashSet<BillBizInfo>(128);
        this.planRecordInfos = new HashSet<PlanRecordInfo>(128);
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public PlanExecuteOpType getPlanExecuteOpType() {
        return this.planExecuteOpType;
    }

    public void setPlanExecuteOpType(PlanExecuteOpType planExecuteOpType) {
        this.planExecuteOpType = planExecuteOpType;
    }

    public Set<BillBizInfo> getBillBizInfos() {
        return this.billBizInfos;
    }

    public void setBillBizInfos(Set<BillBizInfo> billBizInfos) {
        this.billBizInfos = billBizInfos;
    }

    public Set<PlanRecordInfo> getPlanRecordInfos() {
        return this.planRecordInfos;
    }

    public void setPlanRecordInfos(Set<PlanRecordInfo> planRecordInfos) {
        this.planRecordInfos = planRecordInfos;
    }

    public void addBillBizInfo(BillBizInfo billBizInfo) {
        this.billBizInfos.add(billBizInfo);
    }

    public void addPlanRecordInfo(PlanRecordInfo planRecordInfo) {
        this.planRecordInfos.add(planRecordInfo);
    }

    public void addPlanRecordInfos(List<PlanRecordInfo> planRecordInfos) {
        if (EmptyUtil.isEmpty(planRecordInfos)) {
            return;
        }
        planRecordInfos.forEach(this::addPlanRecordInfo);
    }

    public boolean isError(BillBizInfo billBizInfo) {
        return this.billBizInfos.contains(billBizInfo);
    }

    public boolean hasError() {
        return EmptyUtil.isNoEmpty(this.billBizInfos) || EmptyUtil.isNoEmpty(this.planRecordInfos);
    }
}

