/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.inspection;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.helper.StringHelper;

public class InspectQueryParam {
    private Map<String, Object> params;

    public InspectQueryParam() {
        this(null);
    }

    public InspectQueryParam(Map<String, Object> params) {
        this.params = params;
        if (Objects.isNull(this.params)) {
            this.params = new HashMap<String, Object>(16);
        }
    }

    public InspectQueryParam addParam(String key, Object val) {
        if (EmptyUtil.isEmpty((String)key) || EmptyUtil.isEmpty((Object)val)) {
            return this;
        }
        this.params.put(key, val);
        return this;
    }

    public String getStringValue(String key) {
        return StringHelper.getStringValue((Object)this.params.get(key));
    }

    public Integer getIntValue(String key) {
        if (EmptyUtil.isEmpty((String)key)) {
            return 0;
        }
        Object o = this.params.get(key);
        if (EmptyUtil.isEmpty((Object)o)) {
            return 0;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        try {
            return Integer.parseInt(o.toString());
        }
        catch (Exception e) {
            return 0;
        }
    }

    public Date getDateValue(String key) {
        if (EmptyUtil.isEmpty((String)key)) {
            return null;
        }
        Object o = this.params.get(key);
        if (EmptyUtil.isEmpty((Object)o)) {
            return null;
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        return null;
    }

    public Long getLongValue(String key) {
        if (EmptyUtil.isEmpty((String)key)) {
            return 0L;
        }
        Object o = this.params.get(key);
        if (EmptyUtil.isEmpty((Object)o)) {
            return 0L;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        try {
            return Long.parseLong(o.toString());
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public <T> T getValue(String key) {
        if (EmptyUtil.isEmpty((String)key)) {
            return null;
        }
        return (T)this.params.get(key);
    }
}

