/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.match;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.DimensionMemberMappingParam;
import kd.tmc.fpm.business.domain.model.control.MatchMapping;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.match.MatchParam;
import kd.tmc.fpm.business.domain.model.match.MatchValue;
import kd.tmc.fpm.business.mvc.service.dimmapping.impl.DetailDimensionMappingManager;
import kd.tmc.fpm.business.mvc.service.dimmapping.impl.DimensionMemberMappingManager;
import org.apache.commons.collections4.MapUtils;

public class MatchInfo {
    private BillMatchRule matchRule;
    private BillBizInfo billBizInfo;
    private FundPlanSystem fundPlanSystem;
    private Long reportOrgId;
    private Set<Long> sumReportOrgIds = new HashSet<Long>(8);
    private Long subjectId;
    private Long currencyId;
    private Set<Long> periodMemIds = new HashSet<Long>(8);
    private List<MatchValue> optionalDimMatchValues = new ArrayList<MatchValue>(8);
    private List<MatchValue> detailDimMatchValues = new ArrayList<MatchValue>(8);
    private String uniqueId;
    private String mergeKey;
    private Long reportTypeId;
    private Map<DimensionType, Dimension> dimensionTypeDimensionMap = new HashMap<DimensionType, Dimension>(8);

    public BillMatchRule getMatchRule() {
        return this.matchRule;
    }

    public void setMatchRule(BillMatchRule matchRule) {
        this.matchRule = matchRule;
    }

    public BillBizInfo getBillBizInfo() {
        return this.billBizInfo;
    }

    public void setBillBizInfo(BillBizInfo billBizInfo) {
        this.billBizInfo = billBizInfo;
    }

    public FundPlanSystem getFundPlanSystem() {
        return this.fundPlanSystem;
    }

    public void setFundPlanSystem(FundPlanSystem fundPlanSystem) {
        this.fundPlanSystem = fundPlanSystem;
    }

    public Long getReportOrgId() {
        return this.reportOrgId;
    }

    public void setReportOrgId(Long reportOrgId) {
        this.reportOrgId = reportOrgId;
    }

    public void setSumReportOrgIds(Set<Long> sumReportOrgIds) {
        this.sumReportOrgIds = sumReportOrgIds;
    }

    public void addSumReportOrgId(Long reportOrgId) {
        this.sumReportOrgIds.add(reportOrgId);
    }

    public void clearSumReportOrgIds() {
        this.sumReportOrgIds.clear();
    }

    public Set<Long> getSumReportOrgIds() {
        return this.sumReportOrgIds;
    }

    public Long getSubjectId() {
        return this.subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public Long getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(Long currencyId) {
        this.currencyId = currencyId;
    }

    public Set<Long> getPeriodMemIds() {
        return this.periodMemIds;
    }

    public void setPeriodMemIds(Set<Long> periodMemIds) {
        this.periodMemIds = periodMemIds;
    }

    public List<MatchValue> getOptionalDimMatchValues() {
        return this.optionalDimMatchValues;
    }

    public void setOptionalDimMatchValues(List<MatchValue> optionalDimMatchValues) {
        this.optionalDimMatchValues = optionalDimMatchValues;
    }

    public List<MatchValue> getDetailDimMatchValues() {
        return this.detailDimMatchValues;
    }

    public void setDetailDimMatchValues(List<MatchValue> detailDimMatchValues) {
        this.detailDimMatchValues = detailDimMatchValues;
    }

    public String getMergeKey() {
        return this.mergeKey;
    }

    public void setMergeKey(String mergeKey) {
        this.mergeKey = mergeKey;
    }

    public Long getReportTypeId() {
        return this.reportTypeId;
    }

    public void setReportTypeId(Long reportTypeId) {
        this.reportTypeId = reportTypeId;
    }

    public Dimension getDimensionByType(DimensionType dimensionType) {
        if (dimensionType.isCustomDim()) {
            throw new UnsupportedOperationException();
        }
        if (MapUtils.isEmpty(this.dimensionTypeDimensionMap)) {
            this.dimensionTypeDimensionMap = this.fundPlanSystem.getMainDimList().stream().collect(Collectors.toMap(Dimension::getDimType, Function.identity(), (a, b) -> a));
        }
        return this.dimensionTypeDimensionMap.get((Object)dimensionType);
    }

    public static List<MatchInfo> getInstance(List<MatchParam> matchParamList) {
        ArrayList<MatchInfo> matchInfoList = new ArrayList<MatchInfo>(matchParamList.size());
        ArrayList optionalDimensionMemberMappingParamList = new ArrayList(matchParamList.size());
        ArrayList detailDimensionMemberMappingParamList = new ArrayList(matchParamList.size());
        DimensionMemberMappingManager dimensionMemberMappingManager = new DimensionMemberMappingManager();
        for (MatchParam matchParam : matchParamList) {
            MatchInfo matchInfo = new MatchInfo();
            matchInfoList.add(matchInfo);
            matchInfo.setUniqueId(matchParam.getUniqueId());
            matchInfo.setMatchRule(matchParam.getMatchRule());
            FundPlanSystem fundPlanSystem = matchParam.getFundPlanSystem();
            matchInfo.setFundPlanSystem(fundPlanSystem);
            matchInfo.setBillBizInfo(matchParam.getBillBizInfo());
            matchInfo.setReportOrgId(matchParam.getReportOrgId());
            matchInfo.setSubjectId(matchParam.getSubjectId());
            Map matchMappingMap = matchParam.getMatchRule().getMappings().stream().collect(Collectors.toMap(MatchMapping::getDimId, Function.identity(), (a, b) -> a));
            DimensionMemberMappingParam.DimensionMemberMappingParamBuilder builder = DimensionMemberMappingParam.builder();
            optionalDimensionMemberMappingParamList.add(builder.billMatchRule(matchParam.getMatchRule()).fundPlanSystem(fundPlanSystem).billBizInfo(matchParam.getBillBizInfo()).callBack((dimension, memberId) -> {
                if (dimension.getDimType().isCurrencyDim()) {
                    matchInfo.setCurrencyId((Long)memberId);
                    return;
                }
                if (dimension.getDimType().isPeriodDim()) {
                    matchInfo.getPeriodMemIds().add((Long)memberId);
                    return;
                }
                matchInfo.getOptionalDimMatchValues().add(new MatchValue((Dimension)dimension, memberId, ((MatchMapping)matchMappingMap.get(dimension.getId())).isSkipNullVal()));
            }).dimMatchListener(matchEvent -> {
                if (!matchEvent.getDimension().getDimType().isSystemDim()) {
                    MatchValue matchValue = new MatchValue(matchEvent.getDimension(), "", matchEvent.getOriginalStringValue(), matchEvent.getMatchMapping().isSkipNullVal());
                    matchValue.setMatched(false);
                    matchInfo.getOptionalDimMatchValues().add(matchValue);
                }
            }).build());
            fundPlanSystem.getMainDimList().stream().filter(dimension -> !dimension.getDimType().isOrgDim() && !dimension.getDimType().isSubjectDim()).map(Dimension::getId).forEach(dimensionMemberMappingManager::addDimensionId);
            DimensionMemberMappingParam.DimensionMemberMappingParamBuilder detailBuilder = DimensionMemberMappingParam.builder();
            Map dimMatchMappingMap = fundPlanSystem.getDetailDimList().stream().map(Dimension::getId).map(matchMappingMap::get).filter(Objects::nonNull).collect(Collectors.toMap(MatchMapping::getDimId, Function.identity(), (a, b) -> a));
            detailDimensionMemberMappingParamList.add(detailBuilder.billMatchRule(matchParam.getMatchRule()).fundPlanSystem(fundPlanSystem).billBizInfo(matchParam.getBillBizInfo()).callBack((dimension, memberId) -> {
                if (dimension.getDetailDimType() == DetailDimType.PLAN_AMOUNT) {
                    return;
                }
                matchInfo.getDetailDimMatchValues().add(new MatchValue((Dimension)dimension, memberId, ((MatchMapping)dimMatchMappingMap.get(dimension.getId())).isSkipNullVal()));
            }).dimMatchListener(matchEvent -> {
                if (!matchEvent.getDimension().getDimType().isDetailDim()) {
                    MatchValue matchValue = new MatchValue(matchEvent.getDimension(), "", matchEvent.getOriginalStringValue(), matchEvent.getMatchMapping().isSkipNullVal());
                    matchValue.setMatched(false);
                    matchInfo.getOptionalDimMatchValues().add(matchValue);
                }
            }).build());
        }
        dimensionMemberMappingManager.process(optionalDimensionMemberMappingParamList);
        new DetailDimensionMappingManager().matchAll().process(detailDimensionMemberMappingParamList);
        return matchInfoList;
    }

    public List<MatchInfo> splitWithReportType() {
        Dimension periodDim = this.getDimensionByType(DimensionType.PERIOD);
        Map reportTypeMemberIdMap = periodDim.getAllDimMemberList().stream().filter(dimMember -> this.periodMemIds.contains(dimMember.getId())).map(PeriodMember.class::cast).collect(Collectors.groupingBy(PeriodMember::getPeriodTypeId, Collectors.mapping(DimMember::getId, Collectors.toSet())));
        ArrayList<MatchInfo> matchInfoList = new ArrayList<MatchInfo>(reportTypeMemberIdMap.size());
        if (reportTypeMemberIdMap.size() <= 1) {
            this.setReportTypeId(reportTypeMemberIdMap.isEmpty() ? Long.valueOf(0L) : reportTypeMemberIdMap.keySet().iterator().next());
            return Collections.singletonList(this);
        }
        for (Map.Entry entry : reportTypeMemberIdMap.entrySet()) {
            MatchInfo copy = this.copy();
            copy.setPeriodMemIds(entry.getValue());
            copy.setReportTypeId(entry.getKey());
            matchInfoList.add(copy);
        }
        return matchInfoList;
    }

    public MatchInfo copy() {
        MatchInfo matchInfo = new MatchInfo();
        matchInfo.setMatchRule(this.matchRule);
        matchInfo.setBillBizInfo(this.billBizInfo);
        matchInfo.setFundPlanSystem(this.fundPlanSystem);
        matchInfo.setReportOrgId(this.reportOrgId);
        matchInfo.setSumReportOrgIds(new HashSet<Long>(this.sumReportOrgIds));
        matchInfo.setSubjectId(this.subjectId);
        matchInfo.setCurrencyId(this.currencyId);
        matchInfo.setPeriodMemIds(this.periodMemIds);
        matchInfo.setOptionalDimMatchValues(new ArrayList<MatchValue>(this.optionalDimMatchValues));
        matchInfo.setDetailDimMatchValues(new ArrayList<MatchValue>(this.detailDimMatchValues));
        matchInfo.setUniqueId(this.uniqueId);
        return matchInfo;
    }
}

