/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.match;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.index.BitMap;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.exception.match.MatchException;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class MatchResult {
    private BillBizInfo billBizInfo;
    private BillMatchRule matchRule;
    private ReportData reportData;
    private DimensionInfoBean dimensionInfoBean;
    private List<ReportData> matchedReportDataList;
    private List<ReportData> sameDimReportDataList;
    private List<ReportData> optionalReportDataList;
    private boolean accurateMatched;
    private BitMap<Long, Long> matchedDetailDim;
    private MatchException matchException;
    private Long reportPeriod;
    private String uniqueKey;
    private Long reportTypeId;
    private Set<Long> matchedReportDataIds;

    public MatchResult() {
        this(null, null);
    }

    public MatchResult(ReportData reportData, DimensionInfoBean dimensionInfoBean) {
        this(reportData, dimensionInfoBean, true);
    }

    public MatchResult(ReportData reportData, DimensionInfoBean dimensionInfoBean, boolean accurateMatched) {
        this.reportData = reportData;
        this.dimensionInfoBean = dimensionInfoBean;
        this.accurateMatched = accurateMatched;
        this.matchedReportDataList = new ArrayList<ReportData>(16);
        this.sameDimReportDataList = new ArrayList<ReportData>(16);
        this.matchedDetailDim = new BitMap(32);
        this.optionalReportDataList = new ArrayList<ReportData>(64);
        this.matchedReportDataIds = new HashSet<Long>(16);
    }

    public BillBizInfo getBillBizInfo() {
        return this.billBizInfo;
    }

    public void setBillBizInfo(BillBizInfo billBizInfo) {
        this.billBizInfo = billBizInfo;
    }

    public BillMatchRule getMatchRule() {
        return this.matchRule;
    }

    public void setMatchRule(BillMatchRule matchRule) {
        this.matchRule = matchRule;
    }

    public ReportData getReportData() {
        return this.reportData;
    }

    public void setReportData(ReportData reportData) {
        this.reportData = reportData;
    }

    public DimensionInfoBean getDimensionInfoBean() {
        return this.dimensionInfoBean;
    }

    public void setDimensionInfoBean(DimensionInfoBean dimensionInfoBean) {
        this.dimensionInfoBean = dimensionInfoBean;
    }

    public List<ReportData> getMatchedReportDataList() {
        return this.matchedReportDataList;
    }

    public void setMatchedReportDataList(List<ReportData> matchedReportDataList) {
        this.matchedReportDataList = matchedReportDataList;
    }

    public List<ReportData> getSameDimReportDataList() {
        return this.sameDimReportDataList;
    }

    public void setSameDimReportDataList(List<ReportData> sameDimReportDataList) {
        this.sameDimReportDataList = sameDimReportDataList;
    }

    public boolean isAccurateMatched() {
        return this.accurateMatched;
    }

    public void setAccurateMatched(boolean accurateMatched) {
        this.accurateMatched = accurateMatched;
    }

    public BitMap<Long, Long> getMatchedDetailDim() {
        return this.matchedDetailDim;
    }

    public void setMatchedDetailDim(BitMap<Long, Long> matchedDetailDim) {
        this.matchedDetailDim = matchedDetailDim;
    }

    public MatchException getMatchException() {
        return this.matchException;
    }

    public void setMatchException(MatchException matchException) {
        this.matchException = matchException;
    }

    public boolean isSuccess() {
        return Objects.isNull((Object)this.matchException);
    }

    public String getErrorMsg() {
        if (Objects.isNull((Object)this.matchException)) {
            return "";
        }
        return this.matchException.getErrorMsg();
    }

    public void addMatchedReportData(ReportData reportData) {
        this.addMatchedReportDataList(Collections.singletonList(reportData));
    }

    public void addMatchedReportDataList(List<ReportData> reportDataList) {
        reportDataList.forEach(rd -> {
            if (this.matchedReportDataIds.add(rd.getId())) {
                this.matchedReportDataList.add((ReportData)rd);
            }
        });
    }

    public void addSameDimReportData(ReportData reportData) {
        this.addSameDimReportDataList(Collections.singletonList(reportData));
    }

    public void addSameDimReportDataList(List<ReportData> reportDataList) {
        reportDataList.forEach(rd -> {
            if (!this.matchedReportDataIds.contains(rd.getId())) {
                this.sameDimReportDataList.add((ReportData)rd);
            }
        });
    }

    public Long getReportPeriod() {
        return this.reportPeriod;
    }

    public void setReportPeriod(Long reportPeriod) {
        this.reportPeriod = reportPeriod;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public void setUniqueKey(String uniqueKey) {
        this.uniqueKey = uniqueKey;
    }

    public Long getReportTypeId() {
        return this.reportTypeId;
    }

    public void setReportTypeId(Long reportTypeId) {
        this.reportTypeId = reportTypeId;
    }

    public List<ReportData> getOptionalReportDataList() {
        return this.optionalReportDataList;
    }

    public void setOptionalReportDataList(List<ReportData> optionalReportDataList) {
        this.optionalReportDataList = optionalReportDataList;
    }

    public void addOptionalReportData(ReportData reportData) {
        if (!this.matchedReportDataIds.contains(reportData.getId())) {
            this.optionalReportDataList.add(reportData);
        }
    }

    public Set<Long> getMatchedReportDataIds() {
        return Collections.unmodifiableSet(this.matchedReportDataIds);
    }

    public boolean isMatchedDetail() {
        return Objects.nonNull(this.matchedDetailDim) && !this.matchedDetailDim.isEmpty();
    }

    public String toString() {
        return "MatchResult{billBizInfo=" + this.billBizInfo.getBillNo() + ", matchRule=" + this.matchRule.getNumber() + ", reportData=" + (Objects.nonNull(this.reportData) ? this.reportData.getId() : "") + ", dimensionInfoBean=" + this.dimensionInfoBean + ", matchedDetailDim=" + this.isMatchedDetail() + ", matchException=" + (Objects.nonNull((Object)this.matchException) ? this.matchException.getErrorMsg() : "") + ", reportPeriod=" + this.reportPeriod + ", uniqueKey='" + this.uniqueKey + '\'' + ", reportTypeId=" + this.reportTypeId + '}';
    }
}

