/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AnalysisReportType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.generate.DimensionIndexTreeGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategy;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategyFactory;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.utils.FpmAssertUtil;

public class AnalysisReport
extends Report {
    private static final Log logger = LogFactory.getLog(AnalysisReport.class);
    private Long reportCurrency;
    private String flow;
    private Map<Long, Long> subjectMapSubjectFlowDimMap = new HashMap<Long, Long>(32);
    private Dimension subjectFlowDim;
    private AnalysisReportType analysisReportType;
    private List<Long> sumDimensionIds = new ArrayList<Long>(2);
    private boolean needSum;
    private Long statisticsDim;

    public Long getReportCurrency() {
        return this.reportCurrency;
    }

    public void setReportCurrency(Long reportCurrency) {
        this.reportCurrency = reportCurrency;
    }

    public Map<Long, Long> getSubjectMapSubjectFlowDimMap() {
        return this.subjectMapSubjectFlowDimMap;
    }

    public void setSubjectMapSubjectFlowDimMap(Map<Long, Long> subjectMapSubjectFlowDimMap) {
        this.subjectMapSubjectFlowDimMap = subjectMapSubjectFlowDimMap;
    }

    public Dimension getSubjectFlowDim() {
        return this.subjectFlowDim;
    }

    public void setSubjectFlowDim(Dimension subjectFlowDim) {
        this.subjectFlowDim = subjectFlowDim;
    }

    public void addSubjectMapSubjectFlowDim(Long subjectMemId, Long subjectFlowMemId) {
        this.subjectMapSubjectFlowDimMap.putIfAbsent(subjectMemId, subjectFlowMemId);
    }

    public AnalysisReportType getAnalysisReportType() {
        return this.analysisReportType;
    }

    public void setAnalysisReportType(AnalysisReportType analysisReportType) {
        this.analysisReportType = analysisReportType;
    }

    public boolean isContainDetailReportType() {
        return Objects.nonNull((Object)this.getReportPeriodType().getDetailPeriodType());
    }

    public String getFlow() {
        return this.flow;
    }

    public void setFlow(String flow) {
        this.flow = flow;
    }

    public boolean isNeedSum() {
        return this.needSum;
    }

    public boolean isNotNeedSum() {
        return !this.needSum;
    }

    public void setNeedSum(boolean needSum) {
        this.needSum = needSum;
    }

    public AnalysisReport addSumDimensionId(Long dimensionId) {
        this.sumDimensionIds.add(dimensionId);
        return this;
    }

    public boolean needClean() {
        return this.isNotNeedSum() && EmptyUtil.isNoEmpty(this.sumDimensionIds);
    }

    public List<Long> getSumDimensionIds() {
        return this.sumDimensionIds;
    }

    public void setSumDimensionIds(List<Long> sumDimensionIds) {
        this.sumDimensionIds = sumDimensionIds;
    }

    @Override
    public DimensionIndexTree getIndexTree(FundPlanSystem system) {
        if (this.indexTree == null) {
            IndexTreeGenerateStrategy strategy = IndexTreeGenerateStrategyFactory.getAnalysisReportDataStrategy(this, system);
            DimensionIndexTreeGenerator generator = new DimensionIndexTreeGenerator(strategy);
            this.indexTree = generator.build();
            List<ReportData> mountReportDataList = this.getReportDataList().stream().filter(o -> !o.isAuxiliaryInfo()).collect(Collectors.toList());
            this.mountReportData(mountReportDataList);
        }
        return this.indexTree;
    }

    @Override
    public void mountReportData(List<ReportData> mountReportDataList) {
        Set<Long> pageDimIds = this.template.getPageDimList().stream().map(TemplateDim::getDimensionId).collect(Collectors.toSet());
        for (ReportData reportData : mountReportDataList) {
            List<TemplateDim> dimList = reportData.getDimList();
            DimensionInfoBean dimensionInfoBean = new DimensionInfoBean();
            List<Object> dataDimValList = reportData.getDimValList();
            for (int i = 0; i < dimList.size(); ++i) {
                TemplateDim templateDim = dimList.get(i);
                if (templateDim.getDimType().isDetailDim() || this.needIgnore(templateDim, pageDimIds)) continue;
                dimensionInfoBean.addDimensionInfo(templateDim.getDimensionId(), dataDimValList.get(i));
            }
            try {
                TreeNode node = this.indexTree.find(dimensionInfoBean);
                if (node == null) continue;
                node.addData(reportData);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean needIgnore(TemplateDim templateDim, Set<Long> pageDimIds) {
        if (!pageDimIds.contains(templateDim.getDimensionId())) {
            return false;
        }
        if (this.isNotNeedSum() && this.sumDimensionIds.contains(templateDim.getDimensionId())) {
            logger.debug("\u7ef4\u5ea6\uff1a{}\u662f\u9875\u9762\u7ef4\uff0c\u4f46\u9700\u8981\u6c47\u603b\uff0c\u6b64\u65f6\u4e0d\u5ffd\u7565\u6b64\u9875\u9762\u7ef4\u5ea6", (Object)templateDim.getDimensionName());
            return false;
        }
        logger.debug("\u5ffd\u7565\u9875\u9762\u7ef4\u5ea6\uff1a{}", (Object)templateDim.getDimensionName());
        return true;
    }

    @Override
    public List<TreeNode> getTreeNodeList(List<ReportData> reportDataList) {
        FpmAssertUtil.isNotNull((Object)this.indexTree, (String)"indexTree is not initialized");
        Set pageDimIds = this.template.getPageDimList().stream().map(TemplateDim::getDimensionId).collect(Collectors.toSet());
        return reportDataList.stream().map(rd -> DimensionInfoHelper.getDimensionInfoBean(rd, this.template, td -> pageDimIds.contains(td.getDimensionId()))).distinct().map(this.indexTree::find).collect(Collectors.toList());
    }

    public Long getStatisticsDim() {
        return this.statisticsDim;
    }

    public void setStatisticsDim(Long statisticsDim) {
        this.statisticsDim = statisticsDim;
    }
}

