/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.report;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.generate.DimensionIndexTreeGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategy;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategyFactory;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateReportType;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import org.apache.commons.collections.CollectionUtils;

public class PlanChangeReport
implements ReportDataSource,
Serializable {
    private Long reportId;
    private Long reportPeriodId;
    protected List<ReportData> reportDataList;
    protected ReportTemplate template;
    protected ReportPeriodType reportPeriodType;
    private List<PeriodMember> periodMemberList;
    private BillStatus recordBillStatus;
    private Map<Long, Integer> reportIndexMap;
    private transient DimensionIndexTree indexTree;
    private int newDataStartRow;
    private int sourceReportTotalRowSize;

    public PlanChangeReport() {
        this.reportDataList = new ArrayList<ReportData>(16);
    }

    public PlanChangeReport(Report report) {
        this.reportId = report.getId();
        this.template = report.getTemplate();
        this.reportPeriodType = report.getReportPeriodType();
        this.reportPeriodId = report.getPeriodMemberList().get(0).getId();
        List<ReportData> reportDataList = report.getReportDataList();
        this.reportIndexMap = new HashMap<Long, Integer>(reportDataList.size());
        if (CollectionUtils.isNotEmpty(reportDataList)) {
            this.reportDataList = reportDataList;
            for (int i = 0; i < reportDataList.size(); ++i) {
                ReportData reportData = reportDataList.get(i);
                this.reportIndexMap.put(reportData.getId(), i);
            }
        }
        if (Objects.isNull(this.reportDataList)) {
            this.reportDataList = new ArrayList<ReportData>(16);
        }
        this.setSourceReportTotalRowSize(report);
    }

    public Long getReportId() {
        return this.reportId;
    }

    public void setReportId(Long reportId) {
        this.reportId = reportId;
    }

    @Override
    public List<ReportData> getReportDataList() {
        return this.reportDataList;
    }

    public void setReportDataList(List<ReportData> reportDataList) {
        this.reportDataList = reportDataList;
    }

    @Override
    public ReportTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(ReportTemplate template) {
        this.template = template;
    }

    @Override
    public ReportPeriodType getReportPeriodType() {
        return this.reportPeriodType;
    }

    public void setReportPeriodType(ReportPeriodType reportPeriodType) {
        this.reportPeriodType = reportPeriodType;
    }

    public Long getReportPeriodId() {
        return this.reportPeriodId;
    }

    public void setReportPeriodId(Long reportPeriodId) {
        this.reportPeriodId = reportPeriodId;
    }

    public Map<Long, Integer> getReportIndexMap() {
        return this.reportIndexMap;
    }

    @Override
    public List<PeriodMember> getPeriodMemberList() {
        return this.periodMemberList;
    }

    @Override
    public List<PeriodMember> getCurrentAllPeriodMembers() {
        return this.periodMemberList;
    }

    public void setPeriodMemberList(List<PeriodMember> periodMemberList) {
        this.periodMemberList = periodMemberList;
    }

    public BillStatus getRecordBillStatus() {
        return this.recordBillStatus;
    }

    public void setRecordBillStatus(BillStatus recordBillStatus) {
        this.recordBillStatus = recordBillStatus;
    }

    public int getNewDataStartRow() {
        return this.newDataStartRow;
    }

    public void setNewDataStartRow(int newDataStartRow) {
        this.newDataStartRow = newDataStartRow;
    }

    public int getSourceReportTotalRowSize() {
        return this.sourceReportTotalRowSize;
    }

    public void setSourceReportTotalRowSize(int sourceReportTotalRowSize) {
        this.sourceReportTotalRowSize = sourceReportTotalRowSize;
    }

    public final void setSourceReportTotalRowSize(Report report) {
        if (report == null || report.getTemplate() == null || !report.getTemplate().getTemplateType().isDetail()) {
            return;
        }
        this.sourceReportTotalRowSize = report.getTemplate().getTotalRow();
    }

    @Override
    public DimensionIndexTree getIndexTree(FundPlanSystem system) {
        if (this.indexTree == null) {
            IndexTreeGenerateStrategy strategy = IndexTreeGenerateStrategyFactory.createReportDataStrategy(this, system);
            DimensionIndexTreeGenerator generator = new DimensionIndexTreeGenerator(strategy);
            this.indexTree = generator.build();
            List mountReportDataList = this.getReportDataList().stream().filter(o -> !o.isAuxiliaryInfo()).collect(Collectors.toList());
            for (ReportData reportData : mountReportDataList) {
                ArrayList<Long> dimIdList = new ArrayList<Long>(reportData.getDimList().size());
                ArrayList<Object> dimMemIdList = new ArrayList<Object>(reportData.getDimList().size());
                List<Object> prepareDatas = reportData.getDimValList();
                for (int inx = 0; inx < reportData.getDimList().size(); ++inx) {
                    TemplateDim templateDim = reportData.getDimList().get(inx);
                    if (templateDim.getDimType() == DimensionType.DETAILDIM) continue;
                    dimIdList.add(templateDim.getDimensionId());
                    dimMemIdList.add(prepareDatas.get(inx));
                }
                DimensionInfoBean dimensionInfoBean = new DimensionInfoBean();
                dimensionInfoBean.setDimensionIdList(dimIdList);
                dimensionInfoBean.setMemberIdList(dimMemIdList);
                TreeNode node = this.indexTree.find(dimensionInfoBean);
                if (node == null) continue;
                node.addData(reportData);
            }
        }
        return this.indexTree;
    }

    public void clearIndexTree() {
        this.indexTree = null;
    }

    public void calNewDataStartRowIfDetailTemplate(List<ReportData> sourceReportDataList, Set<Long> currReportPeriodSet) {
        if (this.template.getTemplateType() != TemplateType.DETAIL) {
            return;
        }
        boolean hasDetailPeriod = this.reportPeriodType.getDetailPeriodType() != null;
        int dataStartRow = this.template.getDataStartRow(hasDetailPeriod) + this.template.getTotalRow() + 1;
        if (CollectionUtils.isEmpty(sourceReportDataList)) {
            this.newDataStartRow = dataStartRow;
            return;
        }
        int periodDimIdx = -1;
        for (ReportData reportData : sourceReportDataList) {
            Long periodMemberId;
            if (reportData.isAuxiliaryInfo()) continue;
            if (periodDimIdx < 0) {
                List<TemplateDim> dimList = reportData.getDimList();
                periodDimIdx = IntStream.range(0, dimList.size()).filter(i -> ((TemplateDim)dimList.get(i)).getDimType() == DimensionType.PERIOD).findAny().orElse(-1);
            }
            if (!currReportPeriodSet.contains(periodMemberId = (Long)reportData.getDimValList().get(periodDimIdx))) continue;
            dataStartRow = Math.max(dataStartRow, reportData.getRow() + 2);
        }
        this.newDataStartRow = dataStartRow;
    }

    public PeriodMember getCurrentReportPeriod() {
        return this.getPeriodMemberList().get(0);
    }

    public List<PeriodMember> getCurrentReportPeriodDetailIfHasDetail() {
        List<PeriodMember> currentReportPeriodDetail = this.getCurrentReportPeriodDetail();
        return EmptyUtil.isEmpty(currentReportPeriodDetail) ? Collections.singletonList(this.getCurrentReportPeriod()) : currentReportPeriodDetail;
    }

    public List<PeriodMember> getCurrentReportPeriodDetail() {
        ReportPeriodType periodType = this.getReportPeriodType();
        if (periodType == null || periodType.getDetailPeriodType() == null) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        return this.getPeriodMemberList().get(0).getAllChildMember().stream().map(item -> (PeriodMember)item).collect(Collectors.toList());
    }

    public boolean isRollContainsDetail() {
        if (this.periodMemberList.size() <= 1 && !this.reportPeriodType.isRoll()) {
            return false;
        }
        if (EmptyUtil.isEmpty((Object)((Object)this.reportPeriodType.getDetailPeriodType()))) {
            return false;
        }
        if (Objects.isNull(this.template)) {
            return false;
        }
        List<TemplateReportType> reportTypeList = this.template.getReportTypeList();
        if (EmptyUtil.isEmpty(reportTypeList)) {
            return true;
        }
        Optional<TemplateReportType> first = reportTypeList.stream().filter(rt -> Objects.equals(this.reportPeriodType.getReportPeriodId(), rt.getReportTypeId())).findFirst();
        if (!first.isPresent()) {
            return false;
        }
        TemplateReportType templateReportType = first.get();
        return templateReportType.isRollContainsDetail();
    }

    public Set<Long> getAllPeriodMemberIds() {
        Set<Long> periodMemberIds = this.periodMemberList.stream().map(DimMember::getId).collect(Collectors.toSet());
        if (this.periodMemberList.size() == 1) {
            periodMemberIds.addAll(this.getCurrentReportPeriodDetail().stream().map(DimMember::getId).collect(Collectors.toSet()));
            return periodMemberIds;
        }
        if (Objects.isNull((Object)this.reportPeriodType.getDetailPeriodType())) {
            return periodMemberIds;
        }
        if (this.isRollContainsDetail()) {
            periodMemberIds.addAll(this.periodMemberList.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).map(DimMember::getId).collect(Collectors.toSet()));
            return periodMemberIds;
        }
        periodMemberIds.addAll(this.getCurrentReportPeriodDetail().stream().map(DimMember::getId).collect(Collectors.toSet()));
        return periodMemberIds;
    }

    public List<PeriodMember> loadCurrentAllPeriodMembers() {
        if (Objects.isNull((Object)this.reportPeriodType.getDetailPeriodType())) {
            return this.periodMemberList.stream().sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList());
        }
        if (!this.isRollContainsDetail()) {
            PeriodMember currPeriodMember = this.periodMemberList.get(0);
            List result = currPeriodMember.getAllChildMember().stream().map(PeriodMember.class::cast).collect(Collectors.toList());
            result.addAll(this.periodMemberList.subList(1, this.periodMemberList.size()));
            return result.stream().sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList());
        }
        return this.periodMemberList.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).map(PeriodMember.class::cast).sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList());
    }
}

