/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.report;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;

public class RelationDimensionShrekDimMap {
    private FundPlanSystem system;
    private String cubName;
    private Map<String, Long> dimShrekKeyMap;
    private Map<Long, Dimension> dimensionMap;
    private Map<Long, Map<String, Long>> dimMemberShrekKeyMap;
    private Map<Long, DimMember> dimMemberMap;

    private RelationDimensionShrekDimMap(FundPlanSystem system) {
        this.system = system;
        this.cubName = system.getShrekKey();
        this.dimShrekKeyMap = new HashMap<String, Long>(16);
        this.dimensionMap = new HashMap<Long, Dimension>(16);
        this.dimMemberShrekKeyMap = new HashMap<Long, Map<String, Long>>(512);
        this.dimMemberMap = new HashMap<Long, DimMember>(16);
        this.init();
    }

    public static RelationDimensionShrekDimMap getInstance(FundPlanSystem system) {
        return new RelationDimensionShrekDimMap(system);
    }

    private void init() {
        List<Dimension> mainDimList = this.system.getMainDimList();
        for (Dimension dimension : mainDimList) {
            String shrekKey = dimension.getShrekKey();
            Long dimensionId = dimension.getId();
            this.dimShrekKeyMap.putIfAbsent(shrekKey, dimensionId);
            this.dimensionMap.putIfAbsent(dimensionId, dimension);
            List<DimMember> allDimMemberList = dimension.getAllDimMemberList();
            for (DimMember dimMember : allDimMemberList) {
                String memberShrekKey = dimMember.getShrekKey();
                Long dimMemberId = dimMember.getId();
                Map shrekDimMemberMap = this.dimMemberShrekKeyMap.computeIfAbsent(dimMember.getDimensionId(), k -> new HashMap(64));
                shrekDimMemberMap.putIfAbsent(memberShrekKey, dimMemberId);
                this.dimMemberMap.putIfAbsent(dimMemberId, dimMember);
            }
        }
    }

    public String getCubName() {
        return this.cubName;
    }

    public static Set<String> getMultiCustomAddDims() {
        HashSet<String> strings = new HashSet<String>(8);
        strings.add("amountunit");
        strings.add("maintable");
        strings.add("version");
        strings.add("ReportPeriodDim");
        return Collections.unmodifiableSet(strings);
    }

    public static boolean isMultiCustomAddDim(String shrekKey) {
        return RelationDimensionShrekDimMap.getMultiCustomAddDims().contains(shrekKey);
    }

    public static boolean isMultiCustomAddReportPeriodDim(String shrekKey) {
        return Objects.equals(shrekKey, "ReportPeriodDim");
    }

    public static boolean isMultiCustomAddReportMainTableDim(String shrekKey) {
        return Objects.equals(shrekKey, "maintable");
    }

    public static boolean isMultiCustomAddReportAmountUnitDim(String shrekKey) {
        return Objects.equals(shrekKey, "amountunit");
    }

    public static boolean isMultiCustomAddReportVersionDim(String shrekKey) {
        return Objects.equals(shrekKey, "version");
    }

    public Dimension getRelationDimension(String shrekKey) {
        Long dimensionId = this.dimShrekKeyMap.get(shrekKey);
        if (EmptyUtil.isEmpty((Long)dimensionId)) {
            return null;
        }
        return this.getDimension(dimensionId);
    }

    public TemplateDim getRelationTemplateDimension(String shrekKey) {
        Long dimensionId = this.dimShrekKeyMap.get(shrekKey);
        if (EmptyUtil.isEmpty((Long)dimensionId)) {
            return null;
        }
        Dimension dimension = this.getDimension(dimensionId);
        if (Objects.isNull(dimension)) {
            return null;
        }
        TemplateDim templateDim = new TemplateDim();
        templateDim.setDimensionId(dimension.getId());
        templateDim.setDimType(dimension.getDimType());
        templateDim.setDetailDimType(dimension.getDetailDimType());
        templateDim.setDimensionName(dimension.getName());
        return templateDim;
    }

    public Dimension getDimension(Long dimensionId) {
        Dimension dimension = this.dimensionMap.get(dimensionId);
        if (Objects.isNull(dimension)) {
            return null;
        }
        return dimension.copy();
    }

    public String getMultiDimKey(Long dimensionId) {
        Dimension dimension = this.dimensionMap.get(dimensionId);
        if (Objects.isNull(dimension)) {
            return "";
        }
        return dimension.getShrekKey();
    }

    public DimMember getRelationDimMember(Long dimensionId, String shrekKey) {
        Long dimMemberId = (Long)this.dimMemberShrekKeyMap.getOrDefault(dimensionId, Collections.emptyMap()).get(shrekKey);
        if (EmptyUtil.isEmpty((Long)dimMemberId)) {
            return null;
        }
        return this.getDimMember(dimMemberId);
    }

    public Long getRelationDimMemberId(Long dimensionId, String shrekKey) {
        return this.dimMemberShrekKeyMap.getOrDefault(dimensionId, Collections.emptyMap()).getOrDefault(shrekKey, 0L);
    }

    public DimMember getDimMember(Long dimMemberId) {
        DimMember dimMember = this.dimMemberMap.get(dimMemberId);
        if (Objects.isNull(dimMember)) {
            return null;
        }
        return dimMember;
    }

    public String getMultiDimMemberKey(Long memberId) {
        DimMember dimMember = this.dimMemberMap.get(memberId);
        if (Objects.isNull(dimMember)) {
            return "";
        }
        return dimMember.getShrekKey();
    }

    public Long getSystemId() {
        return this.system.getId();
    }

    public FundPlanSystem getSystem() {
        return this.system;
    }

    public Map<Long, Dimension> copyDimensionMap() {
        return new HashMap<Long, Dimension>(this.dimensionMap);
    }
}

