/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.sumplan;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.sumplan.EvalDimensionCombination;

public class EvalDimensionCombinationCurrencyMap
implements Serializable {
    private EvalDimensionCombination combination;
    private Long currencyId;
    private List<Long> currencyIdList;

    public EvalDimensionCombinationCurrencyMap() {
    }

    public EvalDimensionCombinationCurrencyMap(EvalDimensionCombination combination, Long currencyId, List<Long> currencyIdList) {
        this.combination = combination;
        this.currencyId = currencyId;
        this.currencyIdList = currencyIdList;
    }

    public EvalDimensionCombination getCombination() {
        return this.combination;
    }

    public void setCombination(EvalDimensionCombination combination) {
        this.combination = combination;
    }

    public Long getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(Long currencyId) {
        this.currencyId = currencyId;
    }

    public List<Long> getCurrencyIdList() {
        return this.currencyIdList;
    }

    public void setCurrencyIdList(List<Long> currencyIdList) {
        this.currencyIdList = currencyIdList;
    }

    public EvalDimensionCombination getConvertEvalDimensionCombination(EvalDimensionCombination dimensionCombination) {
        Long targetCurrencyId = this.currencyId;
        Object sourceCurrencyId = dimensionCombination.getEvalDimensionValList().stream().filter(val -> val.getDimensionType() == DimensionType.CURRENCY).findFirst().get().getValue();
        if (Objects.equals(targetCurrencyId, sourceCurrencyId) || this.currencyIdList.contains(sourceCurrencyId)) {
            return this.combination.copy(t -> {
                if (t.getDimensionType() == DimensionType.CURRENCY) {
                    t.setValue(targetCurrencyId);
                }
            });
        }
        return null;
    }

    public Map<EvalDimensionCombination, EvalDimensionCombinationCurrencyMap> currencyMapEntity(boolean containsSourceCurrency) {
        HashMap<EvalDimensionCombination, EvalDimensionCombinationCurrencyMap> currencyMapMap = new HashMap<EvalDimensionCombination, EvalDimensionCombinationCurrencyMap>(this.currencyIdList.size() + 1);
        for (Long currencyId : this.currencyIdList) {
            currencyMapMap.put(this.combination.copy(t -> {
                if (t.getDimensionType() == DimensionType.CURRENCY) {
                    t.setValue(currencyId);
                }
            }), this);
        }
        if (containsSourceCurrency) {
            currencyMapMap.put(this.combination, this);
        }
        return currencyMapMap;
    }
}

