/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.template;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.enums.TemplateSmartGetValSetType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.template.AuxiliaryField;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateBaseInfo;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateLayout;
import kd.tmc.fpm.business.domain.model.template.TemplateMetric;
import kd.tmc.fpm.business.domain.model.template.TemplateReportType;
import kd.tmc.fpm.business.domain.model.template.TemplateShowConfig;
import kd.tmc.fpm.business.helper.TemplateInfoHelper;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ReportTemplate
implements Serializable {
    public static final int MAX_DIM_LEVEL = 3;
    private long id;
    private long copyId;
    private Long systemId;
    private List<TemplateDim> rowDimList = new ArrayList<TemplateDim>(4);
    private List<TemplateDim> colDimList = new ArrayList<TemplateDim>(4);
    private List<TemplateDim> pageDimList = new ArrayList<TemplateDim>(4);
    private TemplateDim metricTplDim;
    private TemplateLayout dimLayout;
    private boolean showcombine;
    private boolean distinguish;
    private boolean remarkVisible;
    @Deprecated
    private String remarkName;
    private List<Long> remarkFieldList;
    private List<AuxiliaryField> remarkEntityList;
    private List<TemplateAccountSetting> accountSettings = new ArrayList<TemplateAccountSetting>(4);
    private List<Long> userIdList;
    private DimensionIndexTree indexTree;
    private String spreadData;
    private String name;
    private transient Object multiLanguageName;
    private String number;
    private TemplateType templateType;
    private boolean mainTable;
    private String startLocation;
    private Integer maxLineCount;
    private boolean detailIncludeSum;
    @Deprecated
    private List<Long> reportPeriods;
    private String description;
    private AmountUnit amountUnit;
    private boolean enable;
    private Long creatorId;
    private boolean isRelease;
    private List<Long> currencyMemberIdList;
    private List<TemplateReportType> reportTypeList;
    private TemplateSmartGetValSetType smartGetValSetType;
    private List<TemplateMetric> metrics;
    private TemplateUseType templateUse;
    private boolean totalSumVisible;
    private boolean totalSumDictMem;
    private boolean isDistSubject;
    private boolean subSumVisible = true;
    private List<ReportTemplate> statAnalysisTemplateList;
    private Date effectiveDate;
    private transient TemplateShowConfig config;

    public ReportTemplate() {
        this.remarkFieldList = new ArrayList<Long>(4);
        this.remarkEntityList = new ArrayList<AuxiliaryField>(4);
    }

    public void fillBaseInfo(TemplateBaseInfo baseInfo) {
        this.systemId = baseInfo.getSystemId();
        this.number = baseInfo.getNumber();
        this.name = this.getNameValue(baseInfo.getName());
        this.multiLanguageName = baseInfo.getName();
        this.templateType = baseInfo.getTemplateType();
        this.mainTable = baseInfo.isMainTable();
        this.startLocation = baseInfo.getStartLocation();
        this.maxLineCount = baseInfo.getMaxLineCount();
        this.reportPeriods = baseInfo.getReportPeriods();
        this.amountUnit = baseInfo.getAmountUnit();
        this.description = baseInfo.getDescription();
        this.enable = baseInfo.isEnable();
        this.detailIncludeSum = baseInfo.isDetailIncludeSum();
        this.reportTypeList = baseInfo.getReportTypeList();
        this.smartGetValSetType = baseInfo.getSmartGetValSetType();
        this.templateUse = baseInfo.getTemplateUses();
        this.statAnalysisTemplateList = baseInfo.getStatAnalysisTemplateList();
        this.effectiveDate = baseInfo.getEffectiveDate();
    }

    private String getNameValue(Object name) {
        if (EmptyUtil.isEmpty((Object)name)) {
            return "";
        }
        if (name instanceof String) {
            return ((String)name).trim();
        }
        if (name instanceof LocaleString) {
            return ((LocaleString)name).getLocaleValue();
        }
        if (name instanceof OrmLocaleValue) {
            return ((OrmLocaleValue)name).getLocaleValue();
        }
        return name.toString();
    }

    public void setTemplateDim(TemplateDim dim, DimLocation location) {
        if (location == DimLocation.PAGE) {
            this.pageDimList.add(dim);
        } else if (location == DimLocation.ROW) {
            this.rowDimList.add(dim);
        } else if (location == DimLocation.COL) {
            this.colDimList.add(dim);
        }
    }

    public TemplateLayout.LayoutInfo getTemplateLayoutInfoByDimId(Long dimensionId) {
        List<TemplateLayout.LayoutInfo> layoutInfoList = this.dimLayout.getDimLayoutInfoList();
        TemplateLayout.LayoutInfo layoutInfo = layoutInfoList.stream().filter(o -> o.getDimensionId().equals(dimensionId)).findFirst().orElse(null);
        return layoutInfo;
    }

    public List<TemplateDim> getAllTemplateDim() {
        ArrayList<TemplateDim> allDimList = new ArrayList<TemplateDim>(this.getPageDimList());
        allDimList.addAll(this.getRowDimList());
        allDimList.addAll(this.getColDimList());
        return allDimList;
    }

    public ReportTemplate serializeClone() {
        ReportTemplate deserialize = (ReportTemplate)FpmSerializeUtil.deserialize((String)FpmSerializeUtil.serialize((Object)this), ReportTemplate.class);
        deserialize.setMultiLanguageName(this.multiLanguageName);
        return deserialize;
    }

    public boolean isSubSumVisible() {
        return this.subSumVisible;
    }

    public void setSubSumVisible(boolean subSumVisible) {
        this.subSumVisible = subSumVisible;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Long getSystemId() {
        return this.systemId;
    }

    public void setSystemId(Long systemId) {
        this.systemId = systemId;
    }

    public List<TemplateDim> getPageDimList() {
        return this.pageDimList;
    }

    public void setPageDimList(List<TemplateDim> pageDimList) {
        this.pageDimList = pageDimList;
    }

    public List<TemplateAccountSetting> getAccountSettings() {
        return this.accountSettings;
    }

    public void setAccountSettings(List<TemplateAccountSetting> accountSettings) {
        this.accountSettings = accountSettings;
    }

    public List<TemplateDim> getRowDimList() {
        return this.rowDimList;
    }

    public void setRowDimList(List<TemplateDim> rowDimList) {
        this.rowDimList = rowDimList;
    }

    public List<TemplateDim> getColDimList() {
        return this.colDimList;
    }

    public void setColDimList(List<TemplateDim> colDimList) {
        this.colDimList = colDimList;
    }

    public List<Long> getUserIdList() {
        return this.userIdList;
    }

    public void setUserIdList(List<Long> userIdList) {
        this.userIdList = userIdList;
    }

    public String getSpreadData() {
        return this.spreadData;
    }

    public void setSpreadData(String spreadData) {
        this.spreadData = spreadData;
    }

    public TemplateType getTemplateType() {
        return this.templateType;
    }

    public void setTemplateType(TemplateType templateType) {
        this.templateType = templateType;
    }

    public boolean isMainTable() {
        return this.mainTable;
    }

    public void setMainTable(boolean mainTable) {
        this.mainTable = mainTable;
    }

    public String getStartLocation() {
        return this.startLocation;
    }

    public void setStartLocation(String startLocation) {
        this.startLocation = startLocation;
    }

    public Integer getMaxLineCount() {
        return this.maxLineCount;
    }

    public void setMaxLineCount(Integer maxLineCount) {
        this.maxLineCount = maxLineCount;
    }

    public List<Long> getReportPeriods() {
        return this.reportPeriods;
    }

    public void setReportPeriods(List<Long> reportPeriods) {
        this.reportPeriods = reportPeriods;
    }

    public AmountUnit getAmountUnit() {
        return this.amountUnit;
    }

    public void setAmountUnit(AmountUnit amountUnit) {
        this.amountUnit = amountUnit;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getName() {
        if (EmptyUtil.isEmpty((String)this.name) && EmptyUtil.isNoEmpty((Object)this.multiLanguageName)) {
            this.name = this.getNameValue(this.multiLanguageName);
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public boolean isShowcombine() {
        return this.showcombine;
    }

    public void setShowcombine(boolean showcombine) {
        this.showcombine = showcombine;
    }

    public boolean isDistinguish() {
        return this.distinguish;
    }

    public void setDistinguish(boolean distinguish) {
        this.distinguish = distinguish;
    }

    public boolean isRemarkVisible() {
        return this.remarkVisible;
    }

    public void setRemarkVisible(boolean remarkVisible) {
        this.remarkVisible = remarkVisible;
    }

    public String getRemarkName() {
        return this.remarkName;
    }

    public void setRemarkName(String remarkName) {
        this.remarkName = remarkName;
    }

    public TemplateLayout getDimLayout() {
        return this.dimLayout;
    }

    public void setDimLayout(TemplateLayout dimLayout) {
        this.dimLayout = dimLayout;
    }

    public boolean isDetailIncludeSum() {
        return this.detailIncludeSum;
    }

    public void setDetailIncludeSum(boolean detailIncludeSum) {
        this.detailIncludeSum = detailIncludeSum;
    }

    public Long getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(Long creatorId) {
        this.creatorId = creatorId;
    }

    public boolean isRelease() {
        return this.isRelease;
    }

    public void setRelease(boolean release) {
        this.isRelease = release;
    }

    public List<Long> getCurrencyMemberIdList() {
        return this.currencyMemberIdList;
    }

    public void setCurrencyMemberIdList(List<Long> currencyMemberIdList) {
        this.currencyMemberIdList = currencyMemberIdList;
    }

    public long getCopyId() {
        return this.copyId;
    }

    public void setCopyId(long copyId) {
        this.copyId = copyId;
    }

    public boolean isDistSubject() {
        return this.isDistSubject;
    }

    public void setDistSubject(boolean distSubject) {
        this.isDistSubject = distSubject;
    }

    public List<TemplateReportType> getReportTypeList() {
        if (this.reportTypeList == null) {
            this.reportTypeList = new ArrayList<TemplateReportType>(1);
        }
        return this.reportTypeList;
    }

    public void setReportTypeList(List<TemplateReportType> reportTypeList) {
        this.reportTypeList = reportTypeList;
    }

    public TemplateSmartGetValSetType getSmartGetValSetType() {
        return this.smartGetValSetType;
    }

    public void setSmartGetValSetType(TemplateSmartGetValSetType smartGetValSetType) {
        this.smartGetValSetType = smartGetValSetType;
    }

    public List<TemplateMetric> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<TemplateMetric> metrics) {
        this.metrics = metrics;
    }

    public TemplateUseType getTemplateUse() {
        return this.templateUse;
    }

    public void setTemplateUse(TemplateUseType templateUse) {
        this.templateUse = templateUse;
    }

    public boolean isTotalSumVisible() {
        return this.totalSumVisible;
    }

    public void setTotalSumVisible(boolean totalSumVisible) {
        this.totalSumVisible = totalSumVisible;
    }

    public boolean isTotalSumDictMem() {
        return this.totalSumDictMem;
    }

    public void setTotalSumDictMem(boolean totalSumDictMem) {
        this.totalSumDictMem = totalSumDictMem;
    }

    public List<Long> getRemarkFieldList() {
        return this.remarkFieldList;
    }

    public void setRemarkFieldList(List<Long> remarkFieldList) {
        this.remarkFieldList = remarkFieldList;
    }

    public List<AuxiliaryField> getRemarkEntityList() {
        return this.remarkEntityList;
    }

    public void setRemarkEntityList(List<AuxiliaryField> remarkEntityList) {
        this.remarkEntityList = remarkEntityList;
    }

    public List<ReportTemplate> getStatAnalysisTemplateList() {
        if (EmptyUtil.isEmpty(this.statAnalysisTemplateList)) {
            this.statAnalysisTemplateList = Collections.emptyList();
        }
        return this.statAnalysisTemplateList;
    }

    public void setStatAnalysisTemplateList(List<ReportTemplate> statAnalysisTemplateList) {
        this.statAnalysisTemplateList = statAnalysisTemplateList;
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public DimensionIndexTree getIndexTree() {
        return this.indexTree;
    }

    public void setIndexTree(DimensionIndexTree indexTree) {
        this.indexTree = indexTree;
    }

    public Object getMultiLanguageName() {
        return this.multiLanguageName;
    }

    public void setMultiLanguageName(Object multiLanguageName) {
        this.multiLanguageName = multiLanguageName;
        this.name = this.getNameValue(multiLanguageName);
    }

    public TemplateShowConfig getConfig() {
        return this.config;
    }

    public void setConfig(TemplateShowConfig config) {
        this.config = config;
    }

    public int getDataStartRow(boolean isDetailPeriod) {
        List<TemplateDim> colDimList = this.getColDimList();
        if (this.templateType == TemplateType.FIXED) {
            int size = colDimList.size() - 1;
            Optional<TemplateDim> periodColDimOp = colDimList.stream().filter(item -> item.getDimType() == DimensionType.PERIOD).findFirst();
            if (isDetailPeriod && periodColDimOp.isPresent()) {
                ++size;
            }
            if (CollectionUtils.isNotEmpty(this.metrics)) {
                ++size;
            }
            return size;
        }
        int size = 1;
        Optional<TemplateDim> first = colDimList.stream().filter(TemplateDim::isExpand).filter(item -> item.getDimType() != DimensionType.METRIC).findFirst();
        if (first.isPresent()) {
            ++size;
            if (isDetailPeriod && first.get().getDimType() == DimensionType.PERIOD) {
                ++size;
            }
        }
        if (CollectionUtils.isNotEmpty(this.metrics) && this.metrics.size() != 1) {
            ++size;
        } else if (this.templateUse == TemplateUseType.STATISTIC && colDimList.stream().filter(item -> item.getDimType() == DimensionType.METRIC).anyMatch(TemplateDim::isExpand)) {
            ++size;
        }
        return size;
    }

    public Pair<List<Long>, List<List<Long>>> buildPageDimAndValGroup() {
        ArrayList<Long> pageDimIdList = new ArrayList<Long>(this.pageDimList.size());
        ArrayList pageDimGroupIdList = new ArrayList(this.pageDimList.size());
        List visibleList = this.pageDimList.stream().filter(TemplateDim::isVisible).collect(Collectors.toList());
        if (visibleList.size() == 1) {
            pageDimIdList.add(((TemplateDim)visibleList.get(0)).getDimensionId());
            TemplateDim templateDim = (TemplateDim)visibleList.get(0);
            List<Long> memberScope = templateDim.getMemberScope();
            memberScope.stream().map(memberId -> {
                ArrayList<Long> resultIdList = new ArrayList<Long>(1);
                resultIdList.add((Long)memberId);
                return resultIdList;
            }).forEach(pageDimGroupIdList::add);
        } else if (visibleList.size() == 2) {
            List<Long> firstMemberScope = ((TemplateDim)visibleList.get(0)).getMemberScope();
            List<Long> secondMemberScope = ((TemplateDim)visibleList.get(1)).getMemberScope();
            pageDimIdList.add(((TemplateDim)visibleList.get(0)).getDimensionId());
            pageDimIdList.add(((TemplateDim)visibleList.get(1)).getDimensionId());
            for (Long firstId : firstMemberScope) {
                for (Long secondId : secondMemberScope) {
                    ArrayList<Long> resultIdList = new ArrayList<Long>(visibleList.size());
                    resultIdList.add(firstId);
                    resultIdList.add(secondId);
                    pageDimGroupIdList.add(resultIdList);
                }
            }
        } else if (visibleList.size() == 3) {
            List<Long> firstMemberScope = ((TemplateDim)visibleList.get(0)).getMemberScope();
            List<Long> secondMemberScope = ((TemplateDim)visibleList.get(1)).getMemberScope();
            List<Long> thirdMemberScope = ((TemplateDim)visibleList.get(2)).getMemberScope();
            pageDimIdList.add(((TemplateDim)visibleList.get(0)).getDimensionId());
            pageDimIdList.add(((TemplateDim)visibleList.get(1)).getDimensionId());
            pageDimIdList.add(((TemplateDim)visibleList.get(2)).getDimensionId());
            for (Long firstId : firstMemberScope) {
                for (Long secondId : secondMemberScope) {
                    for (Long thirdId : thirdMemberScope) {
                        ArrayList<Long> resultIdList = new ArrayList<Long>(visibleList.size());
                        resultIdList.add(firstId);
                        resultIdList.add(secondId);
                        resultIdList.add(thirdId);
                        pageDimGroupIdList.add(resultIdList);
                    }
                }
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u7ef4\u6570\u91cf\u6709\u8bef\u3002", (String)"ReportTemplate_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        return Pair.of(pageDimIdList, pageDimGroupIdList);
    }

    public TemplateDim getMetricTplDim() {
        return this.metricTplDim;
    }

    public void setMetricTplDim(TemplateDim metricTplDim) {
        this.metricTplDim = metricTplDim;
    }

    public int getTotalRow() {
        int colRow = 0;
        if (this.templateType != TemplateType.DETAIL) {
            return colRow;
        }
        long totalColCount = this.colDimList.stream().filter(TemplateDim::isTotalRow).count();
        if (totalColCount < 1L) {
            return colRow;
        }
        Optional<TemplateDim> currencyOptional = this.colDimList.stream().filter(templateDim -> templateDim.getDimType() == DimensionType.CURRENCY).findFirst();
        boolean isSubjectFlowTotal = this.colDimList.stream().anyMatch(TemplateDim::isSubjectFlowTotal);
        int subjectFlowSize = 0;
        if (isSubjectFlowTotal) {
            List allSubjectMemberIds = this.colDimList.stream().filter(tpl -> tpl.getDimType() == DimensionType.SUBJECTS).map(TemplateDim::getMemberScope).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
            DynamicObjectCollection allSubjectMembers = QueryServiceHelper.query((String)"fpm_member", (String)"id,flow", (QFilter[])new QFilter[]{new QFilter("id", "in", allSubjectMemberIds)});
            Set<String> allFlowTypeSet = allSubjectMembers.stream().map(dy -> dy.getString("flow")).filter(FlowType::isTotalRowsShowType).collect(Collectors.toSet());
            int n = subjectFlowSize = TemplateInfoHelper.hasEnableNetInFlowTotalRow(this, allFlowTypeSet) ? allFlowTypeSet.size() + 1 : allFlowTypeSet.size();
        }
        if (currencyOptional.isPresent()) {
            TemplateDim currencyDim = currencyOptional.get();
            if (currencyDim.isExpand()) {
                return isSubjectFlowTotal ? colRow + subjectFlowSize : colRow + 1;
            }
            return isSubjectFlowTotal ? colRow + currencyDim.getMemberScope().size() * subjectFlowSize : colRow + currencyDim.getMemberScope().size();
        }
        return isSubjectFlowTotal ? colRow + subjectFlowSize : colRow + 1;
    }
}

