/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.template;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.message.service.pa.util.StringUtil;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaOperationVal;
import kd.tmc.fpm.business.spread.formula.FormulaOperatorSymbol;
import kd.tmc.fpm.business.spread.formula.IFormulaOperator;
import kd.tmc.fpm.business.spread.formula.enums.FormulaSymbolEnum;
import org.apache.commons.collections.CollectionUtils;

public class TemplateAccountSetting
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long id;
    private Long accountMemId;
    private ReportInputType inputType;
    private String formula;
    private Long childTemplateId;
    private boolean isLeaf;
    private boolean hideInReport;
    private List<TemplateAccountSetting> children;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Long getAccountMemId() {
        return this.accountMemId;
    }

    public void setAccountMemId(Long accountMemId) {
        this.accountMemId = accountMemId;
    }

    public ReportInputType getInputType() {
        return this.inputType;
    }

    public void setInputType(ReportInputType inputType) {
        this.inputType = inputType;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public Long getChildTemplateId() {
        return this.childTemplateId;
    }

    public void setChildTemplateId(Long childTemplateId) {
        this.childTemplateId = childTemplateId;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public boolean isHideInReport() {
        return this.hideInReport;
    }

    public void setHideInReport(boolean hideInReport) {
        this.hideInReport = hideInReport;
    }

    public static long getSerialVersionUID() {
        return 1L;
    }

    public List<TemplateAccountSetting> getChildren() {
        return this.children;
    }

    public void setChildren(List<TemplateAccountSetting> children) {
        this.children = children;
    }

    public Formula buildFormulaInfo() {
        if (this.inputType != ReportInputType.SUMMARY && this.inputType != ReportInputType.FORMULA) {
            return null;
        }
        Formula resultFormula = new Formula();
        FormulaOperationVal leftOperationVal = new FormulaOperationVal();
        leftOperationVal.setName(this.getAccountMemId().toString());
        resultFormula.setLeftVal(leftOperationVal);
        LinkedList<IFormulaOperator> operator = new LinkedList<IFormulaOperator>();
        if (this.inputType == ReportInputType.SUMMARY) {
            List<TemplateAccountSetting> children = this.getChildren();
            if (CollectionUtils.isEmpty(children)) {
                return null;
            }
            for (int i = 0; i < children.size(); ++i) {
                TemplateAccountSetting childAcctSetting = children.get(i);
                FormulaOperationVal rightVal = new FormulaOperationVal();
                rightVal.setName(childAcctSetting.getAccountMemId().toString());
                operator.add(rightVal);
                if (i >= this.getChildren().size() - 1) continue;
                FormulaOperatorSymbol addSymbol = new FormulaOperatorSymbol(FormulaSymbolEnum.PLUS);
                operator.add(addSymbol);
            }
        } else {
            String targetFormulaStr = this.formula.replaceAll("\\(", "").replaceAll("\\)", "");
            String regEx = "\\+|\\-";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(targetFormulaStr);
            String[] accountIdArr = p.split(targetFormulaStr);
            ArrayList<String> symbolArr = new ArrayList<String>(accountIdArr.length - 1);
            if (accountIdArr.length > 0) {
                for (int count = 0; count < accountIdArr.length; ++count) {
                    if (!m.find()) continue;
                    symbolArr.add(m.group());
                }
            }
            for (int i = 0; i < accountIdArr.length; ++i) {
                String accountId = accountIdArr[i];
                String replace = accountId.replace("[", "").replace("]", "");
                if (StringUtil.isEmpty((String)replace)) continue;
                FormulaOperationVal rightVal = new FormulaOperationVal();
                rightVal.setName(replace);
                operator.add(rightVal);
                if (i >= symbolArr.size()) continue;
                FormulaOperatorSymbol addSymbol = new FormulaOperatorSymbol(FormulaSymbolEnum.getBySymbol((String)symbolArr.get(i)));
                operator.add(addSymbol);
            }
        }
        resultFormula.setOperator(operator);
        return resultFormula;
    }

    public List<TemplateAccountSetting> getAllChildSetting() {
        ArrayList<TemplateAccountSetting> allMemberList = new ArrayList<TemplateAccountSetting>();
        this.getChildMember(this, allMemberList);
        return allMemberList;
    }

    private void getChildMember(TemplateAccountSetting member, List<TemplateAccountSetting> outMemberList) {
        if (member != this) {
            outMemberList.add(member);
        }
        if (member.isLeaf || member.getChildren() == null) {
            return;
        }
        for (TemplateAccountSetting child : member.getChildren()) {
            this.getChildMember(child, outMemberList);
        }
    }
}

