/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.template;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.TemplateDimMemScopeType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.common.annotation.DispersionAnalysisAnnotation;

public class TemplateLayout
implements Serializable {
    private TemplateType templateType;
    private List<LayoutInfo> dimLayoutInfoList;

    public TemplateLayout() {
        this.dimLayoutInfoList = new ArrayList<LayoutInfo>();
    }

    public TemplateLayout(TemplateType templateType, List<LayoutInfo> dimLayoutInfoList) {
        this.templateType = templateType;
        this.dimLayoutInfoList = dimLayoutInfoList;
    }

    public List<LayoutInfo> getRowLayout() {
        return this.dimLayoutInfoList.stream().filter(e -> DimLocation.ROW == e.getDimLocation()).collect(Collectors.toList());
    }

    public List<LayoutInfo> getColLayout() {
        return this.dimLayoutInfoList.stream().filter(e -> DimLocation.COL == e.getDimLocation()).collect(Collectors.toList());
    }

    public List<LayoutInfo> getPageLayout() {
        return this.dimLayoutInfoList.stream().filter(e -> DimLocation.PAGE == e.getDimLocation()).collect(Collectors.toList());
    }

    public TemplateType getTemplateType() {
        return this.templateType;
    }

    public void setTemplateType(TemplateType templateType) {
        this.templateType = templateType;
    }

    public List<LayoutInfo> getDimLayoutInfoList() {
        return this.dimLayoutInfoList;
    }

    public void setDimLayoutInfoList(List<LayoutInfo> dimLayoutInfoList) {
        this.dimLayoutInfoList = dimLayoutInfoList;
    }

    public static class LayoutInfo
    implements Serializable {
        @DispersionAnalysisAnnotation
        private Long dimensionId;
        private String dimensionName;
        @DispersionAnalysisAnnotation
        private DimLocation dimLocation;
        @DispersionAnalysisAnnotation
        private Integer level;
        private boolean visible;
        private boolean expand;
        private boolean includeSum;
        private List<Long> expandMembers;
        @DispersionAnalysisAnnotation
        private TemplateDimMemScopeType scopeType;
        private boolean filterDim;

        public boolean isIncludeSum() {
            return this.includeSum;
        }

        public void setIncludeSum(boolean includeSum) {
            this.includeSum = includeSum;
        }

        public String getDimensionName() {
            return this.dimensionName;
        }

        public void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        public Long getDimensionId() {
            return this.dimensionId;
        }

        public void setDimensionId(Long dimensionId) {
            this.dimensionId = dimensionId;
        }

        public DimLocation getDimLocation() {
            return this.dimLocation;
        }

        public void setDimLocation(DimLocation dimLocation) {
            this.dimLocation = dimLocation;
        }

        public Integer getLevel() {
            return this.level;
        }

        public void setLevel(Integer level) {
            this.level = level;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public boolean isExpand() {
            return this.expand;
        }

        public void setExpand(boolean expand) {
            this.expand = expand;
        }

        public List<Long> getExpandMembers() {
            return this.expandMembers;
        }

        public void setExpandMembers(List<Long> expandMembers) {
            this.expandMembers = expandMembers;
        }

        public TemplateDimMemScopeType getScopeType() {
            return this.scopeType;
        }

        public void setScopeType(TemplateDimMemScopeType scopeType) {
            this.scopeType = scopeType;
        }

        public boolean isFilterDim() {
            return this.filterDim;
        }

        public void setFilterDim(boolean filterDim) {
            this.filterDim = filterDim;
        }
    }
}

