/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.service.ResultCode;
import org.apache.commons.collections4.MapUtils;

public class ControlResult
implements Serializable {
    private ResultCode code;
    private String errMsg;
    private List<Long> successIdList;
    private Map<Long, Set<Long>> failedBillIdExecuteRecordIdsMap;
    private Map<Long, Set<Long>> successBillIdExecuteRecordIdsMap;
    private boolean itemErrFlag;
    private Map<Long, String> errIdMsgInfo = new HashMap<Long, String>();
    private Map<Long, Set<String>> billErrorInfo;

    public ControlResult() {
        this.code = ResultCode.SUCCESS;
        this.successIdList = new ArrayList<Long>(16);
        this.failedBillIdExecuteRecordIdsMap = new HashMap<Long, Set<Long>>(16);
        this.successBillIdExecuteRecordIdsMap = new HashMap<Long, Set<Long>>(16);
        this.billErrorInfo = new HashMap<Long, Set<String>>(16);
    }

    public ResultCode getCode() {
        return this.code;
    }

    public void setCode(ResultCode code) {
        this.code = code;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.code = ResultCode.ERROR;
        this.errMsg = errMsg;
    }

    public List<Long> getSuccessIdList() {
        return this.successIdList;
    }

    public void setSuccessIdList(List<Long> successIdList) {
        this.successIdList = successIdList;
    }

    public Map<Long, String> getErrIdMsgInfo() {
        return this.errIdMsgInfo;
    }

    public void setErrIdMsgInfo(Map<Long, String> errIdMsgInfo) {
        this.errIdMsgInfo = errIdMsgInfo;
    }

    public void addErrMsg(Long errId, String errMsg) {
        this.itemErrFlag = true;
        Set errorMessages = this.billErrorInfo.computeIfAbsent(errId, k -> new HashSet(16));
        errorMessages.add(errMsg);
        this.errIdMsgInfo.put(errId, String.join((CharSequence)"\r\n", errorMessages));
    }

    public boolean isItemErrFlag() {
        return this.itemErrFlag;
    }

    public void setItemErrFlag(boolean itemErrFlag) {
        this.itemErrFlag = itemErrFlag;
    }

    public boolean hasError() {
        return this.code == ResultCode.ERROR || MapUtils.isNotEmpty(this.errIdMsgInfo);
    }

    public boolean isFailed() {
        return this.code == ResultCode.ERROR;
    }

    public boolean isError(Long billId) {
        return EmptyUtil.isNoEmpty((String)this.errIdMsgInfo.get(billId));
    }

    public Map<Long, String> getBillIdErrorMsgInfoMap() {
        return this.errIdMsgInfo;
    }

    public boolean isSuccess() {
        return this.code == ResultCode.SUCCESS;
    }

    public void addFailedExecuteRecordId(Long billId, Long recordId) {
        this.failedBillIdExecuteRecordIdsMap.computeIfAbsent(billId, k -> new HashSet(16)).add(recordId);
    }

    public Map<Long, Set<Long>> getFailedBillIdExecuteRecordIdsMap() {
        return this.failedBillIdExecuteRecordIdsMap;
    }

    public void setFailedBillIdExecuteRecordIdsMap(Map<Long, Set<Long>> failedBillIdExecuteRecordIdsMap) {
        this.failedBillIdExecuteRecordIdsMap = failedBillIdExecuteRecordIdsMap;
    }

    public void addSuccessExecuteRecordId(Long billId, Long recordId) {
        this.successBillIdExecuteRecordIdsMap.computeIfAbsent(billId, k -> new HashSet(16)).add(recordId);
        this.successIdList.add(recordId);
    }

    public Map<Long, Set<Long>> getSuccessBillIdExecuteRecordIdsMap() {
        return this.successBillIdExecuteRecordIdsMap;
    }

    public void setSuccessBillIdExecuteRecordIdsMap(Map<Long, Set<Long>> successBillIdExecuteRecordIdsMap) {
        this.successBillIdExecuteRecordIdsMap = successBillIdExecuteRecordIdsMap;
    }
}

