/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class FpmOperateResult<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean warning;
    private boolean success;
    private List<String> messageList;
    private List<String> tipsInfoList;
    private String warnMessage;
    private String successMessage;
    private T data;

    public FpmOperateResult() {
        this.success = true;
        this.warning = false;
        this.tipsInfoList = new ArrayList<String>();
        this.messageList = new ArrayList<String>();
    }

    public FpmOperateResult(boolean success, List<String> messageList, T data) {
        this.success = success;
        this.warning = false;
        this.messageList = messageList;
        this.tipsInfoList = new ArrayList<String>();
        this.data = data;
        if (Objects.isNull(this.messageList)) {
            this.messageList = new ArrayList<String>(1);
        }
    }

    public FpmOperateResult(boolean success, boolean warning, String warnMessage, T data) {
        this.warning = warning;
        this.success = success;
        this.messageList = new ArrayList<String>();
        this.tipsInfoList = new ArrayList<String>();
        this.warnMessage = warnMessage;
        this.data = data;
    }

    public static <T> FpmOperateResult<T> error(String errMessage) {
        return new FpmOperateResult<Object>(false, new ArrayList<String>(Collections.singletonList(errMessage)), null);
    }

    public static <T> FpmOperateResult<T> error(List<String> errMessage) {
        return new FpmOperateResult<Object>(false, errMessage, null);
    }

    public static <T> FpmOperateResult<T> warn(String warnMessage) {
        return new FpmOperateResult<Object>(false, true, warnMessage, null);
    }

    public static <T> FpmOperateResult<T> warn() {
        return new FpmOperateResult<Object>(false, true, null, null);
    }

    public static <T> FpmOperateResult<T> success() {
        return new FpmOperateResult<Object>(true, null, null);
    }

    public static <T> FpmOperateResult<T> success(T data) {
        return new FpmOperateResult<T>(true, null, data);
    }

    public void addErrMessage(String errMsg) {
        this.success = false;
        this.messageList.add(errMsg);
    }

    public boolean isSuccess() {
        return (this.messageList == null || this.messageList.size() == 0) && this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean isWarning() {
        return this.warning;
    }

    public void setWarning(boolean warning) {
        this.warning = warning;
    }

    public List<String> getMessageList() {
        return this.messageList;
    }

    public void setMessageList(List<String> messageList) {
        this.messageList = messageList;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public List<String> getTipsInfoList() {
        return this.tipsInfoList;
    }

    public void setTipsInfoList(List<String> tipsInfoList) {
        this.tipsInfoList = tipsInfoList;
    }

    public void addTipsMessage(String tipInfo) {
        this.tipsInfoList.add(tipInfo);
    }

    public String getWarnMessage() {
        return this.warnMessage;
    }

    public void setWarnMessage(String warnMessage) {
        this.warnMessage = warnMessage;
    }

    public String getSuccessMessage() {
        return this.successMessage;
    }

    public void setSuccessMessage(String successMessage) {
        this.successMessage = successMessage;
    }
}

