/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fpm.business.dataproc.query.ReportDataQParam;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.InternalOffsetStateType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.interior.offset.InnerCancelInfo;
import kd.tmc.fpm.business.domain.model.interior.offset.InternalOffsetQResult;
import kd.tmc.fpm.business.domain.model.interior.offset.InternalOffsetQueryParam;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.AnalysisReport;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.IVirtualDimMemberProcessService;
import kd.tmc.fpm.business.mvc.service.interior.offset.IInternalOffsetService;
import kd.tmc.fpm.business.mvc.service.interior.offset.impl.InternalOffsetServiceImpl;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.helper.AmountCurrencyRateHelper;
import kd.tmc.fpm.common.utils.NumberUtils;

public class InnerCancelProcessServiceImpl
implements IVirtualDimMemberProcessService {
    private static Log logger = LogFactory.getLog(InnerCancelProcessServiceImpl.class);
    private IInternalOffsetService offsetService = new InternalOffsetServiceImpl();
    private AnalysisHeader header;
    private FundPlanSystem system;
    private AnalysisReport analysisReport;

    public InnerCancelProcessServiceImpl(AnalysisHeader header, AnalysisReport analysisReport, FundPlanSystem system) {
        this.header = header;
        this.system = system;
        this.analysisReport = analysisReport;
    }

    @Override
    public void processVirtualDimMember(List<ReportData> reportData) {
        if (!InternalOffsetStateType.checkOffset(this.header.getInternalOffsetState())) {
            logger.info("\u672a\u67e5\u8be2\u62b5\u6d88\u524d\u6570\u636e\uff0c\u4e0d\u8fdb\u884c\u62b5\u6d88");
            return;
        }
        ReportTemplate analysisTemplate = this.analysisReport.getTemplate();
        List<TemplateDim> allTemplateDim = analysisTemplate.getAllTemplateDim();
        ArrayList<ReportDataQParam.DimBaseInfo> dimIdList = new ArrayList<ReportDataQParam.DimBaseInfo>(allTemplateDim.size());
        ArrayList<List<Object>> dimValList = new ArrayList<List<Object>>(allTemplateDim.size());
        for (TemplateDim templateDim : allTemplateDim) {
            if (CollectionUtils.isEmpty(templateDim.getMemberScope()) || !templateDim.isVisible() || templateDim.getDimType().isVirtualDim() || DimensionType.ORG == templateDim.getDimType()) continue;
            ReportDataQParam.DimBaseInfo dim = new ReportDataQParam.DimBaseInfo();
            dim.setId(templateDim.getDimensionId());
            dim.setDimType(templateDim.getDimType());
            dimIdList.add(dim);
            ArrayList<Long> dimVal = new ArrayList<Long>(templateDim.getMemberScope());
            if (DimensionType.PERIOD == templateDim.getDimType() && this.header.isContainDetailReportType()) {
                Dimension periodDim = this.system.getMainDimensionByDimensionId(templateDim.getDimensionId());
                List scopeIds = periodDim.getAllDimMemberList().stream().filter(item -> templateDim.getMemberScope().contains(item.getId())).map(DimMember::getAllChildMember).flatMap(Collection::stream).map(DimMember::getId).collect(Collectors.toList());
                dimVal.addAll(scopeIds);
            }
            dimValList.add(dimVal);
        }
        logger.info("\u67e5\u8be2\u62b5\u6d88\u6570\u636e\u7ef4\u5ea6\uff0cdimIdList\uff1a{} , dimValList:{}", (Object)((Object)dimIdList).toString(), (Object)((Object)dimValList).toString());
        if (CollectionUtils.isEmpty(dimIdList) || CollectionUtils.isEmpty(dimValList)) {
            logger.info("\u67e5\u8be2\u62b5\u6d88\u6570\u636e\u7ef4\u5ea6\u65f6\uff0c\u7ec4\u88c5\u7ef4\u5ea6\u7ec4\u5408\u4e3a\u7a7a\uff0c\u505c\u6b62\u67e5\u8be2\u62b5\u6d88\u6570\u636e");
            return;
        }
        InternalOffsetQueryParam internalOffsetQueryParam = new InternalOffsetQueryParam();
        internalOffsetQueryParam.setSystemId(this.system.getId());
        internalOffsetQueryParam.setDimIdList(dimIdList);
        internalOffsetQueryParam.setDimValList(dimValList);
        FpmOperateResult<List<InternalOffsetQResult>> internalOffsetData = this.offsetService.queryInternalOffsetData(internalOffsetQueryParam);
        List<InternalOffsetQResult> data = internalOffsetData.getData();
        if (CollectionUtils.isEmpty(data)) {
            logger.info("\u5f53\u524d\u65e0\u62b5\u6d88\u8bb0\u5f55.");
            return;
        }
        List qResultList = data.stream().filter(item -> !CollectionUtils.isEmpty(item.getInnerCancelInfoList())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(qResultList)) {
            logger.info("\u5f53\u524d\u65e0\u62b5\u6d88\u8bb0\u5f55.");
            return;
        }
        QueryIndexInfo<Object, ReportData> dataIndex = QueryIndexInfoMapGenerator.buildReportDataIndex(reportData, this.system);
        for (InternalOffsetQResult offsetData : qResultList) {
            List<InnerCancelInfo> innerCancelInfoList = offsetData.getInnerCancelInfoList();
            if (CollectionUtils.isEmpty(innerCancelInfoList)) continue;
            this.innerCancelByRecord(dataIndex, offsetData, innerCancelInfoList);
        }
    }

    private void innerCancelByRecord(QueryIndexInfo<Object, ReportData> dataIndex, InternalOffsetQResult offsetData, List<InnerCancelInfo> innerCancelInfoList) {
        for (InnerCancelInfo innerCancelInfo : innerCancelInfoList) {
            Long sumOrgMemberId = innerCancelInfo.getSumOrgMemberId();
            List<TemplateDim> dimList = offsetData.getDimList();
            List<Object> dimValList = offsetData.getDimValList();
            ArrayList<Long> dimensionIdList = new ArrayList<Long>(dimList.size());
            ArrayList<Object> dimensionValueList = new ArrayList<Object>(dimList.size());
            for (int i = dimList.size() - 1; i >= 0; --i) {
                TemplateDim templateDim = dimList.get(i);
                if (templateDim.isDetailDim()) continue;
                dimensionIdList.add(templateDim.getDimensionId());
                dimensionValueList.add(templateDim.getDimType() == DimensionType.ORG ? sumOrgMemberId : dimValList.get(i));
            }
            DimensionInfoBean dimensionInfoBean = DimensionInfoBean.of(dimensionIdList, dimensionValueList);
            List<ReportData> indexList = dataIndex.findList(dimensionInfoBean);
            List<ReportData> findList = this.upperFind(dataIndex, dimensionInfoBean, offsetData);
            if (!CollectionUtils.isEmpty(indexList)) {
                findList.addAll(indexList);
            }
            findList.forEach(item -> {
                AmountUnit amountUnit = item.getAmountUnit();
                if (this.analysisReport.getAnalysisReportType().isSynthesisAnalysis()) {
                    amountUnit = this.analysisReport.getTemplate().getAmountUnit();
                }
                BigDecimal offsetAmt = AmountCurrencyRateHelper.convertAmt((BigDecimal)innerCancelInfo.getOffsetAmt(), (AmountUnitEnum)AmountUnit.convert(innerCancelInfo.getAmountUnit()), (AmountUnitEnum)AmountUnit.convert(amountUnit));
                BigDecimal planAmt = CommonUtils.getValueIfNull(item.getPlanAmt());
                planAmt = planAmt.subtract(offsetAmt);
                BigDecimal actAmt = CommonUtils.getValueIfNull(item.getActAmt());
                if (NumberUtils.lessThan((BigDecimal)(actAmt = actAmt.subtract(offsetAmt)), (BigDecimal)BigDecimal.ZERO)) {
                    BigDecimal lockAmt = CommonUtils.getValueIfNull(item.getLockAmt());
                    if (NumberUtils.lessThan((BigDecimal)(lockAmt = lockAmt.add(actAmt)), (BigDecimal)BigDecimal.ZERO)) {
                        lockAmt = BigDecimal.ZERO;
                    }
                    actAmt = BigDecimal.ZERO;
                    item.setLockAmt(lockAmt);
                }
                item.setActAmt(actAmt);
                item.setPlanAmt(planAmt);
            });
        }
    }

    private List<ReportData> upperFind(QueryIndexInfo<Object, ReportData> dataIndex, DimensionInfoBean dimensionInfoBean, InternalOffsetQResult offsetData) {
        ArrayList<ReportData> findResultList = new ArrayList<ReportData>(16);
        List<TemplateDim> dimList = offsetData.getDimList();
        List<Object> dimValList = offsetData.getDimValList();
        List subjectTemplateDim = dimList.stream().filter(item -> DimensionType.SUBJECTS == item.getDimType()).collect(Collectors.toList());
        TemplateDim templateDim = (TemplateDim)subjectTemplateDim.get(0);
        int subjectIndex = dimList.indexOf(templateDim);
        Object subjectMemberId = dimValList.get(subjectIndex);
        Dimension subjectDim = this.system.getMainDimensionByDimensionId(templateDim.getDimensionId());
        this.findBySubjectMember(dataIndex, dimensionInfoBean, subjectDim, (Long)subjectMemberId, findResultList);
        return findResultList;
    }

    private void findBySubjectMember(QueryIndexInfo<Object, ReportData> dataIndex, DimensionInfoBean dimensionInfoBean, Dimension subjectDim, Long subjectMemberId, List<ReportData> findResultList) {
        AccountMember accountMember = (AccountMember)subjectDim.getDimMemberById(subjectMemberId);
        DimMember parent = accountMember.getParent();
        if (Objects.isNull(parent)) {
            return;
        }
        AccountMember associateAccount = (AccountMember)parent;
        DimensionInfoHelper.replaceDimValue(dimensionInfoBean, subjectDim.getId(), associateAccount.getId());
        List<ReportData> resultList = dataIndex.findList(dimensionInfoBean);
        if (!CollectionUtils.isEmpty(resultList)) {
            findResultList.addAll(resultList);
        }
        this.findBySubjectMember(dataIndex, dimensionInfoBean, subjectDim, associateAccount.getId(), findResultList);
    }
}

