/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.AnalysisReport;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.AnalysisReportDataService;
import kd.tmc.fpm.business.domain.service.IDimensionMemberStrategy;
import kd.tmc.fpm.business.domain.service.IVirtualDimMemberProcessService;
import kd.tmc.fpm.business.domain.service.QueryConditionProcessor;
import kd.tmc.fpm.common.utils.NumberUtils;

public abstract class AbstractAnalysisReportDataService
implements AnalysisReportDataService {
    protected static final Log logger = LogFactory.getLog(AbstractAnalysisReportDataService.class);
    protected FundPlanSystem fundPlanSystem;
    protected AnalysisReport analysisReport;
    protected List<Dimension> dimensionList;
    protected List<List<Object>> dimValList;
    protected Set<Long> queryAllDimensionIds;
    private List<IDimensionMemberStrategy> dimensionMemberStrategyList;
    private List<IVirtualDimMemberProcessService> virtualDimMemberProcessServiceList;
    private List<QueryConditionProcessor<?>> queryConditionProcessorList;
    protected boolean dynamicCalculate;

    public AbstractAnalysisReportDataService(FundPlanSystem fundPlanSystem, AnalysisReport analysisReport, Set<Long> queryAllDimensionIds) {
        this.fundPlanSystem = fundPlanSystem;
        this.analysisReport = analysisReport;
        this.dimensionList = new ArrayList<Dimension>(16);
        this.dimValList = new ArrayList<List<Object>>(16);
        this.dimensionMemberStrategyList = new ArrayList<IDimensionMemberStrategy>(16);
        this.virtualDimMemberProcessServiceList = new ArrayList<IVirtualDimMemberProcessService>(16);
        this.queryAllDimensionIds = queryAllDimensionIds;
        this.queryConditionProcessorList = new ArrayList(8);
    }

    public AbstractAnalysisReportDataService addDimensionMemberStrategy(IDimensionMemberStrategy iDimensionMemberStrategy) {
        if (!this.dimensionMemberStrategyList.contains(iDimensionMemberStrategy)) {
            this.dimensionMemberStrategyList.add(iDimensionMemberStrategy);
        }
        return this;
    }

    public AbstractAnalysisReportDataService addVirtualDimMemberProcessService(IVirtualDimMemberProcessService virtualDimMemberProcessService) {
        if (!this.virtualDimMemberProcessServiceList.contains(virtualDimMemberProcessService)) {
            this.virtualDimMemberProcessServiceList.add(virtualDimMemberProcessService);
        }
        return this;
    }

    public AbstractAnalysisReportDataService addQueryConditionProcessor(QueryConditionProcessor queryConditionProcessor) {
        if (!this.queryConditionProcessorList.contains(queryConditionProcessor)) {
            this.queryConditionProcessorList.add(queryConditionProcessor);
        }
        return this;
    }

    public AbstractAnalysisReportDataService dynamicCalculate() {
        this.dynamicCalculate = true;
        return this;
    }

    @Override
    public List<ReportData> getReportDataList() {
        if (EmptyUtil.isEmpty(this.dimensionMemberStrategyList)) {
            return Collections.emptyList();
        }
        this.fillDimensionConditionInfo();
        List<ReportData> reportDataList = this.queryReportDataList();
        this.afterQueryProcess(reportDataList);
        return reportDataList;
    }

    protected void afterQueryProcess(List<ReportData> reportDataList) {
        if (reportDataList == null) {
            return;
        }
        this.doProcessIfNeed(reportDataList);
    }

    protected void doProcessIfNeed(List<ReportData> reportData) {
        if (EmptyUtil.isEmpty(this.virtualDimMemberProcessServiceList)) {
            return;
        }
        for (IVirtualDimMemberProcessService virtualDimMemberProcessService : this.virtualDimMemberProcessServiceList) {
            virtualDimMemberProcessService.processVirtualDimMember(reportData);
        }
    }

    protected void beforeSearch(Object queryObject) {
        if (EmptyUtil.isEmpty(this.queryConditionProcessorList)) {
            return;
        }
        Collections.sort(this.queryConditionProcessorList);
        for (QueryConditionProcessor<?> queryConditionProcessor : this.queryConditionProcessorList) {
            queryConditionProcessor.beforeSearch(queryObject);
        }
    }

    public void fillDimensionConditionInfo() {
        List<Dimension> dimList = this.fundPlanSystem.getMainDimList();
        ReportTemplate template = this.analysisReport.getTemplate();
        Map templateDimMap = template.getAllTemplateDim().stream().collect(Collectors.toMap(TemplateDim::getDimensionId, Function.identity()));
        TemplateDim metricTplDim = template.getMetricTplDim();
        if (EmptyUtil.isNoEmpty((Object)metricTplDim)) {
            templateDimMap.putIfAbsent(metricTplDim.getDimensionId(), metricTplDim);
        }
        HashMap<Long, Integer> dimensionIdIndexMap = new HashMap<Long, Integer>(16);
        for (int i = 0; i < this.dimensionList.size(); ++i) {
            dimensionIdIndexMap.putIfAbsent(this.dimensionList.get(i).getId(), i);
        }
        block1: for (Dimension dimension : dimList) {
            TemplateDim templateDim = (TemplateDim)templateDimMap.get(dimension.getId());
            if (Objects.isNull(templateDim) || templateDim.getDimType().isVirtualDim()) continue;
            for (IDimensionMemberStrategy dimensionMemberStrategy : this.dimensionMemberStrategyList) {
                List<?> memberScope = dimensionMemberStrategy.getMemberScope(dimension, templateDim);
                if (memberScope == null) continue;
                this.dimensionInfoAddConsumer(dimensionIdIndexMap, dimension, memberScope);
                continue block1;
            }
        }
    }

    protected List<ReportData> queryReportDataList() {
        return null;
    }

    protected List<ReportData> queryReportDataList(Long reportTypeId, Long orgId, List<Dimension> dimensionList, List<List<Object>> dimValList) {
        return null;
    }

    protected List<ReportData> queryAllDimReportDataList(Long reportTypeId, Long orgId, List<Dimension> dimensionList, List<List<Object>> dimValList) {
        return null;
    }

    private void dimensionInfoAddConsumer(Map<Long, Integer> dimensionIdIndexMap, Dimension dimension, List<?> memberScope) {
        if (EmptyUtil.isEmpty((Object)dimension) || EmptyUtil.isEmpty(memberScope)) {
            return;
        }
        Long dimensionId = dimension.getId();
        Integer index = dimensionIdIndexMap.getOrDefault(dimensionId, -1);
        if (index == -1) {
            this.dimensionList.add(dimension);
            this.dimValList.add(new ArrayList(memberScope));
            return;
        }
        List<Object> list = this.dimValList.get(index);
        list.removeAll(memberScope);
        list.addAll(memberScope);
    }

    protected void addEmptyMemberIfNeed() {
        if (EmptyUtil.isEmpty(this.queryAllDimensionIds)) {
            return;
        }
        for (int i = 0; i < this.dimensionList.size(); ++i) {
            Dimension dimension = this.dimensionList.get(i);
            if (dimension.getDimType().isSystemDim() || !this.queryAllDimensionIds.contains(dimension.getId())) continue;
            this.dimValList.get(i).add(0L);
        }
    }

    protected void addCustomMemberIfNeed() {
        Dimension dimension;
        int i;
        ArrayList<Object> allCusMemberId = new ArrayList<Object>();
        for (i = 0; i < this.dimensionList.size(); ++i) {
            dimension = this.dimensionList.get(i);
            if (!dimension.getDimType().isCustomDim()) continue;
            List<Object> ids = this.dimValList.get(i);
            allCusMemberId.addAll(ids);
        }
        for (i = 0; i < this.dimensionList.size(); ++i) {
            dimension = this.dimensionList.get(i);
            if (!dimension.getDimType().isCustomDim()) continue;
            if (!this.queryAllDimensionIds.contains(dimension.getId())) {
                allCusMemberId.removeIf(item -> NumberUtils.equalsZero((Long)((Long)item)));
            }
            this.dimValList.set(i, allCusMemberId);
        }
    }

    public List<Dimension> getDimensionList() {
        return this.dimensionList;
    }

    public List<List<Object>> getDimValList() {
        return this.dimValList;
    }
}

