/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.IDimensionMemberStrategy;

public class AnalysisMemberOnlyTopStrategy
implements IDimensionMemberStrategy {
    private Set<Long> dimensionIds = new HashSet<Long>(2);

    public AnalysisMemberOnlyTopStrategy addDimensionId(Long dimensionId) {
        if (EmptyUtil.isNoEmpty((Long)dimensionId)) {
            this.dimensionIds.add(dimensionId);
        }
        return this;
    }

    @Override
    public List<?> getMemberScope(Dimension dimension, TemplateDim templateDim) {
        if (!this.dimensionIds.contains(dimension.getId())) {
            return null;
        }
        HashSet<Long> memberScope = new HashSet<Long>(templateDim.getMemberScope());
        Map dimMemberMap = dimension.getAllDimMemberList().stream().collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        ArrayList<Long> parents = new ArrayList<Long>(memberScope.size());
        for (Long memberId : memberScope) {
            DimMember dimMember = (DimMember)dimMemberMap.get(memberId);
            Long topIdFormMemberScope = this.getTopIdFormMemberScope(memberScope, dimMember);
            if (parents.contains(topIdFormMemberScope)) continue;
            parents.add(topIdFormMemberScope);
        }
        return parents;
    }

    private Long getTopIdFormMemberScope(Set<Long> memberScope, DimMember dimMember) {
        DimMember currentExist = dimMember;
        for (DimMember parent = dimMember.getParent(); parent != null; parent = parent.getParent()) {
            if (!memberScope.contains(parent.getId())) continue;
            currentExist = parent;
        }
        return currentExist.getId();
    }
}

