/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.IDimensionMemberStrategy;

public class AnalysisOrgMemberStrategy
implements IDimensionMemberStrategy {
    private List<Long> searchOrgList;
    private boolean fillBack;

    public AnalysisOrgMemberStrategy(List<Long> searchOrgList) {
        this(searchOrgList, false);
    }

    public AnalysisOrgMemberStrategy(List<Long> searchOrgList, boolean fillBack) {
        this.searchOrgList = searchOrgList;
        this.fillBack = fillBack;
    }

    @Override
    public List<?> getMemberScope(Dimension dimension, TemplateDim templateDim) {
        if (!dimension.getDimType().isOrgDim()) {
            return null;
        }
        if (EmptyUtil.isEmpty(this.searchOrgList)) {
            return Collections.emptyList();
        }
        List<DimMember> orgMemberList = dimension.getAllDimMemberList();
        List orgMemList = orgMemberList.stream().filter(item -> this.searchOrgList.contains(item.getId())).collect(Collectors.toList());
        List allChildMemberList = orgMemList.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).collect(Collectors.toList());
        orgMemList.addAll(allChildMemberList);
        List<Long> memberScope = orgMemList.stream().map(DimMember::getId).distinct().collect(Collectors.toList());
        if (this.fillBack) {
            templateDim.setMemberScope(memberScope);
        }
        return memberScope;
    }
}

