/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryObject;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryService;
import kd.tmc.fpm.business.domain.enums.AnalysisReportType;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.enums.TemplateDimMemScopeType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.AnalysisReport;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountAmtDetailInfo;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountAmtInfo;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountRecord;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanInfo;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.AnalysisReportDataBuildFactory;
import kd.tmc.fpm.business.domain.service.AnalysisReportDataBuildService;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.IAnalysisReportBizService;
import kd.tmc.fpm.business.domain.service.IAnalysisReportService;
import kd.tmc.fpm.business.domain.service.impl.AnalysisReportService;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.ISumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.ITemplateRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.repository.impl.SumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.impl.TemplateRepository;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.impl.RelateReportDataManager;
import kd.tmc.fpm.business.service.sumreport.service.ISummaryConfigService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.business.utils.MetricValueUtils;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.utils.AmountUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class AnalysisReportBizService
implements IAnalysisReportBizService {
    private static Log logger = LogFactory.getLog(AnalysisReportBizService.class);
    private IAnalysisReportService analysisReportService = new AnalysisReportService();
    private IReportDataQueryService reportDataQueryService = new ReportDataQueryService();
    private IDimensionRepository dimensionRepository = new DimensionRepository();
    private IReportRepository reportRepository = new ReportRepository();
    private ITemplateRepository templateRepository = new TemplateRepository();
    private ISumPlanRepository iSumPlanRepository = new SumPlanRepository();
    private ISummaryConfigService iSummaryConfigService = FpmServiceFactory.getBizService(ISummaryConfigService.class);

    @Override
    public FpmOperateResult<Report> loadReport(AnalysisReportType type, AnalysisHeader headerInfo, FundPlanSystem system) {
        if (Objects.isNull((Object)headerInfo.getAnalysisReportType())) {
            headerInfo.setAnalysisReportType(type);
        }
        return this.loadReport(headerInfo, system);
    }

    @Override
    public FpmOperateResult<Report> loadReport(AnalysisHeader headerInfo, FundPlanSystem system) {
        if (Objects.isNull(system)) {
            system = this.dimensionRepository.loadSystem(headerInfo.getBodySystemId());
        }
        AnalysisReportDataBuildService service = AnalysisReportDataBuildFactory.getService(system, headerInfo);
        AnalysisReport analysisReport = service.getAnalysisReport();
        return FpmOperateResult.success(analysisReport);
    }

    private Map<Long, Map<Long, BigDecimal>> initSumPlanSubReportExchangeRate(Report report, AnalysisHeader headerInfo, SumPlanParamConfig sumPlanParamConfig) {
        report.setExchangeRateDate(headerInfo.getExchangeRateDate());
        report.setExchangeRateTableId(headerInfo.getExchangeRateTableId());
        TemplateDim currencyTpl = report.getTemplate().getAllTemplateDim().stream().filter(tpl -> Objects.equals((Object)tpl.getDimType(), (Object)DimensionType.CURRENCY)).findAny().get();
        SumPlanParamConfigInfo sumPlanParamConfigInfo = sumPlanParamConfig.getConfigInfoList().stream().filter(item -> item.getOrgMemberId().equals(headerInfo.getSumReportOrg())).findAny().get();
        SumPlanParamConfigInfo.CurrencyMapCase currencyMapCase = sumPlanParamConfigInfo.getCurrencyMapCase();
        HashMap<Long, Map<Long, BigDecimal>> sumCurrencyRateMap = new HashMap<Long, Map<Long, BigDecimal>>(4);
        if (Objects.isNull(currencyMapCase)) {
            currencyTpl.getMemberScope().forEach(currencyId -> {
                HashMap<Long, BigDecimal> currRateMap = new HashMap<Long, BigDecimal>(2);
                currRateMap.put((Long)currencyId, BigDecimal.ONE);
                sumCurrencyRateMap.put((Long)currencyId, (Map<Long, BigDecimal>)currRateMap);
            });
            return sumCurrencyRateMap;
        }
        HashSet<Long> currencyIdList = new HashSet<Long>(8);
        List<SumPlanParamConfigInfo.CurrencyMapCaseInfo> currencyMapCaseInfoList = currencyMapCase.getCurrencyMapCaseInfoList();
        for (SumPlanParamConfigInfo.CurrencyMapCaseInfo currencyMapCaseInfo : currencyMapCaseInfoList) {
            Long sumCurrencyId = currencyMapCaseInfo.getSumCurrencyId();
            List<Long> subOrgReportCurrencyId = currencyMapCaseInfo.getSubOrgReportCurrencyId();
            currencyIdList.add(sumCurrencyId);
            currencyIdList.addAll(subOrgReportCurrencyId);
        }
        currencyIdList.addAll(currencyTpl.getMemberScope());
        DynamicObjectCollection currencyMemberColl = QueryServiceHelper.query((String)"fpm_member", (String)String.join((CharSequence)",", "id", "sourceid"), (QFilter[])new QFilter[]{new QFilter("id", "in", currencyIdList)});
        Map<Long, Object> idAndSourceIdMap = currencyMemberColl.stream().collect(Collectors.toMap(item -> item.getLong("id"), item -> item.get("sourceid")));
        ArrayList<String> errMsg = new ArrayList<String>(5);
        for (Long reportCurrencyId : currencyTpl.getMemberScope()) {
            HashMap<Long, BigDecimal> currRateMap;
            BigDecimal exchangeRate;
            Optional<SumPlanParamConfigInfo.CurrencyMapCaseInfo> sumCurrencyOpt = currencyMapCase.getCurrencyMapCaseInfoList().stream().filter(item -> reportCurrencyId.compareTo(item.getSumCurrencyId()) == 0).findAny();
            if (!sumCurrencyOpt.isPresent()) {
                exchangeRate = BigDecimal.ONE;
                currRateMap = new HashMap(2);
                currRateMap.put(reportCurrencyId, exchangeRate);
                sumCurrencyRateMap.put(reportCurrencyId, currRateMap);
                continue;
            }
            currRateMap = new HashMap<Long, BigDecimal>(4);
            List<Long> subOrgReportCurrencyId = sumCurrencyOpt.get().getSubOrgReportCurrencyId();
            for (Long subCurrencyId : subOrgReportCurrencyId) {
                if (sumCurrencyOpt.get().getSumCurrencyId().compareTo(subCurrencyId) == 0) {
                    exchangeRate = BigDecimal.ONE;
                    currRateMap.put(subCurrencyId, exchangeRate);
                    continue;
                }
                Object subSourceId = idAndSourceIdMap.get(subCurrencyId);
                Object targetSourceId = idAndSourceIdMap.get(sumCurrencyOpt.get().getSumCurrencyId());
                exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)headerInfo.getExchangeRateTableId(), (Long)((Long)subSourceId), (Long)((Long)targetSourceId), (Date)headerInfo.getExchangeRateDate());
                if (exchangeRate == null) {
                    DynamicObject sourceCurrency = TmcDataServiceHelper.loadSingle((Object)subSourceId, (String)"bd_currency");
                    DynamicObject targetCurrency = TmcDataServiceHelper.loadSingle((Object)targetSourceId, (String)"bd_currency");
                    errMsg.add(String.format(ResManager.loadKDString((String)"%1$s\u548c%2$s\u5e01\u79cd\u4e4b\u95f4\u7f3a\u5c11\u8f6c\u6362\u6c47\u7387\uff0c\u8bf7\u5148\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"AnalysisReportBizService_2", (String)"tmc-fpm-business", (Object[])new Object[0]), sourceCurrency.getString("name"), targetCurrency.getString("name")));
                    continue;
                }
                currRateMap.put(subCurrencyId, exchangeRate);
            }
            sumCurrencyRateMap.put(reportCurrencyId, currRateMap);
        }
        if (CollectionUtils.isNotEmpty(errMsg)) {
            throw new KDBizException(String.join((CharSequence)"\n", errMsg));
        }
        return sumCurrencyRateMap;
    }

    private void initReportExchangeRate(Report report, Long targetCurrencySourceId) {
        TemplateDim currencyTpl = report.getTemplate().getAllTemplateDim().stream().filter(tpl -> Objects.equals((Object)tpl.getDimType(), (Object)DimensionType.CURRENCY)).findAny().get();
        boolean existIncludeSum = currencyTpl.isIncludeSum();
        List<Long> currencyMemberIds = currencyTpl.getMemberScope();
        DynamicObjectCollection currencyMemberColl = QueryServiceHelper.query((String)"fpm_member", (String)String.join((CharSequence)",", "id", "sourceid"), (QFilter[])new QFilter[]{new QFilter("id", "in", currencyMemberIds)});
        Map<Long, Object> idAndSourceIdMap = currencyMemberColl.stream().collect(Collectors.toMap(item -> item.getLong("id"), item -> item.get("sourceid")));
        HashMap<Object, BigDecimal> exchangeRateMap = new HashMap<Object, BigDecimal>(4);
        ArrayList<String> errMsg = new ArrayList<String>(1);
        for (Long currencyMemberId : currencyMemberIds) {
            Long sourceCurrencySourceId = (Long)idAndSourceIdMap.get(currencyMemberId);
            if (!existIncludeSum || sourceCurrencySourceId.compareTo(targetCurrencySourceId) == 0) {
                exchangeRateMap.putIfAbsent(currencyMemberId, BigDecimal.ONE);
                continue;
            }
            BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)report.getExchangeRateTableId(), (Long)sourceCurrencySourceId, (Long)targetCurrencySourceId, (Date)report.getExchangeRateDate());
            if (exchangeRate == null) {
                DynamicObject sourceCurrency = TmcDataServiceHelper.loadSingle((Object)sourceCurrencySourceId, (String)"bd_currency");
                DynamicObject targetCurrency = TmcDataServiceHelper.loadSingle((Object)targetCurrencySourceId, (String)"bd_currency");
                errMsg.add(String.format(ResManager.loadKDString((String)"%1$s\u548c%2$s\u5e01\u79cd\u4e4b\u95f4\u7f3a\u5c11\u8f6c\u6362\u6c47\u7387\uff0c\u8bf7\u5148\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"AnalysisReportBizService_3", (String)"tmc-fpm-business", (Object[])new Object[0]), sourceCurrency.getString("name"), targetCurrency.getString("name")));
                continue;
            }
            exchangeRateMap.put(currencyMemberId, exchangeRate);
        }
        if (CollectionUtils.isNotEmpty(errMsg)) {
            throw new KDBizException(String.join((CharSequence)"\n", errMsg));
        }
        report.setExchangeRateMap(exchangeRateMap);
    }

    @Override
    public FpmOperateResult<Report> loadSumPlanSubReport(AnalysisHeader headerInfo, FundPlanSystem system, IFpmPageCacheService cacheService) {
        SumPlanParamConfig sumPlanParamConfig = this.iSummaryConfigService.getSummaryParamConfigWithoutNoneUpperSumOrg(headerInfo.getReportSumId());
        if (EmptyUtil.isEmpty((Object)sumPlanParamConfig)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5c11\u6c47\u603b\u53c2\u6570\u914d\u7f6e\uff0c\u8bf7\u5148\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"AnalysisReportBizService_4", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        FpmOperateResult<ReportTemplate> tAnalysisTemplate = this.analysisReportService.generateSumPlanSubReportTemplate(system, sumPlanParamConfig, headerInfo, cacheService);
        if (!tAnalysisTemplate.isSuccess()) {
            return FpmOperateResult.error(tAnalysisTemplate.getMessageList());
        }
        FpmOperateResult<Report> tAnalysisReport = this.analysisReportService.generateAnalysisReport(tAnalysisTemplate.getData(), headerInfo);
        Report report = tAnalysisReport.getData();
        this.disableContainDetailReportTypeIfNeed(headerInfo, report, system);
        Map<Long, Map<Long, BigDecimal>> sumCurrencyRateMap = this.initSumPlanSubReportExchangeRate(report, headerInfo, sumPlanParamConfig);
        this.initReportExchangeRate(report, system.getCurrencyId());
        this.buildSumPlanSubReportData(system, report, headerInfo, cacheService, sumPlanParamConfig);
        logger.info("\u67e5\u8be2\u5230\u7684\u62a5\u8868\u6570\u636e\u91cf\uff1a{}", (Object)report.getReportDataList().size());
        SumPlanInfo sumPlanInfo = SumPlanInfo.builder().sumOrgMember(system.getMainDimensionByDimType(DimensionType.ORG).getDimMemberById(headerInfo.getSumReportOrg())).report(report).system(system).currencyRateMap(sumCurrencyRateMap).build();
        FpmOperateResult<Report> reportFpmOperateResult = this.analysisReportService.calculateSumPlanSubReport(sumPlanInfo, headerInfo);
        report = reportFpmOperateResult.getData();
        logger.info("\u91cd\u65b0\u8ba1\u7b97\u540e\u7684\u62a5\u8868\u6570\u636e\u91cf\uff1a{}", (Object)report.getReportDataList().size());
        this.dealRelationReportData(headerInfo, sumPlanInfo, sumPlanParamConfig);
        logger.info("\u6c47\u603b\u6838\u5b9a\u91d1\u989d\u540e\u7684\u62a5\u8868\u6570\u636e\u91cf\uff1a{}", (Object)report.getReportDataList().size());
        this.updateMetricIfShowApprovedAmt(report, cacheService, system);
        return FpmOperateResult.success(report);
    }

    private void buildSumPlanSubReportData(FundPlanSystem system, Report report, AnalysisHeader headerInfo, IFpmPageCacheService cacheService, SumPlanParamConfig sumPlanParamConfig) {
        List<ReportDataQueryResult> resultList;
        ReportDataQueryObject queryObject = new ReportDataQueryObject();
        ArrayList<Dimension> dimIdList = new ArrayList<Dimension>(0);
        ArrayList<List<Object>> dimValList = new ArrayList<List<Object>>(0);
        ReportTemplate template = report.getTemplate();
        List<Dimension> dimList = system.getDimList();
        List<TemplateDim> allTemplateDim = template.getAllTemplateDim();
        Set<Long> orgMemberIdSet = Collections.EMPTY_SET;
        for (Dimension dimension : dimList) {
            List<Long> members;
            if (DimensionType.SUBJECTS == dimension.getDimType()) {
                dimIdList.add(dimension);
                TemplateDim templateDim = allTemplateDim.stream().filter(item -> item.getDimType() == dimension.getDimType()).findFirst().get();
                dimValList.add(templateDim.getMemberScope().stream().map(item -> item).collect(Collectors.toList()));
                continue;
            }
            if (DimensionType.PERIOD == dimension.getDimType() && CollectionUtils.isNotEmpty(headerInfo.getPeriodId())) {
                dimIdList.add(dimension);
                dimValList.add(new ArrayList<Long>(report.getAllPeriodMemberIds()));
                continue;
            }
            if (DimensionType.ORG == dimension.getDimType()) {
                dimIdList.add(dimension);
                orgMemberIdSet = this.listSumOrgAllSubReportOrg(sumPlanParamConfig, headerInfo);
                ArrayList<Long> orgMemberIds = new ArrayList<Long>(orgMemberIdSet);
                headerInfo.setOrg(orgMemberIds);
                dimValList.add(new ArrayList<Long>(orgMemberIds));
                continue;
            }
            if (DimensionType.CURRENCY == dimension.getDimType() && CollectionUtils.isNotEmpty(headerInfo.getCurrency())) {
                SumPlanParamConfigInfo sumPlanParamConfigInfo = sumPlanParamConfig.getConfigInfoList().stream().filter(item -> item.getOrgMemberId().equals(headerInfo.getSumReportOrg())).findAny().get();
                SumPlanParamConfigInfo.CurrencyMapCase currencyMapCase = sumPlanParamConfigInfo.getCurrencyMapCase();
                if (Objects.isNull(currencyMapCase)) {
                    dimIdList.add(dimension);
                    dimValList.add(headerInfo.getCurrency().stream().map(currency -> currency).collect(Collectors.toList()));
                    continue;
                }
                HashSet<Long> currencyIdList = new HashSet<Long>(8);
                for (Long reportCurrencyId : headerInfo.getCurrency()) {
                    currencyIdList.add(reportCurrencyId);
                    Optional<SumPlanParamConfigInfo.CurrencyMapCaseInfo> sumCurrencyOpt = currencyMapCase.getCurrencyMapCaseInfoList().stream().filter(item -> reportCurrencyId.compareTo(item.getSumCurrencyId()) == 0).findAny();
                    sumCurrencyOpt.ifPresent(currencyMapCaseInfo -> currencyIdList.addAll(currencyMapCaseInfo.getSubOrgReportCurrencyId()));
                }
                dimIdList.add(dimension);
                dimValList.add(currencyIdList.stream().collect(Collectors.toList()));
                continue;
            }
            if (DimensionType.SETTLEMENT_TYPE == dimension.getDimType() && !CollectionUtils.isEmpty(headerInfo.getSettlementMethod())) {
                dimIdList.add(dimension);
                dimValList.add(headerInfo.getSettlementMethod().stream().map(item -> item).collect(Collectors.toList()));
                continue;
            }
            if (DimensionType.COMPANY == dimension.getDimType() && !CollectionUtils.isEmpty(headerInfo.getCompany())) {
                dimIdList.add(dimension);
                dimValList.add(headerInfo.getCompany().stream().map(item -> item).collect(Collectors.toList()));
                continue;
            }
            if (DimensionType.CUSTOM != dimension.getDimType() || MapUtils.isEmpty(headerInfo.getCustomDimension()) || !CollectionUtils.isNotEmpty(members = headerInfo.getCustomDimension().get(dimension.getNumber()))) continue;
            dimIdList.add(dimension);
            dimValList.add(members.stream().map(item -> item).collect(Collectors.toList()));
        }
        queryObject.setDimIdList(dimIdList);
        queryObject.setDimValList(dimValList);
        queryObject.setMainTable(true);
        queryObject.setReportPeriodId(Long.valueOf(cacheService.get("reportperiod")));
        HashSet<Long> reportSumIdSet = new HashSet<Long>(2, 1.0f);
        reportSumIdSet.add(headerInfo.getReportSumId());
        Report originalReport = this.reportRepository.loadSimpleReport(reportSumIdSet, t -> t.setNeedTemplate(true)).get(0);
        ArrayList<ReportStatus> reportStatusList = new ArrayList<ReportStatus>(2);
        Collections.addAll(reportStatusList, ReportStatus.REPORTING, ReportStatus.ENABLE);
        if (ReportProcessStatus.AUDIT == originalReport.getProcessStatus()) {
            queryObject.setReportStatuss(reportStatusList);
            resultList = this.reportDataQueryService.queryReportData(queryObject);
        } else {
            queryObject.setReportIdS(Collections.singletonList(headerInfo.getReportSumId()));
            resultList = this.reportDataQueryService.queryReportData(queryObject);
            int idx = IntStream.range(0, dimIdList.size()).filter(i -> DimensionType.ORG == ((Dimension)dimIdList.get(i)).getDimType()).findAny().getAsInt();
            List<Long> subAuditedReportOrgList = this.listSubAuditedReportOrg(sumPlanParamConfig, orgMemberIdSet, headerInfo.getSumReportOrg(), queryObject.getReportPeriodId());
            queryObject.getDimValList().set(idx, subAuditedReportOrgList.stream().map(o -> o).collect(Collectors.toList()));
            queryObject.setReportIdS(null);
            queryObject.setReportStatuss(reportStatusList);
            resultList.addAll(this.reportDataQueryService.queryReportData(queryObject));
        }
        List<ReportData> reportDataList = report.getReportDataList();
        reportDataList.addAll(this.converterToReportDataByTemplate(resultList, allTemplateDim));
    }

    private List<ReportData> converterToReportDataByTemplate(List<ReportDataQueryResult> resultList, List<TemplateDim> allTemplateDim) {
        ArrayList<ReportData> result = new ArrayList<ReportData>(resultList.size());
        logger.info("\u67e5\u8be2\u5230\u7684\u6570\u636e-converterToReportData size\uff1a{}", (Object)resultList.size());
        for (ReportDataQueryResult reportDataQueryResult : resultList) {
            if (reportDataQueryResult.getPlanAmt().compareTo(BigDecimal.ZERO) == 0 && reportDataQueryResult.getActAmt().compareTo(BigDecimal.ZERO) == 0 && reportDataQueryResult.getLockAmt().compareTo(BigDecimal.ZERO) == 0 && reportDataQueryResult.getApplyPlanAmt().compareTo(BigDecimal.ZERO) == 0 && reportDataQueryResult.getOriginalPlanAmt().compareTo(BigDecimal.ZERO) == 0 && reportDataQueryResult.getOffsetAmt().compareTo(BigDecimal.ZERO) == 0) continue;
            ArrayList<Object> currDimValList = new ArrayList<Object>(allTemplateDim.size());
            ArrayList<TemplateDim> currDimList = new ArrayList<TemplateDim>(allTemplateDim.size());
            List<Object> originDimValList = reportDataQueryResult.getDimValList();
            List<Long> originDimIdList = reportDataQueryResult.getDimIdList();
            for (int i = 0; i < originDimIdList.size(); ++i) {
                Long dimId = originDimIdList.get(i);
                OptionalInt dimTplIdxOpt = IntStream.range(0, allTemplateDim.size()).filter(idx -> ((TemplateDim)allTemplateDim.get(idx)).getDimensionId().compareTo(dimId) == 0).findAny();
                if (!dimTplIdxOpt.isPresent()) continue;
                currDimList.add(allTemplateDim.get(dimTplIdxOpt.getAsInt()));
                currDimValList.add(originDimValList.get(i));
            }
            ReportData reportData = new ReportData();
            reportData.setId(reportDataQueryResult.getId());
            reportData.setActAmt(reportDataQueryResult.getActAmt());
            reportData.setPlanAmt(reportDataQueryResult.getPlanAmt());
            reportData.setLockAmt(reportDataQueryResult.getLockAmt());
            reportData.setReportPlanAmt(reportDataQueryResult.getReportPlanAmt() == null ? BigDecimal.ZERO : reportDataQueryResult.getReportPlanAmt());
            reportData.setOriginalPlanAmt(reportDataQueryResult.getApplyPlanAmt());
            reportData.setVersion(reportDataQueryResult.getVersion() + 1);
            reportData.setDimValList(currDimValList);
            reportData.setReportPeriodId(currDimList.stream().filter(item -> item.getDimType() == DimensionType.PERIOD).findFirst().get().getId());
            reportData.setAmountUnit(reportDataQueryResult.getAmountUnit());
            reportData.setReportId(reportDataQueryResult.getReportId());
            reportData.setMainTable(reportDataQueryResult.isMainTable());
            reportData.setOffsetAmt(reportDataQueryResult.getOffsetAmt());
            reportData.setRow(reportDataQueryResult.getRow());
            reportData.setCol(reportDataQueryResult.getCol());
            reportData.putAllMetricVal(reportDataQueryResult.getMetricValMap());
            reportData.setRow(reportDataQueryResult.getRow());
            reportData.setCol(reportDataQueryResult.getCol());
            reportData.setDimList(currDimList);
            result.add(reportData);
        }
        logger.info("\u67e5\u8be2\u5230\u7684\u6570\u636e-converterResult size\uff1a{}", (Object)resultList.size());
        return result;
    }

    private void updateMetricIfShowApprovedAmt(Report report, IFpmPageCacheService cacheService, FundPlanSystem system) {
        List metricMembers = system.getDimList().stream().filter(dimension -> dimension.getDimType() == DimensionType.METRIC).map(Dimension::getAllDimMemberList).flatMap(Collection::stream).map(dimMember -> (MetricMember)dimMember).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(metricMembers)) {
            return;
        }
        for (ReportData reportData : report.getReportDataList()) {
            for (MetricMember metricMember2 : metricMembers) {
                reportData.putMetricVal(metricMember2.getId(), MetricValueUtils.getMetricValue(metricMember2.getTemplateMetricType(), reportData));
            }
        }
        boolean isShowApprovedAmt = Boolean.parseBoolean(cacheService.get("showlimit"));
        Predicate<MetricMember> memberScopeFilter = metricMember -> isShowApprovedAmt ? metricMember.getTemplateMetricType() == TemplateMetricType.REPORTPLANAMT || metricMember.getTemplateMetricType() == TemplateMetricType.ORIGINALPLANAMT : metricMember.getTemplateMetricType() == TemplateMetricType.PLANAMT;
        List<Long> memberScope = metricMembers.stream().filter(memberScopeFilter).map(DimMember::getId).collect(Collectors.toList());
        Dimension metricMainDim = system.getMainDimList().stream().filter(dimension -> dimension.getDimType() == DimensionType.METRIC).findAny().get();
        int metricDimLevel = 1 + report.getTemplate().getColDimList().stream().mapToInt(TemplateDim::getLevel).max().getAsInt();
        TemplateDim metricTplDim = new TemplateDim();
        metricTplDim.setDimensionId(metricMainDim.getId());
        metricTplDim.setDimensionName(metricMainDim.getName());
        metricTplDim.setDetailDim(false);
        metricTplDim.setIncludeSum(false);
        metricTplDim.setVisible(true);
        metricTplDim.setExpand(false);
        metricTplDim.setScopeType(TemplateDimMemScopeType.FIXED_MEMBER);
        metricTplDim.setLocation(DimLocation.COL);
        metricTplDim.setLevel(metricDimLevel);
        metricTplDim.setDimType(DimensionType.METRIC);
        metricTplDim.setMemberScope(memberScope);
        report.getTemplate().setMetricTplDim(metricTplDim);
    }

    private void dealRelationReportData(AnalysisHeader header, SumPlanInfo sumPlanInfo, SumPlanParamConfig sumPlanParamConfig) {
        Report report = sumPlanInfo.getReport();
        if (CollectionUtils.isEmpty(report.getReportDataList()) || Objects.isNull(header.getReportSumRecordId())) {
            return;
        }
        SumPlanRecord sumPlanRecord = this.iSumPlanRepository.load(header.getReportSumRecordId());
        if (sumPlanRecord.getReportStatus() == ReportStatus.ENABLE) {
            return;
        }
        ApprovedAmountRecord approvedAmountRecord = this.iSumPlanRepository.loadApprovedAmtBySumId(sumPlanRecord.getId());
        if (EmptyUtil.isEmpty((Object)approvedAmountRecord)) {
            return;
        }
        logger.info("\u5b58\u5728\u6838\u5b9a\u8bb0\u5f55\uff0c{}", (Object)approvedAmountRecord.getSumPlanRecordId());
        Map<Long, BigDecimal> approvedAmtMap = approvedAmountRecord.getAmountAmtInfoList().stream().map(ApprovedAmountAmtInfo::getAmtDetailInfoList).flatMap(Collection::stream).filter(item -> item.getEvalDetail() == false).collect(Collectors.toMap(ApprovedAmountAmtDetailInfo::getReportDataId, ApprovedAmountAmtDetailInfo::getApprovedAmt));
        if (EmptyUtil.isEmpty(approvedAmtMap)) {
            logger.info("\u6838\u5b9a\u8bb0\u5f55{}\u6c47\u603b\u989d\u5ea6\u6838\u5b9a\u4fe1\u606f\u4e0d\u5b58\u5728", (Object)approvedAmountRecord.getSumPlanRecordId());
            return;
        }
        Map<Long, List<Long>> sumReportDataId2SourceIdMap = this.reportRepository.getReportDataId2SourceIdMapByReportId(header.getReportSumId());
        HashSet nonApprovedAmtLeafRDIdSet = Sets.newHashSetWithExpectedSize((int)16);
        sumReportDataId2SourceIdMap.forEach((reportDataId, sourceIds) -> {
            if (CollectionUtils.isNotEmpty((Collection)sourceIds)) {
                if (sourceIds.stream().anyMatch(approvedAmtMap::containsKey)) {
                    sourceIds.stream().filter(sourceId -> !approvedAmtMap.containsKey(sourceId)).forEach(nonApprovedAmtLeafRDIdSet::add);
                }
            }
        });
        ReportDataQueryObject queryObject = new ReportDataQueryObject();
        ArrayList<Long> queryIdList = new ArrayList<Long>(approvedAmtMap.size() + nonApprovedAmtLeafRDIdSet.size());
        queryIdList.addAll(approvedAmtMap.keySet());
        queryIdList.addAll(nonApprovedAmtLeafRDIdSet);
        queryObject.setIdList(queryIdList);
        List<ReportDataQueryResult> relationDataResult = this.reportDataQueryService.queryReportData(queryObject);
        List<ReportData> approveAmtRDList = ReportHelper.convert(relationDataResult);
        approveAmtRDList.stream().filter(item -> nonApprovedAmtLeafRDIdSet.contains(item.getId())).forEach(item -> approvedAmtMap.put(item.getId(), item.getOriginalPlanAmt()));
        FundPlanSystem fundPlanSystem = sumPlanInfo.getSystem();
        this.fillRelateReportData(fundPlanSystem, approvedAmtMap, approveAmtRDList);
        this.calAmtAfterApprovedAndInnerCancel(approveAmtRDList, approvedAmtMap, sumPlanParamConfig, sumPlanInfo);
    }

    private void fillRelateReportData(FundPlanSystem fundPlanSystem, Map<Long, BigDecimal> approvedAmtMap, List<ReportData> approveAmtRDList) {
        ArrayList<ReportData> sourceReportDataList = new ArrayList<ReportData>(approveAmtRDList.size());
        for (ReportData approveAmtRD : approveAmtRDList) {
            ReportData reportData = new ReportData(approveAmtRD);
            reportData.setId(approveAmtRD.getId());
            reportData.setOriginalPlanAmt(approvedAmtMap.getOrDefault(reportData.getId(), BigDecimal.ZERO));
            sourceReportDataList.add(reportData);
        }
        ControlContext controlContext = new ControlContext();
        controlContext.addSystem(fundPlanSystem);
        RelateReportDataManager relateReportDataManager = new RelateReportDataManager(sourceReportDataList, controlContext);
        List<ReportData> reportDataList = relateReportDataManager.reCalculateRelateDataByDAG();
        for (ReportData reportData : reportDataList) {
            Long reportDataId = reportData.getId();
            if (approvedAmtMap.containsKey(reportDataId)) continue;
            approvedAmtMap.put(reportDataId, reportData.getOriginalPlanAmt());
            approveAmtRDList.add(reportData);
        }
    }

    private void calAmtAfterApprovedAndInnerCancel(List<ReportData> relateReportDataList, Map<Long, BigDecimal> amtMap, SumPlanParamConfig sumPlanParamConfig, SumPlanInfo sumPlanInfo) {
        Report report = sumPlanInfo.getReport();
        FundPlanSystem fundPlanSystem = sumPlanInfo.getSystem();
        QueryIndexInfo<Object, ReportData> queryIndexInfo = report.getQueryIndexInfo(fundPlanSystem);
        Long sumOrgMemberId = sumPlanInfo.getSumOrgMember().getId();
        Long orgDimId = fundPlanSystem.getMainDimensionByDimType(DimensionType.ORG).getId();
        Long currencyDimId = fundPlanSystem.getMainDimensionByDimType(DimensionType.CURRENCY).getId();
        Set reportDataAllDimIdSet = report.getReportDataList().stream().map(ReportData::getDimList).flatMap(Collection::stream).filter(Objects::nonNull).filter(templateDim -> Objects.nonNull(templateDim.getDimensionId()) && templateDim.getDimType() != DimensionType.DETAILDIM).map(TemplateDim::getDimensionId).collect(Collectors.toSet());
        Map sumPlanParamConfigInfoMap = sumPlanParamConfig.getConfigInfoList().stream().collect(Collectors.toMap(SumPlanParamConfigInfo::getOrgMemberId, Function.identity(), (a, b) -> a));
        HashSet<Long> updatedTargetReportDataIdSet = new HashSet<Long>(16);
        Map<Long, Map<Long, BigDecimal>> sumCurrencyRateMap = sumPlanInfo.getCurrencyRateMap();
        block0: for (ReportData reportData : relateReportDataList) {
            Long reportCurrencyId;
            boolean isTransferReportCurrency;
            Object orgMemberId;
            if (reportData.isAuxiliaryInfo() || Objects.isNull(orgMemberId = reportData.getDimValByDimensionId(orgDimId))) continue;
            DimensionInfoBean originalDimensionInfoBean = DimensionInfoHelper.getDimensionInfoBeanByFilter(reportData, templateDim -> reportDataAllDimIdSet.contains(templateDim.getDimensionId()));
            Object currencyMemberId = reportData.getDimValByDimensionId(currencyDimId);
            boolean bl = isTransferReportCurrency = !Objects.equals(currencyMemberId, reportCurrencyId = this.transferReportCurrencyId((Long)currencyMemberId, sumCurrencyRateMap));
            if (isTransferReportCurrency) {
                originalDimensionInfoBean.replaceValueIfContains(currencyDimId, (Object)reportCurrencyId);
            }
            while (sumPlanParamConfigInfoMap.containsKey(orgMemberId)) {
                Long parentOrgId = ((SumPlanParamConfigInfo)sumPlanParamConfigInfoMap.get(orgMemberId)).getParentId();
                orgMemberId = parentOrgId;
                if (EmptyUtil.isEmpty((Long)parentOrgId)) continue;
                DimensionInfoBean dimensionInfoBean = originalDimensionInfoBean.copy();
                dimensionInfoBean.replaceValueIfContains(orgDimId, (Object)parentOrgId);
                List<ReportData> parentOrgReportDataList = queryIndexInfo.findList(dimensionInfoBean);
                if (EmptyUtil.isEmpty(parentOrgReportDataList)) continue;
                if (parentOrgReportDataList.size() > 1) {
                    logger.info("\u6c47\u603b\u8868\u4e2d\u6570\u636e\u5f02\u5e38\uff0c\u540c\u4e00\u7ef4\u5ea6\u7ec4\u5408\u4e0b\u5b58\u5728\u591a\u4e2a\u6570\u636e,\u3010{}\u3011,\u3010{}\u3011,\u3010{}\u3011", (Object)dimensionInfoBean.getDimensionIdList(), (Object)dimensionInfoBean.getMemberIdList());
                    throw new KDBizException(ResManager.loadKDString((String)"\u6c47\u603b\u8868\u4e2d\u6570\u636e\u5f02\u5e38\uff0c\u540c\u4e00\u7ef4\u5ea6\u7ec4\u5408\u4e0b\u5b58\u5728\u591a\u4e2a\u6570\u636e", (String)"AnalysisReportBizService_5", (String)"tmc-fpm-business", (Object[])new Object[0]));
                }
                ReportData targetReportData = parentOrgReportDataList.get(0);
                boolean firstUpdated = updatedTargetReportDataIdSet.add(targetReportData.getId());
                this.updateAmtAfterApproved(reportData, targetReportData, amtMap, firstUpdated, isTransferReportCurrency ? sumCurrencyRateMap.get(reportCurrencyId) : null);
                if (parentOrgId.compareTo(sumOrgMemberId) != 0) continue;
                continue block0;
            }
        }
    }

    private Long transferReportCurrencyId(Long currencyMemberId, Map<Long, Map<Long, BigDecimal>> sumCurrencyRateMap) {
        if (!sumCurrencyRateMap.containsKey(currencyMemberId)) {
            for (Map.Entry<Long, Map<Long, BigDecimal>> sumCurrencyRateMapEntry : sumCurrencyRateMap.entrySet()) {
                if (!sumCurrencyRateMapEntry.getValue().containsKey(currencyMemberId)) continue;
                return sumCurrencyRateMapEntry.getKey();
            }
        }
        return currencyMemberId;
    }

    private void updateAmtAfterApproved(ReportData reportData, ReportData targetReportData, Map<Long, BigDecimal> approvedAmtMap, boolean firstUpdated, Map<Long, BigDecimal> exchangeMap) {
        BigDecimal amt = approvedAmtMap.getOrDefault(reportData.getId(), BigDecimal.ZERO);
        if (exchangeMap != null) {
            amt = amt.multiply(exchangeMap.get(reportData.getDimValByDimType(DimensionType.CURRENCY)));
        }
        amt = AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)reportData.getAmountUnit().getNumber()), (AmountUnitEnum)AmountUnitEnum.get((String)targetReportData.getAmountUnit().getNumber()), (BigDecimal)amt);
        if (firstUpdated) {
            targetReportData.setOriginalPlanAmt(BigDecimal.ZERO);
            targetReportData.setPlanAmt(BigDecimal.ZERO);
        }
        targetReportData.setOriginalPlanAmt(targetReportData.getOriginalPlanAmt().add(amt));
        targetReportData.setPlanAmt(targetReportData.getPlanAmt().add(amt));
    }

    private List<Long> listSubAuditedReportOrg(SumPlanParamConfig sumPlanParamConfig, Set<Long> reportOrgSet, Long sumReportOrg, Long reportPeriodId) {
        List allChildConfigInfoList = sumPlanParamConfig.getConfigInfoList().stream().filter(item -> item.getOrgMemberId().equals(sumReportOrg)).map(SumPlanParamConfigInfo::getAllChildren).flatMap(Collection::stream).collect(Collectors.toList());
        Map allChildConfigInfoMap = allChildConfigInfoList.stream().collect(Collectors.toMap(SumPlanParamConfigInfo::getOrgMemberId, Function.identity(), (a, b) -> a));
        Set<Long> allChildSumReportOrgSet = allChildConfigInfoList.stream().filter(SumPlanParamConfigInfo::isSumAuditNode).map(SumPlanParamConfigInfo::getOrgMemberId).collect(Collectors.toSet());
        List<SumPlanRecord> allChildSumReportList = this.iSumPlanRepository.loadSumPlanRecord(allChildSumReportOrgSet, reportPeriodId);
        Set allChildAuditSumReportOrgSet = allChildSumReportList.stream().filter(sumPlanRecord -> BillStatus.AUDITED == sumPlanRecord.getStatus()).map(SumPlanRecord::getReportOrg).collect(Collectors.toSet());
        ArrayList<Long> subAuditedReportOrgIds = new ArrayList<Long>(allChildConfigInfoList.size());
        block0: for (SumPlanParamConfigInfo childConfigInfo : allChildConfigInfoList) {
            if (!reportOrgSet.contains(childConfigInfo.getOrgMemberId())) continue;
            if (childConfigInfo.isSumAuditNode()) {
                if (!allChildAuditSumReportOrgSet.contains(childConfigInfo.getOrgMemberId())) continue;
                subAuditedReportOrgIds.add(childConfigInfo.getOrgMemberId());
                continue;
            }
            Long currParentOrgId = childConfigInfo.getParentId();
            while (Objects.equals(sumReportOrg, currParentOrgId) || allChildConfigInfoMap.containsKey(currParentOrgId)) {
                if (Objects.equals(sumReportOrg, currParentOrgId)) {
                    subAuditedReportOrgIds.add(childConfigInfo.getOrgMemberId());
                    continue block0;
                }
                if (allChildSumReportOrgSet.contains(currParentOrgId)) {
                    if (!allChildAuditSumReportOrgSet.contains(currParentOrgId)) continue block0;
                    subAuditedReportOrgIds.add(childConfigInfo.getOrgMemberId());
                    continue block0;
                }
                currParentOrgId = ((SumPlanParamConfigInfo)allChildConfigInfoMap.get(currParentOrgId)).getParentId();
            }
        }
        return subAuditedReportOrgIds;
    }

    private Set<Long> listSumOrgAllSubReportOrg(SumPlanParamConfig sumPlanParamConfig, AnalysisHeader headerInfo) {
        HashSet<Object> selectedReportOrgSet;
        if (CollectionUtils.isEmpty(headerInfo.getOrg())) {
            selectedReportOrgSet = new HashSet(2, 1.0f);
            selectedReportOrgSet.add(headerInfo.getSumReportOrg());
        } else {
            selectedReportOrgSet = new HashSet<Long>(headerInfo.getOrg());
        }
        Set allSubReportOrgSet = sumPlanParamConfig.getConfigInfoList().stream().filter(item -> selectedReportOrgSet.contains(item.getOrgMemberId())).map(SumPlanParamConfigInfo::getAllChildren).flatMap(Collection::stream).map(SumPlanParamConfigInfo::getOrgMemberId).collect(Collectors.toSet());
        selectedReportOrgSet.addAll(allSubReportOrgSet);
        return selectedReportOrgSet;
    }

    private void disableContainDetailReportTypeIfNeed(AnalysisHeader header, Report report, FundPlanSystem system) {
        if (report.getReportPeriodType().getDetailPeriodType() == null || !report.getReportPeriodType().isRoll() || report.getReportPeriodType().isRollIncludeDetailPeriod()) {
            return;
        }
        Map periodMemberMap = system.getMainDimensionByDimType(DimensionType.PERIOD).getAllDimMemberList(PeriodMember.class).stream().collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        String prop = "periodlist.fbasedataid.id";
        DynamicObjectCollection reportPeriodDyColl = QueryServiceHelper.query((String)"fpm_report", (String)prop, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)header.getReportSumId())});
        List sumReportPeriodMembers = reportPeriodDyColl.stream().map(dy -> dy.getLong(prop)).map(periodMemberMap::get).sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList());
        if (!Objects.equals(report.getPeriodMemberList().get(0).getId(), ((PeriodMember)sumReportPeriodMembers.get(0)).getId())) {
            report.getReportPeriodType().setDetailPeriodType(null);
        }
    }
}

