/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.service.impl.AbstractAnalysisReportDataBuildService;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class AnalysisReportDataDimensionSumService
extends AbstractAnalysisReportDataBuildService {
    private List<Long> sumDimensionIds = new ArrayList<Long>(4);

    public AnalysisReportDataDimensionSumService(AbstractAnalysisReportDataBuildService abstractAnalysisReportDataBuildService) {
        super(abstractAnalysisReportDataBuildService);
    }

    public AnalysisReportDataDimensionSumService addSumDimension(Long dimensionId) {
        this.sumDimensionIds.add(dimensionId);
        return this;
    }

    @Override
    protected void rebuildData() {
        super.rebuildData();
        if (EmptyUtil.isEmpty(this.sumDimensionIds)) {
            return;
        }
        if (this.analysisTemplate.getTemplateType().isDetail()) {
            return;
        }
        DimensionIndexTree indexTree = this.analysisReport.getIndexTree(this.system);
        List<TreeNode> leafList = indexTree.getLeafList();
        for (Long dimensionId : this.sumDimensionIds) {
            Dimension orgDimension = this.system.getMainDimensionByDimensionId(dimensionId);
            List<DimMember> allDimMemberList = orgDimension.getAllDimMemberList();
            Map<Long, DimMember> dimMemberMap = allDimMemberList.stream().collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
            Consumer<TreeNode> sumAction = this.getSumAction(orgDimension, dimMemberMap);
            leafList.stream().sorted(Comparator.comparing(treeNode -> {
                Object member = treeNode.getDimInfoBean().getMemberByDimensionId(orgDimension.getId());
                if (EmptyUtil.isEmpty((Object)member)) {
                    return 1;
                }
                DimMember dimMember = (DimMember)dimMemberMap.get(member);
                if (Objects.isNull(dimMember)) {
                    return 1;
                }
                return -dimMember.getLevel();
            })).forEach(sumAction);
        }
        List<ReportData> reportDataList = leafList.stream().map(TreeNode::getDataList).filter(Objects::nonNull).flatMap(Collection::stream).map(ReportData.class::cast).collect(Collectors.toList());
        this.analysisReport.setReportDataList(reportDataList);
    }

    public Consumer<TreeNode> getSumAction(Dimension orgDimension, Map<Long, DimMember> dimMemberMap) {
        Long orgDimensionId = orgDimension.getId();
        DimensionIndexTree indexTree = this.analysisReport.getIndexTree(this.system);
        Map parentChildrenMap = dimMemberMap.values().stream().filter(dimMember -> EmptyUtil.isNoEmpty((Long)dimMember.getParentId())).collect(Collectors.groupingBy(DimMember::getParentId, Collectors.mapping(DimMember::getId, Collectors.toSet())));
        return treeNode -> {
            ReportData sumRd;
            DimensionInfoBean dimInfoBean = treeNode.getDimInfoBean();
            Object memberId = dimInfoBean.getMemberByDimensionId(orgDimensionId);
            if (EmptyUtil.isEmpty((Object)memberId)) {
                return;
            }
            DimMember dimMember = (DimMember)dimMemberMap.get(memberId);
            if (Objects.isNull(dimMember)) {
                return;
            }
            if (!parentChildrenMap.containsKey(memberId)) {
                return;
            }
            Set childrenId = (Set)parentChildrenMap.get(memberId);
            if (EmptyUtil.isEmpty((Collection)childrenId)) {
                return;
            }
            List<Object> currentNodeDataList = treeNode.getDataList();
            if (Objects.isNull(currentNodeDataList)) {
                currentNodeDataList = new ArrayList<Object>(2);
                treeNode.setDataList(currentNodeDataList);
            }
            ReportData reportData = sumRd = EmptyUtil.isEmpty(currentNodeDataList) ? null : (ReportData)currentNodeDataList.get(0);
            if (sumRd != null) {
                return;
            }
            DimensionInfoBean copy = dimInfoBean.copy();
            for (Long childId : childrenId) {
                List<Object> dataList;
                copy.replaceValueIfContains(orgDimensionId, (Object)childId);
                TreeNode orgLeafNode = indexTree.find(copy);
                if (Objects.isNull(orgLeafNode) || EmptyUtil.isEmpty(dataList = orgLeafNode.getDataList())) continue;
                for (Object data : dataList) {
                    ReportData rd;
                    if (!(data instanceof ReportData) || (sumRd = this.createIfNeed(sumRd, rd = (ReportData)data, childId, memberId)) == null) continue;
                    this.addAmount2ReportCurrency(sumRd, rd);
                }
            }
            if (sumRd != null) {
                currentNodeDataList.add(sumRd);
            }
        };
    }

    private void addAmount2ReportCurrency(ReportData sumRd, ReportData childRd) {
        sumRd.addPlanAmt(childRd.getPlanAmt());
        sumRd.addLockAmt(childRd.getLockAmt());
        sumRd.addActAmt(childRd.getActAmt());
        sumRd.addReportPlanAmt(childRd.getReportPlanAmt());
        sumRd.addOriginalPlanAmt(childRd.getOriginalPlanAmt());
        sumRd.addPlanReferenceAmt(childRd.getPlanReferenceAmt());
    }

    private ReportData createIfNeed(ReportData sumRd, ReportData rd, Long orgId, Object parentId) {
        if (sumRd != null) {
            return sumRd;
        }
        sumRd = new ReportData(rd);
        int index = rd.getDimValList().indexOf(orgId);
        if (index == -1) {
            return null;
        }
        sumRd.getDimValList().set(index, parentId);
        sumRd.clearAmt();
        return sumRd;
    }
}

