/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.impl.AbstractAnalysisReportDataBuildService;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class AnalysisReportDataRebuildService
extends AbstractAnalysisReportDataBuildService {
    public AnalysisReportDataRebuildService(AbstractAnalysisReportDataBuildService abstractAnalysisReportDataBuildService) {
        super(abstractAnalysisReportDataBuildService);
    }

    @Override
    protected void rebuildData() {
        super.rebuildData();
        if (this.analysisTemplate.getTemplateType().isDetail()) {
            return;
        }
        TemplateDim currencyDim = this.analysisTemplate.getAllTemplateDim().stream().filter(td -> td.getDimType().isCurrencyDim()).findFirst().get();
        List<Long> memberScope = currencyDim.getMemberScope();
        if (EmptyUtil.isEmpty((Long)this.reportCurrencyVirtualMemberId)) {
            return;
        }
        HashSet<Long> originalScope = new HashSet<Long>(memberScope);
        memberScope.remove(this.reportCurrencyVirtualMemberId);
        memberScope.add(0, this.reportCurrencyVirtualMemberId);
        DimensionIndexTree indexTree = this.analysisReport.getIndexTree(this.system);
        List<TreeNode> leafList = indexTree.getLeafList();
        List filterData = leafList.stream().filter(treeNode -> treeNode.getDimInfoBean().containsMemberId((Object)this.reportCurrencyVirtualMemberId)).collect(Collectors.toList());
        for (TreeNode node : filterData) {
            this.mergeDataByVirtualMember(currencyDim, originalScope, indexTree, node);
        }
        List<ReportData> reportDataList = leafList.stream().map(TreeNode::getDataList).filter(Objects::nonNull).flatMap(Collection::stream).map(ReportData.class::cast).collect(Collectors.toList());
        this.analysisReport.setReportDataList(reportDataList);
        if (!this.header.isDisplaycurrency()) {
            memberScope.removeIf(memberId -> !Objects.equals(memberId, this.reportCurrencyVirtualMemberId));
        }
    }

    private void mergeDataByVirtualMember(TemplateDim currencyDim, Set<Long> originalScope, DimensionIndexTree indexTree, TreeNode reportCurrencyTreeNode) {
        Long currencyDimDimensionId = currencyDim.getDimensionId();
        Dimension currencyDimension = this.system.getMainDimensionByDimensionId(currencyDimDimensionId);
        Map currencyMemberMap = currencyDimension.getAllDimMemberList().stream().collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        List<Object> reportCurrencyTreeNodeDataList = reportCurrencyTreeNode.getDataList();
        if (EmptyUtil.isNoEmpty(reportCurrencyTreeNodeDataList)) {
            return;
        }
        DimensionInfoBean dimensionInfoBean = reportCurrencyTreeNode.getDimInfoBean();
        ReportData reportCurrencyRd = null;
        for (Long currency : originalScope) {
            List<Object> dataList;
            dimensionInfoBean.replaceValueIfContains(currencyDimDimensionId, (Object)currency);
            TreeNode treeNode = indexTree.find(dimensionInfoBean);
            if (Objects.isNull(treeNode) || EmptyUtil.isEmpty(dataList = treeNode.getDataList())) continue;
            for (Object data : dataList) {
                ReportData reportData;
                if (!(data instanceof ReportData) || (reportCurrencyRd = this.createReportCurrencyRdIfNeed(currency, reportCurrencyRd, reportData = (ReportData)data)) == null) continue;
                this.addAmount2ReportCurrency(reportCurrencyRd, reportData, ((DimMember)currencyMemberMap.get(currency)).getSourceId());
            }
            if (this.header.isDisplaycurrency()) continue;
            dataList.clear();
        }
        if (reportCurrencyTreeNodeDataList == null) {
            reportCurrencyTreeNodeDataList = new ArrayList<Object>(2);
            reportCurrencyTreeNode.setDataList(reportCurrencyTreeNodeDataList);
        }
        if (reportCurrencyRd != null) {
            reportCurrencyTreeNodeDataList.add(reportCurrencyRd);
        }
    }

    private void addAmount2ReportCurrency(ReportData reportCurrencyRd, ReportData reportData, Long currencyId) {
        reportCurrencyRd.addPlanAmt(this.calculateAmt(reportData.getPlanAmt(), currencyId));
        reportCurrencyRd.addLockAmt(this.calculateAmt(reportData.getLockAmt(), currencyId));
        reportCurrencyRd.addActAmt(this.calculateAmt(reportData.getActAmt(), currencyId));
        reportCurrencyRd.addReportPlanAmt(this.calculateAmt(reportData.getReportPlanAmt(), currencyId));
        reportCurrencyRd.addOriginalPlanAmt(this.calculateAmt(reportData.getOriginalPlanAmt(), currencyId));
        reportCurrencyRd.addPlanReferenceAmt(this.calculateAmt(reportData.getPlanReferenceAmt(), currencyId));
    }

    private BigDecimal calculateAmt(BigDecimal originalAmt, Long currencyId) {
        if (EmptyUtil.isEmpty((BigDecimal)originalAmt)) {
            return BigDecimal.ZERO;
        }
        BigDecimal rate = this.analysisReport.getExchangeRateMap().getOrDefault(currencyId, BigDecimal.ONE);
        return originalAmt.multiply(rate).divide(BigDecimal.ONE, 2, 4);
    }

    private ReportData createReportCurrencyRdIfNeed(Long currency, ReportData reportCurrencyRd, ReportData reportData) {
        if (reportCurrencyRd == null) {
            reportCurrencyRd = new ReportData(reportData);
            int index = reportCurrencyRd.getDimValList().indexOf(currency);
            if (index == -1) {
                return null;
            }
            reportCurrencyRd.getDimValList().set(index, this.reportCurrencyVirtualMemberId);
            reportCurrencyRd.clearAmt();
        }
        return reportCurrencyRd;
    }
}

