/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.AnalysisReportType;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanInfo;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateLayout;
import kd.tmc.fpm.business.domain.model.template.TemplateReportType;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.IAnalysisReportService;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.utils.MetricValueUtils;
import org.apache.commons.collections.CollectionUtils;

public class AnalysisReportService
implements IAnalysisReportService {
    private Map<AmountUnit, BigDecimal> AMOUNTUNIT = new HashMap<AmountUnit, BigDecimal>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(AmountUnit.ONE, BigDecimal.valueOf(1L));
            this.put(AmountUnit.THOUSAND, BigDecimal.valueOf(0.001));
            this.put(AmountUnit.TEN_THOUSAND, BigDecimal.valueOf(1.0E-4));
            this.put(AmountUnit.MILLION, BigDecimal.valueOf(1.0E-6));
            this.put(AmountUnit.HUNDRED_MILLION, BigDecimal.valueOf(1.0E-8));
        }
    };

    @Override
    public FpmOperateResult<Void> rebuildSystemInfo(FundPlanSystem system, AnalysisReportType type, AnalysisHeader headerInfo) {
        if (AnalysisReportType.MULTI == type) {
            Dimension orgDim = system.getMainDimensionByDimType(DimensionType.ORG);
            List<DimMember> dimMemberList = orgDim.getAllDimMemberList();
            List<Long> orgList = headerInfo.getOrg();
            if (CollectionUtils.isNotEmpty(orgList)) {
                dimMemberList = dimMemberList.stream().filter(item -> orgList.contains(item.getId())).collect(Collectors.toList());
            }
            ArrayList<DimMember> finalDimMemberList = new ArrayList<DimMember>(dimMemberList.size());
            finalDimMemberList.addAll(dimMemberList);
            for (DimMember dimMember : dimMemberList) {
                DimMember newParent = this.getCurrOrgParent(dimMember, finalDimMemberList);
                dimMember.setParent(newParent);
                dimMember.setParentId(newParent == null ? null : newParent.getId());
            }
            List<DimMember> needRebuildLevelList = dimMemberList.stream().filter(item -> item.getParent() == null).collect(Collectors.toList());
            this.rebuildMemberLevel(needRebuildLevelList, 1);
            orgDim.setMemberList(dimMemberList.stream().filter(item -> item.getLevel() == 1).collect(Collectors.toList()));
        } else if (AnalysisReportType.POSITION == type) {
            Dimension accountDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
            List<DimMember> dimMemberList = accountDim.getAllDimMemberList();
            List<Long> subjects = headerInfo.getSubjects();
            Map<FlowType, List<DimMember>> accountMap = dimMemberList.stream().filter(item -> CollectionUtils.isEmpty((Collection)subjects) || subjects.contains(item.getId())).collect(Collectors.groupingBy(item -> ((AccountMember)item).getFlowType()));
            for (Map.Entry<FlowType, List<DimMember>> next : accountMap.entrySet()) {
                List<DimMember> flowAccountMemList = next.getValue();
                for (DimMember dimMember : flowAccountMemList) {
                    List<DimMember> allChildMember = dimMember.getAllChildMember();
                    List<DimMember> notExistMember = allChildMember.stream().filter(item -> !flowAccountMemList.contains(item)).collect(Collectors.toList());
                    this.removeChildMember(dimMember, notExistMember);
                    DimMember newParent = this.getCurrFlowTypeParent((AccountMember)dimMember, flowAccountMemList, ((AccountMember)dimMember).getFlowType());
                    dimMember.setParent(newParent);
                    dimMember.setParentId(newParent == null ? null : newParent.getParentId());
                }
                List<DimMember> parentList = flowAccountMemList.stream().filter(item -> item.getParent() == null).collect(Collectors.toList());
                this.rebuildMemberLevel(parentList, 1);
            }
            accountDim.setMemberList(dimMemberList.stream().filter(item -> item.getLevel() == 1).collect(Collectors.toList()));
        }
        return FpmOperateResult.success();
    }

    @Override
    public FpmOperateResult<ReportTemplate> generateSumPlanSubReportTemplate(FundPlanSystem system, SumPlanParamConfig sumPlanParamConfig, AnalysisHeader headerInfo, IFpmPageCacheService cacheService) {
        ReportTemplate reportTemplate = new ReportTemplate();
        reportTemplate.setTemplateUse(TemplateUseType.ANALYSIS);
        reportTemplate.setDistSubject(false);
        List<Dimension> dimList = system.getDimList();
        this.createReportCurrency(headerInfo, dimList);
        reportTemplate.setTemplateType(TemplateType.FIXED);
        reportTemplate.setAmountUnit(headerInfo.getAmountUnit());
        TemplateLayout templateLayout = new TemplateLayout();
        templateLayout.setTemplateType(reportTemplate.getTemplateType());
        ReportPeriodType reportPeriodType = system.getPeriodTypeByPeriodTypeId(headerInfo.getReportTypeId());
        TemplateReportType templateReportType = new TemplateReportType();
        templateReportType.setReportTypeId(headerInfo.getReportTypeId());
        templateReportType.setRollContainsDetail(reportPeriodType.isRollIncludeDetailPeriod());
        reportTemplate.setReportTypeList(Collections.singletonList(templateReportType));
        ArrayList<TemplateDim> pageDimList = new ArrayList<TemplateDim>(0);
        ArrayList<TemplateDim> allDimList = new ArrayList<TemplateDim>(0);
        ArrayList<TemplateLayout.LayoutInfo> layoutInfoList = new ArrayList<TemplateLayout.LayoutInfo>(4);
        List<Dimension> mainDimList = system.getMainDimList();
        Map dimIncludeSumMap = (Map)JSON.parseObject((String)cacheService.get("dimIncludeSumMap"), Map.class);
        for (int i = 0; i < mainDimList.size(); ++i) {
            DimensionType dimType;
            Dimension dimension = mainDimList.get(i);
            if (dimension.getAllDimMemberList().size() < 1 || (dimType = dimension.getDimType()) == DimensionType.METRIC) continue;
            TemplateLayout.LayoutInfo layoutInfo = new TemplateLayout.LayoutInfo();
            TemplateDim templateDim = new TemplateDim();
            layoutInfo.setDimensionId(dimension.getId());
            templateDim.setDimensionId(dimension.getId());
            templateDim.setSequence(i + 1);
            templateDim.setDimensionName(dimension.getName());
            if (!this.isCustomDim(dimType)) {
                layoutInfo.setVisible(true);
                templateDim.setVisible(true);
            }
            layoutInfo.setDimLocation(this.getDimLocation4SubReport(dimension, cacheService, headerInfo));
            layoutInfo.setLevel(this.getDimLevel4SubReport(dimension, cacheService));
            templateDim.setIncludeSum(dimIncludeSumMap.getOrDefault(dimension.getId().toString(), Boolean.FALSE));
            templateDim.setDimType(dimType);
            templateDim.setLocation(layoutInfo.getDimLocation());
            templateDim.setLevel(layoutInfo.getLevel());
            boolean nonExistDim = false;
            switch (dimType) {
                case CURRENCY: {
                    templateDim.setMemberScope(headerInfo.getCurrency());
                    break;
                }
                case SUBJECTS: {
                    templateDim.setMemberScope(headerInfo.getSubjects());
                    break;
                }
                case PERIOD: {
                    this.initialPeriodTemplateDim(templateDim, dimension, headerInfo, system);
                    break;
                }
                case ORG: {
                    this.initialOrgTemplateDim(templateDim, headerInfo, sumPlanParamConfig);
                    break;
                }
                case COMPANY: {
                    templateDim.setMemberScope(headerInfo.getCompany());
                    nonExistDim = EmptyUtil.isEmpty(templateDim.getMemberScope());
                    break;
                }
                case SETTLEMENT_TYPE: {
                    templateDim.setMemberScope(headerInfo.getSettlementMethod());
                    nonExistDim = EmptyUtil.isEmpty(templateDim.getMemberScope());
                    break;
                }
                case CUSTOM: {
                    Map<String, List<Long>> customDimensionMap = Optional.ofNullable(headerInfo.getCustomDimension()).orElse(Collections.EMPTY_MAP);
                    if (CollectionUtils.isNotEmpty((Collection)customDimensionMap.get(dimension.getNumber()))) {
                        templateDim.setMemberScope(customDimensionMap.get(dimension.getNumber()));
                    }
                    nonExistDim = EmptyUtil.isEmpty(templateDim.getMemberScope());
                    break;
                }
            }
            if (nonExistDim) continue;
            if (templateDim.getMemberScope() == null || templateDim.getMemberScope().size() < 1) {
                templateDim.setMemberScope(dimension.getAllDimMemberList().stream().map(DimMember::getId).collect(Collectors.toList()));
            }
            layoutInfoList.add(layoutInfo);
            allDimList.add(templateDim);
            if (DimLocation.PAGE != templateDim.getLocation()) continue;
            pageDimList.add(templateDim);
        }
        templateLayout.setDimLayoutInfoList(layoutInfoList);
        reportTemplate.setPageDimList(pageDimList);
        reportTemplate.setDimLayout(templateLayout);
        reportTemplate.setColDimList(allDimList.stream().filter(v -> DimLocation.COL == v.getLocation()).sorted(Comparator.comparing(TemplateDim::getLevel)).collect(Collectors.toList()));
        reportTemplate.setRowDimList(allDimList.stream().filter(v -> DimLocation.ROW == v.getLocation()).sorted(Comparator.comparing(TemplateDim::getLevel)).collect(Collectors.toList()));
        return FpmOperateResult.success(reportTemplate);
    }

    private DimLocation getDimLocation4SubReport(Dimension dimension, IFpmPageCacheService cacheService, AnalysisHeader headerInfo) {
        if (DimensionType.ORG == dimension.getDimType()) {
            return DimLocation.ROW;
        }
        String dimLocationEnumName = cacheService.get(String.format("sumplan:subreport:dim:location:%s", dimension.getId()));
        if (StringUtils.isEmpty((CharSequence)dimLocationEnumName)) {
            if (dimension.getDimType().getNumber().equals(headerInfo.getDimType())) {
                return DimLocation.ROW;
            }
            return DimLocation.PAGE;
        }
        return DimLocation.valueOf(dimLocationEnumName);
    }

    private int getDimLevel4SubReport(Dimension dimension, IFpmPageCacheService cacheService) {
        if (DimensionType.ORG == dimension.getDimType()) {
            String rowDimMaxLevelStr = cacheService.get("sumplan:subreport:dim:max:level");
            return Integer.parseInt(rowDimMaxLevelStr) + 1;
        }
        String rowDimLevelStr = cacheService.get(String.format("sumplan:subreport:dim:level:%s", dimension.getId()));
        if (StringUtils.isEmpty((CharSequence)rowDimLevelStr)) {
            return 1;
        }
        return Integer.parseInt(rowDimLevelStr);
    }

    private void initialPeriodTemplateDim(TemplateDim templateDim, Dimension dimension, AnalysisHeader headerInfo, FundPlanSystem system) {
        templateDim.setMemberScope(headerInfo.getPeriodId());
        templateDim.setIncludeSubSum(false);
        if (dimension.getDimType() == DimensionType.PERIOD && templateDim.getLocation() == DimLocation.COL && templateDim.getLevel() == 1) {
            templateDim.setIncludeSum(false);
        }
        if (!headerInfo.isContainDetailReportType()) {
            ReportPeriodType reportPeriodType = system.getPeriodTypeByPeriodTypeId(headerInfo.getReportTypeId());
            dimension.getMemberList().stream().map(v -> (PeriodMember)v).forEach(tMember -> {
                if (headerInfo.getReportTypeId().compareTo(tMember.getPeriodTypeId()) == 0) {
                    tMember.getAllChildMember().forEach(item -> {
                        PeriodMember tAllChildMember = (PeriodMember)item;
                        if (tAllChildMember.getChildren().stream().map(v -> (PeriodMember)v).findFirst().filter(v -> v.getPeriodType() == reportPeriodType.getDetailPeriodType()).isPresent()) {
                            tAllChildMember.setChildren(null);
                        }
                    });
                }
            });
        }
    }

    private void initialOrgTemplateDim(TemplateDim templateDim, AnalysisHeader headerInfo, SumPlanParamConfig sumPlanParamConfig) {
        HashSet<Object> selectedReportOrgSet;
        if (CollectionUtils.isEmpty(headerInfo.getOrg())) {
            selectedReportOrgSet = new HashSet(2, 1.0f);
            selectedReportOrgSet.add(headerInfo.getSumReportOrg());
        } else {
            selectedReportOrgSet = new HashSet<Long>(headerInfo.getOrg());
        }
        Set allSubReportOrgSet = sumPlanParamConfig.getConfigInfoList().stream().filter(item -> selectedReportOrgSet.contains(item.getOrgMemberId())).map(SumPlanParamConfigInfo::getAllChildren).flatMap(Collection::stream).map(SumPlanParamConfigInfo::getOrgMemberId).collect(Collectors.toSet());
        selectedReportOrgSet.addAll(allSubReportOrgSet);
        templateDim.setMemberScope(new ArrayList<Object>(selectedReportOrgSet));
        if (!DimensionType.ORG.getNumber().equals(headerInfo.getDimType())) {
            templateDim.setIncludeSum(true);
        }
    }

    private boolean isCustomDim(DimensionType dimensionType) {
        return DimensionType.ORG != dimensionType && DimensionType.CURRENCY != dimensionType && DimensionType.PERIOD != dimensionType && DimensionType.SUBJECTS != dimensionType;
    }

    @Override
    public FpmOperateResult<Report> generateAnalysisReport(ReportTemplate analysisTemplate, AnalysisHeader headerinfo) {
        ReportTemplate reportTemplate = analysisTemplate.serializeClone();
        DimensionRepository dimRepo = new DimensionRepository();
        FundPlanSystem system = dimRepo.loadSystem(headerinfo.getBodySystemId());
        Long reportPeriodId = headerinfo.getReportTypeId();
        ReportPeriodType reportPeriodType = system.getPeriodTypeByPeriodTypeId(reportPeriodId);
        ArrayList<PeriodMember> reportPeriodMemList = new ArrayList<PeriodMember>(headerinfo.getPeriodId().size());
        for (Long tPeriodId : headerinfo.getPeriodId()) {
            reportPeriodMemList.addAll(this.buildPeriodMemberInfo(system, reportTemplate, reportPeriodType, tPeriodId));
        }
        reportPeriodMemList.sort(Comparator.comparing(PeriodMember::getStartDate));
        List<OrgMember> orgMembers = this.buildOrgMemberInfo(system, reportTemplate);
        Report report = new Report();
        report.setSystemId(headerinfo.getBodySystemId());
        report.setTemplate(analysisTemplate);
        report.setReportPeriodType(reportPeriodType);
        report.setPeriodMemberList(reportPeriodMemList);
        report.setCompanyMemberList(orgMembers);
        report.setName(analysisTemplate.getName());
        report.setInitFlag(false);
        report.setReportDataList(new ArrayList<ReportData>(0));
        return FpmOperateResult.success(report);
    }

    private List<PeriodMember> buildPeriodMemberInfo(FundPlanSystem system, ReportTemplate reportTemplate, ReportPeriodType reportPeriodType, Long periodMemberId) {
        if (reportPeriodType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e2d\u672a\u67e5\u8be2\u5230\u7f16\u62a5\u7c7b\u578b\u3002", (String)"AnalysisReportService_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        PeriodType periodType = reportPeriodType.getPeriodType();
        Dimension periodDim = system.getMainDimensionByDimType(DimensionType.PERIOD);
        List<PeriodMember> periodList = periodDim.getMemberList(PeriodMember.class);
        Date currentTime = new Date();
        ArrayList<PeriodMember> reportPeriodMemList = new ArrayList<PeriodMember>();
        for (PeriodMember periodMember : periodList) {
            reportPeriodMemList.addAll(periodMember.getChildMemberByPeriodTypeAndPeriodId(periodType, reportPeriodType.getReportPeriodId()));
            if (PeriodType.MONTH_WEEK != periodType) continue;
            reportPeriodMemList.addAll(periodMember.getChildMemberByPeriodTypeAndPeriodId(PeriodType.YEAR_WEEK, reportPeriodType.getReportPeriodId()));
        }
        Optional<PeriodMember> first = reportPeriodMemList.stream().filter(o -> o.getId().equals(periodMemberId)).findFirst();
        if (CollectionUtils.isEmpty(reportPeriodMemList = reportPeriodMemList.stream().filter(o -> {
            if (periodMemberId != null && periodMemberId != 0L) {
                if (first.isPresent()) {
                    PeriodMember periodMember = (PeriodMember)first.get();
                    return o.getStartDate().compareTo(periodMember.getStartDate()) >= 0;
                }
                return false;
            }
            return currentTime.compareTo(o.getStartDate()) <= 0;
        }).sorted(Comparator.comparing(PeriodMember::getStartDate)).limit(1L).collect(Collectors.toList()))) {
            return reportPeriodMemList;
        }
        TemplateLayout.LayoutInfo periodLayoutInfo = reportTemplate.getTemplateLayoutInfoByDimId(periodDim.getId());
        List<Object> templateDimList = new ArrayList(2);
        templateDimList = periodLayoutInfo.getDimLocation() == DimLocation.ROW ? reportTemplate.getRowDimList() : (periodLayoutInfo.getDimLocation() == DimLocation.COL ? reportTemplate.getColDimList() : reportTemplate.getPageDimList());
        TemplateDim periodTemplateDim = null;
        periodTemplateDim = reportTemplate.getTemplateType() == TemplateType.DETAIL ? templateDimList.stream().filter(item -> periodLayoutInfo.getDimensionId().equals(item.getDimensionId())).findFirst().get() : (TemplateDim)templateDimList.get(periodLayoutInfo.getLevel() - 1);
        List<Long> periodMemberIdList = reportPeriodMemList.stream().map(DimMember::getId).collect(Collectors.toList());
        periodTemplateDim.setMemberScope(periodMemberIdList);
        return reportPeriodMemList;
    }

    private List<OrgMember> buildOrgMemberInfo(FundPlanSystem system, ReportTemplate reportTemplate) {
        Dimension orgDim = system.getMainDimensionByDimType(DimensionType.ORG);
        List<OrgMember> orgMemberList = orgDim.getMemberList(OrgMember.class);
        ArrayList<OrgMember> reportOrgMemberList = new ArrayList<OrgMember>(10);
        reportOrgMemberList.addAll(orgMemberList);
        for (OrgMember orgMember : orgMemberList) {
            List<DimMember> allChildMember = orgMember.getAllChildMember();
            List allOrgChildMember = allChildMember.stream().map(item -> (OrgMember)item).collect(Collectors.toList());
            reportOrgMemberList.addAll(allOrgChildMember);
        }
        List<TemplateDim> pageDimList = reportTemplate.getAllTemplateDim();
        Optional<TemplateDim> orgTemplateDimOptional = pageDimList.stream().filter(item -> item.getDimensionId().equals(orgDim.getId())).findFirst();
        if (orgTemplateDimOptional.isPresent()) {
            TemplateDim orgTemplateDim = orgTemplateDimOptional.get();
            List<Long> orgMemberIdList = reportOrgMemberList.stream().map(DimMember::getId).collect(Collectors.toList());
            orgTemplateDim.setMemberScope(orgMemberIdList);
        }
        return reportOrgMemberList;
    }

    @Override
    public FpmOperateResult<Report> calculateSumPlanSubReport(SumPlanInfo sumPlanInfo, AnalysisHeader headerInfo) {
        List<ReportData> tReportDataList;
        Report analysisReport = sumPlanInfo.getReport();
        List<TemplateDim> tPageDimList = analysisReport.getTemplate().getPageDimList();
        List<TemplateDim> tAllTemplateDim = analysisReport.getTemplate().getAllTemplateDim();
        Map<List, Long> tPageDimIdsList = tPageDimList.stream().filter(item -> item.getMemberScope().size() > 0).collect(Collectors.toMap(TemplateDim::getMemberScope, TemplateDim::getDimensionId));
        boolean isSumReportData = tPageDimList.stream().anyMatch(v -> v.getMemberScope().size() > 0);
        Optional<TemplateDim> tAmtDim = tAllTemplateDim.stream().filter(item -> item.getDimType() == DimensionType.AMTTYPE).findFirst();
        if (isSumReportData) {
            HashMap tPageDimIdList = new HashMap(0);
            tPageDimIdsList.forEach((key, value) -> {
                Long cfr_ignored_0 = (Long)tPageDimIdList.put(value, key.get(0));
            });
            tReportDataList = analysisReport.getReportDataList();
            int tDImVal = tAmtDim.isPresent() ? 0 : 1;
            Map<List, List<ReportData>> tReportDataGroupByList = tReportDataList.stream().filter(item -> item.getDimValList().size() >= tAllTemplateDim.size() + tDImVal - tPageDimList.size()).collect(Collectors.groupingBy(ReportData::getDimValList));
            ArrayList tReportDataSumList = new ArrayList(tReportDataGroupByList.size());
            for (Map.Entry<List, List<ReportData>> entry : tReportDataGroupByList.entrySet()) {
                List key2 = entry.getKey();
                List<ReportData> value2 = entry.getValue();
                ReportData defValue = value2.get(0);
                ReportData reportData = new ReportData();
                reportData.setAmountUnit(AmountUnit.ONE);
                reportData.setActAmt(BigDecimal.ZERO);
                reportData.setPlanAmt(BigDecimal.ZERO);
                reportData.setLockAmt(BigDecimal.ZERO);
                reportData.setReportPlanAmt(BigDecimal.ZERO);
                reportData.setOriginalPlanAmt(BigDecimal.ZERO);
                value2.forEach(v -> {
                    reportData.setActAmt(v.getActAmt().divide(this.AMOUNTUNIT.get((Object)v.getAmountUnit())).add(reportData.getActAmt().divide(this.AMOUNTUNIT.get((Object)reportData.getAmountUnit()))));
                    reportData.setPlanAmt(v.getPlanAmt().divide(this.AMOUNTUNIT.get((Object)v.getAmountUnit())).add(reportData.getPlanAmt().divide(this.AMOUNTUNIT.get((Object)reportData.getAmountUnit()))));
                    reportData.setLockAmt(v.getLockAmt().divide(this.AMOUNTUNIT.get((Object)v.getAmountUnit())).add(reportData.getLockAmt().divide(this.AMOUNTUNIT.get((Object)reportData.getAmountUnit()))));
                    reportData.setOriginalPlanAmt(v.getOriginalPlanAmt().divide(this.AMOUNTUNIT.get((Object)v.getAmountUnit())).add(reportData.getOriginalPlanAmt().divide(this.AMOUNTUNIT.get((Object)reportData.getAmountUnit()))));
                    reportData.setReportPlanAmt(v.getReportPlanAmt().divide(this.AMOUNTUNIT.get((Object)v.getAmountUnit())).add(reportData.getReportPlanAmt().divide(this.AMOUNTUNIT.get((Object)reportData.getAmountUnit()))));
                });
                reportData.setVersion(defValue.getVersion());
                reportData.setDimValList(defValue.getDimValList());
                reportData.setReportPeriodId(defValue.getReportPeriodId());
                reportData.setDimList(defValue.getDimList());
                tReportDataSumList.add(reportData);
            }
            analysisReport.setReportDataList(tReportDataSumList);
            for (TemplateDim templateDim : tPageDimList) {
                tPageDimIdList.get(templateDim.getDimensionId());
                List<Long> tMemberScope = templateDim.getMemberScope();
                tMemberScope.clear();
                tMemberScope.add((Long)tPageDimIdList.get(templateDim.getDimensionId()));
                templateDim.setMemberScope(tMemberScope);
            }
        }
        List<TemplateDim> tColDimList = analysisReport.getTemplate().getColDimList();
        tReportDataList = analysisReport.getReportDataList();
        AmountUnit tAmountUnit = Optional.ofNullable(analysisReport.getTemplate().getAmountUnit()).orElse(AmountUnit.TEN_THOUSAND);
        analysisReport.getTemplate().setAmountUnit(tAmountUnit);
        BigDecimal tAmountUnitNum = this.AMOUNTUNIT.get((Object)tAmountUnit);
        if (tAmountUnitNum != null && BigDecimal.ZERO.compareTo(tAmountUnitNum) != 0) {
            for (ReportData tReportData : tReportDataList) {
                tReportData.setActAmt(tAmountUnitNum.multiply(tReportData.getActAmt().divide(this.AMOUNTUNIT.get((Object)tReportData.getAmountUnit()))));
                tReportData.setPlanAmt(tAmountUnitNum.multiply(tReportData.getPlanAmt().divide(this.AMOUNTUNIT.get((Object)tReportData.getAmountUnit()))));
                tReportData.setLockAmt(tAmountUnitNum.multiply(tReportData.getLockAmt().divide(this.AMOUNTUNIT.get((Object)tReportData.getAmountUnit()))));
                tReportData.setOriginalPlanAmt(tAmountUnitNum.multiply(tReportData.getOriginalPlanAmt().divide(this.AMOUNTUNIT.get((Object)tReportData.getAmountUnit()))));
                tReportData.setReportPlanAmt(tAmountUnitNum.multiply(tReportData.getReportPlanAmt().divide(this.AMOUNTUNIT.get((Object)tReportData.getAmountUnit()))));
                tReportData.setAmountUnit(analysisReport.getTemplate().getAmountUnit());
            }
        }
        Map<Long, Map<Long, BigDecimal>> sumCurrencyRateMap = sumPlanInfo.getCurrencyRateMap();
        ArrayList<ReportData> tExchangeReportDataList = new ArrayList<ReportData>(tReportDataList.size());
        for (ReportData tReportData : tReportDataList) {
            Iterator<TemplateDim> tDimValList = new ArrayList(tReportData.getDimValList().size());
            TemplateDim currencyDim = tReportData.getDimList().stream().filter(dim -> dim.getDimType() == DimensionType.CURRENCY).findFirst().get();
            int currencyDimIdx = tReportData.getDimList().indexOf(currencyDim);
            BigDecimal tExchangeRate = BigDecimal.ONE;
            for (int i = 0; i < tReportData.getDimValList().size(); ++i) {
                Object tDimVal2 = tReportData.getDimValList().get(i);
                if (i == currencyDimIdx) {
                    for (Map.Entry<Long, Map<Long, BigDecimal>> entry : sumCurrencyRateMap.entrySet()) {
                        Map<Long, BigDecimal> currencyRateMap = entry.getValue();
                        if (!Objects.nonNull(currencyRateMap.get(tDimVal2))) continue;
                        tExchangeRate = currencyRateMap.get(tDimVal2);
                        tDimVal2 = entry.getKey();
                    }
                }
                tDimValList.add((TemplateDim)tDimVal2);
            }
            Iterator<ReportData> tExchangeReportData = new ReportData();
            ((ReportData)((Object)tExchangeReportData)).setActAmt(tExchangeRate.multiply(tReportData.getActAmt()));
            ((ReportData)((Object)tExchangeReportData)).setPlanAmt(tExchangeRate.multiply(tReportData.getPlanAmt()));
            ((ReportData)((Object)tExchangeReportData)).setLockAmt(tExchangeRate.multiply(tReportData.getLockAmt()));
            ((ReportData)((Object)tExchangeReportData)).setOriginalPlanAmt(tExchangeRate.multiply(tReportData.getOriginalPlanAmt()));
            ((ReportData)((Object)tExchangeReportData)).setReportPlanAmt(tExchangeRate.multiply(tReportData.getReportPlanAmt()));
            ((ReportData)((Object)tExchangeReportData)).setVersion(tReportData.getVersion());
            ((ReportData)((Object)tExchangeReportData)).setDimValList((List<Object>)((Object)tDimValList));
            ((ReportData)((Object)tExchangeReportData)).setReportPeriodId(tReportData.getReportPeriodId());
            ((ReportData)((Object)tExchangeReportData)).setDimList(tReportData.getDimList());
            ((ReportData)((Object)tExchangeReportData)).setAmountUnit(tReportData.getAmountUnit());
            tExchangeReportDataList.add((ReportData)((Object)tExchangeReportData));
        }
        tReportDataList = tExchangeReportDataList;
        if (!headerInfo.isContainDetailReportType()) {
            List<PeriodMember> list = analysisReport.getPeriodMemberList();
            Map<List, Long> tentryMap = list.stream().distinct().filter(item -> item.getAllChildMember().size() > 0).collect(Collectors.toMap(t -> t.getAllChildMember().stream().map(v -> v.getId()).collect(Collectors.toList()), DimMember::getId));
            for (ReportData tReportData : tReportDataList) {
                ArrayList<Object> tDoDimValList = new ArrayList<Object>(tReportData.getDimValList().size());
                tReportData.getDimValList().forEach(tDimVal -> {
                    if (tDimVal instanceof Long) {
                        for (Map.Entry tentry : tentryMap.entrySet()) {
                            if (!((List)tentry.getKey()).contains(Long.parseLong(tDimVal.toString()))) continue;
                            tDimVal = tentry.getValue();
                            break;
                        }
                        tDoDimValList.add(tDimVal);
                    }
                });
                tReportData.setDimValList(tDoDimValList);
            }
            for (TemplateDim tColDim : tColDimList) {
                if (tColDim.getDimType() != DimensionType.PERIOD) continue;
                tColDim.setMemberScope(list.stream().map(DimMember::getId).collect(Collectors.toList()));
                break;
            }
            analysisReport.getReportPeriodType().setDetailPeriodType(null);
        }
        List<OrgMember> list = analysisReport.getCompanyMemberList();
        List tOrgMemberIdList = list.stream().map(DimMember::getId).collect(Collectors.toList());
        HashMap tOrgMap = new HashMap(0);
        for (OrgMember tOrgMember : list) {
            List tChildrenOrgIdList = list.stream().filter(item -> tOrgMember.getId().compareTo(item.getId()) == 0).findFirst().get().getAllChildMember().stream().map(v -> v.getId()).collect(Collectors.toList());
            if (tChildrenOrgIdList.size() <= 0 || !analysisReport.getReportDataList().stream().noneMatch(item -> tOrgMember.getId().equals(item.getDimValByDimType(DimensionType.ORG, null)))) continue;
            tOrgMap.put(tOrgMember.getId(), tChildrenOrgIdList);
        }
        HashMap<ArrayList<Object>, ReportData> tNewOrgReportDataList = new HashMap<ArrayList<Object>, ReportData>();
        ArrayList<ReportData> tOrgReportDataList = new ArrayList<ReportData>(0);
        for (ReportData data : tReportDataList) {
            ReportData tNewOrgReportData = new ReportData();
            tNewOrgReportData.setVersion(data.getVersion());
            tNewOrgReportData.setDimValList(data.getDimValList());
            tNewOrgReportData.setReportPeriodId(data.getReportPeriodId());
            tNewOrgReportData.setDimList(data.getDimList());
            tNewOrgReportData.setAmountUnit(data.getAmountUnit());
            tNewOrgReportData.setActAmt(data.getActAmt());
            tNewOrgReportData.setPlanAmt(data.getPlanAmt());
            tNewOrgReportData.setLockAmt(data.getLockAmt());
            tNewOrgReportData.setOriginalPlanAmt(data.getOriginalPlanAmt());
            tNewOrgReportData.setReportPlanAmt(data.getReportPlanAmt());
            tOrgReportDataList.add(tNewOrgReportData);
        }
        for (ReportData data : tReportDataList) {
            ArrayList newDimValLista = new ArrayList(0);
            ArrayList<Object> arrayList = new ArrayList<Object>(0);
            HashSet newOrgParentList = new HashSet(0);
            boolean isLista = true;
            for (Object tDimVal3 : data.getDimValList()) {
                if (!(tDimVal3 instanceof Long)) continue;
                Long l = Long.parseLong(tDimVal3.toString());
                for (Map.Entry tOrg : tOrgMap.entrySet()) {
                    if (!((List)tOrg.getValue()).contains(l)) continue;
                    newOrgParentList.add(tOrg.getKey());
                    isLista = false;
                }
                if (isLista) {
                    newDimValLista.add(tDimVal3);
                    continue;
                }
                if (tOrgMemberIdList.contains(l)) continue;
                arrayList.add(tDimVal3);
            }
            for (Long newOrgParent : newOrgParentList) {
                ArrayList<Object> arrayList2 = new ArrayList<Object>(0);
                arrayList2.addAll(newDimValLista);
                arrayList2.add(newOrgParent);
                arrayList2.addAll(arrayList);
                if (!tOrgReportDataList.stream().noneMatch(item -> new HashSet(newDimValList).containsAll(item.getDimValList())) || !tNewOrgReportDataList.keySet().stream().noneMatch(item -> new HashSet(newDimValList).containsAll((Collection<?>)item))) continue;
                ReportData tNewOrgReportData = new ReportData();
                tNewOrgReportData.setVersion(data.getVersion());
                tNewOrgReportData.setDimValList(arrayList2);
                tNewOrgReportData.setReportPeriodId(data.getReportPeriodId());
                tNewOrgReportData.setDimList(data.getDimList());
                tNewOrgReportData.setAmountUnit(data.getAmountUnit());
                tNewOrgReportData.setActAmt(BigDecimal.ZERO);
                tNewOrgReportData.setPlanAmt(BigDecimal.ZERO);
                tNewOrgReportData.setLockAmt(BigDecimal.ZERO);
                tNewOrgReportData.setOriginalPlanAmt(BigDecimal.ZERO);
                tNewOrgReportData.setReportPlanAmt(BigDecimal.ZERO);
                tNewOrgReportDataList.put(arrayList2, tNewOrgReportData);
            }
        }
        tReportDataList.addAll(tNewOrgReportDataList.values());
        Map<List, List<ReportData>> tReportDataGroupByList = tReportDataList.stream().collect(Collectors.groupingBy(ReportData::getDimValList));
        ArrayList<ReportData> tReportDataSumList = new ArrayList<ReportData>(0);
        for (Map.Entry entry : tReportDataGroupByList.entrySet()) {
            List key3 = (List)entry.getKey();
            List value3 = (List)entry.getValue();
            ReportData defValue = (ReportData)value3.get(0);
            ReportData reportData = new ReportData();
            reportData.setActAmt(BigDecimal.ZERO);
            reportData.setPlanAmt(BigDecimal.ZERO);
            reportData.setLockAmt(BigDecimal.ZERO);
            reportData.setOriginalPlanAmt(BigDecimal.ZERO);
            reportData.setReportPlanAmt(BigDecimal.ZERO);
            value3.forEach(v -> {
                reportData.setActAmt(v.getActAmt().add(reportData.getActAmt()));
                reportData.setPlanAmt(v.getPlanAmt().add(reportData.getPlanAmt()));
                reportData.setLockAmt(v.getLockAmt().add(reportData.getLockAmt()));
                reportData.setOriginalPlanAmt(v.getOriginalPlanAmt().add(reportData.getOriginalPlanAmt()));
                reportData.setReportPlanAmt(v.getReportPlanAmt().add(reportData.getReportPlanAmt()));
            });
            reportData.setVersion(defValue.getVersion());
            reportData.setDimValList(defValue.getDimValList());
            reportData.setReportPeriodId(defValue.getReportPeriodId());
            reportData.setDimList(defValue.getDimList());
            reportData.setAmountUnit(defValue.getAmountUnit());
            tReportDataSumList.add(reportData);
        }
        List<OrgMember> headerOrgMembers = list.stream().filter(item -> headerInfo.getOrg().contains(item.getId())).collect(Collectors.toList());
        Map<Long, List<Long>> map = this.getDataOrgList(analysisReport, headerOrgMembers);
        for (ReportData tReportData : tReportDataSumList) {
            HashSet<Object> tDimValSet = new HashSet<Object>(tReportData.getDimValList().size());
            for (Object e : tReportData.getDimValList()) {
                Long tOrgId;
                if (!(e instanceof Long) || !tOrgMap.containsKey(tOrgId = Long.valueOf(Long.parseLong(e.toString())))) continue;
                tDimValSet.addAll((Collection)tOrgMap.get(tOrgId));
                tDimValSet.addAll(tReportData.getDimValList());
                tDimValSet.remove(tOrgId);
                break;
            }
            Long targetOrgId = (Long)tReportData.getDimValByDimType(DimensionType.ORG, null);
            List<Long> list2 = map.get(targetOrgId);
            if (tDimValSet.size() <= 0 || !CollectionUtils.isNotEmpty(list2)) continue;
            List tOrgReportDataList1 = tOrgReportDataList.stream().filter(item -> tDimValSet.containsAll(item.getDimValList())).collect(Collectors.toList());
            for (ReportData tOrgReportData : tOrgReportDataList1) {
                Long orgID = (Long)tOrgReportData.getDimValByDimType(DimensionType.ORG, null);
                if (!list2.contains(orgID)) continue;
                tReportData.setActAmt(tOrgReportData.getActAmt().add(tReportData.getActAmt()));
                tReportData.setPlanAmt(tOrgReportData.getPlanAmt().add(tReportData.getPlanAmt()));
                tReportData.setLockAmt(tOrgReportData.getLockAmt().add(tReportData.getLockAmt()));
                tReportData.setOriginalPlanAmt(tOrgReportData.getOriginalPlanAmt().add(tReportData.getOriginalPlanAmt()));
                tReportData.setReportPlanAmt(tOrgReportData.getReportPlanAmt().add(tReportData.getReportPlanAmt()));
            }
        }
        if (analysisReport.getTemplate().getMetricTplDim() != null && CollectionUtils.isNotEmpty(headerInfo.getMetricMember())) {
            ArrayList<ReportData> tReportDataAmtList = new ArrayList<ReportData>(0);
            for (ReportData defVal : tReportDataSumList) {
                for (MetricMember metricMember : headerInfo.getMetricMember()) {
                    ReportData reportData = new ReportData();
                    reportData.setVersion(defVal.getVersion());
                    reportData.setReportPeriodId(defVal.getReportPeriodId());
                    reportData.setDimList(defVal.getDimList());
                    reportData.setAmountUnit(defVal.getAmountUnit());
                    if (StringUtils.isEmpty((CharSequence)metricMember.getValStr())) {
                        reportData.setBigDecimalValueOrDefault(MetricValueUtils.getMetricValue(metricMember.getTemplateMetricType(), defVal));
                    } else {
                        reportData.setBigDecimalValueOrDefault(MetricValueUtils.evalMetricValue(metricMember.getValStr(), defVal));
                    }
                    ArrayList<Object> tDimValList = new ArrayList<Object>(defVal.getDimValList());
                    tDimValList.add(metricMember.getId());
                    reportData.setDimValList(tDimValList);
                    ArrayList<TemplateDim> dimList = new ArrayList<TemplateDim>(reportData.getDimList());
                    dimList.add(analysisReport.getTemplate().getMetricTplDim());
                    List<TemplateDim> sortedDimList = dimList.stream().sorted(Comparator.comparingLong(TemplateDim::getDimensionId)).collect(Collectors.toList());
                    List<Object> dimValList = reportData.getDimValList();
                    ArrayList<Object> sortedValList = new ArrayList<Object>(dimValList.size());
                    for (TemplateDim templateDim : sortedDimList) {
                        sortedValList.add(dimValList.get(dimList.indexOf(templateDim)));
                    }
                    reportData.setDimList(sortedDimList);
                    reportData.setDimValList(sortedValList);
                    tReportDataAmtList.add(reportData);
                }
            }
            tReportDataSumList.clear();
            tReportDataSumList.addAll(tReportDataAmtList);
        }
        tReportDataList = tReportDataSumList;
        analysisReport.setReportDataList(tReportDataList);
        return FpmOperateResult.success(analysisReport);
    }

    private Map<Long, List<Long>> getDataOrgList(Report analysisReport, List<OrgMember> headerOrgMembers) {
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(headerOrgMembers.size());
        for (OrgMember orgMember : headerOrgMembers) {
            result.put(orgMember.getId(), this.getOrg(analysisReport, orgMember));
        }
        return result;
    }

    private List<Long> getOrg(Report analysisReport, OrgMember orgMember) {
        ArrayList<Long> result = new ArrayList<Long>(10);
        Long orgId = orgMember.getId();
        if (analysisReport.getReportDataList().stream().anyMatch(item -> orgId.equals(item.getDimValByDimType(DimensionType.ORG, null)))) {
            result.add(orgId);
        } else if (CollectionUtils.isNotEmpty(orgMember.getChildren())) {
            for (DimMember child : orgMember.getChildren()) {
                result.addAll(this.getOrg(analysisReport, (OrgMember)child));
            }
        }
        return result;
    }

    private void createReportCurrency(AnalysisHeader headerinfo, List<Dimension> dimList) {
        Optional<DimMember> tReportCurrencyMem;
        long memberId = DB.genLongId((String)"fpm_member");
        Optional<Dimension> dim = dimList.stream().filter(item -> item.getDimType() == DimensionType.CURRENCY).findFirst();
        if (dim.isPresent() && (tReportCurrencyMem = dim.get().getAllDimMemberList().stream().filter(item -> headerinfo.getReportCurrency() != null && item.getId().compareTo(headerinfo.getReportCurrency()) == 0).findFirst()).isPresent()) {
            DimMember inDimMember = new DimMember();
            inDimMember.setId(memberId);
            inDimMember.setNumber(tReportCurrencyMem.get().getNumber());
            inDimMember.setLongNumber(tReportCurrencyMem.get().getLongNumber());
            inDimMember.setSortCode("0000");
            inDimMember.setName(String.format(ResManager.loadKDString((String)"%1$s\uff08\u62a5\u544a\u5e01\uff09", (String)"AnalysisReportService_2", (String)"tmc-fpm-business", (Object[])new Object[0]), tReportCurrencyMem.get().getName()));
            inDimMember.setMemberType(MemberType.DIM_MEMBER);
            List<DimMember> tMemberList = dim.get().getMemberList();
            tMemberList.add(inDimMember);
            dim.get().setMemberList(tMemberList);
            headerinfo.setDisReportCurrency(memberId);
        }
    }

    private DimMember getCurrFlowTypeParent(AccountMember accountMember, List<DimMember> flowAccountMemList, FlowType flowType) {
        DimMember parent = accountMember.getParent();
        if (!(parent == null || ((AccountMember)parent).getFlowType() == flowType && flowAccountMemList.contains(parent))) {
            return this.getCurrFlowTypeParent((AccountMember)parent, flowAccountMemList, flowType);
        }
        return parent;
    }

    private void removeChildMember(DimMember member, List<DimMember> needRemoveChildList) {
        List<DimMember> children = member.getChildren();
        if (CollectionUtils.isEmpty(children)) {
            return;
        }
        children.removeAll(needRemoveChildList);
        for (DimMember child : children) {
            this.removeChildMember(child, needRemoveChildList);
        }
    }

    private DimMember getCurrOrgParent(DimMember accountMember, List<DimMember> flowAccountMemList) {
        DimMember parent = accountMember.getParent();
        if (parent != null && !flowAccountMemList.contains(parent)) {
            return this.getCurrOrgParent(parent, flowAccountMemList);
        }
        return parent;
    }

    private void rebuildMemberLevel(List<DimMember> memberList, int level) {
        if (CollectionUtils.isEmpty(memberList)) {
            return;
        }
        for (DimMember dimMember : memberList) {
            List<DimMember> children = dimMember.getChildren();
            dimMember.setLevel(level);
            this.rebuildMemberLevel(children, level + 1);
        }
    }
}

