/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ControlIntensityType;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.enums.PeriodControlStrategyType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.SubjectFlowType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlAmountCache;
import kd.tmc.fpm.business.domain.model.control.ControlStrategy;
import kd.tmc.fpm.business.domain.model.control.ControlStrategyDetail;
import kd.tmc.fpm.business.domain.model.control.DetailControlInfo;
import kd.tmc.fpm.business.domain.model.control.ReportType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.IControlService;
import kd.tmc.fpm.business.domain.service.IReportDataMatchService;
import kd.tmc.fpm.business.helper.ControlHelper;
import kd.tmc.fpm.business.helper.ControlMetricCalculateHelper;
import kd.tmc.fpm.business.mvc.service.dto.ControlParamDTO;
import kd.tmc.fpm.business.mvc.service.dto.ControlParamResultDTO;
import kd.tmc.fpm.business.provider.ReportDataBaseDataProvider;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.business.utils.MetricValueUtils;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.helper.StringHelper;
import kd.tmc.fpm.common.utils.NumberUtils;

public class ControlService
implements IControlService,
IReportDataMatchService {
    private static Log logger = LogFactory.getLog(ControlService.class);
    private static Set<DimensionType> SYSTEM_DIMENSION_TYPE;

    @Override
    public FpmOperateResult<ControlParamResultDTO> checkByStrategy(ControlParamDTO controlParamDTO) {
        Object curSubjectId;
        logger.info("\u6267\u884c\u63a7\u5236\u7b56\u7565\u6821\u9a8c\uff0c\u6821\u9a8c\u53c2\u6570:{}", (Object)controlParamDTO);
        ControlStrategy strategy = controlParamDTO.getControlStrategy();
        ReportData reportData = controlParamDTO.getReportData();
        DimMember currPeriodMember = controlParamDTO.getCurrPeriodMember();
        PeriodMember periodMember = (PeriodMember)currPeriodMember;
        Long periodTypeId = periodMember.getPeriodTypeId();
        FundPlanSystem fundPlanSystem = controlParamDTO.getFundPlanSystem();
        if (Objects.isNull(strategy)) {
            Object orgId = reportData.getDimValByDimType(DimensionType.ORG, null);
            Dimension orgDimension = fundPlanSystem.getMainDimensionByDimType(DimensionType.ORG);
            DimMember orgMember = orgDimension.getAllDimMemberList().stream().filter(dimMember -> Objects.equals(orgId, dimMember.getId())).findFirst().get();
            ReportPeriodType periodType = fundPlanSystem.getReportTypeList().stream().filter(reportPeriodType -> Objects.equals(periodTypeId, reportPeriodType.getReportPeriodId())).findFirst().get();
            String errorMessage = String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u201c%1$s\u201d\u7f16\u62a5\u4e3b\u4f53\u201c%2$s\u201d\u7f16\u62a5\u7c7b\u578b\u201c%3$s\u201d\u6ca1\u6709\u6709\u6548\u7684\u63a7\u5236\u7b56\u7565\u3002", (String)"ControlService_0", (String)"tmc-fpm-business", (Object[])new Object[0]), fundPlanSystem.getName(), orgMember.getName(), periodType.getName());
            return FpmOperateResult.error(errorMessage);
        }
        List<ControlStrategyDetail> controlStrategyDetails = strategy.getControlStrategyDetails();
        Map<Long, ControlStrategyDetail> strategyDetailMap = controlStrategyDetails.stream().collect(Collectors.toMap(ControlStrategyDetail::getSubjectId, Function.identity()));
        ControlStrategyDetail strategyDetail = (ControlStrategyDetail)strategyDetailMap.get(curSubjectId = reportData.getDimValByDimType(DimensionType.SUBJECTS, null));
        if (Objects.isNull(strategyDetail) || strategyDetail.getSubjectFlow() == SubjectFlowType.BALANCE) {
            return FpmOperateResult.success(new ControlParamResultDTO());
        }
        ReportType currentReportType = strategy.getReportType().stream().filter(reportType -> reportType.getId().equals(periodTypeId)).findFirst().get();
        logger.info("\u4f53\u7cfb\uff1a{}\u63a7\u5236\u7b56\u7565:{},\u5f53\u524d\u7f16\u62a5\u7c7b\u578b:{}", new Object[]{fundPlanSystem.getName(), strategy.getNumber(), currentReportType.getNumber()});
        QueryIndexInfo<Long, ReportData> relateReportDataQueryIndexInfo = controlParamDTO.getRelateReportDataQueryIndexInfo();
        ReportData actualOperatorReportData = this.getActualOperatorReportData(controlParamDTO, currentReportType, periodMember);
        if (Objects.isNull(actualOperatorReportData)) {
            String errorMessage = String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u3010%1$s\u3011\u63a7\u5236\u7b56\u7565\uff1a%2$s\u4e3a\u660e\u7ec6\u671f\u95f4\u63a7\u5236\uff0c\u7f16\u62a5\u7c7b\u578b%3$s\u4e0d\u5305\u542b\u660e\u7ec6\u533a\u95f4\uff0c\u6309\u5f53\u671f\u5904\u7406\uff0c\u7236\u7ea7\u7f16\u62a5\u6570\u636e\u4e3a\u7a7a", (String)"ControlService_1", (String)"tmc-fpm-business", (Object[])new Object[0]), fundPlanSystem.getName(), strategy.getName(), currentReportType.getNumber());
            return FpmOperateResult.error(errorMessage);
        }
        logger.info("\u7f16\u62a5\u6570\u636eid:{},\u5bf9\u5e94\u7684\u5b9e\u9645\u7f16\u62a5\u6570\u636eid:{}", (Object)reportData.getId(), (Object)actualOperatorReportData.getId());
        ControlParamResultDTO controlParamResultDTO = new ControlParamResultDTO();
        BigDecimal realAmount = controlParamDTO.getRealAmount();
        logger.info("\u3010\u63a7\u5236\u7b56\u7565\u6821\u9a8c\u91d1\u989d:\u3011{}=\u3010\u5f85\u9884\u5360\u91d1\u989d:\u3011{} + \u3010\u7f13\u5b58\u53ef\u7528\u4f59\u989d:\u3011{}", new Object[]{realAmount, controlParamDTO.getRealAmount(), controlParamDTO.getControlAmountCache().getAvailableLockAmt(reportData.getId())});
        if (realAmount.compareTo(BigDecimal.ZERO) <= 0) {
            this.updateControlAmtCache(controlParamDTO);
            return FpmOperateResult.success(controlParamResultDTO);
        }
        logger.info("\u5f00\u59cb\u63a7\u5236\u7b56\u7565....");
        Long subjectId = (Long)actualOperatorReportData.getDimValByDimType(DimensionType.SUBJECTS, null);
        ControlStrategyDetail controlStrategyDetail = (ControlStrategyDetail)strategyDetailMap.get(subjectId);
        if (controlStrategyDetail == null) {
            logger.info("\u5f53\u524d\u79d1\u76ee\u6ca1\u6709\u914d\u7f6e\u63a7\u5236\u6d4b\u8bd5\uff0c\u79d1\u76eeid\uff1a{}", (Object)subjectId);
            return FpmOperateResult.error(ResManager.loadKDString((String)"\u5f53\u524d\u79d1\u76ee\u6ca1\u6709\u914d\u7f6e\u63a7\u5236\u7b56\u7565\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ControlService_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        List<Long> allParentIdS = controlStrategyDetail.getAllParentIdS();
        boolean checkResult = this.checkAmount(strategyDetailMap, actualOperatorReportData, controlParamResultDTO, controlParamDTO);
        if (!checkResult) {
            return FpmOperateResult.success(controlParamResultDTO);
        }
        DimensionInfoBean dimInfoByNotSystemDimFilter = DimensionInfoHelper.getDimensionInfoBeanByFilter(reportData, templateDim -> !templateDim.getDimType().isSystemDim());
        List<Long> needCheckSubject = this.getNeedCheckSubject(allParentIdS, controlParamDTO.getTemplate());
        if (!CollectionUtils.isEmpty(needCheckSubject)) {
            Dimension subjectDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.SUBJECTS);
            DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBeanByFilter(actualOperatorReportData, templateDim -> templateDim.getDimType().isSystemDim());
            for (Long currSubjectId : needCheckSubject) {
                ReportData parentReportData;
                dimensionInfoBean.replaceValueIfContains(subjectDim.getId(), (Object)currSubjectId);
                List<ReportData> parentReportDataList = relateReportDataQueryIndexInfo.findList(dimensionInfoBean);
                if (CollectionUtils.isEmpty(parentReportDataList)) continue;
                if (NumberUtils.equals((Integer)parentReportDataList.size(), (Integer)1)) {
                    parentReportData = parentReportDataList.get(0);
                } else {
                    List<Long> dimensionIdList = relateReportDataQueryIndexInfo.listDimensionId();
                    for (Long dimensionId : dimensionIdList) {
                        boolean hasDim;
                        Object memberByDimensionId = dimInfoByNotSystemDimFilter.getMemberByDimensionId(dimensionId);
                        if (Objects.isNull(memberByDimensionId) || memberByDimensionId instanceof Long && NumberUtils.equalsZero((Long)((Long)memberByDimensionId)) || !(hasDim = parentReportDataList.stream().allMatch(item -> Objects.nonNull(item.getDimValByDimensionId(dimensionId))))) continue;
                        dimensionInfoBean.addDimensionInfo(dimensionId, memberByDimensionId);
                    }
                    parentReportData = relateReportDataQueryIndexInfo.findOne(dimensionInfoBean);
                }
                if (this.checkAmount(strategyDetailMap, parentReportData, controlParamResultDTO, controlParamDTO)) continue;
                break;
            }
        }
        this.updateControlAmtCache(controlParamDTO);
        return FpmOperateResult.success(controlParamResultDTO);
    }

    private void updateControlAmtCache(ControlParamDTO controlParamDTO) {
        QueryIndexInfo<Long, ReportData> relateReportDataQueryIndexInfo = controlParamDTO.getRelateReportDataQueryIndexInfo();
        ControlAmountCache controlAmountCache = controlParamDTO.getControlAmountCache();
        BiConsumer<ReportData, BigDecimal> upperSubjectOccupyAmtConsumer = ControlHelper.getUpperSubjectOccupyAmtConsumer(controlAmountCache, controlParamDTO.getControlStrategy(), relateReportDataQueryIndexInfo, controlParamDTO.getControlStrategyDelegate());
        BigDecimal realAmount = controlParamDTO.getRealAmount();
        ReportData reportData = controlParamDTO.getReportData();
        controlAmountCache.updateLockAmount(reportData.getId(), reportData.getReportActAmount(realAmount));
        upperSubjectOccupyAmtConsumer.accept(reportData, realAmount);
        DimMember currPeriodMember = controlParamDTO.getCurrPeriodMember();
        PeriodMember periodMember = (PeriodMember)currPeriodMember;
        FundPlanSystem fundPlanSystem = controlParamDTO.getFundPlanSystem();
        ReportPeriodType reportPeriodType = fundPlanSystem.getReportTypeList().stream().filter(rt -> Objects.equals(rt.getReportPeriodId(), periodMember.getPeriodTypeId())).findFirst().get();
        if (Objects.isNull((Object)reportPeriodType.getDetailPeriodType())) {
            return;
        }
        Long periodMemberId = periodMember.getId();
        DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBean(reportData);
        List memberIdList = dimensionInfoBean.getMemberIdList();
        int index = memberIdList.indexOf(periodMemberId);
        if (index == -1) {
            return;
        }
        memberIdList.set(index, periodMember.getParentId());
        List<ReportData> parentPeriodReportDataList = relateReportDataQueryIndexInfo.findList(dimensionInfoBean);
        if (EmptyUtil.isEmpty(parentPeriodReportDataList)) {
            return;
        }
        parentPeriodReportDataList.forEach(rd -> {
            controlAmountCache.updateLockAmount(rd.getId(), rd.getReportActAmount(realAmount));
            upperSubjectOccupyAmtConsumer.accept((ReportData)rd, realAmount);
        });
    }

    private List<Long> getNeedCheckSubject(List<Long> allParentIdS, ReportTemplate template) {
        if (template == null) {
            logger.error("\u6570\u636e\u5f02\u5e38\uff0c\u5339\u914d\u5230\u7684\u6570\u636e\u672a\u67e5\u8be2\u5230\u6a21\u677f\u4fe1\u606f");
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff0c\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u6a21\u677f\u4fe1\u606f\u3002", (String)"ControlService_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        if (!template.isMainTable()) {
            return allParentIdS;
        }
        ArrayList<Long> result = new ArrayList<Long>(allParentIdS.size());
        List<TemplateAccountSetting> accountSettings = template.getAccountSettings();
        Map accountSettingMap = accountSettings.stream().collect(Collectors.toMap(TemplateAccountSetting::getAccountMemId, Function.identity()));
        for (Long subjectId : allParentIdS) {
            TemplateAccountSetting templateAccountSetting = (TemplateAccountSetting)accountSettingMap.get(subjectId);
            if (templateAccountSetting.getInputType() == ReportInputType.FORMULA) {
                return result;
            }
            result.add(subjectId);
        }
        return result;
    }

    private boolean checkAmount(Map<Long, ControlStrategyDetail> strategyDetailMap, ReportData actualOperatorReportData, ControlParamResultDTO controlParamResultDTO, ControlParamDTO controlParamDTO) {
        if (Objects.isNull(actualOperatorReportData)) {
            logger.info("\u5f85\u6821\u9a8c\u7684\u5b9e\u9645\u7f16\u62a5\u6570\u636e\u4e3a\u7a7a\uff0c\u8ba4\u4e3a\u5df2\u5230\u8fbe\u9876\u7ea7\u79d1\u76ee\uff0c\u68c0\u9a8c\u901a\u8fc7\u3002\u3002\u3002\u3002");
            return true;
        }
        ControlStrategy controlStrategy = controlParamDTO.getControlStrategy();
        String strategyNumber = controlStrategy.getNumber();
        Long subjectId = (Long)actualOperatorReportData.getDimValByDimType(DimensionType.SUBJECTS, null);
        ControlStrategyDetail controlStrategyDetail = strategyDetailMap.get(subjectId);
        ControlIntensityType controlIntensity = controlStrategyDetail.getControlIntensity();
        FundPlanSystem fundPlanSystem = controlParamDTO.getFundPlanSystem();
        if (Objects.isNull(controlIntensity)) {
            return true;
        }
        HashSet<DimensionValue> matchedOptionalDim = new HashSet<DimensionValue>(4);
        AtomicReference<BigDecimal> planAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        BigDecimal availableAmount = this.getAvailableAmount(controlStrategyDetail, actualOperatorReportData, controlParamDTO, matchedOptionalDim, planAmount);
        logger.info("\u4f53\u7cfb\uff1a{},\u63a7\u5236\u7b56\u7565\uff1a{}\uff0c\u5f53\u524d\u8ba1\u5212\u79d1\u76ee\u7f16\u7801:{},\u5f53\u524d\u79d1\u76ee\u6240\u5728\u8bb0\u5f55\u7684\u53ef\u7528\u4f59\u989d:{},\u8ba1\u5212\u91d1\u989d\u603b\u989d\u5ea6\uff1a{}", new Object[]{fundPlanSystem.getName(), strategyNumber, controlStrategyDetail.getSubjectNumber(), availableAmount, planAmount.get()});
        BillBizInfo billBizInfo = controlParamDTO.getBillBizInfo();
        if (matchedOptionalDim.isEmpty()) {
            this.addErrorMessageNotMatch(controlParamResultDTO, controlStrategy.getFundPlanSystem(), controlStrategyDetail, billBizInfo.getBillNo());
            return false;
        }
        List<String> dimensionName = matchedOptionalDim.stream().sorted(Comparator.comparing(ControlService::getDimensionScore)).map(dimensionValue -> ControlService.getDimensionName(controlStrategy.getFundPlanSystem(), dimensionValue, actualOperatorReportData)).collect(Collectors.toList());
        BigDecimal realAmount = actualOperatorReportData.getReportActAmount(controlParamDTO.getRealAmount());
        if (availableAmount.compareTo(realAmount) < 0) {
            logger.info("\u8d44\u91d1\u8ba1\u5212\u989d\u5ea6\u4e0d\u8db3\uff0c\u5355\u636e\uff1a{}\u5339\u914d\u5230\u4f53\u7cfb\uff1a{}\uff0c\u7684\uff1a{}\u7684\u8d44\u91d1\u8ba1\u5212\u4f59\u989d\u4e0d\u8db3\uff0c\u5f53\u524d\u5269\u4f59\u53ef\u7528\u4f59\u989d\uff1a{}\uff0c\u9884\u8ba1\u672c\u6b21\u5360\u7528\uff08\u5b9e\u9645\u6263\u51cf\uff09{}", new Object[]{billBizInfo.getBillNo(), fundPlanSystem.getName(), dimensionName, availableAmount, realAmount});
            controlParamResultDTO.addErrorMessage(new ControlParamResultDTO.ErrorMessage(billBizInfo.getBillNo(), fundPlanSystem, dimensionName, planAmount.get(), realAmount, availableAmount, actualOperatorReportData.getAmountUnit()));
            return false;
        }
        this.availableAmountWarn(controlStrategy, availableAmount.subtract(realAmount), planAmount.get(), controlParamResultDTO, remainAmount -> new ControlParamResultDTO.WarnMessage(billBizInfo.getBillNo(), fundPlanSystem, dimensionName, (BigDecimal)planAmount.get(), BigDecimal.ZERO, (BigDecimal)remainAmount, actualOperatorReportData.getAmountUnit()));
        return true;
    }

    private void addErrorMessageNotMatch(ControlParamResultDTO controlParamResultDTO, FundPlanSystem fundPlanSystem, ControlStrategyDetail controlStrategyDetail, String billNo) {
        List<ControlStrategyDetail.DetailControlBasis> detailControlBasisList = controlStrategyDetail.getDetailControlBasisList();
        if (CollectionUtils.isEmpty(detailControlBasisList)) {
            return;
        }
        ArrayList<Dimension> dimensionList = new ArrayList<Dimension>(SYSTEM_DIMENSION_TYPE.size() + detailControlBasisList.size());
        for (DimensionType dimensionType : SYSTEM_DIMENSION_TYPE) {
            Dimension dimension = fundPlanSystem.getMainDimensionByDimType(dimensionType);
            dimensionList.add(dimension);
        }
        List<Dimension> detailDimList = fundPlanSystem.getDetailDimList();
        Map dimensionMap = detailDimList.stream().collect(Collectors.toMap(Dimension::getId, Function.identity()));
        for (ControlStrategyDetail.DetailControlBasis detailControlBasis : detailControlBasisList) {
            DimensionType dimensionType = detailControlBasis.getDimensionType();
            dimensionList.add(Objects.isNull((Object)dimensionType) || dimensionType == DimensionType.DETAILDIM ? (Dimension)dimensionMap.get(detailControlBasis.getDimensionId()) : fundPlanSystem.getMainDimensionByDimensionId(detailControlBasis.getDimensionId()));
        }
        controlParamResultDTO.addErrorMessage(new ControlParamResultDTO.ErrorMessage(true, billNo, fundPlanSystem, controlStrategyDetail.getSubjectName(), dimensionList.stream().sorted(Comparator.comparing(DimensionInfoHelper::getScoreByDimensionType)).map(Dimension::getName).collect(Collectors.toList())));
    }

    private void availableAmountWarn(ControlStrategy controlStrategy, BigDecimal remainAmount, BigDecimal planAmount, ControlParamResultDTO controlParamResultDTO, Function<BigDecimal, ControlParamResultDTO.WarnMessage> warnMessage) {
        if (!controlStrategy.isNeedUnAvailableWarn()) {
            return;
        }
        Integer unAvailableWarn = controlStrategy.getUnAvailableWarn();
        BigDecimal warnAmount = planAmount.multiply(BigDecimal.valueOf(unAvailableWarn.intValue())).divide(BigDecimal.valueOf(100L));
        if (remainAmount.compareTo(warnAmount) <= 0) {
            ControlParamResultDTO.WarnMessage message = warnMessage.apply(remainAmount);
            message.setWarnAmount(warnAmount);
            logger.info(message.getMessage());
            controlParamResultDTO.addWarnMessage(message);
        }
    }

    private BigDecimal getAvailableAmount(ControlStrategyDetail controlStrategyDetail, ReportData actualOperatorReportData, ControlParamDTO controlParamDTO, Set<DimensionValue> matchedOptionalDim, AtomicReference<BigDecimal> planAmount) {
        List<ReportData> mustDimensionReportData;
        if (!controlStrategyDetail.getDetailControl().booleanValue()) {
            mustDimensionReportData = this.getMustDimensionReportData(actualOperatorReportData, controlParamDTO.getRelateReportDataQueryIndexInfo(), Collections.emptySet(), matchedOptionalDim);
        } else {
            List<ControlStrategyDetail.DetailControlBasis> detailControlBasisList = controlStrategyDetail.getDetailControlBasisList();
            if (!controlParamDTO.isAccurateMatch()) {
                return BigDecimal.ZERO;
            }
            Set matched = controlParamDTO.getMatchedDimensions().stream().map(dimension -> new ControlStrategyDetail.DetailControlBasis(dimension.getDimType(), dimension.getId())).collect(Collectors.toSet());
            Set<ControlStrategyDetail.DetailControlBasis> controlBasisSet = detailControlBasisList.stream().filter(matched::contains).collect(Collectors.toSet());
            mustDimensionReportData = this.getMustDimensionReportData(actualOperatorReportData, controlParamDTO.getRelateReportDataQueryIndexInfo(), controlBasisSet, matchedOptionalDim);
        }
        return this.getAvailableAmount(mustDimensionReportData, controlStrategyDetail, planAmount, controlParamDTO);
    }

    private BigDecimal getAvailableAmount(List<ReportData> mustDimensionReportData, ControlStrategyDetail controlStrategyDetail, AtomicReference<BigDecimal> planAmount, ControlParamDTO controlParamDTO) {
        ControlAmountCache controlAmountCache = controlParamDTO.getControlAmountCache();
        BigDecimal controlCoefficient = controlStrategyDetail.getControlCoefficient();
        BigDecimal playAmount = BigDecimal.ZERO;
        BigDecimal preAmount = BigDecimal.ZERO;
        BigDecimal aclAmount = BigDecimal.ZERO;
        BigDecimal holdLockAmt = BigDecimal.ZERO;
        BigDecimal holdActAmt = BigDecimal.ZERO;
        BigDecimal concurrentAmt = BigDecimal.ZERO;
        for (ReportData reportData : mustDimensionReportData) {
            playAmount = playAmount.add(reportData.getPlanAmt());
            preAmount = preAmount.add(reportData.getLockAmt());
            aclAmount = aclAmount.add(reportData.getActAmt());
            holdLockAmt = holdLockAmt.add(controlAmountCache.getAvailableLockAmt(reportData.getId())).add(reportData.getHoldLockAmt());
            holdActAmt = holdActAmt.add(controlAmountCache.getAvailableActAmt(reportData.getId())).add(reportData.getHoldActAmt());
            concurrentAmt = concurrentAmt.add(reportData.getConcurrentAmt());
        }
        planAmount.set(playAmount);
        Set ids = mustDimensionReportData.stream().map(ReportData::getId).collect(Collectors.toSet());
        logger.info("\u53c2\u4e0e\u53ef\u7528\u4f59\u989d\u8ba1\u7b97\u7684\u7f16\u5236\u6570\u636eid\uff1a{},\u8ba1\u7b97\u53ef\u7528\u4f59\u989d\uff1a\u63a7\u5236\u7cfb\u6570\uff1a{} * \u8ba1\u5212\u91d1\u989d\uff1a{} / 100 - \u9884\u5360\u91d1\u989d\uff1a{} - \u5b9e\u5360\u91d1\u989d\uff1a{} - \u9884\u5360\u9884\u6263\u51cf\u91d1\u989d\uff1a{} - \u5b9e\u5360\u9884\u6263\u51cf\u91d1\u989d\uff1a{} - \u5e76\u53d1\u66f4\u65b0\u91d1\u989d\uff1a{}", new Object[]{ids, controlCoefficient, playAmount, preAmount, aclAmount, holdLockAmt, holdActAmt, concurrentAmt});
        BigDecimal hundredPercent = BigDecimal.ONE.divide(new BigDecimal(100), 12, RoundingMode.HALF_EVEN);
        BigDecimal planAmt = controlCoefficient.multiply(playAmount).multiply(hundredPercent);
        HashMap<TemplateMetricType, String> param = new HashMap<TemplateMetricType, String>();
        param.put(TemplateMetricType.PLANAMT, CommonUtils.getIfZeroValue(planAmt).toString());
        param.put(TemplateMetricType.LOCKAMT, CommonUtils.getIfZeroValue(preAmount).toString());
        param.put(TemplateMetricType.ACTMAT, CommonUtils.getIfZeroValue(aclAmount).toString());
        BigDecimal bigDecimal = MetricValueUtils.computeByExpress(ControlMetricCalculateHelper.getMetricMember(controlParamDTO.getFundPlanSystem(), TemplateMetricType.AVAILABLEAMT), param);
        return bigDecimal.subtract(holdLockAmt).subtract(holdActAmt).subtract(concurrentAmt);
    }

    private List<ReportData> getMustDimensionReportData(ReportData actualOperatorReportData, QueryIndexInfo<Long, ReportData> queryIndexInfo, Set<ControlStrategyDetail.DetailControlBasis> mustMatchSet, Set<DimensionValue> matchedOptionalDim) {
        logger.info("\u6309\u660e\u7ec6\u9879\u63a7\u5236\u7ef4\u5ea6id\uff1a{}", mustMatchSet);
        DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBeanByFilter(actualOperatorReportData, templateDim -> templateDim.getDimType().isSystemDim());
        List<TemplateDim> dimList = actualOperatorReportData.getDimList();
        Map templateDimMap = dimList.stream().collect(Collectors.toMap(TemplateDim::getDimensionId, Function.identity(), (a, b) -> a));
        List<Object> dataDimValList = actualOperatorReportData.getDimValList();
        HashMap<Long, Object> optionDimValueMap = new HashMap<Long, Object>(8);
        for (int i = 0; i < dimList.size(); ++i) {
            TemplateDim templateDim2 = dimList.get(i);
            if (!templateDim2.getDimType().isDetailDim()) {
                optionDimValueMap.put(templateDim2.getDimensionId(), dataDimValList.get(i));
            }
            if (templateDim2.getDimType().isSystemDim()) continue;
        }
        HashSet<Long> detailFields = new HashSet<Long>(8);
        DimensionInfoBean copy = dimensionInfoBean.copy();
        for (ControlStrategyDetail.DetailControlBasis controlBasis : mustMatchSet) {
            if (controlBasis.getDimensionType().isDetailDim()) {
                detailFields.add(controlBasis.getDimensionId());
                continue;
            }
            Long val = optionDimValueMap.getOrDefault(controlBasis.getDimensionId(), 0L);
            if (EmptyUtil.isEmpty((Object)val)) continue;
            copy.addDimensionInfo(controlBasis.getDimensionId(), (Object)val);
        }
        List<ReportData> list = queryIndexInfo.findList(copy);
        List dimensionIdList = copy.getDimensionIdList();
        List memberIdList = copy.getMemberIdList();
        for (int i = 0; i < dimensionIdList.size(); ++i) {
            Long dimensionId = (Long)dimensionIdList.get(i);
            matchedOptionalDim.add(new DimensionValue((TemplateDim)templateDimMap.get(dimensionId), memberIdList.get(i)));
        }
        if (EmptyUtil.isEmpty(list)) {
            return list;
        }
        if (EmptyUtil.isNoEmpty(detailFields)) {
            Map<Long, Object> detailDimValueMap = DimensionInfoHelper.getDetailDimValueMap(actualOperatorReportData, detailFields);
            matchedOptionalDim.addAll(detailDimValueMap.entrySet().stream().map(entry -> new DimensionValue((TemplateDim)templateDimMap.get(entry.getKey()), entry.getValue())).collect(Collectors.toList()));
            logger.info("\u7f16\u5236\u6570\u636eid:{}\uff0c\u6309\u660e\u7ec6\u5b57\u6bb5:{}\u63a7\uff0c\u660e\u7ec6\u5b57\u6bb5\u503c\uff1a{}", new Object[]{actualOperatorReportData.getId(), detailFields, detailDimValueMap});
            Predicate<ReportData> predicate = DimensionInfoHelper.getDetailFieldMatchFilter(detailDimValueMap);
            list = list.stream().filter(predicate::test).collect(Collectors.toList());
        }
        if (!actualOperatorReportData.isMainTable()) {
            logger.info("\u5f53\u524d\u7f16\u5236\u6570\u636eid:{}, \u4e3a\u7cbe\u786e\u5339\u914d\u6570\u636e\uff0c\u4e14\u4e3a\u5b50\u8868\u6570\u636e\uff0c\u4e0d\u9700\u8981\u518d\u67e5\u627e\u6c47\u603b\u5b50\u9879\uff0c\u76f4\u63a5\u8fd4\u56de\uff0c\u5339\u914d\u5230\u7684\u6570\u636e\uff1a{}", (Object)actualOperatorReportData.getId(), list);
            List dataList = list.stream().filter(ReportData::isMainTable).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(dataList)) {
                list = dataList;
            }
        } else {
            list = list.stream().filter(rd -> Objects.equals(rd.getReportId(), actualOperatorReportData.getReportId())).collect(Collectors.toList());
            logger.info("\u5f53\u524d\u7f16\u5236\u6570\u636eid:{}, \u4e3a\u7cbe\u786e\u5339\u914d\u6570\u636e\uff0c\u4e14\u4e3a\u4e3b\u8868\u6570\u636e\uff0c\u4e0d\u9700\u8981\u518d\u67e5\u627e\u6c47\u603b\u5b50\u9879\uff0c\u76f4\u63a5\u8fd4\u56de", (Object)actualOperatorReportData.getId());
        }
        return list;
    }

    private ReportData getActualOperatorReportData(ControlParamDTO controlParamDTO, ReportType currentReportType, PeriodMember periodMember) {
        ControlStrategy strategy = controlParamDTO.getControlStrategy();
        ReportData reportData = controlParamDTO.getReportData();
        PeriodControlStrategyType periodControlStrategyType = strategy.getPeriodControlStrategyType();
        PeriodType detailPeriodType = currentReportType.getDetailPeriodType();
        if (periodControlStrategyType == PeriodControlStrategyType.DETAIL_PERIOD_CONTROL && Objects.nonNull((Object)detailPeriodType)) {
            logger.info("\u63a7\u5236\u7b56\u7565:{},\u671f\u95f4\u63a7\u5236\u7b56\u7565\uff1a{}\u4e3a\u6309\u660e\u7ec6\u7a7a,\u7f16\u62a5\u7c7b\u578b\u660e\u7ec6\u533a\u95f4:{},\u7f16\u62a5\u6570\u636eid:{}", new Object[]{strategy.getNumber(), periodControlStrategyType.getNumber(), detailPeriodType.getNumber(), reportData.getId()});
            return reportData;
        }
        QueryIndexInfo<Long, ReportData> queryIndexInfo = controlParamDTO.getRelateReportDataQueryIndexInfo();
        if (Objects.nonNull((Object)detailPeriodType) && periodMember.getPeriodType() == detailPeriodType) {
            Set<Long> detailDimIds;
            Long parentId = periodMember.getParentId();
            DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBean(reportData);
            dimensionInfoBean.replaceValueIfContains(periodMember.getDimensionId(), (Object)parentId);
            DetailControlInfo detailControlInfo = controlParamDTO.getDetailControlInfo();
            List<ReportData> list = queryIndexInfo.findList(dimensionInfoBean);
            Long subjectId = (Long)reportData.getDimValByDimType(DimensionType.SUBJECTS);
            if (list.size() == 1 || detailControlInfo == null || EmptyUtil.isEmpty(detailDimIds = detailControlInfo.getDetailDimIds(subjectId))) {
                ReportData parentReportData = list.get(0);
                logger.info("\u63a7\u5236\u7b56\u7565:{},\u671f\u95f4\u63a7\u5236\u7b56\u7565\uff1a{},\u7f16\u62a5\u7c7b\u578b\u660e\u7ec6\u671f\u95f4\uff1a{}\uff0c\u6309\u5f53\u671f\u5904\u7406\uff0c\u83b7\u53d6\u4e0a\u7ea7\u5f53\u671f\u7f16\u62a5\u6570\u636e\uff0c\u7cbe\u786e\u5339\u914d\u7684\u7f16\u62a5\u6570\u636eid:{},\u83b7\u53d6\u5230\u7684\u7236\u7ea7\u7f16\u62a5\u6570\u636eid:{}", new Object[]{strategy.getNumber(), periodControlStrategyType.getNumber(), detailPeriodType, reportData.getId(), Objects.isNull(parentReportData) ? "" : parentReportData.getId()});
                return parentReportData;
            }
            Map<Long, Object> detailDimValueMap = DimensionInfoHelper.getDetailDimValueMap(reportData, detailDimIds);
            Predicate<ReportData> detailFieldMatchFilter = DimensionInfoHelper.getDetailFieldMatchFilter(detailDimValueMap);
            ReportData parentReportData = list.stream().filter(detailFieldMatchFilter).findFirst().orElse(null);
            logger.info("\u63a7\u5236\u7b56\u7565:{},\u671f\u95f4\u63a7\u5236\u7b56\u7565\uff1a{},\u7f16\u62a5\u7c7b\u578b\u660e\u7ec6\u671f\u95f4\uff1a{}\uff0c\u6309\u5f53\u671f\u5904\u7406\uff0c\u83b7\u53d6\u4e0a\u7ea7\u5f53\u671f\u7f16\u62a5\u6570\u636e\uff0c\u7cbe\u786e\u5339\u914d\u7684\u7f16\u62a5\u6570\u636eid:{},\u83b7\u53d6\u5230\u7684\u7236\u7ea7\u7f16\u62a5\u6570\u636eid:{}", new Object[]{strategy.getNumber(), periodControlStrategyType.getNumber(), detailPeriodType, reportData.getId(), Objects.isNull(parentReportData) ? "" : parentReportData.getId()});
            return parentReportData;
        }
        logger.info("\u63a7\u5236\u7b56\u7565:{},\u671f\u95f4\u63a7\u5236\u7b56\u7565\uff1a{}\uff0c\u6309\u5f53\u671f\u5904\u7406,\u7f16\u62a5\u6570\u636eid:{}", new Object[]{strategy.getNumber(), periodControlStrategyType.getNumber(), reportData.getId()});
        return reportData;
    }

    @Override
    public List<ReportData> getMustDimensionReportData(ReportData actualOperatorReportData, QueryIndexInfo<Long, ReportData> queryIndexInfo, Set<ControlStrategyDetail.DetailControlBasis> mustMatchSet) {
        return this.getMustDimensionReportData(actualOperatorReportData, queryIndexInfo, mustMatchSet, new HashSet<DimensionValue>(2));
    }

    @Override
    public ReportData getParentReportData(ReportData reportData, QueryIndexInfo<Long, ReportData> queryIndexInfo, Long parentId, Long dimensionId) {
        logger.info("\u83b7\u53d6\u7236\u7ea7\u7684\u7f16\u5236\u6570\u636e\uff0c\u7236\u7ef4\u5ea6id\uff1a{}\uff0c\u7236\u7ef4\u5ea6\u6210\u5458id\uff1a{}\uff0c\u5f53\u524d\u7f16\u5236\u6570\u636e\uff1a{}", new Object[]{dimensionId, parentId, reportData.getId()});
        DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBean(reportData);
        dimensionInfoBean.replaceValueIfContains(dimensionId, (Object)parentId);
        ReportData one = queryIndexInfo.findOne(dimensionInfoBean);
        logger.info("\u67e5\u627e\u7236\u7ea7\u7f16\u5236\u6570\u636e:{},\u7ef4\u5ea6\u7ec4\u5408\uff1a{}\uff0c\u5f53\u524d\u7f16\u5236\u6570\u636e:{}", new Object[]{one, dimensionInfoBean, reportData.getId()});
        return one;
    }

    private static int getDimensionScore(DimensionValue dimensionValue) {
        TemplateDim templateDim = dimensionValue.getTemplateDim();
        DimensionType dimType = templateDim.getDimType();
        Dimension dimension = new Dimension();
        dimension.setId(templateDim.getDimensionId());
        dimension.setDimType(dimType);
        dimension.setDetailDimType(templateDim.getDetailDimType());
        return DimensionInfoHelper.getScoreByDimensionType(dimension);
    }

    private static String getDimensionName(FundPlanSystem fundPlanSystem, DimensionValue dimensionValue, ReportData reportData) {
        TemplateDim templateDim = dimensionValue.getTemplateDim();
        DetailDimType detailDimType = templateDim.getDetailDimType();
        if (Objects.isNull((Object)detailDimType)) {
            Dimension dimension = fundPlanSystem.getMainDimensionByDimensionId(templateDim.getDimensionId());
            List<DimMember> allDimMemberList = dimension.getAllDimMemberList();
            return allDimMemberList.stream().filter(dimMember -> dimMember.getId().equals(dimensionValue.getValue())).map(DimMember::getName).findFirst().orElse("");
        }
        Dimension dimension = fundPlanSystem.getDetailDimensionByDetailType(detailDimType);
        return ControlService.getValueForDetailDimension(dimension, dimensionValue.getValue(), reportData);
    }

    private static String getValueForDetailDimension(Dimension dimension, Object detailMemberValue, ReportData reportData) {
        MainEntityType dataEntityType;
        MemberType memberType = dimension.getMemberType();
        if (memberType == MemberType.BASE_DATA) {
            logger.info("\u660e\u7ec6\u5b57\u6bb5\uff1a{},\u7c7b\u578b\u4e3a\u57fa\u7840\u8d44\u6599\uff0c\u503c\u4e3a\uff1a{}", (Object)dimension.getName(), detailMemberValue);
            return ControlService.getValueForBaseData(dimension, detailMemberValue, reportData);
        }
        if (memberType == MemberType.MUTI_BASE_DATA && Objects.nonNull(dataEntityType = EntityMetadataCache.getDataEntityType((String)StringHelper.getStringValue((Object)detailMemberValue)))) {
            return dataEntityType.getDisplayName().getLocaleValue();
        }
        return ControlService.getValue(detailMemberValue);
    }

    private static String getValueForBaseData(Dimension dimension, Object detailMemberValue, ReportData reportData) {
        String bdEntity;
        ArrayList<ReportData> reportDataList = new ArrayList<ReportData>(2);
        reportDataList.add(reportData);
        ReportDataBaseDataProvider reportDataBaseDataProvider = new ReportDataBaseDataProvider(reportDataList);
        DetailDimType detailDimType = dimension.getDetailDimType();
        List<TemplateDim> dimList = reportData.getDimList();
        List<Object> dimValList = reportData.getDimValList();
        logger.info("\u7ef4\u5ea6\u503c\uff1a{}", dimValList);
        DynamicObject baseData = null;
        if (detailDimType == DetailDimType.COUNTERPARTY_NAME) {
            Optional<TemplateDim> first = dimList.stream().filter(item -> item.getDetailDimType() == DetailDimType.CONNTERPARTY_TYPE).findFirst();
            if (first.isPresent()) {
                int typeIndex = dimList.indexOf(first.get());
                String bdEntity2 = (String)dimValList.get(typeIndex);
                baseData = reportDataBaseDataProvider.getBaseData(bdEntity2, detailMemberValue);
            }
        } else if (detailDimType == DetailDimType.BANK_CATE || detailDimType == DetailDimType.BANK_ACCOUNT || detailDimType == DetailDimType.BUSINESS_PARTNER) {
            bdEntity = (String)detailDimType.getExtVal();
            logger.info("\u660e\u7ec6\u5b57\u6bb5:{},\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e3a\uff1a{},\u57fa\u7840\u8d44\u6599id\uff1a{}", new Object[]{dimension.getName(), bdEntity, detailMemberValue});
            baseData = reportDataBaseDataProvider.getBaseData(bdEntity, detailMemberValue);
        } else if (DetailDimType.isExtraField(detailDimType) && MemberType.BASE_DATA == dimension.getMemberType()) {
            bdEntity = dimension.getBaseDataType();
            logger.info("\u81ea\u5b9a\u4e49\u660e\u7ec6\u5b57\u6bb5:{},\u5bf9\u5e94\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e3a\uff1a{},\u57fa\u7840\u8d44\u6599id\uff1a{}", new Object[]{dimension.getName(), bdEntity, detailMemberValue});
            baseData = reportDataBaseDataProvider.getBaseData(bdEntity, detailMemberValue);
        }
        if (Objects.isNull(baseData)) {
            return detailMemberValue.toString();
        }
        String name = baseData.getString("name");
        return StringUtils.isEmpty((CharSequence)name) ? detailMemberValue.toString() : name;
    }

    private static String getValue(Object detailMemberValue) {
        if (detailMemberValue instanceof Date) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date date = (Date)detailMemberValue;
            return dateFormat.format(date);
        }
        return detailMemberValue.toString();
    }

    static {
        HashSet<DimensionType> dimensionTypeSet = new HashSet<DimensionType>(8);
        dimensionTypeSet.add(DimensionType.ORG);
        dimensionTypeSet.add(DimensionType.SUBJECTS);
        dimensionTypeSet.add(DimensionType.PERIOD);
        dimensionTypeSet.add(DimensionType.CURRENCY);
        SYSTEM_DIMENSION_TYPE = Collections.unmodifiableSet(dimensionTypeSet);
    }

    static class DimensionValue {
        private TemplateDim templateDim;
        private Object value;

        public TemplateDim getTemplateDim() {
            return this.templateDim;
        }

        public void setTemplateDim(TemplateDim templateDim) {
            this.templateDim = templateDim;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public DimensionValue(TemplateDim templateDim, Object value) {
            this.templateDim = templateDim;
            this.value = value;
        }
    }
}

