/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.AnalysisReportType;
import kd.tmc.fpm.business.domain.enums.DetailDataType;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.AnalyseReportQueryParam;
import kd.tmc.fpm.business.domain.model.report.AnalysisReport;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.sumplan.EvalDimensionCombination;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateShowConfig;
import kd.tmc.fpm.business.domain.service.InnerCancelProcessServiceImpl;
import kd.tmc.fpm.business.domain.service.QueryConditionProcessor;
import kd.tmc.fpm.business.domain.service.impl.AbstractAnalysisReportDataBuildService;
import kd.tmc.fpm.business.domain.service.impl.AbstractAnalysisReportDataService;
import kd.tmc.fpm.business.domain.service.impl.AnalysisPeriodMemberStrategy;
import kd.tmc.fpm.business.domain.service.impl.CommonDimMemberStrategy;
import kd.tmc.fpm.business.domain.service.impl.LinkSearchShrekQueryConditionProcessor;
import kd.tmc.fpm.business.domain.service.impl.ReportSearchRelationAnalysisReportDataService;
import kd.tmc.fpm.business.domain.service.impl.ShrekAnalysisReportDataService;
import kd.tmc.fpm.business.domain.service.impl.SynthesisRelationQueryConditionProcessor;
import kd.tmc.fpm.business.domain.service.impl.SynthesisShrekQueryConditionProcessor;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.helper.AmountCurrencyRateHelper;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import kd.tmc.fpm.common.utils.NumberUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class LinkSearchAnalyseReportDataBuildServiceImpl
extends AbstractAnalysisReportDataBuildService {
    private Long virtualPeriodTypeId;
    private Boolean isForceRemoveSummaryOfPeriod = false;
    private Map<Long, Dimension> dimensionMap;
    protected Map<Object, DimMember> dimMemberMap;
    private Dimension orgDimension;
    private Boolean orgNeedCleanSubLevelData = false;

    public LinkSearchAnalyseReportDataBuildServiceImpl(AnalyseReportQueryParam param) {
        super(param.getAnalysisHeader(), param.getSystem());
        this.summaryDimIdList = param.getSummaryDimIdList();
        this.dimensionMap = this.system.getDimList().stream().collect(Collectors.toMap(Dimension::getId, Function.identity()));
        this.dimMemberMap = this.system.getMainDimList().stream().map(Dimension::getAllDimMemberList).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, o -> o, (a, b) -> a));
        this.orgDimension = this.system.getMainDimList().stream().filter(dimension -> dimension.getDimType().isOrgDim()).findFirst().get();
    }

    @Override
    public void buildSystem() {
        this.createReportCurrency();
        this.handleHeader();
    }

    private void handleHeader() {
        if (CollectionUtils.isEmpty(this.header.getOrg())) {
            List orgIds = ModelHelper.getOrgAuthScopeWithCheckManager((String)"fpm", (String)"fpm_synthesisquery");
            HashSet orgSet = new HashSet(orgIds);
            Set<Long> memberScope = this.orgDimension.getAllDimMemberList().stream().filter(DimMember::isEnable).map(DimMember::getId).filter(orgSet::contains).collect(Collectors.toSet());
            ArrayList<Long> parents = new ArrayList<Long>(memberScope.size());
            for (Long memberId : memberScope) {
                DimMember dimMember = this.dimMemberMap.get(memberId);
                Long topIdFormMemberScope = this.getTopIdFormMemberScope(memberScope, dimMember);
                if (parents.contains(topIdFormMemberScope)) continue;
                parents.add(topIdFormMemberScope);
            }
            this.header.setOrg(parents);
        }
    }

    private Long getTopIdFormMemberScope(Set<Long> memberScope, DimMember dimMember) {
        DimMember currentExist = dimMember;
        for (DimMember parent = dimMember.getParent(); parent != null; parent = parent.getParent()) {
            if (!memberScope.contains(parent.getId())) continue;
            currentExist = parent;
        }
        return currentExist.getId();
    }

    @Override
    public void buildTemplate() {
        boolean parentViewIsExecute;
        ReportTemplate parentViewTemplate = this.header.getParentViewTemplate();
        FpmAssertUtil.isNotNull((Object)parentViewTemplate, (String)"parentViewTemplate is empty");
        this.analysisTemplate = parentViewTemplate;
        this.analysisTemplate.getColDimList().removeIf(i -> i.getDimType().isMetric());
        this.analysisTemplate.getRowDimList().removeIf(i -> i.getDimType().isMetric());
        this.analysisTemplate.setAmountUnit(this.header.getAmountUnit());
        AnalysisReportType parentAnalyseReportType = this.header.getParentAnalyseReportType();
        boolean bl = parentViewIsExecute = Objects.nonNull((Object)parentAnalyseReportType) && parentAnalyseReportType.isExecuteAnalysis();
        if (parentViewIsExecute && !this.header.isContainDetailReportType()) {
            TemplateShowConfig templateShowConfig = new TemplateShowConfig();
            templateShowConfig.setSummaryShow(true);
            this.analysisTemplate.setConfig(templateShowConfig);
        }
        this.handleTemplateDim();
    }

    @Override
    public List<PeriodMember> getPeriodMemberList() {
        if (CollectionUtils.isEmpty(this.system.getReportTypeList())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e2d\u672a\u67e5\u8be2\u5230\u7f16\u62a5\u7c7b\u578b", (String)"SynthesisReportDataBuildServiceImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        Long reportTypeId = this.header.getReportTypeId();
        List<ReportPeriodType> reportTypeList = this.system.getReportTypeList();
        Dimension periodDim = this.system.getMainDimensionByDimType(DimensionType.PERIOD);
        List<PeriodMember> periodList = periodDim.getMemberList(PeriodMember.class);
        ArrayList<PeriodMember> reportPeriodMemList = new ArrayList<PeriodMember>();
        for (ReportPeriodType reportPeriodType : reportTypeList) {
            PeriodType periodType = reportPeriodType.getPeriodType();
            for (PeriodMember periodMember : periodList) {
                reportPeriodMemList.addAll(periodMember.getChildMemberByPeriodTypeAndPeriodId(periodType, reportPeriodType.getReportPeriodId()));
                if (PeriodType.MONTH_WEEK != periodType) continue;
                reportPeriodMemList.addAll(periodMember.getChildMemberByPeriodTypeAndPeriodId(PeriodType.YEAR_WEEK, reportPeriodType.getReportPeriodId()));
            }
        }
        List<Long> periodId = this.header.getPeriodId();
        return reportPeriodMemList.stream().filter(p -> periodId.contains(p.getId())).sorted(Comparator.comparing(DimMember::getLongNumber)).collect(Collectors.toList());
    }

    private void handleTemplateDim() {
        List allTemplateDim = this.analysisTemplate.getAllTemplateDim().stream().filter(i -> !i.isViDim()).collect(Collectors.toList());
        Map<DimLocation, Integer> dimLocationMaxLevelMap = allTemplateDim.stream().collect(Collectors.groupingBy(TemplateDim::getLocation, Collectors.mapping(TemplateDim::getLevel, Collectors.reducing(0, (a, b) -> a.compareTo((Integer)b) > 0 ? a : b))));
        for (TemplateDim templateDim : allTemplateDim) {
            switch (templateDim.getDimType()) {
                case CURRENCY: {
                    templateDim.setMemberScope(this.header.getCurrency());
                    break;
                }
                case PERIOD: {
                    templateDim.setMemberScope(this.header.getPeriodId());
                    if (!this.isForceRemoveSummaryOfPeriod.booleanValue()) break;
                    templateDim.setIncludeSum(false);
                    break;
                }
                case SUBJECTS: {
                    templateDim.setMemberScope(this.header.getSubjects());
                    break;
                }
                case SETTLEMENT_TYPE: {
                    templateDim.setMemberScope(this.header.getSettlementMethod());
                    break;
                }
                case COMPANY: {
                    templateDim.setMemberScope(this.header.getCompany());
                    break;
                }
                case ORG: {
                    templateDim.setMemberScope(this.header.getOrg());
                    break;
                }
                case CUSTOM: {
                    Dimension dimension = this.dimensionMap.get(templateDim.getDimensionId());
                    templateDim.setMemberScope(this.header.getCustomDimension().getOrDefault(dimension.getNumber(), Collections.emptyList()));
                    break;
                }
            }
            this.handleDimBySearchType(templateDim, dimLocationMaxLevelMap);
            this.addAllMemberIfNeed(templateDim);
            if (!templateDim.getDimType().isPeriodDim()) continue;
            Dimension periodDim = this.system.getMainDimensionByDimensionId(templateDim.getDimensionId());
            List<Long> sortedMember = periodDim.getAllDimMemberList().stream().filter(p -> templateDim.getMemberScope().contains(p.getId())).sorted(Comparator.comparing(DimMember::getLongNumber)).map(DimMember::getId).collect(Collectors.toList());
            templateDim.setMemberScope(sortedMember);
        }
        this.rebuildLevel(this.analysisTemplate.getRowDimList());
        this.rebuildLevel(this.analysisTemplate.getColDimList());
        TemplateDim metricTplDim = this.analysisTemplate.getMetricTplDim();
        metricTplDim.setMemberScope(this.header.getMetricIds());
    }

    private void rebuildLevel(List<TemplateDim> dimList) {
        Integer minLevel = dimList.stream().map(TemplateDim::getLevel).min(Comparator.comparing(i -> i)).orElse(0);
        List sortDimList = dimList.stream().sorted(Comparator.comparingInt(TemplateDim::getLevel)).collect(Collectors.toList());
        int level = Math.min(minLevel, 1);
        for (TemplateDim templateDim : sortDimList) {
            templateDim.setLevel(level);
            ++level;
        }
    }

    private void handleDimBySearchType(TemplateDim templateDim, Map<DimLocation, Integer> dimLocationMaxLevelMap) {
        boolean orgOrSubject;
        String searchDimType = this.header.getDimType();
        DimensionType dimType = templateDim.getDimType();
        DimLocation location = templateDim.getLocation();
        Dimension dimension = this.dimensionMap.get(templateDim.getDimensionId());
        if (!StringUtils.equals((CharSequence)dimension.getNumber(), (CharSequence)searchDimType)) {
            if (location.inRow()) {
                templateDim.setIncludeSum(false);
            }
            if (dimType.isOrgDim()) {
                if (location.inPage()) {
                    this.updateMemberScopeAllSubLevelMember(this.header.getOrg(), dimension, templateDim);
                }
                if (location.inRow() || location.inCol()) {
                    this.updateMemberScopeAllSubLevelMember(this.header.getOrg(), dimension, templateDim);
                    this.orgNeedCleanSubLevelData = true;
                }
            }
            return;
        }
        List<Long> searchIdList = null;
        if (dimType.isOrgDim()) {
            searchIdList = this.header.getOrg();
        } else if (dimType.isSubjectDim()) {
            searchIdList = this.header.getSubjects();
        }
        boolean bl = orgOrSubject = dimType.isOrgDim() || dimType.isSubjectDim();
        if (orgOrSubject) {
            Integer maxLevel;
            if (location.inRow()) {
                this.updateMemberScopeAllSubLevelMember(searchIdList, dimension, templateDim);
                return;
            }
            if (location.inPage()) {
                maxLevel = dimLocationMaxLevelMap.get((Object)DimLocation.ROW);
                templateDim.setLocation(DimLocation.ROW);
                templateDim.setLevel(maxLevel + 1);
                this.updateMemberScopeAllSubLevelMember(searchIdList, dimension, templateDim);
                this.analysisTemplate.getPageDimList().removeIf(i -> Objects.equals(i.getDimensionId(), templateDim.getDimensionId()));
                this.analysisTemplate.getRowDimList().add(templateDim);
            }
            if (location.inCol()) {
                maxLevel = dimLocationMaxLevelMap.get((Object)DimLocation.ROW);
                templateDim.setLocation(DimLocation.ROW);
                templateDim.setLevel(maxLevel + 1);
                this.updateMemberScopeAllSubLevelMember(searchIdList, dimension, templateDim);
                this.analysisTemplate.getColDimList().removeIf(i -> Objects.equals(i.getDimensionId(), templateDim.getDimensionId()));
                this.analysisTemplate.getRowDimList().add(templateDim);
            }
            return;
        }
        if (dimType.isCurrencyDim()) {
            templateDim.setIncludeSum(false);
        }
        if (location.inRow() || location.inCol()) {
            return;
        }
        if (location.inPage()) {
            Integer maxLevel = dimLocationMaxLevelMap.get((Object)DimLocation.ROW);
            templateDim.setLocation(DimLocation.ROW);
            templateDim.setLevel(maxLevel + 1);
            templateDim.setIncludeSum(true);
            if (dimType.isCurrencyDim()) {
                templateDim.setIncludeSum(false);
            }
            this.analysisTemplate.getPageDimList().removeIf(i -> Objects.equals(i.getDimensionId(), templateDim.getDimensionId()));
            this.analysisTemplate.getRowDimList().add(templateDim);
        }
    }

    public void updateMemberScopeAllSubLevelMember(List<Long> searchIdList, Dimension dimension, TemplateDim templateDim) {
        if (EmptyUtil.isEmpty(searchIdList)) {
            return;
        }
        HashSet<Long> searchSet = new HashSet<Long>(searchIdList);
        List<DimMember> orgMemberList = dimension.getAllDimMemberList();
        List orgMemList = orgMemberList.stream().filter(item -> searchSet.contains(item.getId())).collect(Collectors.toList());
        List allChildMemberList = orgMemList.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).collect(Collectors.toList());
        orgMemList.addAll(allChildMemberList);
        List<Long> memberScope = orgMemList.stream().map(DimMember::getId).distinct().collect(Collectors.toList());
        templateDim.setMemberScope(memberScope);
    }

    @Override
    public void buildAnalysisReport() {
        logger.info("\u521d\u59cb\u5316\u5206\u6790\u8868");
        this.analysisReport = this.getAnalysisReportInstance();
        this.queryReportDataList();
        if (EmptyUtil.isNoEmpty((String)this.header.getDimType())) {
            Optional<Dimension> first = this.system.getMainDimList().stream().filter(dimension -> Objects.equals(dimension.getNumber(), this.header.getDimType())).findFirst();
            first.ifPresent(dimension -> this.analysisReport.setStatisticsDim(dimension.getId()));
        }
        logger.info("\u521d\u59cb\u5316\u6c47\u7387");
        this.initExchangeRate();
    }

    private void queryReportDataList() {
        AbstractAnalysisReportDataService analysisReportDataService = this.isFromMultiDim() ? new ShrekAnalysisReportDataService(this.system, this.analysisReport, this.queryAllDimensionIds) : new ReportSearchRelationAnalysisReportDataService(this.system, this.analysisReport, this.queryAllDimensionIds);
        analysisReportDataService.dynamicCalculate().addDimensionMemberStrategy(new AnalysisPeriodMemberStrategy(this.analysisReport)).addDimensionMemberStrategy(new CommonDimMemberStrategy()).addVirtualDimMemberProcessService(new InnerCancelProcessServiceImpl(this.header, this.analysisReport, this.system)).addQueryConditionProcessor(this.getProcessor());
        if (this.isFromMultiDim()) {
            analysisReportDataService.addQueryConditionProcessor(new LinkSearchShrekQueryConditionProcessor(this.header));
        }
        analysisReportDataService.fillDimensionConditionInfo();
        this.queryAndSetReportData(analysisReportDataService);
    }

    private void queryAndSetReportData(AbstractAnalysisReportDataService analysisReportDataService) {
        ArrayList<ReportData> result = new ArrayList<ReportData>(512);
        List<ReportData> reportDataList = analysisReportDataService.queryReportDataList();
        this.analysisReport.setReportDataList(reportDataList);
        if (this.needRemoveNotMaxVersionData()) {
            this.retainMaxVersionData();
        }
        analysisReportDataService.afterQueryProcess(this.analysisReport.getReportDataList());
        this.analysisReport.rebuildTree(this.system);
        this.doRebuildData(true);
        result.addAll(this.analysisReport.getReportDataList());
        this.analysisReport.setReportDataList(result);
    }

    private QueryConditionProcessor<?> getProcessor() {
        return this.isFromMultiDim() ? new SynthesisShrekQueryConditionProcessor(this.header) : new SynthesisRelationQueryConditionProcessor(this.header, this.analysisTemplate);
    }

    @Override
    public void rebuildData() {
        if (this.needRemoveNotMaxVersionData()) {
            this.retainMaxVersionData();
        }
        this.rebuildFixData();
    }

    @Override
    public void afterReBuild() {
        if (this.orgNeedCleanSubLevelData.booleanValue()) {
            List<ReportData> reportDataList = this.analysisReport.getReportDataList();
            List<Long> searchIdList = this.header.getOrg();
            if (EmptyUtil.isEmpty(searchIdList)) {
                return;
            }
            HashSet<Long> searchSet = new HashSet<Long>(searchIdList);
            reportDataList = reportDataList.stream().filter(i -> searchSet.contains((Long)i.getDimValByDimType(DimensionType.ORG))).collect(Collectors.toList());
            this.analysisReport.setReportDataList(reportDataList);
            List<TemplateDim> allTemplateDim = this.analysisReport.getTemplate().getAllTemplateDim();
            allTemplateDim.stream().filter(i -> i.getDimType().isOrgDim()).forEach(i -> {
                List<Long> containOrgIds = i.getMemberScope().stream().filter(searchSet::contains).collect(Collectors.toList());
                i.setMemberScope(containOrgIds);
            });
        }
    }

    private void rebuildFixData() {
        this.analysisReport.rebuildTree(this.system);
        this.handleRollReportData();
        this.doRebuildData(false);
    }

    private void handleRollReportData() {
        DimensionIndexTree indexTree = this.analysisReport.getIndexTree(this.system);
        List<ReportData> reportDataList = this.analysisReport.getReportDataList();
        Set reportPeriodIds = reportDataList.stream().map(ReportData::getReportPeriodId).collect(Collectors.toSet());
        Dimension periodDimension = this.system.getMainDimensionByDimType(DimensionType.PERIOD);
        Map periodMemberMap = periodDimension.getAllDimMemberList().stream().filter(dimMember -> reportPeriodIds.contains(dimMember.getId())).map(PeriodMember.class::cast).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        List<TreeNode> leafList = indexTree.getLeafList();
        Map orgParentChildrenMap = this.orgDimension.getAllDimMemberList().stream().filter(dimMember -> EmptyUtil.isNoEmpty((Long)dimMember.getParentId())).collect(Collectors.groupingBy(DimMember::getParentId, Collectors.mapping(DimMember::getId, Collectors.toSet())));
        for (TreeNode treeNode : leafList) {
            List<Object> currentNodeDataList;
            Set childrenId;
            DimMember dimMember2;
            DimensionInfoBean dimInfoBean = treeNode.getDimInfoBean();
            Object memberId = dimInfoBean.getMemberByDimensionId(this.orgDimension.getId());
            if (EmptyUtil.isEmpty((Object)memberId) || Objects.isNull(dimMember2 = this.dimMemberMap.get(memberId)) || !orgParentChildrenMap.containsKey(memberId) || EmptyUtil.isEmpty(childrenId = orgParentChildrenMap.get(memberId)) || EmptyUtil.isEmpty(currentNodeDataList = treeNode.getDataList())) continue;
            ReportData sumOrgRd = (ReportData)currentNodeDataList.get(0);
            ReportData sumOrgRdFromChildren = null;
            DimensionInfoBean copy = dimInfoBean.copy();
            for (Long childId : childrenId) {
                List<Object> dataList;
                copy.replaceValueIfContains(this.orgDimension.getId(), (Object)childId);
                TreeNode orgLeafNode = indexTree.find(copy);
                if (Objects.isNull(orgLeafNode) || EmptyUtil.isEmpty(dataList = orgLeafNode.getDataList())) continue;
                for (Object data : dataList) {
                    ReportData rd;
                    if (!(data instanceof ReportData) || (sumOrgRdFromChildren = this.createIfNeed(sumOrgRdFromChildren, rd = (ReportData)data, childId, memberId)) == null) continue;
                    this.addAmount2ReportCurrency(sumOrgRdFromChildren, rd);
                }
            }
            if (null == sumOrgRdFromChildren) continue;
            Long reportPeriodIdParent = sumOrgRd.getReportPeriodId();
            Long reportPeriodIdChildren = sumOrgRdFromChildren.getReportPeriodId();
            PeriodMember periodMemberParent = (PeriodMember)periodMemberMap.get(reportPeriodIdParent);
            PeriodMember periodMemberChildren = (PeriodMember)periodMemberMap.get(reportPeriodIdChildren);
            if (periodMemberChildren.getStartDate().compareTo(periodMemberParent.getStartDate()) <= 0) continue;
            currentNodeDataList.clear();
            currentNodeDataList.add(sumOrgRdFromChildren);
        }
    }

    private ReportData createIfNeed(ReportData sumRd, ReportData rd, Long orgId, Object parentId) {
        if (sumRd != null) {
            return sumRd;
        }
        sumRd = new ReportData(rd);
        int index = rd.getDimValList().indexOf(orgId);
        if (index == -1) {
            return null;
        }
        sumRd.getDimValList().set(index, parentId);
        sumRd.clearAmt();
        return sumRd;
    }

    private void addAmount2ReportCurrency(ReportData sumRd, ReportData childRd) {
        sumRd.addPlanAmt(childRd.getPlanAmt());
        sumRd.addLockAmt(childRd.getLockAmt());
        sumRd.addActAmt(childRd.getActAmt());
        sumRd.addReportPlanAmt(childRd.getReportPlanAmt());
        sumRd.addOriginalPlanAmt(childRd.getOriginalPlanAmt());
        sumRd.addPlanReferenceAmt(childRd.getPlanReferenceAmt());
    }

    private void rebuildDetailData() {
        List<ReportData> reportDataList = this.analysisReport.getReportDataList();
        List pageDimensionIdList = this.analysisTemplate.getAllTemplateDim().stream().filter(templateDim -> templateDim.getLocation() == DimLocation.PAGE).map(TemplateDim::getDimensionId).collect(Collectors.toList());
        Map<EvalDimensionCombination, List<ReportData>> combinationListMap = reportDataList.stream().collect(Collectors.groupingBy(rd -> EvalDimensionCombination.getEvalDimensionCombinationWithDetailDim(rd, td -> !pageDimensionIdList.contains(td.getDimensionId()))));
        ArrayList<ReportData> mergeResult = new ArrayList<ReportData>(123);
        for (Map.Entry<EvalDimensionCombination, List<ReportData>> entry : combinationListMap.entrySet()) {
            List<ReportData> dataList = entry.getValue();
            if (dataList.size() <= 1) {
                mergeResult.add(dataList.get(0));
                continue;
            }
            ReportData mergeData = new ReportData(dataList.get(0));
            mergeData.clearAmt();
            for (ReportData reportData2 : dataList) {
                if (!Objects.equals(mergeData.getReportPeriodId(), reportData2.getReportPeriodId())) break;
                mergeData.addPlanAmt(reportData2.getPlanAmt());
                mergeData.addReportPlanAmt(reportData2.getReportPlanAmt());
                mergeData.addOriginalPlanAmt(reportData2.getOriginalPlanAmt());
                mergeData.addPlanReferenceAmt(reportData2.getPlanReferenceAmt());
                mergeData.addLockAmt(reportData2.getLockAmt());
                mergeData.addActAmt(reportData2.getActAmt());
            }
            mergeResult.add(mergeData);
        }
        HashSet needRemovePeriodMemberIds = new HashSet();
        List<ReportData> sortedList = mergeResult.stream().sorted(this.getReportDataComparator()).collect(Collectors.toList());
        sortedList.forEach(item -> this.collectNeedRemoveId((ReportData)item, needRemovePeriodMemberIds));
        AmountUnit templateAmountUnit = this.analysisTemplate.getAmountUnit();
        AmountUnitEnum templateAmountUnitEnum = AmountUnit.convert(templateAmountUnit);
        TemplateDim totalDim = null;
        TemplateDim expandDim = null;
        for (TemplateDim templateDim2 : this.analysisTemplate.getAllTemplateDim()) {
            if (templateDim2.isTotalRow()) {
                totalDim = templateDim2;
            }
            if (!templateDim2.isExpand()) continue;
            expandDim = templateDim2;
        }
        sortedList.removeIf(reportData -> needRemovePeriodMemberIds.contains(reportData.getDimValByDimType(DimensionType.PERIOD)));
        boolean isDetailPeriod = this.analysisReport.getReportPeriodType().getDetailPeriodType() != null;
        int rowOffset = this.analysisTemplate.getDataStartRow(isDetailPeriod);
        rowOffset = this.analysisTemplate.getTemplateUse() == TemplateUseType.STATISTIC && totalDim != null && expandDim != null ? rowOffset - 1 : rowOffset;
        for (int i = 0; i < sortedList.size(); ++i) {
            ReportData reportData3 = (ReportData)sortedList.get(i);
            reportData3.setRow(i + rowOffset);
            AmountUnitEnum reportDataAmountUnit = AmountUnit.convert(reportData3.getAmountUnit());
            reportData3.setPlanAmt(AmountCurrencyRateHelper.convertAmt((BigDecimal)reportData3.getPlanAmt(), (AmountUnitEnum)reportDataAmountUnit, (AmountUnitEnum)templateAmountUnitEnum));
            reportData3.setPlanReferenceAmt(AmountCurrencyRateHelper.convertAmt((BigDecimal)reportData3.getPlanReferenceAmt(), (AmountUnitEnum)reportDataAmountUnit, (AmountUnitEnum)templateAmountUnitEnum));
            reportData3.setActAmt(AmountCurrencyRateHelper.convertAmt((BigDecimal)reportData3.getActAmt(), (AmountUnitEnum)reportDataAmountUnit, (AmountUnitEnum)templateAmountUnitEnum));
            reportData3.setReportPlanAmt(AmountCurrencyRateHelper.convertAmt((BigDecimal)reportData3.getReportPlanAmt(), (AmountUnitEnum)reportDataAmountUnit, (AmountUnitEnum)templateAmountUnitEnum));
            reportData3.setLockAmt(AmountCurrencyRateHelper.convertAmt((BigDecimal)reportData3.getLockAmt(), (AmountUnitEnum)reportDataAmountUnit, (AmountUnitEnum)templateAmountUnitEnum));
            reportData3.setOriginalPlanAmt(AmountCurrencyRateHelper.convertAmt((BigDecimal)reportData3.getOriginalPlanAmt(), (AmountUnitEnum)reportDataAmountUnit, (AmountUnitEnum)templateAmountUnitEnum));
            for (int j = 0; j < reportData3.getDimList().size(); ++j) {
                String amountStr;
                TemplateDim templateDim3 = reportData3.getDimList().get(j);
                if (!templateDim3.isDetailDim() || templateDim3.getDetailDataType() != DetailDataType.AMOUNT) continue;
                Object val = reportData3.getDimValList().get(j);
                if (val instanceof BigDecimal) {
                    BigDecimal newAmount = AmountCurrencyRateHelper.convertAmt((BigDecimal)((BigDecimal)val), (AmountUnitEnum)reportDataAmountUnit, (AmountUnitEnum)templateAmountUnitEnum);
                    reportData3.getDimValList().set(j, newAmount.toString());
                    continue;
                }
                if (!(val instanceof String) || !StringUtils.isNotEmpty((CharSequence)(amountStr = (String)val))) continue;
                BigDecimal newAmount = AmountCurrencyRateHelper.convertAmt((BigDecimal)new BigDecimal(amountStr), (AmountUnitEnum)reportDataAmountUnit, (AmountUnitEnum)templateAmountUnitEnum);
                reportData3.getDimValList().set(j, newAmount.toString());
            }
        }
        this.analysisReport.setReportDataList(sortedList);
    }

    private Comparator<ReportData> getReportDataComparator() {
        TemplateDim sortDim = this.analysisTemplate.getAllTemplateDim().stream().filter(TemplateDim::isDefaultSortItem).findFirst().orElse(null);
        if (Objects.isNull(sortDim)) {
            logger.warn("\u9ed8\u8ba4\u6392\u5e8f\u88ab\u5173\u95ed");
            List orgDim = this.analysisTemplate.getAllTemplateDim().stream().filter(item -> item.getDimType().isOrgDim()).collect(Collectors.toList());
            sortDim = (TemplateDim)orgDim.get(0);
        }
        TemplateDim finalSortDim = sortDim;
        Map dimMemberMap = this.system.getDimList().stream().map(Dimension::getAllDimMemberList).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, Function.identity()));
        List sortMainDimList = this.analysisTemplate.getAllTemplateDim().stream().filter(item -> item.getDimType().isDefaultCompareMainDimension()).filter(item -> !item.getDimensionId().equals(finalSortDim.getDimensionId())).sorted(Comparator.comparingInt(i -> i.getDimType().getAnalyseDimOrder())).collect(Collectors.toList());
        return (o1, o2) -> {
            if (finalSortDim.isDetailDim()) {
                Object o1Value = o1.getDimValByDimType(finalSortDim.getDimType(), finalSortDim.getDetailDimType());
                Object o2Value = o2.getDimValByDimType(finalSortDim.getDimType(), finalSortDim.getDetailDimType());
                if (o1Value != null && o2Value != null) {
                    int stringResult = o1Value.toString().compareTo(o2Value.toString());
                    if (!NumberUtils.equalsZero((Integer)stringResult)) {
                        return stringResult;
                    }
                    return this.defaultSortResult(dimMemberMap, sortMainDimList, (ReportData)o1, (ReportData)o2);
                }
                return 1;
            }
            int firstCompare = this.sortByDimType(dimMemberMap, finalSortDim, (ReportData)o1, (ReportData)o2);
            if (!NumberUtils.equalsZero((Integer)firstCompare)) {
                return firstCompare;
            }
            return this.defaultSortResult(dimMemberMap, sortMainDimList, (ReportData)o1, (ReportData)o2);
        };
    }

    private int sortByDimType(Map<Long, DimMember> dimMemberMap, TemplateDim finalSortDim, ReportData o1, ReportData o2) {
        Object o1Value = o1.getDimValByDimensionId(finalSortDim.getDimensionId());
        Object o2Value = o2.getDimValByDimensionId(finalSortDim.getDimensionId());
        if (Objects.isNull(o1Value) && Objects.nonNull(o2Value)) {
            return -1;
        }
        if (Objects.nonNull(o1Value) && Objects.isNull(o2Value)) {
            return 1;
        }
        if (Objects.isNull(o1Value)) {
            return 0;
        }
        DimMember dimMember1 = dimMemberMap.get(o1Value);
        DimMember dimMember2 = dimMemberMap.get(o2Value);
        int result = dimMember1.getSortCode().compareTo(dimMember2.getSortCode());
        if (!NumberUtils.equalsZero((Integer)result)) {
            return result;
        }
        return 0;
    }

    private int defaultSortResult(Map<Long, DimMember> dimMemberMap, List<TemplateDim> sortMainDimList, ReportData o1, ReportData o2) {
        for (TemplateDim templateDim : sortMainDimList) {
            int result = this.sortByDimType(dimMemberMap, templateDim, o1, o2);
            if (NumberUtils.equalsZero((Integer)result)) continue;
            return result;
        }
        return 0;
    }

    private void collectNeedRemoveId(ReportData reportData, Set<Long> needRemovePeriodMemberIds) {
        DimMember periodMember = this.dimMemberMap.get(reportData.getDimValByDimType(DimensionType.PERIOD));
        if (periodMember.getParent() != null) {
            needRemovePeriodMemberIds.add(periodMember.getParent().getId());
        }
    }

    @Override
    protected AnalysisReport getAnalysisReportInstance() {
        AnalysisReport analysisReport = new AnalysisReport();
        Long reportPeriodId = this.header.getReportTypeId();
        ReportPeriodType reportPeriodType = this.system.getPeriodTypeByPeriodTypeId(reportPeriodId);
        analysisReport.setAnalysisReportType(this.header.getAnalysisReportType());
        analysisReport.setSystemId(this.system.getId());
        analysisReport.setTemplate(this.analysisTemplate);
        if (!this.header.isContainDetailReportType()) {
            reportPeriodType.setDetailPeriodType(null);
        }
        analysisReport.setReportPeriodType(reportPeriodType);
        analysisReport.setPeriodMemberList(this.getPeriodMemberList());
        analysisReport.setCompanyMemberList(this.getOrgMemberList());
        analysisReport.setName(this.analysisTemplate.getName());
        analysisReport.setInitFlag(false);
        analysisReport.setReportDataList(new ArrayList<ReportData>(128));
        Optional<TemplateDim> pageCurrencyExist = this.analysisTemplate.getAllTemplateDim().stream().filter(td -> td.getDimType().isCurrencyDim() && td.getLocation() == DimLocation.PAGE).findFirst();
        Optional<TemplateDim> pageOrgExist = this.analysisTemplate.getAllTemplateDim().stream().filter(td -> td.getDimType().isOrgDim() && td.getLocation() == DimLocation.PAGE).findFirst();
        Optional<TemplateDim> pagePeriodExist = this.analysisTemplate.getAllTemplateDim().stream().filter(td -> td.getDimType().isPeriodDim() && td.getLocation() == DimLocation.PAGE).findFirst();
        if (pageCurrencyExist.isPresent()) {
            analysisReport.addSumDimensionId(this.system.getMainDimensionByDimType(DimensionType.CURRENCY).getId());
        }
        if (pageOrgExist.isPresent()) {
            analysisReport.addSumDimensionId(this.system.getMainDimensionByDimType(DimensionType.ORG).getId());
        }
        if (pagePeriodExist.isPresent()) {
            analysisReport.addSumDimensionId(this.system.getMainDimensionByDimType(DimensionType.PERIOD).getId());
        }
        return analysisReport;
    }

    @Override
    public void initExchangeTableInfo() {
        QFilter exQFilter = new QFilter("id", "=", (Object)this.system.getId());
        DynamicObject exchangeRate = QueryServiceHelper.queryOne((String)"fpm_bodysysmanage", (String)"ratetype", (QFilter[])new QFilter[]{exQFilter});
        this.analysisReport.setExchangeRateTableId(exchangeRate.getLong("ratetype"));
        this.analysisReport.setExchangeRateDate(new Date());
    }

    private void createVirtualPeriod() {
        List periodMembers = this.header.getPeriodId().stream().map(this.dimMemberMap::get).collect(Collectors.toList());
        Map<PeriodType, List<PeriodMember>> periodTypeListMap = periodMembers.stream().filter(Objects::nonNull).map(PeriodMember.class::cast).collect(Collectors.groupingBy(PeriodMember::getPeriodType));
        if (periodTypeListMap.size() > 1) {
            this.isForceRemoveSummaryOfPeriod = true;
        }
        List reportPeriodTypeList = this.system.getReportTypeList().stream().filter(reportPeriodType -> this.header.getReportTypeIdList().contains(reportPeriodType.getReportPeriodId())).collect(Collectors.toList());
        ReportPeriodType mixPeriodType = new ReportPeriodType();
        mixPeriodType.setName(reportPeriodTypeList.stream().map(ReportPeriodType::getName).collect(Collectors.joining("_")));
        mixPeriodType.setNumber(reportPeriodTypeList.stream().map(ReportPeriodType::getNumber).collect(Collectors.joining("_")));
        Optional<ReportPeriodType> findDetailPeriodType = reportPeriodTypeList.stream().filter(reportPeriodType -> reportPeriodType.getDetailPeriodType() != null).findFirst();
        findDetailPeriodType.ifPresent(reportPeriodType -> mixPeriodType.setDetailPeriodType(reportPeriodType.getDetailPeriodType()));
        this.virtualPeriodTypeId = DB.genGlobalLongId();
        mixPeriodType.setReportPeriodId(this.virtualPeriodTypeId);
        mixPeriodType.setDetailPeriodType(PeriodType.MIX_DETAIL);
        mixPeriodType.setPeriodType(PeriodType.MIX);
        this.system.getReportTypeList().clear();
        this.system.getReportTypeList().add(mixPeriodType);
        this.header.setReportTypeId(this.virtualPeriodTypeId);
        Dimension periodDimension = this.system.getMainDimensionByDimType(DimensionType.PERIOD);
        Map<Long, ReportPeriodType> reportPeriodTypeMap = reportPeriodTypeList.stream().collect(Collectors.toMap(ReportPeriodType::getReportPeriodId, v -> v));
        List<DimMember> allDimMemberList = periodDimension.getAllDimMemberList();
        ArrayList<PeriodMember> filterMembers = new ArrayList<PeriodMember>(allDimMemberList.size());
        for (DimMember dimMember : allDimMemberList) {
            PeriodMember periodMember = (PeriodMember)dimMember;
            if (!reportPeriodTypeMap.containsKey(periodMember.getPeriodTypeId())) continue;
            PeriodType periodType = periodMember.getPeriodType();
            if (periodType == reportPeriodTypeMap.get(periodMember.getPeriodTypeId()).getPeriodType()) {
                filterMembers.add(periodMember);
                continue;
            }
            if (!Arrays.asList(PeriodType.MONTH_WEEK, PeriodType.YEAR_WEEK).contains((Object)periodType) || reportPeriodTypeMap.get(periodMember.getPeriodTypeId()).getPeriodType() != PeriodType.MONTH_WEEK) continue;
            filterMembers.add(periodMember);
        }
        for (PeriodMember periodMember : filterMembers) {
            periodMember.setPeriodTypeId(this.virtualPeriodTypeId);
            periodMember.setParent(null);
            periodMember.setParentId(null);
            periodMember.setPeriodType(PeriodType.MIX);
            if (!this.header.isContainDetailReportType()) continue;
            if (periodMember.getChildren().size() == 0) {
                PeriodMember copy = periodMember.copy();
                copy.setParent(periodMember);
                copy.setId(DB.genGlobalLongId());
                copy.setParentId(periodMember.getId());
                copy.setPeriodType(PeriodType.MIX_DETAIL);
                periodMember.getChildren().add(copy);
                periodMember.setLeaf(false);
                continue;
            }
            for (DimMember child : periodMember.getChildren()) {
                PeriodMember periodChild = (PeriodMember)child;
                periodChild.setPeriodType(PeriodType.MIX_DETAIL);
                periodChild.setPeriodTypeId(this.virtualPeriodTypeId);
            }
        }
    }
}

