/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateMetric;
import kd.tmc.fpm.business.domain.model.template.TemplateShowConfig;
import kd.tmc.fpm.business.domain.service.AnalysisReportDataService;
import kd.tmc.fpm.business.domain.service.InnerCancelProcessServiceImpl;
import kd.tmc.fpm.business.domain.service.impl.AbstractVirtualTemplateAnalysisReportDataBuildService;
import kd.tmc.fpm.business.domain.service.impl.AnalysisOrgMemberStrategy;
import kd.tmc.fpm.business.domain.service.impl.AnalysisPeriodMemberStrategy;
import kd.tmc.fpm.business.domain.service.impl.CommonDimMemberStrategy;
import kd.tmc.fpm.business.domain.service.impl.RelationShrekAnalysisReportDataServiceAdapter;
import kd.tmc.fpm.common.enums.FlowEnum;

public class PlanExecAnalysisReportDataBuildServiceImpl
extends AbstractVirtualTemplateAnalysisReportDataBuildService {
    public PlanExecAnalysisReportDataBuildServiceImpl(AnalysisHeader header, FundPlanSystem system) {
        super(header, system);
    }

    @Override
    public void buildTemplate() {
        super.buildTemplate();
        this.createReportCurrency();
        this.createViAccountDim();
        this.fillTemplateInfo();
    }

    @Override
    AnalysisReportDataService getAnalysisReportDataService() {
        return new RelationShrekAnalysisReportDataServiceAdapter(this.system, this.analysisReport, this.queryAllDimensionIds).dynamicCalculate().addDimensionMemberStrategy(new AnalysisPeriodMemberStrategy(this.analysisReport)).addDimensionMemberStrategy(new AnalysisOrgMemberStrategy(this.header.getOrg(), true)).addDimensionMemberStrategy(new CommonDimMemberStrategy()).addVirtualDimMemberProcessService(new InnerCancelProcessServiceImpl(this.header, this.analysisReport, this.system));
    }

    private void fillTemplateInfo() {
        this.analysisTemplate.setSubSumVisible(true);
        if (!this.header.isContainDetailReportType()) {
            TemplateShowConfig templateShowConfig = new TemplateShowConfig();
            templateShowConfig.setSummaryShow(true);
            this.analysisTemplate.setConfig(templateShowConfig);
        }
        List<Dimension> mainDimList = this.system.getMainDimList();
        for (int i = 0; i < mainDimList.size(); ++i) {
            Dimension dimension = mainDimList.get(i);
            if (EmptyUtil.isEmpty(dimension.getAllDimMemberList())) continue;
            this.doFillTemplateInfo(dimension, i);
        }
    }

    private void doFillTemplateInfo(Dimension dimension, int index) {
        TemplateDim templateDim = new TemplateDim();
        templateDim.setDimensionId(dimension.getId());
        templateDim.setSequence(index + 1);
        templateDim.setDimensionName(dimension.getName());
        DimensionType dimType = dimension.getDimType();
        templateDim.setDimType(dimType);
        templateDim.setVisible(dimType.isSystemDim());
        switch (dimType) {
            case CURRENCY: {
                templateDim.setLocation(DimLocation.COL);
                templateDim.setLevel(1);
                templateDim.setMemberScope(this.header.getCurrency());
                break;
            }
            case PERIOD: {
                templateDim.setLocation(DimLocation.COL);
                templateDim.setLevel(2);
                templateDim.setMemberScope(this.header.getPeriodId());
                templateDim.setIncludeSum(true);
                templateDim.setIncludeSubSum(true);
                break;
            }
            case METRIC: {
                List<Long> metricIds = this.header.getMetricIds();
                templateDim.setMemberScope(metricIds);
                this.analysisTemplate.setMetricTplDim(templateDim);
                List<MetricMember> metricMemberList = this.header.getMetricMember();
                if (EmptyUtil.isEmpty(metricMemberList)) {
                    metricMemberList = this.system.getMainDimensionByDimType(DimensionType.METRIC).getMemberList(MetricMember.class);
                }
                if (EmptyUtil.isEmpty(metricMemberList)) break;
                this.analysisTemplate.setMetrics(metricMemberList.stream().map(TemplateMetric::getByMetricMember).collect(Collectors.toList()));
                break;
            }
            case ORG: {
                templateDim.setLocation(DimLocation.ROW);
                templateDim.setLevel(1);
                templateDim.setMemberScope(this.header.getOrg());
                break;
            }
            case SUBJECTS: {
                templateDim.setLocation(DimLocation.ROW);
                templateDim.setLevel(2);
                if (EmptyUtil.isEmpty((String)this.header.getFlow())) {
                    this.header.setFlow(FlowEnum.NONLIMIT.getValue());
                }
                templateDim.setMemberScope(EmptyUtil.isNoEmpty(this.header.getSubjects()) ? this.header.getSubjects() : dimension.getAllDimMemberList().stream().map(AccountMember.class::cast).filter(accountMember -> FlowType.isNonLimit(this.header.getFlow()) ? accountMember.getFlowType().isNonLimitLevel() : Objects.equals(accountMember.getFlowType().getNumber(), this.header.getFlow())).filter(DimMember::isEnable).map(DimMember::getId).collect(Collectors.toList()));
                break;
            }
            case ACCOUNTTYPE: {
                templateDim.setLocation(DimLocation.PAGE);
                templateDim.setLevel(1);
                HashSet<String> set = new HashSet<String>(8);
                set.add(FlowEnum.OUTFLOW.getValue());
                set.add(FlowEnum.INFLOW.getValue());
                set.add(FlowEnum.BALANCE.getValue());
                this.fillVirtualSubjectFlowMemberScope(dimension, templateDim, dm -> set.contains(dm.getNumber()));
                break;
            }
            default: {
                this.setStatisticsDimOrPage(dimension, templateDim);
            }
        }
        this.addAllMemberIfNeed(templateDim);
        this.addTemplateDim2TemplateInfo(dimension, templateDim);
    }

    @Override
    protected void afterReBuild() {
        super.afterReBuild();
        Optional<TemplateDim> first = this.analysisTemplate.getAllTemplateDim().stream().filter(td -> td.getDimType().isOrgDim()).findFirst();
        if (!first.isPresent()) {
            return;
        }
        first.get().setMemberScope(this.header.getOrg());
    }
}

