/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryObject;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.AnalysisReport;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.service.impl.AbstractAnalysisReportDataService;
import kd.tmc.fpm.business.domain.service.impl.RelationQueryConditionLogProcessorImpl;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class ReportSearchRelationAnalysisReportDataService
extends AbstractAnalysisReportDataService {
    private IReportDataQueryService reportDataQueryService = FpmServiceFactory.getBizService(IReportDataQueryService.class);

    public ReportSearchRelationAnalysisReportDataService(FundPlanSystem fundPlanSystem, AnalysisReport analysisReport, Set<Long> queryAllDimensionIds) {
        super(fundPlanSystem, analysisReport, queryAllDimensionIds);
        this.addQueryConditionProcessor(new RelationQueryConditionLogProcessorImpl());
    }

    @Override
    protected List<ReportData> queryReportDataList() {
        ReportDataQueryObject queryDTO = new ReportDataQueryObject();
        queryDTO.setDimIdList(this.dimensionList);
        queryDTO.setDimValList(this.dimValList);
        queryDTO.setMainTable(true);
        queryDTO.setNeedDimIfValueIsNotEmpty(true);
        this.addEmptyMemberIfNeed();
        this.addCustomMemberIfNeed();
        this.beforeSearch(queryDTO);
        logger.info("\u67e5\u8be2\u7ef4\u5ea6:{}\uff0c\u67e5\u8be2\u7ef4\u5ea6\u7684\u6210\u5458\uff1a{}", this.dimensionList.stream().map(Dimension::getName).collect(Collectors.toList()), (Object)this.dimValList);
        List<ReportDataQueryResult> reportDataQueryResults = this.reportDataQueryService.queryReportData(queryDTO);
        return ReportHelper.convert(reportDataQueryResults);
    }
}

