/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryObject;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryService;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteStatus;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.TemplateDimMemScopeType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.formula.ReportFormulaManager;
import kd.tmc.fpm.business.domain.formula.ReportTreeNodeFormulaManager;
import kd.tmc.fpm.business.domain.formula.SubjectFindReportTreeNodeFormulaManager;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.index.generate.bean.WarpBean;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.PlanChangeReport;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportChangeData;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.ReportGenerateInfo;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateLayout;
import kd.tmc.fpm.business.domain.model.template.TemplateReportType;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.IDimensionMemberStrategy;
import kd.tmc.fpm.business.domain.service.IReportService;
import kd.tmc.fpm.business.domain.service.provider.ReportDataVersionParam;
import kd.tmc.fpm.business.domain.service.provider.ReportDataVersionProvider;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.helper.TemplateInfoHelper;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.dto.ReportNeedPropDTO;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.service.calculate.ReportCalculateService;
import kd.tmc.fpm.business.mvc.service.calculate.ReportCalculateServiceFactory;
import kd.tmc.fpm.business.mvc.service.dto.ReportCalculateDTO;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaOperationVal;
import kd.tmc.fpm.business.spread.formula.FormulaOperatorSymbol;
import kd.tmc.fpm.business.spread.formula.IFormulaOperator;
import kd.tmc.fpm.business.spread.formula.enums.FormulaSymbolEnum;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.business.utils.MetricValueUtils;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import kd.tmc.fpm.common.utils.CollectionBuildUtil;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ReportService
implements IReportService {
    private static final Log LOGGER = LogFactory.getLog(ReportService.class);
    private IReportRepository iReportRepository = new ReportRepository();

    @Override
    public FpmOperateResult<List<Report>> generateReport(FundPlanSystem system, List<ReportGenerateInfo> genInfoList) {
        FpmOperateResult<List<Report>> result = new FpmOperateResult<List<Report>>();
        system = system.clone();
        ArrayList<Report> reportList = new ArrayList<Report>(genInfoList.size());
        HashMap<String, List<PeriodMember>> periodListMap = new HashMap<String, List<PeriodMember>>(16);
        HashMap<String, List<OrgMember>> orgListMap = new HashMap<String, List<OrgMember>>(16);
        Map templateMap = genInfoList.stream().map(ReportGenerateInfo::getTemplateList).flatMap(Collection::stream).filter(ReportTemplate::isMainTable).collect(Collectors.toMap(ReportTemplate::getCopyId, Function.identity(), (o1, o2) -> o1));
        for (ReportGenerateInfo genInfo : genInfoList) {
            List<ReportTemplate> templateList = genInfo.getTemplateList();
            for (ReportTemplate reportTemplate : templateList) {
                List<TemplateReportType> reportTypeList;
                Optional<TemplateReportType> first;
                reportTemplate = reportTemplate.serializeClone();
                Long reportPeriodId = genInfo.getReportPeriodId();
                ReportPeriodType reportPeriodType = system.getPeriodTypeByPeriodTypeId(reportPeriodId);
                String periodKey = String.join((CharSequence)"#", genInfo.getPeriodMemberId() + "", reportTemplate.getId() + "");
                List<PeriodMember> reportPeriodMemList = (List<PeriodMember>)periodListMap.get(periodKey);
                if (reportPeriodMemList == null) {
                    reportPeriodMemList = this.buildPeriodMemberInfo(system, reportTemplate, reportPeriodType, genInfo.getPeriodMemberId());
                    periodListMap.put(periodKey, reportPeriodMemList);
                } else {
                    TemplateDim templateDim = reportTemplate.getAllTemplateDim().stream().filter(item -> item.getDimType() == DimensionType.PERIOD).findFirst().get();
                    templateDim.setMemberScope(reportPeriodMemList.stream().map(DimMember::getId).collect(Collectors.toList()));
                }
                List<OrgMember> orgMembers = (List<OrgMember>)orgListMap.get(reportTemplate.getId() + "");
                if (orgMembers == null) {
                    orgMembers = this.buildOrgMemberInfo(system, reportTemplate);
                    orgListMap.put(periodKey, orgMembers);
                }
                Long reportOrgId = genInfo.getReportOrgId();
                orgMembers = orgMembers.stream().filter(item -> reportOrgId.equals(item.getId())).collect(Collectors.toList());
                Long parentTemplateId = genInfo.getParentTemplateId();
                Report report = new Report();
                report.setSystemId(system.getId());
                report.setTemplate(reportTemplate);
                report.setReportPeriodType(reportPeriodType);
                report.setPeriodMemberList(reportPeriodMemList);
                report.setCompanyMemberList(orgMembers);
                report.setCloseDate(genInfo.getCloseDate());
                report.setExchangeRateDate(genInfo.getExchangeRateDate());
                report.setExchangeRateTableId(genInfo.getExchangeRateTableId());
                report.setName(reportTemplate.getName());
                report.setStartDate(genInfo.getStartDate());
                TemplateUseType templateUse = reportTemplate.getTemplateUse();
                if (templateUse == TemplateUseType.SUMMARY) {
                    report.setReportPlanType(ReportPlanType.SUMPLAN);
                } else if (templateUse == TemplateUseType.PLANING) {
                    report.setReportPlanType(ReportPlanType.REPORTPLAN);
                }
                if (!reportTemplate.isMainTable()) {
                    report.setParentTemplateId(parentTemplateId);
                }
                if ((first = (reportTypeList = reportTemplate.getReportTypeList()).stream().filter(item -> item.getReportTypeId().equals(reportPeriodId)).findFirst()).isPresent()) {
                    TemplateReportType templateReportType = first.get();
                    Long referenceReportTypeId = templateReportType.getReferenceReportTypeId();
                    ReportPeriodType referencePeriodType = system.getPeriodTypeByPeriodTypeId(referenceReportTypeId);
                    report.setReferencePeriodType(referencePeriodType);
                    if (referencePeriodType != null && reportPeriodMemList != null) {
                        PeriodMember periodMember = this.buildReferencePeriodMemberInfo(system, referencePeriodType, reportPeriodMemList.get(0));
                        report.setReferencePeriodMember(periodMember);
                    }
                }
                if (templateUse == TemplateUseType.SUMMARY) {
                    if (!reportTemplate.isMainTable()) {
                        this.buildSumOrgMemberInfo(system, reportTemplate, (ReportTemplate)templateMap.get(parentTemplateId), reportOrgId);
                    } else {
                        this.buildSumOrgMemberInfo(system, reportTemplate, reportTemplate, reportOrgId);
                    }
                }
                reportList.add(report);
            }
        }
        result.setData(reportList);
        return result;
    }

    @Override
    public FpmOperateResult<Report> generateTemplatePreviewReport(FundPlanSystem system, ReportTemplate reportTemplate, Long periodTypeId) {
        return this.generateTemplatePreviewReport(system, reportTemplate, periodTypeId, null);
    }

    @Override
    public FpmOperateResult<Report> generateTemplatePreviewReport(FundPlanSystem system, ReportTemplate reportTemplate, Long periodTypeId, Long sumOrgMemberId) {
        ReportPeriodType reportPeriodType;
        FundPlanSystem realSystem = system;
        List<PeriodMember> reportPeriodMemList = this.buildPeriodMemberInfo(system = system.clone(), reportTemplate = reportTemplate.serializeClone(), reportPeriodType = system.getPeriodTypeByPeriodTypeId(periodTypeId), null);
        if (reportPeriodMemList == null || reportPeriodMemList.size() == 0) {
            return FpmOperateResult.error(ResManager.loadKDString((String)"\u6a21\u677f\u9884\u89c8\u5931\u8d25\uff0c\u8bf7\u5148\u7ef4\u62a4\u671f\u95f4\u7ef4\u5ea6\u6210\u5458\u3002", (String)"ReportService_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        Report report = new Report();
        report.setSystemId(system.getId());
        report.setTemplate(reportTemplate);
        report.setReportPeriodType(reportPeriodType);
        report.setPeriodMemberList(reportPeriodMemList);
        List<TemplateReportType> reportTypeList = reportTemplate.getReportTypeList();
        Optional<TemplateReportType> first = reportTypeList.stream().filter(item -> item.getReportTypeId().equals(periodTypeId)).findFirst();
        if (first.isPresent()) {
            TemplateReportType templateReportType = first.get();
            Long referenceReportTypeId = templateReportType.getReferenceReportTypeId();
            ReportPeriodType referencePeriodType = system.getPeriodTypeByPeriodTypeId(referenceReportTypeId);
            report.setReferencePeriodType(referencePeriodType);
            if (referencePeriodType != null) {
                PeriodMember periodMember = this.buildReferencePeriodMemberInfo(system, referencePeriodType, reportPeriodMemList.get(0));
                report.setReferencePeriodMember(periodMember);
            }
        }
        if (EmptyUtil.isNoEmpty((Long)sumOrgMemberId)) {
            this.buildSumOrgMemberInfo(system, reportTemplate, reportTemplate, sumOrgMemberId);
        }
        TemplateInfoHelper.addSubjectFlowColIfDetailTemplateNeed(reportTemplate, realSystem);
        return FpmOperateResult.success(report);
    }

    @Override
    public FpmOperateResult checkReport(Report report, FundPlanSystem system, String opKey) {
        ReportTemplate template = report.getTemplate();
        if ((TemplateType.DETAIL != template.getTemplateType() || !"submit".equals(opKey)) && "unaudit".equals(opKey)) {
            List reportDataIds = Optional.ofNullable(report.getReportDataList()).orElseGet(Collections::emptyList).stream().map(ReportData::getId).collect(Collectors.toList());
            boolean exists = TmcDataServiceHelper.exists((String)"fpm_executeplan", (QFilter[])new QFilter[]{new QFilter("bodysys", "=", (Object)report.getSystemId()).and("reportdataid", "in", reportDataIds), new QFilter("executeoperatorstatus", "!=", (Object)PlanExecuteStatus.FAILURE.getValue()), new QFilter("deleteflag", "=", (Object)"0")});
            if (exists) {
                return FpmOperateResult.error(ResManager.loadKDString((String)"\u62a5\u8868\u5df2\u5b58\u5728\u9884\u5360\u6216\u5b9e\u5360\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ReportService_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
        }
        return FpmOperateResult.success();
    }

    @Override
    public FpmOperateResult sumSubData(ReportDataSource parentReport, ReportDataSource subReport, FundPlanSystem system) {
        return this.addOrSubSubData(parentReport, subReport, system, true);
    }

    @Override
    public FpmOperateResult subSubData(ReportDataSource parentReport, ReportDataSource subReport, FundPlanSystem system) {
        return this.addOrSubSubData(parentReport, subReport, system, false);
    }

    @Override
    public void calculateReport(Report report, FundPlanSystem system) {
        ReportCalculateDTO calculateDTO = new ReportCalculateDTO();
        calculateDTO.setReport(report);
        calculateDTO.setSystem(system);
        ReportCalculateService calculateService = ReportCalculateServiceFactory.getService();
        calculateService.calculateReport(calculateDTO);
    }

    @Override
    public List<ReportData> calculateReportScope(Report report, FundPlanSystem system, List<ReportData> scopeData) {
        ReportCalculateDTO calculateDTO = new ReportCalculateDTO();
        calculateDTO.setReport(report);
        calculateDTO.setSystem(system);
        calculateDTO.setScopeData(scopeData);
        ReportCalculateService calculateService = ReportCalculateServiceFactory.getScopeService();
        return calculateService.calculateReport(calculateDTO);
    }

    @Override
    public FpmOperateResult<List<ReportData>> calcFormulaData(ReportDataSource report, FundPlanSystem system, List<ReportData> reportDataList) {
        return this.calcFormulaData(report, system, reportDataList, false);
    }

    @Override
    public FpmOperateResult<List<ReportData>> calcFormulaData(ReportDataSource report, FundPlanSystem system) {
        return this.calcFormulaData(report, system, null, true);
    }

    private FpmOperateResult<List<ReportData>> calcFormulaData(ReportDataSource report, FundPlanSystem system, List<ReportData> reportDataList, boolean isVisitAll) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan("reportservice_calcFormulaData_method");){
            span.addTag("reportservice_calcFormulaData_method_step1");
            ReportTemplate template = report.getTemplate();
            if (template.getTemplateType() == TemplateType.DETAIL) {
                FpmOperateResult<List<ReportData>> fpmOperateResult = FpmOperateResult.success(Collections.emptyList());
                return fpmOperateResult;
            }
            Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
            List<DimMember> memberList = subjectDim.getAllDimMemberList();
            Map<Long, Long> beginEndPeriodMap = memberList.stream().map(AccountMember.class::cast).filter(accountMember -> Objects.nonNull(accountMember.getPeriodDirection()) && Objects.nonNull(accountMember.getAssociateAccount())).collect(Collectors.toMap(accountMember -> accountMember.getAssociateAccount().getId(), DimMember::getId, (k1, k2) -> k1));
            List sortedPeriodList = report.getCurrentAllPeriodMembers().stream().sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList());
            Map<Long, Long> previousPeriodMap = IntStream.range(0, sortedPeriodList.size()).boxed().collect(Collectors.toMap(i -> ((PeriodMember)sortedPeriodList.get((int)i)).getId(), i -> i > 0 ? ((PeriodMember)sortedPeriodList.get(i - 1)).getId() : 0L));
            Set<Object> reportIdSet = new HashSet();
            if (reportDataList != null) {
                reportIdSet = reportDataList.stream().map(ReportData::getId).collect(Collectors.toSet());
            }
            HashMap<Long, Formula> formulaMap = new HashMap<Long, Formula>(16);
            List<ReportData> allReportDataList = report.getReportDataList();
            DimensionIndexTree indexTree = report.getIndexTree(system);
            span.addTag("reportservice_calcFormulaData_method_step2");
            for (ReportData reportData : allReportDataList) {
                ReportData lastPeriodReportData;
                String excelFunc;
                String formulaStr;
                span.addTag("reportservice_calcFormulaData_method_for_step1");
                if (reportIdSet.contains(reportData.getId()) || reportData.isAuxiliaryInfo()) continue;
                Object accountId = reportData.getDimValByDimType(DimensionType.SUBJECTS, null);
                List summaryAcctSettings = template.getAccountSettings().stream().filter(Objects::nonNull).filter(item -> ReportInputType.SUMMARY == item.getInputType()).collect(Collectors.toList());
                Map accountSettingMap = summaryAcctSettings.stream().collect(Collectors.toMap(TemplateAccountSetting::getAccountMemId, Function.identity()));
                TemplateAccountSetting templateAccountSetting = (TemplateAccountSetting)accountSettingMap.get(accountId);
                if (Objects.nonNull(templateAccountSetting)) {
                    span.addTag("reportservice_calcFormulaData_method_for_step2");
                    List<ReportData> coords = this.seekCoordOfAcctChild(indexTree, reportData, templateAccountSetting, allReportDataList);
                    if (!EmptyUtil.isEmpty(coords)) {
                        Formula formula = this.getFormula(reportData, coords);
                        formulaMap.put(reportData.getId(), formula);
                    }
                }
                span.addTag("reportservice_calcFormulaData_method_for_step3");
                Map<Long, TemplateAccountSetting> acctFormulaItemSettingMaps = template.getAccountSettings().stream().filter(Objects::nonNull).filter(item -> ReportInputType.FORMULA == item.getInputType()).collect(Collectors.toMap(TemplateAccountSetting::getAccountMemId, o -> o));
                Set<Long> acctIdOfFormulaItems = acctFormulaItemSettingMaps.keySet();
                if (acctIdOfFormulaItems.contains(accountId) && StringUtils.isNotEmpty((CharSequence)(formulaStr = this.generateAcctFormula((Long)accountId, acctFormulaItemSettingMaps))) && StringUtils.isNotEmpty((CharSequence)(excelFunc = this.convertToExcelFunc(indexTree, formulaStr, reportData, allReportDataList)))) {
                    Formula formula = this.getFormula(excelFunc, reportData);
                    formulaMap.put(reportData.getId(), formula);
                }
                if (accountSettingMap.containsKey(accountId) || acctIdOfFormulaItems.contains(accountId) || !beginEndPeriodMap.containsKey(accountId) || (lastPeriodReportData = this.findLastPeriodReportData(indexTree, reportData, allReportDataList, beginEndPeriodMap, previousPeriodMap)) == null) continue;
                Formula formula = this.getFormula(lastPeriodReportData.getId().toString(), reportData);
                formulaMap.put(reportData.getId(), formula);
            }
            span.addTag("reportservice_calcFormulaData_method_for_step4");
            ReportFormulaManager reportFormulaManager = new ReportFormulaManager(report, formulaMap, isVisitAll);
            if (!CollectionUtils.isEmpty(reportDataList)) {
                span.addTag("reportservice_calcFormulaData_method_for_step5");
                List<ReportData> updatedReportDataS = reportFormulaManager.updateData(reportDataList);
                FpmOperateResult<List<ReportData>> fpmOperateResult = FpmOperateResult.success(updatedReportDataS);
                return fpmOperateResult;
            }
            FpmOperateResult<List<ReportData>> fpmOperateResult = FpmOperateResult.success(Collections.emptyList());
            return fpmOperateResult;
        }
    }

    private FpmOperateResult addOrSubSubData(ReportDataSource parentReport, ReportDataSource subReport, FundPlanSystem system, boolean isAdd) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(String.format("%s-%s", ReportService.class.getSimpleName(), "addOrSubSubData"));){
            ReportTemplate subTemplate = subReport.getTemplate();
            span.addTag("Related operations of approval report - preparation of sub-table data collection data takes time");
            DimensionIndexTree parentTree = parentReport.getIndexTree(system);
            DimensionIndexTree subTree = subReport.getIndexTree(system);
            ReportTemplate parentTemplate = parentReport.getTemplate();
            List<TemplateAccountSetting> accountSettings = parentTemplate.getAccountSettings();
            List parentAccList = accountSettings.stream().filter(item -> ReportInputType.DETAIL_INPUT == item.getInputType() && Objects.equals(item.getChildTemplateId(), subTemplate.getId())).collect(Collectors.toList());
            LOGGER.info(String.format("\u5b50\u8868\u6a21\u677fid\uff1a\u3010%s\u3011", subTemplate.getId()));
            PeriodType detailPeriodType = subReport.getReportPeriodType().getDetailPeriodType();
            boolean subHasDetailPeriod = detailPeriodType != null;
            PeriodType parentDetailPeriodType = parentReport.getReportPeriodType().getDetailPeriodType();
            boolean parentHasDetailPeriod = parentDetailPeriodType != null;
            List<PeriodMember> subPeriodMemberList = subReport.getPeriodMemberList();
            Set<Long> subPeriodMemberScope = new HashSet<Long>(4);
            PeriodMember subPeriodMember = subPeriodMemberList.get(0);
            for (final TemplateAccountSetting templateAccountSetting : parentAccList) {
                span.addTag(String.format("Operation related to approval report - obtaining Cartesian product of dimension combination (account setting: %s) takes time", templateAccountSetting.getId()));
                ArrayList<Long> sonDimessionIds = new ArrayList<Long>(5);
                ArrayList<List<Object>> sonDimessionMemberIds = new ArrayList<List<Object>>(5);
                List<DimMember> allDimMemberList = system.getMainDimensionByDimType(DimensionType.PERIOD).getAllDimMemberList();
                List templateDimList = subReport.getTemplate().getAllTemplateDim().stream().filter(Objects::nonNull).filter(o -> !o.isDetailDim()).collect(Collectors.toList());
                for (TemplateDim templateDim : templateDimList) {
                    sonDimessionIds.add(templateDim.getDimensionId());
                    if (templateDim.getDimType() == DimensionType.SUBJECTS) {
                        ArrayList<Long> accountMemIdLst = new ArrayList<Long>(){
                            {
                                this.add(templateAccountSetting.getAccountMemId());
                            }
                        };
                        sonDimessionMemberIds.add(accountMemIdLst);
                        continue;
                    }
                    if (templateDim.getDimType() == DimensionType.PERIOD) {
                        if (subHasDetailPeriod) {
                            boolean rollContainDetail;
                            boolean bl = rollContainDetail = Report.class.isInstance(subReport) && ((Report)subReport).isRollContainsDetail();
                            if (rollContainDetail) {
                                subPeriodMemberScope = subPeriodMemberList.stream().map(DimMember::getId).collect(Collectors.toSet());
                            } else {
                                subPeriodMemberScope.add(subPeriodMember.getId());
                            }
                            HashSet<Long> subPeriodMemberFinalScope = subPeriodMemberScope;
                            List detailPeriodMembers = allDimMemberList.stream().filter(Objects::nonNull).filter(b -> subPeriodMemberFinalScope.contains(b.getId())).map(DimMember::getChildren).flatMap(Collection::stream).map(DimMember::getId).collect(Collectors.toList());
                            ArrayList periodMemberScopes = new ArrayList(10);
                            periodMemberScopes.addAll(detailPeriodMembers);
                            if (!rollContainDetail) {
                                periodMemberScopes.addAll(subPeriodMemberList.stream().filter(periodMember -> periodMember != subPeriodMember).map(DimMember::getId).collect(Collectors.toList()));
                            }
                            sonDimessionMemberIds.add(periodMemberScopes);
                            continue;
                        }
                        sonDimessionMemberIds.add(templateDim.getMemberScope());
                        continue;
                    }
                    sonDimessionMemberIds.add(templateDim.getMemberScope());
                }
                List sonMemberIdDescarteGroups = CollectionBuildUtil.descartes(sonDimessionMemberIds);
                HashSet<ReportData> dealClearParentReportData = new HashSet<ReportData>(10);
                span.addTag("Related operations of audit report - data collection takes time");
                for (List sonMemberIdDescarteGroup : sonMemberIdDescarteGroups) {
                    ReportData subReportData;
                    ArrayList members = new ArrayList(sonMemberIdDescarteGroup);
                    DimensionInfoBean sonDimssion = new DimensionInfoBean();
                    sonDimssion.setDimensionIdList(sonDimessionIds);
                    sonDimssion.setMemberIdList(members);
                    TreeNode subTreeNode = subTree.find(sonDimssion);
                    List subReportDatas = null;
                    Optional<List<Object>> subDataListOp = Optional.ofNullable(subTreeNode.getDataList());
                    if (subDataListOp.isPresent()) {
                        subReportDatas = subTreeNode.getDataList().stream().filter(o -> o instanceof ReportData).map(o -> (ReportData)o).collect(Collectors.toList());
                    }
                    if (subReportDatas == null || !EmptyUtil.isNoEmpty(subReportDatas) || (subReportData = (ReportData)subReportDatas.get(0)) == null) continue;
                    List<TemplateDim> currDimList = subReportData.getDimList();
                    List<Object> currDimValList = subReportData.getDimValList();
                    boolean hasPeriod = currDimList.stream().anyMatch(item -> item.getDimType() == DimensionType.PERIOD);
                    if (!hasPeriod) continue;
                    ArrayList<TemplateDim> currMainDimList = new ArrayList<TemplateDim>(5);
                    ArrayList<Object> currMainDimValList = new ArrayList<Object>(5);
                    for (int i2 = 0; i2 < currDimList.size(); ++i2) {
                        TemplateDim templateDim = currDimList.get(i2);
                        List<TemplateDim> allTemplateDim = parentTemplate.getAllTemplateDim();
                        if (!allTemplateDim.stream().anyMatch(item -> item.getDimensionId().equals(templateDim.getDimensionId())) || DimensionType.DETAILDIM == templateDim.getDimType()) continue;
                        currMainDimList.add(templateDim);
                        currMainDimValList.add(currDimValList.get(i2));
                    }
                    List currDimIdList = currMainDimList.stream().map(TemplateDim::getDimensionId).collect(Collectors.toList());
                    DimensionInfoBean parentDimssion = new DimensionInfoBean();
                    parentDimssion.setDimensionIdList(currDimIdList);
                    parentDimssion.setMemberIdList(currMainDimValList);
                    TreeNode parentTreeNode = parentTree.find(parentDimssion);
                    if (parentTreeNode == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u5728\u7ef4\u5ea6\u6811\u4e2d\u627e\u5230\u5bf9\u5e94\u7ef4\u5ea6\u7ec4\u5408\u7684\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReportService_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
                    }
                    ReportData parentReportData = null;
                    Optional<List<Object>> dataListOp = Optional.ofNullable(parentTreeNode.getDataList());
                    if (dataListOp.isPresent()) {
                        parentReportData = dataListOp.get().stream().filter(o -> o instanceof ReportData).map(o -> (ReportData)o).findFirst().orElseGet(() -> null);
                    }
                    if (isAdd) {
                        if (EmptyUtil.isEmpty(parentReportData)) {
                            List<TemplateDim> allTemplateDim;
                            List allTemplateDimList;
                            List<PeriodMember> periodMemberList = parentReport.getPeriodMemberList();
                            List periDimValList = periodMemberList.stream().map(DimMember::getId).collect(Collectors.toList());
                            if (parentHasDetailPeriod) {
                                if (Report.class.isInstance(parentReport) && ((Report)parentReport).isRollContainsDetail()) {
                                    periDimValList = periodMemberList.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).map(DimMember::getId).collect(Collectors.toList());
                                } else {
                                    PeriodMember parentPeriodMember = periodMemberList.get(0);
                                    periDimValList = parentPeriodMember.getAllChildMember().stream().map(DimMember::getId).collect(Collectors.toList());
                                    periDimValList.addAll(periodMemberList.stream().filter(periodMember -> periodMember != parentPeriodMember).map(DimMember::getId).collect(Collectors.toList()));
                                }
                            }
                            if (!currDimIdList.containsAll(allTemplateDimList = (allTemplateDim = parentTemplate.getAllTemplateDim()).stream().map(TemplateDim::getDimensionId).collect(Collectors.toList()))) continue;
                            ArrayList<TemplateDim> parentCurrMainDimList = new ArrayList<TemplateDim>(5);
                            ArrayList<Object> parentCurrMainDimValList = new ArrayList<Object>(5);
                            boolean continueFlag = true;
                            for (TemplateDim templateDim : allTemplateDim) {
                                continueFlag = true;
                                Optional<TemplateDim> subTemplateDimOp = currMainDimList.stream().filter(i -> i.getDimensionId().equals(templateDim.getDimensionId())).findFirst();
                                if (!subTemplateDimOp.isPresent()) break;
                                int index = currMainDimList.indexOf(subTemplateDimOp.get());
                                Object value = currMainDimValList.get(index);
                                List<Long> memberScope = templateDim.getMemberScope();
                                if (DimensionType.PERIOD == templateDim.getDimType()) {
                                    memberScope = periDimValList;
                                }
                                if (!memberScope.contains(value)) {
                                    continueFlag = false;
                                    break;
                                }
                                parentCurrMainDimList.add(subTemplateDimOp.get());
                                parentCurrMainDimValList.add(value);
                            }
                            if (continueFlag) {
                                parentReportData = this.getNewReportData(parentReport, parentCurrMainDimList, parentCurrMainDimValList);
                                parentTreeNode.addData(parentReportData);
                                dealClearParentReportData.add(parentReportData);
                            }
                        } else if (dealClearParentReportData.add(parentReportData)) {
                            if (parentReportData == null) {
                                parentReportData = new ReportData();
                            }
                            parentReportData.setPlanAmt(BigDecimal.ZERO);
                            parentReportData.setReportPlanAmt(BigDecimal.ZERO);
                            parentReportData.setOriginalPlanAmt(BigDecimal.ZERO);
                            parentReportData.setPlanReferenceAmt(BigDecimal.ZERO);
                        }
                        if (parentReportData == null) continue;
                        parentReportData.setMainTable(parentTemplate.isMainTable());
                        parentReportData.setAmountUnit(parentTemplate.getAmountUnit());
                        BigDecimal planAmt = parentReportData.getPlanAmt() == null ? BigDecimal.ZERO : parentReportData.getPlanAmt();
                        BigDecimal actReferenceAmt = parentReportData.getPlanReferenceAmt() == null ? BigDecimal.ZERO : parentReportData.getPlanReferenceAmt();
                        BigDecimal reportPlanAmt = parentReportData.getReportPlanAmt() == null ? BigDecimal.ZERO : parentReportData.getReportPlanAmt();
                        BigDecimal originalPlanAmt = parentReportData.getOriginalPlanAmt() == null ? BigDecimal.ZERO : parentReportData.getOriginalPlanAmt();
                        BigDecimal subActAmount = BigDecimal.ZERO;
                        BigDecimal subReferenceAmount = BigDecimal.ZERO;
                        BigDecimal subReportPlanAmt = BigDecimal.ZERO;
                        BigDecimal subOriginalPlanAmt = BigDecimal.ZERO;
                        for (ReportData subReportDataItem : subReportDatas) {
                            subActAmount = subActAmount.add(subReportDataItem.getPlanAmt());
                            subReferenceAmount = subReferenceAmount.add(subReportDataItem.getPlanReferenceAmt());
                            subReportPlanAmt = subReportPlanAmt.add(subReportDataItem.getReportPlanAmt());
                            subOriginalPlanAmt = subOriginalPlanAmt.add(subReportDataItem.getOriginalPlanAmt());
                        }
                        planAmt = planAmt.add(subActAmount);
                        actReferenceAmt = actReferenceAmt.add(subReferenceAmount);
                        reportPlanAmt = reportPlanAmt.add(subReportPlanAmt);
                        originalPlanAmt = originalPlanAmt.add(subOriginalPlanAmt);
                        parentReportData.setPlanAmt(planAmt);
                        parentReportData.setPlanReferenceAmt(actReferenceAmt);
                        parentReportData.setReportPlanAmt(reportPlanAmt);
                        parentReportData.setOriginalPlanAmt(originalPlanAmt);
                        parentReportData.setDirty(Boolean.TRUE);
                        continue;
                    }
                    if (parentReportData == null || !EmptyUtil.isNoEmpty(parentReportData)) continue;
                    parentReportData.setPlanAmt(BigDecimal.ZERO);
                    parentReportData.setReportPlanAmt(BigDecimal.ZERO);
                    parentReportData.setOriginalPlanAmt(BigDecimal.ZERO);
                    parentReportData.setPlanReferenceAmt(BigDecimal.ZERO);
                    parentReportData.setDirty(Boolean.TRUE);
                }
            }
            span.addTag("Related operations of approval report - recalculation of parent table formula items takes time");
            if (parentReport instanceof Report && ((Report)parentReport).getInitFlag().booleanValue()) {
                this.calcFormulaData((Report)parentReport, system);
            }
            FpmOperateResult fpmOperateResult = FpmOperateResult.success();
            return fpmOperateResult;
        }
    }

    private ReportData getNewReportData(ReportDataSource parentReport, List<TemplateDim> parentCurrMainDimList, List<Object> parentCurrMainDimValList) {
        Report report;
        PlanChangeReport planChangeReport = parentReport instanceof PlanChangeReport ? (PlanChangeReport)parentReport : null;
        Report report2 = report = parentReport instanceof Report ? (Report)parentReport : null;
        if (Objects.isNull(planChangeReport) && Objects.isNull(report)) {
            throw new KDBizException("");
        }
        ReportData parentRD = Objects.nonNull(planChangeReport) ? new ReportChangeData() : new ReportData();
        parentReport.getReportDataList().add(parentRD);
        parentRD.setVersion(1);
        parentRD.setLinkedReportId(Objects.isNull(planChangeReport) ? report.getId() : planChangeReport.getReportId());
        parentRD.setDimList(parentCurrMainDimList);
        parentRD.setDimValList(parentCurrMainDimValList);
        parentRD.setReportPeriodId(parentReport.getPeriodMemberList().get(0).getId());
        parentRD.setAmountUnit(parentReport.getTemplate().getAmountUnit());
        return parentRD;
    }

    private List<PeriodMember> buildPeriodMemberInfo(FundPlanSystem system, ReportTemplate reportTemplate, ReportPeriodType reportPeriodType, Long periodMemberId) {
        List<TemplateDim> templateDimList;
        if (reportPeriodType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e2d\u672a\u67e5\u8be2\u5230\u7f16\u62a5\u7c7b\u578b\u3002", (String)"ReportService_4", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        PeriodType periodType = reportPeriodType.getPeriodType();
        Dimension periodDim = system.getMainDimensionByDimType(DimensionType.PERIOD);
        List<PeriodMember> periodList = periodDim.getMemberList(PeriodMember.class);
        Date currentTime = new Date();
        ArrayList<PeriodMember> reportPeriodMemList = new ArrayList<PeriodMember>();
        for (PeriodMember periodMember : periodList) {
            reportPeriodMemList.addAll(periodMember.getChildMemberByPeriodTypeAndPeriodId(periodType, reportPeriodType.getReportPeriodId()));
            if (PeriodType.MONTH_WEEK != periodType) continue;
            reportPeriodMemList.addAll(periodMember.getChildMemberByPeriodTypeAndPeriodId(PeriodType.YEAR_WEEK, reportPeriodType.getReportPeriodId()));
        }
        Optional<PeriodMember> first = reportPeriodMemList.stream().filter(o -> o.getId().equals(periodMemberId)).findFirst();
        if (CollectionUtils.isEmpty(reportPeriodMemList = reportPeriodMemList.stream().filter(o -> {
            if (periodMemberId != null && periodMemberId != 0L) {
                if (first.isPresent()) {
                    PeriodMember periodMember = (PeriodMember)first.get();
                    return o.getStartDate().compareTo(periodMember.getStartDate()) >= 0 && o.isEnable();
                }
                return false;
            }
            if (!o.isEnable()) {
                return false;
            }
            return currentTime.compareTo(o.getStartDate()) <= 0;
        }).sorted(Comparator.comparing(PeriodMember::getStartDate)).limit(reportPeriodType.isRoll() ? (long)reportPeriodType.getRollNum().intValue() : 1L).collect(Collectors.toList()))) {
            return reportPeriodMemList;
        }
        TemplateLayout.LayoutInfo periodLayoutInfo = reportTemplate.getTemplateLayoutInfoByDimId(periodDim.getId());
        if (periodLayoutInfo == null) {
            return null;
        }
        if (periodLayoutInfo.getDimLocation() == DimLocation.ROW) {
            templateDimList = reportTemplate.getRowDimList();
        } else if (periodLayoutInfo.getDimLocation() == DimLocation.COL) {
            templateDimList = reportTemplate.getColDimList();
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u4e0d\u80fd\u8bbe\u7f6e\u4e3a\u9875\u9762\u7ef4\u3002", (String)"ReportService_5", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        TemplateDim periodTemplateDim = null;
        periodTemplateDim = reportTemplate.getTemplateType() == TemplateType.DETAIL ? templateDimList.stream().filter(item -> periodLayoutInfo.getDimensionId().equals(item.getDimensionId())).findFirst().get() : templateDimList.get(periodLayoutInfo.getLevel() - 1);
        List<Long> periodMemberIdList = reportPeriodMemList.stream().map(DimMember::getId).collect(Collectors.toList());
        periodTemplateDim.setMemberScope(periodMemberIdList);
        return reportPeriodMemList;
    }

    private PeriodMember buildReferencePeriodMemberInfo(FundPlanSystem system, ReportPeriodType reportPeriodType, PeriodMember reportPeriod) {
        Optional<PeriodMember> first;
        if (reportPeriodType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e2d\u672a\u67e5\u8be2\u5230\u7f16\u62a5\u7c7b\u578b", (String)"ReportService_6", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        Dimension periodDim = system.getMainDimensionByDimType(DimensionType.PERIOD);
        List<PeriodMember> periodList = periodDim.getMemberList(PeriodMember.class);
        PeriodType referenceType = reportPeriodType.getPeriodType();
        ArrayList<PeriodMember> reportPeriodMemList = new ArrayList<PeriodMember>();
        for (PeriodMember periodMember : periodList) {
            reportPeriodMemList.addAll(periodMember.getChildMemberByPeriodTypeAndPeriodId(referenceType, reportPeriodType.getReportPeriodId()));
            if (PeriodType.MONTH_WEEK != referenceType) continue;
            reportPeriodMemList.addAll(periodMember.getChildMemberByPeriodTypeAndPeriodId(PeriodType.YEAR_WEEK, reportPeriodType.getReportPeriodId()));
        }
        PeriodType reportType = reportPeriod.getPeriodType();
        if (reportType == PeriodType.YEAR_WEEK) {
            reportType = PeriodType.MONTH_WEEK;
        }
        if (reportType == referenceType) {
            first = reportPeriodMemList.stream().filter(o -> o.getStartDate().compareTo(reportPeriod.getStartDate()) < 0 && o.isEnable()).sorted(Comparator.comparing(PeriodMember::getStartDate).reversed()).limit(1L).findFirst();
            if (first.isPresent()) {
                return first.get();
            }
            return null;
        }
        first = reportPeriodMemList.stream().filter(o -> o.getStartDate().compareTo(reportPeriod.getStartDate()) <= 0 && o.getEndDate().compareTo(reportPeriod.getStartDate()) >= 0 && o.isEnable()).sorted(Comparator.comparing(PeriodMember::getStartDate).reversed()).findFirst();
        if (first.isPresent()) {
            return first.get();
        }
        return null;
    }

    private List<OrgMember> buildOrgMemberInfo(FundPlanSystem system, ReportTemplate reportTemplate) {
        Dimension orgDim = system.getMainDimensionByDimType(DimensionType.ORG);
        List<OrgMember> orgMemberList = orgDim.getMemberList(OrgMember.class);
        ArrayList<OrgMember> reportOrgMemberList = new ArrayList<OrgMember>(10);
        reportOrgMemberList.addAll(orgMemberList);
        for (OrgMember orgMember : orgMemberList) {
            List<DimMember> allChildMember = orgMember.getAllChildMember();
            List allOrgChildMember = allChildMember.stream().map(item -> (OrgMember)item).collect(Collectors.toList());
            reportOrgMemberList.addAll(allOrgChildMember);
        }
        List<TemplateDim> pageDimList = reportTemplate.getPageDimList();
        Optional<TemplateDim> first = pageDimList.stream().filter(item -> item.getDimensionId().equals(orgDim.getId())).findFirst();
        if (first.isPresent()) {
            TemplateDim orgTemplateDim = first.get();
            List<Long> periodMemberIdList = reportOrgMemberList.stream().map(DimMember::getId).collect(Collectors.toList());
            orgTemplateDim.setMemberScope(periodMemberIdList);
        }
        return reportOrgMemberList;
    }

    private void buildSumOrgMemberInfo(FundPlanSystem system, ReportTemplate reportTemplate, ReportTemplate socTpl, Long sumOrgMemberId) {
        List<Object> memberScope = new ArrayList<Long>(16);
        Dimension orgDim = system.getMainDimensionByDimType(DimensionType.ORG);
        OrgMember sumOrgMember = orgDim.getDimMemberByDimId(OrgMember.class, sumOrgMemberId);
        TemplateDim orgTplDim = socTpl.getAllTemplateDim().stream().filter(item -> item.getDimType() == DimensionType.ORG).findFirst().get();
        TemplateDimMemScopeType scopeType = orgTplDim.getScopeType();
        if (TemplateDimMemScopeType.DIRECT_SUB_LEVEL == scopeType) {
            List<DimMember> childrenS = sumOrgMember.getChildren();
            memberScope.add(sumOrgMember.getId());
            memberScope.addAll(childrenS.stream().map(DimMember::getId).collect(Collectors.toList()));
        } else if (TemplateDimMemScopeType.SUM_NODE_THIS_LEVEL == scopeType) {
            memberScope.add(sumOrgMember.getId());
        } else {
            memberScope = orgTplDim.getMemberScope();
        }
        TemplateDim templateDim = reportTemplate.getAllTemplateDim().stream().filter(item -> item.getDimType() == DimensionType.ORG).findFirst().get();
        templateDim.setMemberScope(memberScope);
    }

    private List<ReportData> seekCoordOfAcctChild(DimensionIndexTree indexTree, ReportData reportData, TemplateAccountSetting acctSetting, List<ReportData> reportDataList) {
        List<TemplateAccountSetting> childrenS = acctSetting.getChildren();
        if (childrenS == null || childrenS.size() == 0) {
            return null;
        }
        ArrayList<ReportData> coords = new ArrayList<ReportData>(childrenS.size());
        for (TemplateAccountSetting childAcctSetting : childrenS) {
            Long childAcctMemId = childAcctSetting.getAccountMemId();
            ReportData childAcctReportData = this.findAcctReportData(indexTree, reportData, childAcctMemId, reportDataList);
            coords.add(childAcctReportData);
        }
        return coords;
    }

    private ReportData findAcctReportData(DimensionIndexTree indexTree, ReportData reportData, Long childAcctMemId, List<ReportData> reportDataList) {
        List<TemplateDim> dimList = reportData.getDimList();
        List<Object> dimValList = reportData.getDimValList();
        ArrayList<Object> targetDimValList = new ArrayList<Object>(dimValList);
        int accountIndex = dimList.indexOf(dimList.stream().filter(item -> item.getDimType() == DimensionType.SUBJECTS).findFirst().get());
        targetDimValList.remove(accountIndex);
        targetDimValList.add(accountIndex, childAcctMemId);
        ArrayList<Long> dimensionIdList = new ArrayList<Long>(dimList.size());
        ArrayList memberIdList = new ArrayList(dimList.size());
        int index = 0;
        for (TemplateDim templateDim : dimList) {
            if (templateDim.isDetailDim()) {
                ++index;
                continue;
            }
            dimensionIdList.add(templateDim.getDimensionId());
            memberIdList.add(targetDimValList.get(index));
            ++index;
        }
        DimensionInfoBean dimensionInfoBean = new DimensionInfoBean();
        dimensionInfoBean.setDimensionIdList(dimensionIdList);
        dimensionInfoBean.setMemberIdList(memberIdList);
        ReportData result = null;
        try {
            TreeNode treeNode = indexTree.find(dimensionInfoBean);
            if (treeNode != null) {
                List<Object> dataList = treeNode.getDataList();
                if (CollectionUtils.isNotEmpty(dataList)) {
                    result = (ReportData)dataList.get(0);
                }
            } else {
                LOGGER.warn("ReportService findAcctReportData tree node is null, reportData:{},dimId:{},targetDimValList:{}", new Object[]{reportData.getId(), dimensionInfoBean.getDimensionIdList(), targetDimValList});
            }
        }
        catch (Exception e) {
            LOGGER.warn("reportData:{},dimId:{},targetDimValList:{}", new Object[]{reportData.getId(), dimensionInfoBean.getDimensionIdList(), targetDimValList, e});
            Optional<ReportData> first = reportDataList.stream().filter(item -> item.getDimValList().size() == targetDimValList.size() && new HashSet<Object>(item.getDimValList()).containsAll(targetDimValList)).findFirst();
            result = first.orElse(null);
        }
        return result;
    }

    private ReportData findLastPeriodReportData(DimensionIndexTree indexTree, ReportData reportData, List<ReportData> reportDataList, Map<Long, Long> beginEndPeriodMap, Map<Long, Long> previousPeriodMap) {
        List<TemplateDim> dimList = reportData.getDimList();
        List<Object> dimValList = reportData.getDimValList();
        ArrayList<Object> targetDimValList = new ArrayList<Object>(dimValList);
        int accountIndex = dimList.indexOf(dimList.stream().filter(item -> item.getDimType() == DimensionType.SUBJECTS).findFirst().get());
        Long removeId = (Long)targetDimValList.remove(accountIndex);
        targetDimValList.add(accountIndex, beginEndPeriodMap.get(removeId));
        int periodIndex = dimList.indexOf(dimList.stream().filter(item -> item.getDimType() == DimensionType.PERIOD).findFirst().get());
        Long removePeriodId = (Long)targetDimValList.remove(periodIndex);
        if (!previousPeriodMap.containsKey(removePeriodId) || !EmptyUtil.isNoEmpty((Long)previousPeriodMap.get(removePeriodId))) {
            return null;
        }
        targetDimValList.add(periodIndex, previousPeriodMap.get(removePeriodId));
        DimensionInfoBean dimensionInfoBean = new DimensionInfoBean();
        dimensionInfoBean.setDimensionIdList(dimList.stream().map(TemplateDim::getDimensionId).collect(Collectors.toList()));
        dimensionInfoBean.setMemberIdList(targetDimValList);
        ReportData result = null;
        try {
            TreeNode treeNode = indexTree.find(dimensionInfoBean);
            if (treeNode != null) {
                List<Object> dataList = treeNode.getDataList();
                if (CollectionUtils.isNotEmpty(dataList)) {
                    result = (ReportData)dataList.get(0);
                }
            } else {
                LOGGER.warn("ReportService findLastPeriodReportData tree node is null, reportData:{},dimId:{},targetDimValList:{}", new Object[]{reportData.getId(), dimensionInfoBean.getDimensionIdList(), targetDimValList});
            }
        }
        catch (Exception e) {
            LOGGER.warn("reportData:{},dimId:{},targetDimValList:{}", new Object[]{reportData.getId(), dimensionInfoBean.getDimensionIdList(), targetDimValList, e});
            Optional<ReportData> first = reportDataList.stream().filter(item -> item.getDimValList().size() == targetDimValList.size() && new HashSet<Object>(item.getDimValList()).containsAll(targetDimValList)).findFirst();
            result = first.orElse(null);
        }
        return result;
    }

    private Formula getFormula(ReportData leftCalcVal, List<ReportData> dataValList) {
        Formula formula = new Formula();
        FormulaOperationVal leftOperationVal = new FormulaOperationVal();
        leftOperationVal.setName(leftCalcVal.getId().toString());
        formula.setLeftVal(leftOperationVal);
        LinkedList<IFormulaOperator> operator = new LinkedList<IFormulaOperator>();
        for (ReportData reportCalcVal : dataValList) {
            if (reportCalcVal == null) continue;
            FormulaOperationVal rightVal = new FormulaOperationVal();
            rightVal.setName(reportCalcVal.getId().toString());
            operator.add(rightVal);
            FormulaOperatorSymbol addSymbol = new FormulaOperatorSymbol(FormulaSymbolEnum.PLUS);
            operator.add(addSymbol);
        }
        if (CollectionUtils.isNotEmpty(operator)) {
            operator.removeLast();
        }
        formula.setOperator(operator);
        return formula;
    }

    private Formula getFormula(String excelFormula, ReportData leftCalcVal) {
        Formula formula = new Formula();
        FormulaOperationVal leftOperationVal = new FormulaOperationVal();
        leftOperationVal.setName(leftCalcVal.getId().toString());
        formula.setLeftVal(leftOperationVal);
        LinkedList<IFormulaOperator> operator = new LinkedList<IFormulaOperator>();
        excelFormula = excelFormula.replaceAll("SUM\\(", "");
        excelFormula = excelFormula.replaceAll("\\)", "");
        String regEx = "\\+|\\-";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(excelFormula);
        String[] excelPostArr = p.split(excelFormula);
        ArrayList<String> symbolArr = new ArrayList<String>(excelPostArr.length - 1);
        if (excelPostArr.length > 0) {
            for (int count = 0; count < excelPostArr.length; ++count) {
                if (!m.find()) continue;
                symbolArr.add(m.group());
            }
        }
        for (int i = 0; i < excelPostArr.length; ++i) {
            String excelPost = excelPostArr[i];
            if (excelPost.matches("^(\\[)[0-9]+(\\])$")) {
                LOGGER.warn("ReportService getFormula warn, \u5f53\u524d\u516c\u5f0f\u79d1\u76eeID\u672a\u66ff\u6362\u4e3a\u6709\u6548\u6570\u636e\uff0c\u79d1\u76eeID:{}", (Object)excelPost);
                continue;
            }
            FormulaOperationVal rightVal = new FormulaOperationVal();
            rightVal.setName(excelPost);
            operator.add(rightVal);
            if (i >= symbolArr.size()) continue;
            FormulaOperatorSymbol addSymbol = new FormulaOperatorSymbol(FormulaSymbolEnum.getBySymbol((String)symbolArr.get(i)));
            operator.add(addSymbol);
        }
        formula.setOperator(operator);
        return formula;
    }

    private String convertToExcelFunc(DimensionIndexTree indexTree, String formula, ReportData reportData, List<ReportData> reportDataList) {
        String[] formulaItemArr;
        for (String formulaItem : formulaItemArr = formula.replaceAll("\\(", "").replaceAll("\\)", "").split("[\\+|\\-]")) {
            if (!formulaItem.matches("^(\\[)[0-9]+(\\])$")) continue;
            Long subjectId = Long.valueOf(formulaItem.replace("[", "").replace("]", ""));
            ReportData findReportData = this.findAcctReportData(indexTree, reportData, subjectId, reportDataList);
            if (findReportData != null && findReportData.getId() != null) {
                formula = formula.replace(formulaItem, findReportData.getId().toString());
                continue;
            }
            formula = "";
            break;
        }
        return formula;
    }

    private String generateAcctFormula(Long acctId, Map<Long, TemplateAccountSetting> accountSettingMap) {
        String formula = "";
        if (acctId == null || accountSettingMap.size() == 0) {
            return formula;
        }
        formula = accountSettingMap.get(acctId).getFormula();
        return formula;
    }

    @Override
    public void reBuildReportData(Report report, FundPlanSystem system) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(String.format("%s-%s", ReportService.class.getSimpleName(), "reBuildReportData"));){
            span.addTag("sumToParentPeriod");
            report.sumToParentPeriod(system, false);
            ReportPeriodType reportPeriodType = report.getReportPeriodType();
            if (reportPeriodType.isRoll()) {
                span.addTag("Duration of rolling processing");
                this.handleReportVersion(report);
            }
        }
    }

    private void handleReportVersion(Report report) {
        ReportDataVersionParam dataVersionParam = new ReportDataVersionParam();
        dataVersionParam.setReport(report);
        ReportDataVersionProvider dataProvider = new ReportDataVersionProvider();
        Map versionMap = (Map)dataProvider.getData(dataVersionParam);
        block0: for (ReportData reportData : report.getReportDataList()) {
            List<Object> dimValList = reportData.getDimValList();
            for (Object dimVal : dimValList) {
                Integer version;
                if (dimVal == null || (version = (Integer)versionMap.get(dimVal)) == null) continue;
                reportData.setVersion(version);
                continue block0;
            }
        }
    }

    @Override
    public void reBuildReportData(Report report, FundPlanSystem system, boolean isFinalState) {
        report.sumToParentPeriod(system, isFinalState);
        ReportPeriodType reportPeriodType = report.getReportPeriodType();
        if (reportPeriodType.isRoll()) {
            ReportDataVersionParam dataVersionParam = new ReportDataVersionParam();
            dataVersionParam.setReport(report);
            ReportDataVersionProvider dataProvider = new ReportDataVersionProvider();
            Map versionMap = (Map)dataProvider.getData(dataVersionParam);
            block0: for (ReportData reportData : report.getReportDataList()) {
                List<Object> dimValList = reportData.getDimValList();
                for (Object dimVal : dimValList) {
                    Integer version;
                    if (dimVal == null || (version = (Integer)versionMap.get(dimVal)) == null) continue;
                    reportData.setVersion(version);
                    continue block0;
                }
            }
        }
    }

    @Override
    public void sumToParent(ReportDataSource parentReport, ReportDataSource report, FundPlanSystem system) {
        Dimension metricDim = system.getMainDimensionByDimType(DimensionType.METRIC);
        List<MetricMember> needSumMetricMembers = metricDim.getAllDimMemberList().stream().map(item -> (MetricMember)item).filter(item -> item.getTemplateMetricType() == TemplateMetricType.PLANREFERENCEAMT || item.getTemplateMetricType() == TemplateMetricType.PLANAMT || item.getTemplateMetricType() == TemplateMetricType.REPORTPLANAMT || item.getTemplateMetricType() == TemplateMetricType.ORIGINALPLANAMT).collect(Collectors.toList());
        this.summarySubData2Main(parentReport, report, system, null, needSumMetricMembers);
    }

    @Override
    public void sumToParent(ReportDataSource parentReport, ReportDataSource report, FundPlanSystem system, List<MetricMember> needSumMetricMembers) {
        QueryIndexInfo<Long, ReportData> reportDataQueryIndexInfo = null;
        if (CollectionUtils.isNotEmpty(parentReport.getReportDataList())) {
            reportDataQueryIndexInfo = QueryIndexInfoMapGenerator.buildReportDataIndex(parentReport.getReportDataList(), system, rd -> !rd.isAuxiliaryInfo());
        }
        this.summarySubData2Main(parentReport, report, system, reportDataQueryIndexInfo, needSumMetricMembers);
    }

    @Override
    public void reBuildReportData(Report report) {
        ReportPeriodType reportPeriodType;
        List<TemplateDim> dimList;
        List<ReportData> reportDataList = report.getReportDataList();
        PeriodType detailPeriodType = report.getReportPeriodType().getDetailPeriodType();
        boolean hasDetailPeriod = detailPeriodType != null;
        List<PeriodMember> periodMemberList = report.getPeriodMemberList();
        PeriodMember reportPeriod = periodMemberList.get(0);
        if (!report.isRollContainsDetail()) {
            periodMemberList = Collections.singletonList(reportPeriod);
        }
        Map detailPeriodMap = periodMemberList.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, Function.identity()));
        if (hasDetailPeriod) {
            ArrayList newReportList = new ArrayList();
            HashMap mainDataRDId = new HashMap(16);
            for (PeriodMember periodMember : periodMemberList) {
                dimList = report.getTemplate().getAllTemplateDim();
                TemplateDim periodDim = dimList.stream().filter(i -> i.getDimType() == DimensionType.PERIOD).findFirst().get();
                ArrayList<Long> dimIdList = new ArrayList<Long>(1);
                dimIdList.add(periodDim.getDimensionId());
                ArrayList<Object> dimValList = new ArrayList<Object>(1);
                dimValList.add(periodMember.getId());
                List<ReportData> mainPeriodDataList = report.getReportDataByDimInfo(dimIdList, dimValList, reportDataList);
                mainPeriodDataList.forEach(item -> mainDataRDId.put(JSON.toJSONString(item.getDimValList()), item.getId()));
                reportDataList.removeAll(mainPeriodDataList);
            }
            reportDataList.forEach(item -> {
                List<TemplateDim> dimList = item.getDimList();
                Optional<TemplateDim> first = dimList.stream().filter(i -> i.getDimType() == DimensionType.PERIOD).findFirst();
                if (first.isPresent()) {
                    TemplateDim periodDim = first.get();
                    int index = dimList.indexOf(periodDim);
                    List<Object> dimValList = item.getDimValList();
                    Object periodId = dimValList.get(index);
                    DimMember dimMember = (DimMember)detailPeriodMap.get(periodId);
                    if (Objects.isNull(dimMember)) {
                        return;
                    }
                    Long parentId = dimMember.getParentId();
                    ReportData reportData = (ReportData)FpmSerializeUtil.deserialize((String)FpmSerializeUtil.serialize((Object)item), ReportData.class);
                    List<Object> newDimValList = reportData.getDimValList();
                    reportData.setId(null);
                    newDimValList.remove(index);
                    newDimValList.add(index, parentId);
                    newReportList.add(reportData);
                }
            });
            Map<String, List<ReportData>> dimValMap = newReportList.stream().collect(Collectors.groupingBy(item -> {
                List<TemplateDim> dimList = item.getDimList();
                List sortedDimList = dimList.stream().sorted(Comparator.comparingLong(TemplateDim::getDimensionId)).collect(Collectors.toList());
                List<Object> dimValList = item.getDimValList();
                ArrayList<String> sortedValList = new ArrayList<String>(dimValList.size());
                for (TemplateDim templateDim : sortedDimList) {
                    int index = dimList.indexOf(templateDim);
                    Object val = dimValList.get(index);
                    if (val == null) {
                        val = "";
                    }
                    sortedValList.add(val.toString());
                }
                return String.join((CharSequence)"#", sortedValList);
            }));
            Iterator iterator = dimValMap.entrySet().iterator();
            ArrayList<ReportData> finalNewDataList = new ArrayList<ReportData>(0);
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                List currReportDataList = (List)next.getValue();
                ReportData needCopeData = (ReportData)currReportDataList.get(0);
                BigDecimal reduce = currReportDataList.stream().filter(item -> item.getPlanAmt() != null).map(ReportData::getPlanAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal actAmt = currReportDataList.stream().filter(item -> item.getActAmt() != null).map(ReportData::getActAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal lockAmt = currReportDataList.stream().filter(item -> item.getLockAmt() != null).map(ReportData::getLockAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal originalPlanAmt = currReportDataList.stream().filter(item -> item.getOriginalPlanAmt() != null).map(ReportData::getOriginalPlanAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal reportAmt = currReportDataList.stream().filter(item -> item.getReportPlanAmt() != null).map(ReportData::getReportPlanAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                ReportData reportData = (ReportData)FpmSerializeUtil.deserialize((String)FpmSerializeUtil.serialize((Object)needCopeData), ReportData.class);
                Long orgId = (Long)mainDataRDId.get(JSON.toJSONString(reportData.getDimValList()));
                reportData.setId(orgId);
                reportData.setRow(0);
                reportData.setCol(0);
                reportData.setPlanAmt(reduce);
                reportData.setLockAmt(lockAmt);
                reportData.setActAmt(actAmt);
                reportData.setOriginalPlanAmt(originalPlanAmt);
                reportData.setReportPlanAmt(reportAmt);
                finalNewDataList.add(reportData);
            }
            reportDataList.addAll(finalNewDataList);
        }
        if ((reportPeriodType = report.getReportPeriodType()).isRoll()) {
            HashMap<Long, Integer> versionMap = new HashMap<Long, Integer>();
            for (PeriodMember periodMember : periodMemberList) {
                ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
                qFilterList.add(new QFilter("templatebak.templateid", "=", (Object)report.getTemplate().getCopyId()));
                qFilterList.add(new QFilter("reportorg.id", "=", (Object)report.getCompanyMemberList().get(0).getId()));
                qFilterList.add(new QFilter("periodlist.fbasedataid", "=", (Object)periodMember.getId()));
                qFilterList.add(new QFilter("reportperiod.startdate", "<", (Object)periodMemberList.get(0).getStartDate()));
                int count = TmcDataServiceHelper.count((String)"fpm_report", (QFilter[])qFilterList.toArray(new QFilter[0]));
                List periodIdList = periodMember.getAllChildMember().stream().map(DimMember::getId).collect(Collectors.toList());
                periodIdList.add(periodMember.getId());
                for (Long periodId : periodIdList) {
                    versionMap.put(periodId, count + 1);
                }
            }
            for (int i2 = 0; i2 < reportDataList.size(); ++i2) {
                ReportData reportData = reportDataList.get(i2);
                dimList = reportData.getDimList();
                Optional<TemplateDim> periodDim = dimList.stream().filter(item -> item.getDimType() == DimensionType.PERIOD).findFirst();
                if (!periodDim.isPresent()) continue;
                TemplateDim templateDim = periodDim.get();
                int index = dimList.indexOf(templateDim);
                List<Object> dimValList = reportData.getDimValList();
                Object periodId = dimValList.get(index);
                Integer version = (Integer)versionMap.get(periodId);
                if (version == null) continue;
                reportData.setVersion(version);
            }
        }
    }

    private void summarySubData2Main(ReportDataSource parentReport, ReportDataSource subReport, FundPlanSystem system, QueryIndexInfo<Long, ReportData> reportDataQueryIndexInfo, List<MetricMember> needSumMetricMembers) {
        if (CollectionUtils.isEmpty(needSumMetricMembers)) {
            needSumMetricMembers = MetricValueUtils.listAllBaseMetricMember(system);
        }
        List<TemplateMetricType> templateMetricTypes = needSumMetricMembers.stream().map(MetricMember::getTemplateMetricType).collect(Collectors.toList());
        LOGGER.info("\u5f00\u59cb\u4e3b\u5b50\u8868\u6c47\u603b....");
        Report mainReport = (Report)parentReport;
        Report childReport = (Report)subReport;
        Map<Long, Set<Long>> underAllSubjectOfMainReport = this.getChildReportUnderAllSubjectOfMainReport(mainReport.getTemplate(), childReport.getTemplate());
        LOGGER.info("\u4e3b\u8868\u660e\u7ec6\u586b\u62a5\u79d1\u76ee\u53ca\u5176\u4e0b\u7ea7\u6240\u6709\u5b50\u79d1\u76ee:{}", underAllSubjectOfMainReport);
        Set needSummarySubjectIds = underAllSubjectOfMainReport.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Supplier<QueryIndexInfo> reportDataQueryIndexInfoSupplier = () -> this.getMainReportDataQueryIndexInfo(mainReport, childReport, system, needSummarySubjectIds);
        if (subReport.getTemplate().getTemplateType().isDetail() && EmptyUtil.isEmpty(subReport.getReportDataList())) {
            reportDataQueryIndexInfoSupplier.get();
            return;
        }
        boolean detail = subReport.getTemplate().getTemplateType().isDetail();
        List<ReportData> subReportDataList = subReport.getReportDataList();
        HashMap<Long, Set<Long>> summaryMap = new HashMap<Long, Set<Long>>(subReportDataList.size());
        ArrayList<ReportData> summaryMainReportDataList = new ArrayList<ReportData>(subReportDataList.size());
        HashSet<Long> summaryMainReportDataIds = new HashSet<Long>(subReportDataList.size());
        Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        Long subjectDimId = subjectDim.getId();
        HashSet<Long> currencyMemberIds = new HashSet<Long>(mainReport.getTemplate().getAllTemplateDim().stream().filter(td -> td.getDimType().isCurrencyDim()).findFirst().get().getMemberScope());
        boolean hasNewData = false;
        for (ReportData subReportData : subReportDataList) {
            Object subjectMemberId;
            Object currencyMemberId;
            if (subReportData.isAuxiliaryInfo() || !currencyMemberIds.contains(currencyMemberId = subReportData.getDimValByDimType(DimensionType.CURRENCY, null)) || !needSummarySubjectIds.contains(subjectMemberId = subReportData.getDimValByDimensionId(subjectDimId))) continue;
            if ((reportDataQueryIndexInfo = Optional.ofNullable(reportDataQueryIndexInfo).orElseGet(reportDataQueryIndexInfoSupplier)) == null) {
                return;
            }
            DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBeanByFilter(subReportData, td -> td.getDimType() != DimensionType.METRIC);
            ReportData mainReportData = (ReportData)reportDataQueryIndexInfo.findOne(dimensionInfoBean);
            boolean isFirstSum = EmptyUtil.isEmpty((Object)mainReportData);
            mainReportData = this.createNewReportDataIfNeed(mainReportData, subReportData, mainReport);
            if (underAllSubjectOfMainReport.containsKey((Long)subjectMemberId) && summaryMainReportDataIds.add(mainReportData.getId())) {
                summaryMainReportDataList.add(mainReportData);
            }
            if (isFirstSum) {
                hasNewData = true;
            }
            if (isFirstSum && !detail) continue;
            if (detail) {
                this.updateIndexIfNeed(mainReportData, reportDataQueryIndexInfo, isFirstSum);
                this.doSumDetailReportData2Main(mainReportData, subReportData, summaryMap, templateMetricTypes);
                continue;
            }
            this.setAmountIfChange(mainReportData, subReportData, templateMetricTypes);
        }
        if (hasNewData) {
            LOGGER.info("\u4e3b\u8868\u521b\u5efa\u4e86\u65b0\u6570\u636e\uff0c\u91cd\u5efaindexTree");
            mainReport.clearIndexTree();
        }
        if (EmptyUtil.isEmpty(summaryMainReportDataIds)) {
            return;
        }
        ReportTreeNodeFormulaManager formulaManager = mainReport.getFormulaManager(system, hasNewData);
        List<TreeNode> treeNodeList = formulaManager.updateData(mainReport.getTreeNodeList(summaryMainReportDataList));
        if (EmptyUtil.isEmpty(treeNodeList)) {
            return;
        }
        treeNodeList.stream().map(TreeNode::getDataList).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(ReportData.class::cast).forEach(rd -> rd.setDirty(true));
        LOGGER.info("\u4e3b\u5b50\u8868\u6c47\u603b\u7ed3\u675f\u3002\u3002\u3002");
    }

    private QueryIndexInfo<Long, ReportData> getMainReportDataQueryIndexInfo(Report mainReport, Report subReport, FundPlanSystem system, Set<Long> needSummarySubjectIds) {
        mainReport.buildIndexTree(system);
        List subReportDataList = subReport.getReportDataList().stream().filter(rd -> !rd.isAuxiliaryInfo()).collect(Collectors.toList());
        SubjectFindReportTreeNodeFormulaManager subjectManager = new SubjectFindReportTreeNodeFormulaManager(mainReport, system);
        List<Long> effectSubjectId = subjectManager.findEffectData(needSummarySubjectIds);
        List<IDimensionMemberStrategy> dimensionMemberStrategyList = DimensionInfoHelper.getDimensionMemberStrategyList(mainReport);
        dimensionMemberStrategyList.add((dimension, templateDim) -> dimension.getDimType().isSubjectDim() ? new ArrayList(effectSubjectId) : null);
        List<DimensionInfoBean> effectDimBean = DimensionInfoHelper.getDimensionInfoBeanListFromTemplate(system, mainReport.getTemplate(), dimensionMemberStrategyList);
        List<ReportData> reportDataList = this.getRelateReportData(effectDimBean, mainReport, system, needSummarySubjectIds);
        if (EmptyUtil.isEmpty(reportDataList)) {
            return QueryIndexInfo.buildEmptyIndexInfo(subReportDataList.size());
        }
        reportDataList.removeIf(ReportData::isAuxiliaryInfo);
        reportDataList.stream().filter(rd -> needSummarySubjectIds.contains((Long)rd.getDimValByDimType(DimensionType.SUBJECTS))).forEach(ReportData::clearAmt);
        mainReport.setReportDataList(reportDataList);
        mainReport.mountReportData(reportDataList);
        return QueryIndexInfoMapGenerator.buildReportDataIndex(reportDataList, system, rd -> !rd.isAuxiliaryInfo());
    }

    private List<ReportData> getRelateReportData(List<DimensionInfoBean> effectDimBeanList, Report mainReport, FundPlanSystem system, Set<Long> needSummarySubjectIds) {
        Set values;
        Map dimMap = system.getDimList().stream().collect(Collectors.toMap(Dimension::getId, Function.identity()));
        ArrayList<Dimension> tplDimIdList = new ArrayList<Dimension>(16);
        ArrayList<List<Object>> dimValList = new ArrayList<List<Object>>(16);
        HashMap<Long, Set> dimValuesMap = new HashMap<Long, Set>(16);
        for (DimensionInfoBean dimensionInfoBean : effectDimBeanList) {
            Map dimValueMap = dimensionInfoBean.getDimValueMap();
            if (tplDimIdList.isEmpty()) {
                tplDimIdList.addAll(dimensionInfoBean.getDimensionIdList().stream().map(dimMap::get).filter(Objects::nonNull).collect(Collectors.toList()));
            }
            for (Dimension dimension : tplDimIdList) {
                values = dimValuesMap.computeIfAbsent(dimension.getId(), k -> new HashSet(16));
                values.add(dimValueMap.get(dimension.getId()));
            }
        }
        ReportDataQueryService queryService = new ReportDataQueryService();
        ReportDataQueryObject queryObject = new ReportDataQueryObject();
        if (EmptyUtil.isEmpty(tplDimIdList)) {
            Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
            tplDimIdList.add(subjectDim);
            Set objects = dimValuesMap.computeIfAbsent(subjectDim.getId(), k -> new HashSet(4));
            objects.addAll(needSummarySubjectIds);
        }
        queryObject.setDimIdList(tplDimIdList);
        Set<Long> allPeriodMemberIds = mainReport.getAllPeriodMemberIds();
        for (Dimension dimension : tplDimIdList) {
            values = (Set)dimValuesMap.get(dimension.getId());
            if (dimension.getDimType() == DimensionType.SUBJECTS) {
                values.addAll(needSummarySubjectIds);
            }
            if (dimension.getDimType() == DimensionType.PERIOD) {
                values.addAll(allPeriodMemberIds);
            }
            dimValList.add(new ArrayList(values));
        }
        queryObject.setDimValList(dimValList);
        LOGGER.info("\u4e3b\u5b50\u8868\u6c47\u603b\uff0c\u4e3b\u8868\u5173\u8054\u6570\u636e\u7ef4\u5ea6\u67e5\u8be2\u6761\u4ef6\uff1a{},{}", tplDimIdList.stream().map(Dimension::getName).collect(Collectors.toList()), dimValList);
        queryObject.setReportIdS(Collections.singletonList(mainReport.getId()));
        queryObject.setNeedDimIfValueIsNotEmpty(true);
        List<ReportDataQueryResult> reportDataQueryResults = queryService.queryReportData(queryObject);
        return ReportHelper.convert(reportDataQueryResults);
    }

    private void setAmountIfChange(ReportData mainReportData, ReportData subReportData, List<TemplateMetricType> metricTypeList) {
        BigDecimal value = CommonUtils.getValueIfNull(mainReportData.getBigDecimalValue()).add(CommonUtils.getValueIfNull(subReportData.getBigDecimalValue()));
        mainReportData.setBigDecimalValueOrDefault(value);
        mainReportData.setDirty(Boolean.TRUE);
        for (TemplateMetricType metricType : metricTypeList) {
            switch (metricType) {
                case PLANAMT: {
                    mainReportData.addPlanAmt(subReportData.getPlanAmt());
                    break;
                }
                case LOCKAMT: {
                    mainReportData.addLockAmt(subReportData.getLockAmt());
                    break;
                }
                case ACTMAT: {
                    mainReportData.addActAmt(subReportData.getActAmt());
                    break;
                }
                case REPORTPLANAMT: {
                    mainReportData.addReportPlanAmt(subReportData.getReportPlanAmt());
                    break;
                }
                case ORIGINALPLANAMT: {
                    mainReportData.addOriginalPlanAmt(subReportData.getOriginalPlanAmt());
                    break;
                }
                case PLANREFERENCEAMT: {
                    mainReportData.addPlanReferenceAmt(subReportData.getPlanReferenceAmt());
                    break;
                }
            }
        }
    }

    private void updateIndexIfNeed(ReportData mainReportData, QueryIndexInfo<Long, ReportData> reportDataQueryIndexInfo, boolean isFirstSum) {
        if (!isFirstSum) {
            return;
        }
        reportDataQueryIndexInfo.updateIndex(new WarpBean<Long, ReportData>(mainReportData.getId(), DimensionInfoHelper.getDimensionInfoBean(mainReportData), mainReportData));
    }

    private void doSumDetailReportData2Main(ReportData mainReportData, ReportData subReportData, Map<Long, Set<Long>> summaryMap, List<TemplateMetricType> metricTypeLists) {
        Set subDataIds = summaryMap.computeIfAbsent(mainReportData.getId(), k -> new HashSet(8));
        if (EmptyUtil.isEmpty((Collection)subDataIds)) {
            mainReportData.clearAmt();
        }
        if (Objects.isNull(subReportData.getId()) || subDataIds.add(subReportData.getId())) {
            this.setAmountIfChange(mainReportData, subReportData, metricTypeLists);
        }
    }

    private ReportData createNewReportDataIfNeed(ReportData mainReportData, ReportData subReportData, Report mainReport) {
        if (EmptyUtil.isNoEmpty((Object)mainReportData)) {
            return mainReportData;
        }
        LOGGER.info("\u5b50\u8868\u6570\u636e\uff1a{}\u5728\u4e3b\u8868\u4e0d\u5b58\u5728\u5bf9\u5e94\u7ef4\u5ea6\u7ec4\u5408\u7684\u6570\u636e\uff0c\u521b\u5efa\u4e00\u6761\u6c47\u603b\u6570\u636e", (Object)subReportData.getId());
        mainReportData = new ReportData(subReportData);
        mainReportData.setReportId(mainReport.getId());
        mainReportData.setMainTable(true);
        mainReportData.setId(DB.genGlobalLongId());
        mainReportData.setDirty(true);
        mainReport.getReportDataList().add(mainReportData);
        return mainReportData;
    }

    private Map<Long, Set<Long>> getChildReportUnderAllSubjectOfMainReport(ReportTemplate mainTemplate, ReportTemplate childTemplate) {
        List<TemplateAccountSetting> mainSubjectSettingList = mainTemplate.getAccountSettings();
        long childTemplateId = childTemplate.getId();
        HashMap<Long, Set<Long>> detailSubjectDownLevelSubjectIdMap = new HashMap<Long, Set<Long>>(8);
        for (TemplateAccountSetting mainSubjectSetting : mainSubjectSettingList) {
            Long detailTemplateId;
            ReportInputType inputType = mainSubjectSetting.getInputType();
            if (inputType != ReportInputType.DETAIL_INPUT || !Objects.equals(detailTemplateId = mainSubjectSetting.getChildTemplateId(), childTemplateId)) continue;
            Set detailInputSubjectIds = detailSubjectDownLevelSubjectIdMap.computeIfAbsent(mainSubjectSetting.getAccountMemId(), k -> new HashSet(16));
            detailInputSubjectIds.add(mainSubjectSetting.getAccountMemId());
        }
        TemplateType templateType = childTemplate.getTemplateType();
        if (templateType == TemplateType.DETAIL) {
            return detailSubjectDownLevelSubjectIdMap;
        }
        List<TemplateAccountSetting> accountSettings = childTemplate.getAccountSettings();
        for (TemplateAccountSetting accountSetting : accountSettings) {
            Long subjectMemberId = accountSetting.getAccountMemId();
            if (!detailSubjectDownLevelSubjectIdMap.containsKey(subjectMemberId)) continue;
            Set detailInputSubjectIds = (Set)detailSubjectDownLevelSubjectIdMap.get(subjectMemberId);
            this.addDownLevelChildSubjectIds(detailInputSubjectIds, accountSetting);
        }
        return detailSubjectDownLevelSubjectIdMap;
    }

    private void addDownLevelChildSubjectIds(Set<Long> detailInputSubjectIds, TemplateAccountSetting accountSetting) {
        if (EmptyUtil.isEmpty((Object)accountSetting)) {
            return;
        }
        List<TemplateAccountSetting> children = accountSetting.getChildren();
        if (Objects.isNull(children)) {
            return;
        }
        for (TemplateAccountSetting child : children) {
            detailInputSubjectIds.add(child.getAccountMemId());
            this.addDownLevelChildSubjectIds(detailInputSubjectIds, child);
        }
    }

    @Override
    public void genEmptyReportData(Report report, FundPlanSystem system) {
        this.genEmptyReportData(report, system, true);
    }

    @Override
    public void genEmptyReportData(Report report, FundPlanSystem system, boolean validateInitFlag) {
        if (report.getTemplate().getTemplateType().isDetail()) {
            return;
        }
        if (validateInitFlag && report.getInitFlag().booleanValue()) {
            return;
        }
        DimensionInfoBean findBean = new DimensionInfoBean();
        ArrayList<Long> dimensionIdList = new ArrayList<Long>(16);
        ArrayList memberIdList = new ArrayList(16);
        findBean.setDimensionIdList(dimensionIdList);
        findBean.setMemberIdList(memberIdList);
        ArrayList<List<Object>> dimMemList = new ArrayList<List<Object>>(16);
        for (TemplateDim item : report.getTemplate().getAllTemplateDim()) {
            if (item.getDimType() == DimensionType.PERIOD && report.getReportPeriodType().getDetailPeriodType() != null) {
                List<PeriodMember> periodMemberList;
                List<PeriodMember> memberList = periodMemberList = report.getPeriodMemberList();
                List rollPeriodMembers = Collections.emptyList();
                if (!report.isRollContainsDetail()) {
                    PeriodMember periodMember = periodMemberList.get(0);
                    memberList = Collections.singletonList(periodMember);
                    rollPeriodMembers = periodMemberList.subList(1, periodMemberList.size()).stream().map(DimMember::getId).collect(Collectors.toList());
                }
                List memberScope = memberList.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).map(DimMember::getId).collect(Collectors.toList());
                memberScope.addAll(rollPeriodMembers);
                dimMemList.add(memberScope);
            } else {
                dimMemList.add(item.getMemberScope());
            }
            dimensionIdList.add(item.getDimensionId());
        }
        List descartes = CollectionBuildUtil.descartes(dimMemList);
        ArrayList<TemplateDim> allTemplateDim = new ArrayList<TemplateDim>(report.getTemplate().getAllTemplateDim());
        Map templateDimMap = allTemplateDim.stream().collect(Collectors.toMap(TemplateDim::getDimensionId, Function.identity()));
        ArrayList<TemplateDim> targetTplDimList = new ArrayList<TemplateDim>(allTemplateDim.size());
        for (Long dimId : findBean.getDimensionIdList()) {
            targetTplDimList.add((TemplateDim)templateDimMap.remove(dimId));
        }
        ArrayList newReportDataList = new ArrayList(1024);
        Map<Long, Report> detailInputSubject2SubReportMap = this.loadDetailInputSubject2SubReportMap(report);
        DimensionIndexTree indexTree = report.getIndexTree(system);
        long count = report.getReportDataList().stream().filter(reportData -> reportData.getId() == null).count();
        for (List memberIds : descartes) {
            memberIdList.clear();
            memberIdList.addAll(memberIds);
            TreeNode treeNode = indexTree.find(findBean);
            if (treeNode != null && CollectionUtils.isEmpty(treeNode.getDataList())) {
                List<ReportData> emptyReportDataList = this.createFixedReportEmptyReportDataList(report, targetTplDimList, findBean, detailInputSubject2SubReportMap);
                emptyReportDataList.forEach(reportData -> {
                    treeNode.addData(reportData);
                    newReportDataList.add(reportData);
                });
                continue;
            }
            if (treeNode == null || !this.isFillMainReportFullDimEmptyReportData(report, findBean, detailInputSubject2SubReportMap)) continue;
            List<ReportData> currDimReportDataList = treeNode.getDataList().stream().map(o -> (ReportData)o).filter(rd -> !rd.isAuxiliaryInfo()).collect(Collectors.toList());
            List<ReportData> emptyReportDataList = this.fillMainReportFullDimReportDataList(report, currDimReportDataList, targetTplDimList, findBean, detailInputSubject2SubReportMap);
            emptyReportDataList.forEach(reportData -> {
                treeNode.addData(reportData);
                newReportDataList.add(reportData);
            });
        }
        report.getReportDataList().addAll(newReportDataList);
        LinkedList<Long> idQueue = new LinkedList<Long>();
        if ((count += (long)newReportDataList.size()) > 0L) {
            long[] idArr = DB.genGlobalLongIds((int)((int)count));
            for (Object id : (TreeNode)idArr) {
                idQueue.offer((long)id);
            }
        }
        for (ReportData reportData2 : report.getReportDataList()) {
            if (reportData2.getId() != null) continue;
            reportData2.setId((Long)idQueue.poll());
            reportData2.setDirty(true);
        }
    }

    private Map<Long, Report> loadDetailInputSubject2SubReportMap(Report mainReport) {
        if (mainReport == null || mainReport.getTemplate() == null || !mainReport.getTemplate().isMainTable()) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        List<TemplateAccountSetting> accountSettings = mainReport.getTemplate().getAccountSettings();
        List detailInputAccountSettings = accountSettings.stream().filter(item -> ReportInputType.DETAIL_INPUT == item.getInputType()).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(detailInputAccountSettings)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        List<Long> subReportIds = this.iReportRepository.querySubReportId(mainReport.getId());
        if (EmptyUtil.isEmpty(subReportIds)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        ReportNeedPropDTO reportNeedPropDTO = new ReportNeedPropDTO();
        reportNeedPropDTO.setNeedTemplate(true);
        List<Report> subReportList = this.iReportRepository.loadSimpleReport(new HashSet<Long>(subReportIds), reportNeedPropDTO);
        Map subReportMap = subReportList.stream().collect(Collectors.toMap(key -> key.getTemplate().getId(), Function.identity(), (a, b) -> a));
        return detailInputAccountSettings.stream().collect(Collectors.toMap(TemplateAccountSetting::getAccountMemId, val -> (Report)subReportMap.get(val.getChildTemplateId())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFillMainReportFullDimEmptyReportData(Report report, DimensionInfoBean targetDimInfoBean, Map<Long, Report> detailInputSubject2SubReportMap) {
        if (!report.getTemplate().isMainTable()) {
            return false;
        }
        boolean bl = false;
        boolean withoutFill = bl;
        if (withoutFill) return false;
        if (detailInputSubject2SubReportMap.isEmpty()) {
            return false;
        }
        boolean bl2 = false;
        withoutFill = bl2;
        if (withoutFill) return false;
        if (targetDimInfoBean.getMemberIdList().stream().noneMatch(detailInputSubject2SubReportMap::containsKey)) {
            return false;
        }
        boolean bl3 = withoutFill = false;
        if (withoutFill) {
            return false;
        }
        Report subReport = targetDimInfoBean.getMemberIdList().stream().filter(detailInputSubject2SubReportMap::containsKey).map(detailInputSubject2SubReportMap::get).findAny().get();
        ReportTemplate subReportTemplate = subReport.getTemplate();
        List subReportAllMainTemplateDimList = subReportTemplate.getAllTemplateDim().stream().filter(td -> td.isVisible() && td.getDimType().isMainDimensionType()).collect(Collectors.toList());
        HashSet targetMainDimIdSet = new HashSet(targetDimInfoBean.getDimensionIdList());
        List diffTemplateDimList = subReportAllMainTemplateDimList.stream().filter(td -> !targetMainDimIdSet.contains(td.getDimensionId())).collect(Collectors.toList());
        if (!EmptyUtil.isEmpty(diffTemplateDimList)) return true;
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private List<ReportData> createFixedReportEmptyReportDataList(Report report, List<TemplateDim> targetTplDimList, DimensionInfoBean targetDimInfoBean, Map<Long, Report> detailInputSubject2SubReportMap) {
        createSingleData = report.getTemplate().isMainTable() == false;
        v0 = createSingleData = createSingleData != false || detailInputSubject2SubReportMap.isEmpty() != false;
        if (createSingleData) ** GOTO lbl-1000
        if (targetDimInfoBean.getMemberIdList().stream().noneMatch((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, containsKey(java.lang.Object ), (Ljava/lang/Object;)Z)(detailInputSubject2SubReportMap))) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = createSingleData = false;
        }
        if (createSingleData) {
            emptyReportDataList = new ArrayList<ReportData>(1);
            reportData = this.buildEmptyReportData(report, new ArrayList<TemplateDim>(targetTplDimList), new ArrayList<Object>(targetDimInfoBean.getMemberIdList()));
            emptyReportDataList.add(reportData);
            return emptyReportDataList;
        }
        subReport = targetDimInfoBean.getMemberIdList().stream().filter((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, containsKey(java.lang.Object ), (Ljava/lang/Object;)Z)(detailInputSubject2SubReportMap)).map((Function<Object, Report>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, get(java.lang.Object ), (Ljava/lang/Object;)Lkd/tmc/fpm/business/domain/model/report/Report;)(detailInputSubject2SubReportMap)).findAny().get();
        subReportTemplate = subReport.getTemplate();
        subReportAllMainTemplateDimList = subReportTemplate.getAllTemplateDim().stream().filter((Predicate<TemplateDim>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$createFixedReportEmptyReportDataList$77(kd.tmc.fpm.business.domain.model.template.TemplateDim ), (Lkd/tmc/fpm/business/domain/model/template/TemplateDim;)Z)()).collect(Collectors.toList());
        targetMainDimIdSet = new HashSet<E>(targetDimInfoBean.getDimensionIdList());
        diffTemplateDimList = subReportAllMainTemplateDimList.stream().filter((Predicate<TemplateDim>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$createFixedReportEmptyReportDataList$78(java.util.Set kd.tmc.fpm.business.domain.model.template.TemplateDim ), (Lkd/tmc/fpm/business/domain/model/template/TemplateDim;)Z)(targetMainDimIdSet)).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(diffTemplateDimList)) {
            emptyReportDataList = new ArrayList<ReportData>(1);
            reportData = this.buildEmptyReportData(report, new ArrayList<TemplateDim>(targetTplDimList), new ArrayList<Object>(targetDimInfoBean.getMemberIdList()));
            emptyReportDataList.add(reportData);
            return emptyReportDataList;
        }
        diffDimMemList = new ArrayList<List<Long>>(diffTemplateDimList.size());
        targetFullTplDimList = new ArrayList<TemplateDim>(targetTplDimList);
        for (TemplateDim item : diffTemplateDimList) {
            diffDimMemList.add(item.getMemberScope());
            targetFullTplDimList.add(item);
        }
        descartes = CollectionBuildUtil.descartes(diffDimMemList);
        emptyReportDataList = new ArrayList<ReportData>(descartes.size());
        for (List memberIds : descartes) {
            targetFullDimValList = new ArrayList<Object>(targetDimInfoBean.getMemberIdList());
            targetFullDimValList.addAll(memberIds);
            reportData = this.buildEmptyReportData(report, new ArrayList<TemplateDim>(targetFullTplDimList), targetFullDimValList);
            emptyReportDataList.add(reportData);
        }
        return emptyReportDataList;
    }

    private List<ReportData> fillMainReportFullDimReportDataList(Report report, List<ReportData> currDimReportDataList, List<TemplateDim> targetTplDimList, DimensionInfoBean targetDimInfoBean, Map<Long, Report> detailInputSubject2SubReportMap) {
        Report subReport = targetDimInfoBean.getMemberIdList().stream().filter(detailInputSubject2SubReportMap::containsKey).map(detailInputSubject2SubReportMap::get).findAny().get();
        ReportTemplate subReportTemplate = subReport.getTemplate();
        List subReportAllMainTemplateDimList = subReportTemplate.getAllTemplateDim().stream().filter(td -> td.isVisible() && td.getDimType().isMainDimensionType()).collect(Collectors.toList());
        HashSet targetMainDimIdSet = new HashSet(targetDimInfoBean.getDimensionIdList());
        List diffTemplateDimList = subReportAllMainTemplateDimList.stream().filter(td -> !targetMainDimIdSet.contains(td.getDimensionId())).collect(Collectors.toList());
        ArrayList<List<Long>> diffDimMemList = new ArrayList<List<Long>>(diffTemplateDimList.size());
        ArrayList<TemplateDim> targetFullTplDimList = new ArrayList<TemplateDim>(targetTplDimList);
        for (TemplateDim item : diffTemplateDimList) {
            diffDimMemList.add(item.getMemberScope());
            targetFullTplDimList.add(item);
        }
        List descartes = CollectionBuildUtil.descartes(diffDimMemList);
        ArrayList<ReportData> emptyReportDataList = new ArrayList<ReportData>(descartes.size());
        for (List memberIds : descartes) {
            Optional<ReportData> existFullDimReportData = currDimReportDataList.stream().filter(rd -> memberIds.stream().allMatch(memberId -> rd.getDimValList().contains(memberId))).findAny();
            if (existFullDimReportData.isPresent()) continue;
            Optional<ReportData> existNeedUpdateDimReportDataOpt = currDimReportDataList.stream().filter(rd -> {
                DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBean(rd);
                return dimensionInfoBean.hashCode() == targetDimInfoBean.hashCode();
            }).findAny();
            if (existNeedUpdateDimReportDataOpt.isPresent()) {
                ReportData needUpdateDimReportData = existNeedUpdateDimReportDataOpt.get();
                needUpdateDimReportData.getDimList().addAll(diffTemplateDimList);
                needUpdateDimReportData.getDimValList().addAll(memberIds);
                needUpdateDimReportData.setDirty(Boolean.TRUE);
                continue;
            }
            ArrayList<Object> targetFullDimValList = new ArrayList<Object>(targetDimInfoBean.getMemberIdList());
            targetFullDimValList.addAll(memberIds);
            ReportData reportData = this.buildEmptyReportData(report, new ArrayList<TemplateDim>(targetFullTplDimList), targetFullDimValList);
            emptyReportDataList.add(reportData);
        }
        return emptyReportDataList;
    }

    private ReportData buildEmptyReportData(Report report, List<TemplateDim> dimList, List<Object> dimValList) {
        ReportData reportData = new ReportData();
        reportData.setVersion(1);
        reportData.setLinkedReportId(report.getId());
        reportData.setDimList(dimList);
        reportData.setDimValList(dimValList);
        reportData.setReportPeriodId(report.getPeriodMemberList().get(0).getId());
        reportData.setMainTable(report.getTemplate().isMainTable());
        reportData.setAmountUnit(report.getTemplate().getAmountUnit());
        reportData.setBigDecimalValueOrDefault(BigDecimal.ZERO);
        reportData.setPlanAmt(BigDecimal.ZERO);
        reportData.setActAmt(BigDecimal.ZERO);
        reportData.setLockAmt(BigDecimal.ZERO);
        reportData.setOffsetAmt(BigDecimal.ZERO);
        reportData.setReportPlanAmt(BigDecimal.ZERO);
        reportData.setOriginalPlanAmt(BigDecimal.ZERO);
        reportData.setDirty(Boolean.TRUE);
        return reportData;
    }

    private static /* synthetic */ boolean lambda$createFixedReportEmptyReportDataList$78(Set targetMainDimIdSet, TemplateDim td) {
        return !targetMainDimIdSet.contains(td.getDimensionId());
    }

    private static /* synthetic */ boolean lambda$createFixedReportEmptyReportDataList$77(TemplateDim td) {
        return td.isVisible() && td.getDimType().isMainDimensionType();
    }
}

