/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.ShrekReportDataQueryDTO;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.service.QueryConditionProcessor;

public class ShrekQueryConditionLogProcessorImpl
implements QueryConditionProcessor<ShrekReportDataQueryDTO> {
    private static final Log logger = LogFactory.getLog(ShrekQueryConditionLogProcessorImpl.class);

    @Override
    public void beforeSearch(ShrekReportDataQueryDTO shrekReportDataQueryDTO) {
        StringBuilder sb = new StringBuilder();
        List<Dimension> dimIdList = shrekReportDataQueryDTO.getDimIdList();
        List<List<Object>> dimValIdList = shrekReportDataQueryDTO.getDimValIdList();
        List<List<DimMember>> dimValList = shrekReportDataQueryDTO.getDimValList();
        if (EmptyUtil.isNoEmpty(dimIdList)) {
            for (int i = 0; i < dimIdList.size(); ++i) {
                Dimension dimension = dimIdList.get(i);
                List<Object> values = EmptyUtil.isEmpty(dimValIdList) ? new ArrayList(dimValList.get(i)) : dimValIdList.get(i);
                sb.append(dimension.getNumber()).append(":").append(values.stream().map(v -> v instanceof DimMember ? ((DimMember)v).getName() : v).map(String::valueOf).collect(Collectors.joining("\u3001"))).append(",");
            }
        }
        if (EmptyUtil.isNoEmpty((Object)shrekReportDataQueryDTO.getEffectFlag())) {
            sb.append("EffectFlag:").append(shrekReportDataQueryDTO.getEffectFlag()).append(",");
        }
        if (EmptyUtil.isNoEmpty(shrekReportDataQueryDTO.getReportPeriodList())) {
            sb.append("ReportPeriodList:").append(shrekReportDataQueryDTO.getReportPeriodList().stream().map(Object::toString).collect(Collectors.joining("\u3001"))).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        logger.info("\u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)sb.toString());
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

