/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.StringUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.ListUtils;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.business.domain.enums.SunReportSumStatus;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.ReportDataIndexQueryMap;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.index.generate.bean.WarpBean;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.BatchSaveSDKReportData;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.SumPlanHeader;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountAmtDetailInfo;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountAmtInfo;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountRecord;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelDetail;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelRecord;
import kd.tmc.fpm.business.domain.model.sumplan.SourceIdEntryData;
import kd.tmc.fpm.business.domain.model.sumplan.SumOrCancelPlanReportUpperParam;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanInfo;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanUpdateInfo;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateMetric;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.ISumPlanService;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.service.IRelateReportDataManager;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.control.factory.RelateReportDataManagerFactory;
import kd.tmc.fpm.business.mvc.service.impl.RelateReportDataManager;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.business.utils.MetricValueUtils;
import kd.tmc.fpm.business.utils.ReportUtils;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.helper.AmountCurrencyRateHelper;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import kd.tmc.fpm.common.utils.AmountUtil;
import org.apache.commons.collections4.CollectionUtils;

public class SumPlanService
implements ISumPlanService {
    private static Log logger = LogFactory.getLog(SumPlanService.class);

    @Override
    public FpmOperateResult<Void> transfer(SumPlanRecord sumPlanRecord, FundPlanSystem system, List<InnerCancelRecord> innerCancelRecordList, ApprovedAmountRecord approvedAmountRecord, List<ReportData> relationDataList, List<ReportData> subReportDataList, SumPlanHeader sumPlanHeader) {
        logger.info("\u6c47\u603b\u8868\u6570\u636e\u8f6c\u6362,{}", (Object)sumPlanRecord.getId());
        throw new UnsupportedOperationException();
    }

    @Override
    public FpmOperateResult<Void> transfer(SumPlanInfo sumPlanInfo, List<ReportData> subReportDataList) {
        logger.info("\u6c47\u603b\u8868\u6570\u636e\u8f6c\u6362,{}", (Object)sumPlanInfo.getReport().getId());
        SumPlanHeader sumPlanHeader = sumPlanInfo.getSumPlanHeader();
        if (Objects.nonNull(sumPlanHeader) && org.apache.commons.collections.CollectionUtils.isNotEmpty(sumPlanHeader.getMetricMemberIds())) {
            Report report = sumPlanInfo.getReport();
            ReportTemplate template = report.getTemplate();
            TemplateDim metricTplDim = template.getMetricTplDim();
            metricTplDim.setMemberScope(sumPlanHeader.getMetricMemberIds());
        } else {
            this.updateMetricIfShowApprovedAmt(sumPlanInfo);
        }
        String message = this.buildSumReportData(sumPlanInfo);
        if (EmptyUtil.isNotEmpty((CharSequence)message)) {
            return FpmOperateResult.error(message);
        }
        if (!EmptyUtil.isEmpty(subReportDataList)) {
            List<ReportData> reportDataList = sumPlanInfo.getReport().getReportDataList();
            reportDataList.addAll(subReportDataList);
            sumPlanInfo.setQueryIndexInfo(QueryIndexInfoMapGenerator.buildReportDataIndex(reportDataList, sumPlanInfo.getSystem(), rd -> !rd.isAuxiliaryInfo()));
        }
        this.rebuildReportData(sumPlanInfo);
        return FpmOperateResult.success();
    }

    @Override
    public void rebuildReportData(SumPlanInfo sumPlanInfo) {
        logger.info("\u6c47\u603b\u62a5\u8868\u67e5\u770b-\u521b\u5efa\u6570\u636e-\u6309\u6a21\u677f\u91cd\u65b0\u751f\u6210\u6570\u636e");
        Report report = sumPlanInfo.getReport();
        Long referencePeriodMemberId = Optional.ofNullable(report.getReferencePeriodMember()).orElseGet(PeriodMember::new).getId();
        ReportTemplate template = report.getTemplate();
        List auxReportDataList = report.getReportDataList().stream().filter(ReportData::isAuxiliaryInfo).collect(Collectors.toList());
        List<TemplateDim> allTemplateDim = template.getAllTemplateDim();
        List<List<Long>> dimMemScopeList = allTemplateDim.stream().map(item -> this.getMemberScope((TemplateDim)item, report)).collect(Collectors.toList());
        int currencyIndex = -1;
        Optional<TemplateDim> first = allTemplateDim.stream().filter(item -> item.getDimType() == DimensionType.CURRENCY).findFirst();
        if (first.isPresent()) {
            currencyIndex = allTemplateDim.indexOf(first.get());
        }
        List<List<Long>> descartes = this.descartes(dimMemScopeList);
        Map<Long, Map<Long, BigDecimal>> currencyRateMap = sumPlanInfo.getCurrencyRateMap();
        Set needTransferCurrency = currencyRateMap.values().stream().map(Map::keySet).flatMap(Collection::stream).collect(Collectors.toSet());
        List dimIdList = allTemplateDim.stream().map(TemplateDim::getDimensionId).collect(Collectors.toList());
        BiFunction<DimensionInfoBean, Map<Long, BigDecimal>, ReportData> sumReportDataFunction = this.getSumReportDataFunction(sumPlanInfo);
        ArrayList<ReportData> resultDataList = new ArrayList<ReportData>(descartes.size());
        for (List<Long> dimInfo : descartes) {
            Long currencyMemId = dimInfo.get(currencyIndex);
            Map currencyMap = currencyRateMap.getOrDefault(currencyMemId, new HashMap(4));
            if (currencyMap.isEmpty() && needTransferCurrency.contains(currencyMemId)) continue;
            currencyMap.putIfAbsent(currencyMemId, BigDecimal.ONE);
            DimensionInfoBean dimensionInfoBean = DimensionInfoBean.of(dimIdList, dimInfo);
            ReportData sumReportData = sumReportDataFunction.apply(dimensionInfoBean, currencyMap);
            MetricValueUtils.fillMetricValMap(sumReportData, report, Objects.equals(sumReportData.getReportPeriodId(), referencePeriodMemberId));
            resultDataList.add(sumReportData);
        }
        resultDataList.addAll(auxReportDataList);
        report.setReportDataList(resultDataList);
    }

    private BiFunction<DimensionInfoBean, Map<Long, BigDecimal>, ReportData> getSumReportDataFunction(SumPlanInfo sumPlanInfo) {
        QueryIndexInfo<Long, ReportData> queryIndexInfo = sumPlanInfo.getQueryIndexInfo();
        ReportDataIndexQueryMap<Long> indexQueryMap = queryIndexInfo.getIndexQueryMap();
        Map<Long, ReportData> dataMap = queryIndexInfo.getDataMap();
        FundPlanSystem system = sumPlanInfo.getSystem();
        Dimension currencyDimension = system.getMainDimensionByDimType(DimensionType.CURRENCY);
        Long currencyDimensionId = currencyDimension.getId();
        Function<DimensionInfoBean, ReportData> reportDataFunction = this.getGenerateSumReportDataFunction(sumPlanInfo.getReport());
        return (dimensionInfoBean, currencyMap) -> {
            DimensionInfoBean copy = dimensionInfoBean.copy();
            List dimensionIdList = copy.getDimensionIdList();
            int index = dimensionIdList.indexOf(currencyDimensionId);
            ReportData sumReportData = (ReportData)reportDataFunction.apply((DimensionInfoBean)dimensionInfoBean);
            if (index == -1) {
                return sumReportData;
            }
            List memberIdList = copy.getMemberIdList();
            for (Map.Entry entry : currencyMap.entrySet()) {
                Long currencyMemId = (Long)entry.getKey();
                memberIdList.set(index, currencyMemId);
                List list = indexQueryMap.findList(copy);
                if (EmptyUtil.isEmpty(list)) continue;
                List<ReportData> reportDataList = list.stream().map(dataMap::get).collect(Collectors.toList());
                BigDecimal rate = currencyMap.getOrDefault(currencyMemId, BigDecimal.ONE);
                this.sumReportData(sumReportData, reportDataList, rate);
            }
            return sumReportData;
        };
    }

    private void sumReportData(ReportData sumReportData, List<ReportData> reportDataList, BigDecimal rate) {
        if (EmptyUtil.isEmpty(reportDataList)) {
            return;
        }
        AmountUnit amountUnit = sumReportData.getAmountUnit();
        String sumReportAmountUnit = amountUnit.getNumber();
        List<Long> sourceIdList = sumReportData.getSourceIdList();
        for (ReportData reportData : reportDataList) {
            String reportDataAmountUnit = reportData.getAmountUnit().getNumber();
            sumReportData.addPlanAmt(rate.multiply(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)reportDataAmountUnit), (AmountUnitEnum)AmountUnitEnum.get((String)sumReportAmountUnit), (BigDecimal)reportData.getPlanAmt())));
            sumReportData.addLockAmt(rate.multiply(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)reportDataAmountUnit), (AmountUnitEnum)AmountUnitEnum.get((String)sumReportAmountUnit), (BigDecimal)reportData.getLockAmt())));
            sumReportData.addActAmt(rate.multiply(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)reportDataAmountUnit), (AmountUnitEnum)AmountUnitEnum.get((String)sumReportAmountUnit), (BigDecimal)reportData.getActAmt())));
            sumReportData.addReportPlanAmt(rate.multiply(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)reportDataAmountUnit), (AmountUnitEnum)AmountUnitEnum.get((String)sumReportAmountUnit), (BigDecimal)reportData.getReportPlanAmt())));
            sumReportData.addOriginalPlanAmt(rate.multiply(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)reportDataAmountUnit), (AmountUnitEnum)AmountUnitEnum.get((String)sumReportAmountUnit), (BigDecimal)reportData.getOriginalPlanAmt())));
            sumReportData.addPlanReferenceAmt(rate.multiply(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)reportDataAmountUnit), (AmountUnitEnum)AmountUnitEnum.get((String)sumReportAmountUnit), (BigDecimal)reportData.getPlanReferenceAmt())));
            sourceIdList.add(reportData.getId());
        }
        sumReportData.setReportPeriodId(reportDataList.get(0).getReportPeriodId());
    }

    private Consumer<ReportData> getSumReportDataConsumer(ReportData sumReportData, List<TemplateMetricType> metricTypeList, Function<BigDecimal, BigDecimal> amtWarp) {
        AmountUnit amountUnit = sumReportData.getAmountUnit();
        String sumReportAmountUnit = amountUnit.getNumber();
        return reportData -> {
            String reportDataAmountUnit = reportData.getAmountUnit().getNumber();
            List<Long> sourceIdList = sumReportData.getSourceIdList();
            if (!sourceIdList.contains(reportData.getId())) {
                sourceIdList.add(reportData.getId());
            }
            for (TemplateMetricType metricType : metricTypeList) {
                switch (metricType) {
                    case PLANAMT: {
                        sumReportData.addPlanAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)reportDataAmountUnit), (AmountUnitEnum)AmountUnitEnum.get((String)sumReportAmountUnit), (BigDecimal)((BigDecimal)amtWarp.apply(reportData.getOriginalPlanAmt()))));
                        break;
                    }
                    case ACTMAT: {
                        sumReportData.addActAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)reportDataAmountUnit), (AmountUnitEnum)AmountUnitEnum.get((String)sumReportAmountUnit), (BigDecimal)((BigDecimal)amtWarp.apply(reportData.getActAmt()))));
                        break;
                    }
                    case LOCKAMT: {
                        sumReportData.addLockAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)reportDataAmountUnit), (AmountUnitEnum)AmountUnitEnum.get((String)sumReportAmountUnit), (BigDecimal)((BigDecimal)amtWarp.apply(reportData.getLockAmt()))));
                        break;
                    }
                    case REPORTPLANAMT: {
                        sumReportData.addReportPlanAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)reportDataAmountUnit), (AmountUnitEnum)AmountUnitEnum.get((String)sumReportAmountUnit), (BigDecimal)((BigDecimal)amtWarp.apply(reportData.getOriginalPlanAmt()))));
                        break;
                    }
                    case ORIGINALPLANAMT: {
                        sumReportData.addOriginalPlanAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)reportDataAmountUnit), (AmountUnitEnum)AmountUnitEnum.get((String)sumReportAmountUnit), (BigDecimal)((BigDecimal)amtWarp.apply(reportData.getOriginalPlanAmt()))));
                        break;
                    }
                    case PLANREFERENCEAMT: {
                        sumReportData.addPlanReferenceAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)reportDataAmountUnit), (AmountUnitEnum)AmountUnitEnum.get((String)sumReportAmountUnit), (BigDecimal)((BigDecimal)amtWarp.apply(reportData.getPlanReferenceAmt()))));
                        break;
                    }
                }
            }
        };
    }

    private Consumer<ReportData> rebuildSumReportDataConsumer(ReportData sumReportData, List<TemplateMetricType> metricTypeList, Function<BigDecimal, BigDecimal> amtWarp) {
        AmountUnit amountUnit = sumReportData.getAmountUnit();
        String sumReportAmountUnit = amountUnit.getNumber();
        return reportData -> {
            String reportDataAmountUnit = reportData.getAmountUnit().getNumber();
            List<Long> sourceIdList = sumReportData.getSourceIdList();
            if (!sourceIdList.contains(reportData.getId())) {
                sourceIdList.add(reportData.getId());
            }
            for (TemplateMetricType metricType : metricTypeList) {
                switch (metricType) {
                    case PLANAMT: {
                        sumReportData.addPlanAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)reportDataAmountUnit), (AmountUnitEnum)AmountUnitEnum.get((String)sumReportAmountUnit), (BigDecimal)((BigDecimal)amtWarp.apply(reportData.getPlanAmt()))));
                        break;
                    }
                    case ACTMAT: {
                        sumReportData.addActAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)reportDataAmountUnit), (AmountUnitEnum)AmountUnitEnum.get((String)sumReportAmountUnit), (BigDecimal)((BigDecimal)amtWarp.apply(reportData.getActAmt()))));
                        break;
                    }
                    case LOCKAMT: {
                        sumReportData.addLockAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)reportDataAmountUnit), (AmountUnitEnum)AmountUnitEnum.get((String)sumReportAmountUnit), (BigDecimal)((BigDecimal)amtWarp.apply(reportData.getLockAmt()))));
                        break;
                    }
                    case REPORTPLANAMT: {
                        sumReportData.addReportPlanAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)reportDataAmountUnit), (AmountUnitEnum)AmountUnitEnum.get((String)sumReportAmountUnit), (BigDecimal)((BigDecimal)amtWarp.apply(reportData.getReportPlanAmt()))));
                        break;
                    }
                    case ORIGINALPLANAMT: {
                        sumReportData.addOriginalPlanAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)reportDataAmountUnit), (AmountUnitEnum)AmountUnitEnum.get((String)sumReportAmountUnit), (BigDecimal)((BigDecimal)amtWarp.apply(reportData.getOriginalPlanAmt()))));
                        break;
                    }
                    case PLANREFERENCEAMT: {
                        sumReportData.addPlanReferenceAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)reportDataAmountUnit), (AmountUnitEnum)AmountUnitEnum.get((String)sumReportAmountUnit), (BigDecimal)((BigDecimal)amtWarp.apply(reportData.getPlanReferenceAmt()))));
                        break;
                    }
                }
            }
        };
    }

    private Function<DimensionInfoBean, ReportData> getGenerateSumReportDataFunction(Report report) {
        ReportTemplate template = report.getTemplate();
        List<TemplateDim> allTemplateDim = template.getAllTemplateDim();
        Long periodMemId = report.getPeriodMemberList().get(0).getId();
        AmountUnit amountUnit = template.getAmountUnit();
        return dimensionInfoBean -> {
            ReportData reportData = new ReportData();
            reportData.setDimList(allTemplateDim);
            reportData.setDimValList(dimensionInfoBean.getMemberIdList());
            reportData.setVersion(0);
            reportData.setReportPeriodId(periodMemId);
            reportData.setAmountUnit(amountUnit);
            reportData.setMainTable(template.isMainTable());
            reportData.setPlanAmt(BigDecimal.ZERO);
            reportData.setLockAmt(BigDecimal.ZERO);
            reportData.setActAmt(BigDecimal.ZERO);
            reportData.setOriginalPlanAmt(BigDecimal.ZERO);
            reportData.setReportPlanAmt(BigDecimal.ZERO);
            reportData.setSourceIdList(new ArrayList<Long>(4));
            reportData.setRow(1);
            reportData.setCol(1);
            reportData.setId(DB.genGlobalLongId());
            return reportData;
        };
    }

    private List<Long> getMemberScope(TemplateDim templateDim, Report report) {
        ArrayList<Long> memberScope = new ArrayList<Long>(templateDim.getMemberScope());
        if (templateDim.getDimType() != DimensionType.PERIOD) {
            return memberScope;
        }
        PeriodMember currPeriodMember = report.getPeriodMemberList().get(0);
        List periodMemberList = report.getPeriodMemberList().stream().filter(p -> memberScope.contains(p.getId())).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(periodMemberList)) {
            return memberScope;
        }
        PeriodMember firstPeriodMember = (PeriodMember)periodMemberList.get(0);
        PeriodMember referencePeriodMember = report.getReferencePeriodMember();
        Long referencePeriodId = Objects.isNull(referencePeriodMember) ? Long.valueOf(0L) : referencePeriodMember.getId();
        Consumer<List> referencePeriodConsumer = scope -> {
            if (EmptyUtil.isNoEmpty((Long)referencePeriodId)) {
                scope.add(referencePeriodId);
            }
        };
        PeriodType detailPeriodType = report.getReportPeriodType().getDetailPeriodType();
        if (Objects.isNull((Object)detailPeriodType)) {
            referencePeriodConsumer.accept(memberScope);
            return memberScope;
        }
        if (periodMemberList.size() == 1) {
            List<Long> periodMemberIdList = firstPeriodMember.getId().equals(currPeriodMember.getId()) ? firstPeriodMember.getAllChildMember().stream().map(DimMember::getId).collect(Collectors.toList()) : Collections.singletonList(firstPeriodMember.getId());
            referencePeriodConsumer.accept(periodMemberIdList);
            return periodMemberIdList;
        }
        List<Object> rollMember = new ArrayList(4);
        List memberList = periodMemberList;
        if (!report.isRollContainsDetail()) {
            List<Long> memberIdList;
            if (firstPeriodMember.getId().equals(currPeriodMember.getId())) {
                rollMember = periodMemberList.subList(1, periodMemberList.size()).stream().map(DimMember::getId).collect(Collectors.toList());
                memberIdList = firstPeriodMember.getAllChildMember().stream().map(DimMember::getId).collect(Collectors.toList());
                memberIdList.addAll(rollMember);
            } else {
                memberIdList = memberList.stream().map(DimMember::getId).collect(Collectors.toList());
            }
            referencePeriodConsumer.accept(memberIdList);
            return memberIdList;
        }
        List<Long> memberIdList = memberList.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).map(DimMember::getId).collect(Collectors.toList());
        memberIdList.addAll(rollMember);
        referencePeriodConsumer.accept(memberIdList);
        return memberIdList;
    }

    private String buildSumReportData(SumPlanInfo sumPlanInfo) {
        List<ReportData> relationDataList = sumPlanInfo.getRelationDataList();
        if (EmptyUtil.isEmpty(relationDataList)) {
            return "";
        }
        String message = this.buildApprovedAmountData(sumPlanInfo, relationDataList);
        if (EmptyUtil.isNotEmpty((CharSequence)message)) {
            return message;
        }
        return this.buildInnerCancelData(sumPlanInfo, relationDataList);
    }

    private String buildInnerCancelData(SumPlanInfo sumPlanInfo, List<ReportData> relationDataList) {
        if (EmptyUtil.isEmpty(relationDataList)) {
            return "";
        }
        List<InnerCancelRecord> innerCancelRecordList = sumPlanInfo.getInnerCancelRecordList();
        if (EmptyUtil.isEmpty(innerCancelRecordList)) {
            return "";
        }
        InnerCancelRecord innerCancelRecord = innerCancelRecordList.get(0);
        logger.info("\u6570\u636e\u67e5\u770b\u65b9\u5f0f\u4e3a\u67e5\u770b\u62b5\u6d88\u540e\u6570\u636e\uff0c{},{}", (Object)innerCancelRecord.getSumPlanRecordId(), (Object)innerCancelRecordList.size());
        Map<Long, BigDecimal> innerCancelMap = innerCancelRecordList.stream().filter(item -> item.getCancelDetailList() != null).map(InnerCancelRecord::getCancelDetailList).flatMap(Collection::stream).collect(Collectors.toMap(InnerCancelDetail::getReportDataId, InnerCancelDetail::getCancelAmt, BigDecimal::add));
        List<ReportData> innerCancelRDList = relationDataList.stream().filter(item -> innerCancelMap.containsKey(item.getId())).collect(Collectors.toList());
        this.fillInnerCancelRelateReportData(sumPlanInfo, innerCancelMap, innerCancelRDList);
        BiConsumer<ReportData, BigDecimal> consumer = (reportData, amt) -> {
            reportData.setOriginalPlanAmt(reportData.getOriginalPlanAmt().subtract((BigDecimal)amt));
            reportData.setReportPlanAmt(reportData.getReportPlanAmt().subtract((BigDecimal)amt));
            reportData.setPlanAmt(reportData.getPlanAmt().subtract((BigDecimal)amt));
        };
        Function<List<ReportData>, String> innerCancelFunction = this.getBuildInnerCancelAmtDataFunction(sumPlanInfo, innerCancelMap, consumer);
        return innerCancelFunction.apply(innerCancelRDList);
    }

    private String buildApprovedAmountData(SumPlanInfo sumPlanInfo, List<ReportData> relationDataList) {
        ApprovedAmountRecord approvedAmountRecord = sumPlanInfo.getApprovedAmountRecord();
        if (Objects.isNull(approvedAmountRecord)) {
            return "";
        }
        logger.info("\u5b58\u5728\u6838\u5b9a\u8bb0\u5f55\uff0c{}", (Object)approvedAmountRecord.getSumPlanRecordId());
        Map<Long, BigDecimal> approvedAmtMap = approvedAmountRecord.getAmountAmtInfoList().stream().map(ApprovedAmountAmtInfo::getAmtDetailInfoList).flatMap(Collection::stream).filter(item -> item.getEvalDetail() == false).collect(Collectors.toMap(ApprovedAmountAmtDetailInfo::getReportDataId, ApprovedAmountAmtDetailInfo::getApprovedAmt));
        Report sumPlanReport = sumPlanInfo.getReport();
        Set sumReportDataIdSet = approvedAmountRecord.getAmountAmtInfoList().stream().map(ApprovedAmountAmtInfo::getReportDataIdStr).map(str -> str.split(",")).flatMap(Arrays::stream).map(Long::valueOf).collect(Collectors.toSet());
        List sumReportData = sumPlanReport.getReportDataList().stream().filter(i -> sumReportDataIdSet.contains(i.getId())).collect(Collectors.toList());
        FundPlanSystem system = sumPlanInfo.getSystem();
        Dimension periodDim = system.getMainDimensionByDimType(DimensionType.PERIOD);
        ArrayList relData = new ArrayList(sumReportData);
        DimensionIndexTree indexTree = sumPlanReport.rebuildTree(system);
        Map<Long, PeriodMember> periodMemberIdReportPeriodMap = ReportUtils.getPeriodMemberIdReportPeriodMap(sumPlanReport);
        for (ReportData reportData : sumReportData) {
            Long parentPeriodId;
            Long periodMemberId;
            PeriodMember periodMember;
            if (reportData.isAuxiliaryInfo() || Objects.isNull(periodMember = periodMemberIdReportPeriodMap.get(periodMemberId = (Long)reportData.getDimValByDimType(DimensionType.PERIOD))) || Objects.equals(parentPeriodId = periodMember.getId(), periodMemberId)) continue;
            DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBean(reportData);
            dimensionInfoBean.replaceValueIfContains(periodDim.getId(), (Object)parentPeriodId);
            TreeNode node = indexTree.find(dimensionInfoBean);
            if (node == null || CollectionUtils.isEmpty(node.getDataList())) continue;
            List rdList = node.getDataList().stream().map(ReportData.class::cast).collect(Collectors.toList());
            relData.addAll(rdList);
        }
        sumPlanReport.clearIndexTree();
        Set subMainReportDataIds = relData.stream().map(ReportData::getSourceIdList).flatMap(Collection::stream).collect(Collectors.toSet());
        List<ReportData> subMainData = relationDataList.stream().filter(i -> subMainReportDataIds.contains(i.getId())).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(subMainData)) {
            subMainData.forEach(item -> approvedAmtMap.put(item.getId(), item.getOriginalPlanAmt()));
        }
        Set nonApprovedAmtLeafRDIdSet = sumPlanReport.getReportDataList().stream().filter(item -> {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(item.getSourceIdList())) {
                return item.getSourceIdList().stream().anyMatch(approvedAmtMap::containsKey);
            }
            return false;
        }).map(item -> item.getSourceIdList().stream().filter(sourceId -> !approvedAmtMap.containsKey(sourceId)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet());
        List<ReportData> approveAmtRDList = relationDataList.stream().filter(item -> approvedAmtMap.containsKey(item.getId()) || nonApprovedAmtLeafRDIdSet.contains(item.getId())).collect(Collectors.toList());
        approveAmtRDList.stream().filter(item -> nonApprovedAmtLeafRDIdSet.contains(item.getId())).forEach(item -> approvedAmtMap.put(item.getId(), item.getOriginalPlanAmt()));
        this.fillRelateReportData(sumPlanInfo, approvedAmtMap, approveAmtRDList);
        return this.updateApproveAmt(sumPlanInfo, approvedAmtMap, approveAmtRDList);
    }

    private void fillRelateReportData(SumPlanInfo sumPlanInfo, Map<Long, BigDecimal> approvedAmtMap, List<ReportData> approveAmtRDList) {
        ArrayList<ReportData> sourceReportDataList = new ArrayList<ReportData>(approveAmtRDList.size());
        for (ReportData approveAmtRD : approveAmtRDList) {
            ReportData reportData = new ReportData(approveAmtRD);
            reportData.setId(approveAmtRD.getId());
            reportData.setOriginalPlanAmt(approvedAmtMap.getOrDefault(reportData.getId(), BigDecimal.ZERO));
            sourceReportDataList.add(reportData);
        }
        RelateReportDataManager mainTableReportRelateManager = new RelateReportDataManager();
        mainTableReportRelateManager.setCalculateRollData(true);
        ControlContext controlContext = new ControlContext();
        controlContext.addSystem(sumPlanInfo.getSystem());
        mainTableReportRelateManager.buildManager(sourceReportDataList, controlContext);
        List<ReportData> reportDataList = mainTableReportRelateManager.reCalculateRelateDataByDAG();
        for (ReportData reportData : reportDataList) {
            Long reportDataId = reportData.getId();
            if (approvedAmtMap.containsKey(reportDataId)) continue;
            approvedAmtMap.put(reportDataId, reportData.getOriginalPlanAmt());
            approveAmtRDList.add(reportData);
        }
    }

    private void fillInnerCancelRelateReportData(SumPlanInfo sumPlanInfo, Map<Long, BigDecimal> innerCancelMap, List<ReportData> innerCancelRDList) {
        ArrayList<ReportData> sourceReportDataList = new ArrayList<ReportData>(innerCancelRDList.size());
        for (ReportData approveAmtRD : innerCancelRDList) {
            ReportData reportData = new ReportData(approveAmtRD);
            reportData.setId(approveAmtRD.getId());
            reportData.setOffsetAmt(innerCancelMap.getOrDefault(reportData.getId(), BigDecimal.ZERO));
            sourceReportDataList.add(reportData);
        }
        IRelateReportDataManager relateReportDataManager = RelateReportDataManagerFactory.getRelateReportDataManagerInstance(sourceReportDataList, sumPlanInfo.getSystem());
        List<ReportData> reportDataList = relateReportDataManager.reCalculateRelateDataByDAG();
        for (ReportData reportData : reportDataList) {
            Long reportDataId = reportData.getId();
            if (innerCancelMap.containsKey(reportDataId)) continue;
            innerCancelMap.put(reportDataId, reportData.getOffsetAmt());
            innerCancelRDList.add(reportData);
        }
    }

    private String updateApproveAmt(SumPlanInfo sumPlanInfo, Map<Long, BigDecimal> amtMap, List<ReportData> reportDataList) {
        Report report = sumPlanInfo.getReport();
        ReportTemplate template = report.getTemplate();
        AmountUnitEnum targetAmountUnit = AmountUnit.convert(template.getAmountUnit());
        DimMember sumOrgMember = sumPlanInfo.getSumOrgMember();
        QueryIndexInfo<Long, ReportData> queryIndexInfo = sumPlanInfo.getQueryIndexInfo();
        HashSet<Long> reportDataIdSet = new HashSet<Long>(16);
        for (ReportData reportData : reportDataList) {
            DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.replaceSumOrgFromDownDimensionInfo(reportData, sumOrgMember.getId());
            List<ReportData> rdList = queryIndexInfo.findList(dimensionInfoBean);
            if (EmptyUtil.isEmpty(rdList)) continue;
            if (rdList.size() > 1 && (rdList = rdList.stream().filter(rd -> Objects.equals(dimensionInfoBean, DimensionInfoHelper.getDimensionInfoBean(rd))).collect(Collectors.toList())).size() > 1) {
                logger.info("\u6c47\u603b\u8868\u4e2d\u6570\u636e\u5f02\u5e38\uff0c\u540c\u4e00\u7ef4\u5ea6\u7ec4\u5408\u4e0b\u5b58\u5728\u591a\u4e2a\u6570\u636e,\u3010{}\u3011,\u3010{}\u3011,\u3010{}\u3011", (Object)dimensionInfoBean.getDimensionIdList(), (Object)dimensionInfoBean.getMemberIdList());
                return ResManager.loadKDString((String)"\u6c47\u603b\u8868\u4e2d\u6570\u636e\u5f02\u5e38\uff0c\u540c\u4e00\u7ef4\u5ea6\u7ec4\u5408\u4e0b\u5b58\u5728\u591a\u4e2a\u6570\u636e", (String)"SumPlanService_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
            }
            ReportData targetReportData = rdList.get(0);
            BigDecimal amt = amtMap.getOrDefault(reportData.getId(), BigDecimal.ZERO);
            AmountUnit target = reportData.getAmountUnit();
            AmountUnitEnum sourceAmountUnit = AmountUnit.convert(target);
            BigDecimal approveAmt = AmountCurrencyRateHelper.convertAmt((BigDecimal)amt, (AmountUnitEnum)sourceAmountUnit, (AmountUnitEnum)targetAmountUnit);
            if (reportDataIdSet.add(targetReportData.getId())) {
                targetReportData.setOriginalPlanAmt(BigDecimal.ZERO);
                targetReportData.setPlanAmt(BigDecimal.ZERO);
            }
            if (!reportData.isMainTable()) continue;
            targetReportData.setOriginalPlanAmt(targetReportData.getOriginalPlanAmt().add(approveAmt));
            targetReportData.setPlanAmt(targetReportData.getPlanAmt().add(approveAmt));
        }
        return "";
    }

    private Function<List<ReportData>, String> getBuildInnerCancelAmtDataFunction(SumPlanInfo sumPlanInfo, Map<Long, BigDecimal> amtMap, BiConsumer<ReportData, BigDecimal> consumer) {
        QueryIndexInfo<Long, ReportData> queryIndexInfo = sumPlanInfo.getQueryIndexInfo();
        ReportDataIndexQueryMap<Long> indexQueryMap = queryIndexInfo.getIndexQueryMap();
        DimMember sumOrgMember = sumPlanInfo.getSumOrgMember();
        Map<Long, ReportData> dataMap = queryIndexInfo.getDataMap();
        List sumPlanTemplateDimList = sumPlanInfo.getReport().getTemplate().getAllTemplateDim().stream().filter(Objects::nonNull).filter(tpl -> Objects.nonNull(tpl.getDimensionId()) && tpl.getDimType() != DimensionType.DETAILDIM).map(TemplateDim::getDimensionId).collect(Collectors.toList());
        Set originSumReportAllDimIdSet = sumPlanInfo.getReport().getReportDataList().stream().map(ReportData::getDimList).flatMap(Collection::stream).filter(Objects::nonNull).filter(templateDim -> Objects.nonNull(templateDim.getDimensionId()) && templateDim.getDimType() != DimensionType.DETAILDIM).map(TemplateDim::getDimensionId).collect(Collectors.toSet());
        Long orgDimId = sumPlanInfo.getReport().getTemplate().getAllTemplateDim().stream().filter(Objects::nonNull).filter(templateDim -> templateDim.getDimType() == DimensionType.ORG).map(TemplateDim::getDimensionId).findAny().get();
        return reportDataList -> {
            for (ReportData reportData : reportDataList) {
                DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBeanByFilter(reportData, templateDim -> originSumReportAllDimIdSet.contains(templateDim.getDimensionId()));
                dimensionInfoBean.replaceValueIfContains(orgDimId, (Object)sumOrgMember.getId());
                List reportDataIdList = indexQueryMap.findList(dimensionInfoBean);
                if (EmptyUtil.isEmpty(reportDataIdList)) continue;
                if (reportDataIdList.size() > 1) {
                    Set currDataDimList = reportData.getDimList().stream().filter(Objects::nonNull).filter(tpl -> Objects.nonNull(tpl.getDimensionId()) && tpl.getDimType() != DimensionType.DETAILDIM).map(TemplateDim::getDimensionId).collect(Collectors.toSet());
                    Optional<Long> sumTplNonExistDimOpt = sumPlanTemplateDimList.stream().filter(dimId -> !currDataDimList.contains(dimId)).findAny();
                    if (sumTplNonExistDimOpt.isPresent()) {
                        logger.info("\u6c47\u603b\u8868\u4e2d\u6570\u636e\u5f02\u5e38\uff0c\u5185\u90e8\u62b5\u6d88\u573a\u666f\u4e0b\u540c\u4e00\u7ef4\u5ea6\u7ec4\u5408\u4e0b\u5b58\u5728\u591a\u4e2a\u6570\u636e, \u3010{}\u3011,\u3010{}\u3011\uff0c\u4e14\u62a5\u8868\u6570\u636e\u3010{}\u3011\u7684\u7ef4\u5ea6\u3010{}\u3011\u4e0d\u5728\u6a21\u677f\u4e2d", new Object[]{dimensionInfoBean.getDimensionIdList(), dimensionInfoBean.getMemberIdList(), reportData.getId(), sumTplNonExistDimOpt.get()});
                        return ResManager.loadKDString((String)"\u6c47\u603b\u8868\u4e2d\u6570\u636e\u5f02\u5e38\uff0c\u540c\u4e00\u7ef4\u5ea6\u7ec4\u5408\u4e0b\u5b58\u5728\u591a\u4e2a\u6570\u636e", (String)"SumPlanService_1", (String)"tmc-fpm-business", (Object[])new Object[0]);
                    }
                }
                Long reportDataId = (Long)reportDataIdList.get(0);
                ReportData targetReportData = (ReportData)dataMap.get(reportDataId);
                BigDecimal amt = amtMap.getOrDefault(reportData.getId(), BigDecimal.ZERO);
                consumer.accept(targetReportData, amt);
            }
            return "";
        };
    }

    private void updateMetricIfShowApprovedAmt(SumPlanInfo sumPlanInfo) {
        SumPlanHeader sumPlanHeader = sumPlanInfo.getSumPlanHeader();
        if (EmptyUtil.isEmpty((Object)sumPlanHeader) || EmptyUtil.isEmpty((Object)sumPlanHeader.isShowApprovedAmt())) {
            return;
        }
        Report report = sumPlanInfo.getReport();
        ReportTemplate template = report.getTemplate();
        List<TemplateMetric> metrics = template.getMetrics();
        Set planAmtMetricIdS = metrics.stream().map(TemplateMetric::getMetricMember).filter(Objects::nonNull).filter(metricMember -> metricMember.getTemplateMetricType() == TemplateMetricType.PLANAMT).map(DimMember::getId).collect(Collectors.toSet());
        TemplateDim templateDim = template.getMetricTplDim();
        Predicate<Long> memberScopeFilter = id -> {
            if (sumPlanHeader.isShowApprovedAmt().booleanValue()) {
                return !planAmtMetricIdS.contains(id);
            }
            return planAmtMetricIdS.contains(id);
        };
        List<Long> memberScope = templateDim.getMemberScope();
        memberScope = memberScope.stream().filter(memberScopeFilter).collect(Collectors.toList());
        templateDim.setMemberScope(memberScope);
        template.setMetricTplDim(templateDim);
    }

    @Override
    public FpmOperateResult<SumPlanUpdateInfo> sumPlanReportUpper(List<Report> reportPlanList, SumPlanReport sumReport, FundPlanSystem system) {
        return this.sumOrCancelPlanReportUpper(reportPlanList, sumReport, SunReportSumStatus.SUM, system, null);
    }

    @Override
    public FpmOperateResult<SumPlanUpdateInfo> sumPlanReportUpper(List<Report> reportPlanList, SumPlanReport sumReport, FundPlanSystem system, List<MetricMember> needSumMetricS) {
        return this.sumOrCancelPlanReportUpper(reportPlanList, sumReport, SunReportSumStatus.SUM, system, needSumMetricS);
    }

    @Override
    public FpmOperateResult<SumPlanUpdateInfo> cancelSumPlanReportUpper(List<Report> reportPlanList, SumPlanReport sumReport, FundPlanSystem system) {
        return this.sumOrCancelPlanReportUpper(reportPlanList, sumReport, SunReportSumStatus.CANCEL, system, null);
    }

    @Override
    public FpmOperateResult<SumPlanUpdateInfo> sdkReportPlanReportUpperSum(List<Report> reportPlanList, SumPlanReport sumPlanReport, FundPlanSystem system, List<MetricMember> needSumMetrics) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(reportPlanList) || Objects.isNull(sumPlanReport)) {
            return FpmOperateResult.error(ResManager.loadKDString((String)"\u53c2\u6570\u5f02\u5e38\uff0c\u7f16\u5236\u8868\u6570\u636e\u6216\u6c47\u603b\u8868\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SumPlanService_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        logger.info("\u7f16\u62a5\u4e3b\u4f53\u6570\u636e\u6c47\u603b\uff0c[{}]\uff0c[{}], [{}]\uff0c[{}]", new Object[]{reportPlanList.stream().map(Report::getId).collect(Collectors.toList()), sumPlanReport.getId(), SunReportSumStatus.SUM, needSumMetrics.stream().map(MetricMember::getTemplateMetricType).collect(Collectors.toList())});
        return this.sdkReportPlanReportUpperSum(reportPlanList, sumPlanReport, SunReportSumStatus.SUM, system, needSumMetrics);
    }

    private FpmOperateResult<SumPlanUpdateInfo> sumOrCancelPlanReportUpper(List<Report> reportPlanList, SumPlanReport sumPlanReport, SunReportSumStatus sumStatus, FundPlanSystem system, List<MetricMember> needSumMetricS) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(reportPlanList) || Objects.isNull(sumPlanReport)) {
            return FpmOperateResult.error(ResManager.loadKDString((String)"\u53c2\u6570\u5f02\u5e38\uff0c\u7f16\u5236\u8868\u6570\u636e\u6216\u6c47\u603b\u8868\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SumPlanService_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty(needSumMetricS)) {
            ReportTemplate template = sumPlanReport.getTemplate();
            needSumMetricS = template.getMetrics().stream().map(TemplateMetric::getMetricMember).collect(Collectors.toList());
            Dimension metricDim = system.getMainDimensionByDimType(DimensionType.METRIC);
            MetricMember planRefMetric = metricDim.getAllDimMemberList().stream().map(item -> (MetricMember)item).filter(item -> item.getTemplateMetricType() == TemplateMetricType.PLANREFERENCEAMT).findFirst().get();
            needSumMetricS.add(planRefMetric);
        }
        logger.info("\u7f16\u62a5\u4e3b\u4f53\u6570\u636e\u6c47\u603b\uff0c{}\uff0c{},{}", new Object[]{reportPlanList.size(), sumPlanReport.getId(), sumStatus, null});
        if (sumPlanReport.getProcessStatus() != ReportProcessStatus.SAVE) {
            return FpmOperateResult.error(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8ba1\u5212\u7f16\u5236\u5355\u636e\u3010%1$s\u3011\u6240\u5173\u8054\u7684\u4e0a\u7ea7\u6c47\u603b\u5355\u636e\u3010%2$s\u3011\u4e3a\u975e\u6682\u5b58\u72b6\u6001\u3002", (String)"SumPlanService_3", (String)"tmc-fpm-business", (Object[])new Object[0]), reportPlanList.get(0).getName(), sumPlanReport.getName()));
        }
        SumOrCancelPlanReportUpperParam upperParam = new SumOrCancelPlanReportUpperParam();
        upperParam.setReportPlanList(reportPlanList);
        upperParam.setSumPlanReport(sumPlanReport);
        upperParam.setSystem(system);
        upperParam.setSumStatus(sumStatus);
        upperParam.setNeedSumMetricS(needSumMetricS);
        return this.doSumOrCancelPlanReportUpper(upperParam);
    }

    @Override
    public FpmOperateResult<SumPlanUpdateInfo> sumPlanReportChangeUpper(List<Report> reportPlanList, SumPlanReport sumPlanReport, FundPlanSystem fundPlanSystem) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(reportPlanList) || Objects.isNull(sumPlanReport)) {
            return FpmOperateResult.error(ResManager.loadKDString((String)"\u53c2\u6570\u5f02\u5e38\uff0c\u7f16\u5236\u8868\u6570\u636e\u6216\u6c47\u603b\u8868\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SumPlanService_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        if (sumPlanReport.getProcessStatus() != ReportProcessStatus.AUDIT) {
            return FpmOperateResult.error(String.format(ResManager.loadKDString((String)"\u8c03\u6574\u5ba1\u6838\u4e0a\u6c47\u5931\u8d25\uff0c\u8ba1\u5212\u7f16\u5236\u5355\u636e\u3010%1$s\u3011\u6240\u5173\u8054\u7684\u4e0a\u7ea7\u6c47\u603b\u5355\u636e\u3010%2$s\u3011\u4e3a\u975e\u5ba1\u6838\u72b6\u6001\u3002", (String)"SumPlanService_10", (String)"tmc-fpm-business", (Object[])new Object[0]), reportPlanList.stream().map(Report::getNumber).collect(Collectors.joining(",")), sumPlanReport.getNumber()));
        }
        logger.info("\u8c03\u6574\u5ba1\u6838\u4e0a\u6c47\uff0c\u8ba1\u5212\u7f16\u5236\u5355\u636e[{}]\uff0c\u4e0a\u7ea7\u6c47\u603b\u5355\u636e[{}]", (Object)reportPlanList.stream().map(Report::getId).map(String::valueOf).collect(Collectors.joining(",")), (Object)sumPlanReport.getId());
        return this.dealSumPlanReportChangeUpper(reportPlanList, sumPlanReport, fundPlanSystem);
    }

    @Override
    public FpmOperateResult<SumPlanUpdateInfo> rebuildSumReportData(SumOrCancelPlanReportUpperParam upperParam) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(upperParam.getReportPlanList()) || Objects.isNull(upperParam.getSumPlanReport())) {
            return FpmOperateResult.error(ResManager.loadKDString((String)"\u53c2\u6570\u5f02\u5e38\uff0c\u7f16\u5236\u8868\u6570\u636e\u6216\u6c47\u603b\u8868\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SumPlanService_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty(upperParam.getNeedSumMetricS())) {
            upperParam.setNeedSumMetricS(MetricValueUtils.listAllBaseMetricMember(upperParam.getSystem()));
        }
        return this.doSumOrCancelPlanReportUpper(upperParam);
    }

    private FpmOperateResult<SumPlanUpdateInfo> doSumOrCancelPlanReportUpper(SumOrCancelPlanReportUpperParam upperParam) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan("sumOrSubDownReportDataToUpper");){
            List<Report> reportPlanList = upperParam.getReportPlanList();
            SumPlanReport sumPlanReport = upperParam.getSumPlanReport();
            SunReportSumStatus sumStatus = upperParam.getSumStatus();
            FundPlanSystem system = upperParam.getSystem();
            SumPlanUpdateInfo sumPlanUpdateInfo = new SumPlanUpdateInfo(sumPlanReport);
            Predicate<Report> skip = Objects.equals(upperParam.getBusinessType(), "REBUILD_SUM_REPORT_DATA") ? report -> false : this.needSkip(sumPlanReport, sumStatus);
            Function<Report, Set<Long>> skipSubjectMemIdSetFunction = this.getSkipSubjectMemIdSetFunction(reportPlanList);
            Consumer<Long> addOrUpdateReportSumRecordConsumer = this.addOrUpdateReportSumRecord(sumPlanUpdateInfo, sumStatus);
            QueryIndexInfo<Object, ReportData> queryIndexInfo = sumPlanReport.getQueryIndexInfo(system);
            span.addTag("foreach sum Report");
            for (Report planReport : reportPlanList) {
                Long planReportId = planReport.getId();
                logger.info("\u8ba1\u5212\u7f16\u5236\u5b50\u8868\u6570\u636e\u6c47\u603b\uff1areportId:{}", (Object)planReportId);
                ReportTemplate template = planReport.getTemplate();
                if (skip.test(planReport)) continue;
                span.addTag("foreach sum Report skipSubjectMemIdSet");
                Set<Long> skipSubjectMemIdSet = skipSubjectMemIdSetFunction.apply(planReport);
                span.addTag("foreach sum Report addOrUpdateReportSumRecordConsumer");
                addOrUpdateReportSumRecordConsumer.accept(planReportId);
                List<ReportData> reportDataList = planReport.getReportDataList();
                if (EmptyUtil.isEmpty(reportDataList)) continue;
                span.addTag("foreach sum Report getReportDataFilter");
                Predicate<ReportData> filter = this.getReportDataFilter(skipSubjectMemIdSet, template);
                span.addTag("foreach sum Report getReportDataSumFunction");
                Consumer<ReportData> reportDataSumFunction = this.getReportDataSumFunction(sumPlanUpdateInfo, queryIndexInfo, upperParam);
                span.addTag("foreach sum Report ReportDataSum");
                reportDataList.stream().filter(filter).forEach(reportDataSumFunction);
            }
            FpmOperateResult<SumPlanUpdateInfo> fpmOperateResult = FpmOperateResult.success(sumPlanUpdateInfo);
            return fpmOperateResult;
        }
    }

    private Predicate<ReportData> getReportDataFilter(Set<Long> skipSubjectMemIdSet, ReportTemplate template) {
        List tplDimIdList = template.getAllTemplateDim().stream().map(TemplateDim::getDimensionId).collect(Collectors.toList());
        return reportData -> {
            if (reportData.isAuxiliaryInfo()) {
                return false;
            }
            if (!StringUtils.isEmpty((Object)reportData.getRemark()) || reportData.getDimList().size() < tplDimIdList.size()) {
                return false;
            }
            Object currSubjectId = reportData.getDimValByDimType(DimensionType.SUBJECTS);
            return !skipSubjectMemIdSet.contains(currSubjectId);
        };
    }

    private Consumer<ReportData> getReportDataSumFunction(SumPlanUpdateInfo sumPlanUpdateInfo, QueryIndexInfo<Object, ReportData> queryIndexInfo, SumOrCancelPlanReportUpperParam upperParam) {
        SumPlanReport sumPlanReport = sumPlanUpdateInfo.getSumPlanReport();
        if (Objects.isNull(sumPlanReport)) {
            return reportData -> {};
        }
        SunReportSumStatus sumStatus = upperParam.getSumStatus();
        List<MetricMember> needSumMetricS = upperParam.getNeedSumMetricS();
        OrgMember sumOrgMember = sumPlanReport.getCompanyMemberList().get(0);
        Long sumOrgMemberId = sumOrgMember.getId();
        ReportTemplate template = sumPlanReport.getTemplate();
        return reportData -> {
            ReportData sumReportData;
            DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.replaceSumOrgFromDownDimensionInfo(reportData, sumOrgMemberId);
            List list = queryIndexInfo.findList(dimensionInfoBean);
            if (list.size() > 1 && (list = list.stream().filter(rd -> Objects.equals(dimensionInfoBean, DimensionInfoHelper.getDimensionInfoBean(rd))).collect(Collectors.toList())).size() > 1) {
                logger.info("\u6c47\u603b\u8868\u4e2d\u6570\u636e\u5f02\u5e38\uff0c\u540c\u4e00\u7ef4\u5ea6\u7ec4\u5408\u4e0b\u5b58\u5728\u591a\u4e2a\u6570\u636e,\u3010{}\u3011,\u3010{}\u3011,\u3010{}\u3011,\u3010{}\u3011,\u3010{}\u3011", new Object[]{reportData.getId(), list, sumPlanReport.getName(), dimensionInfoBean.getDimensionIdList(), dimensionInfoBean.getMemberIdList()});
                throw new KDBizException(ResManager.loadKDString((String)"\u6c47\u603b\u8868\u4e2d\u6570\u636e\u5f02\u5e38\uff0c\u540c\u4e00\u7ef4\u5ea6\u7ec4\u5408\u4e0b\u5b58\u5728\u591a\u4e2a\u6570\u636e", (String)"SumPlanService_4", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isEmpty(list) && sumStatus == SunReportSumStatus.CANCEL) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6c47\u603b\u8868\u6570\u636e\u5f02\u5e38\uff0c\u4e3b\u8868\u4e2d\u672a\u627e\u5230\u76f8\u5173\u7ef4\u5ea6\u6570\u636e\uff0c%1$s", (String)"SumPlanService_5", (String)"tmc-fpm-business", (Object[])new Object[0]), sumPlanReport.getName()));
            }
            if (list.size() == 1) {
                sumReportData = (ReportData)list.get(0);
                sumPlanUpdateInfo.addUpdateReportData(sumReportData);
            } else {
                TemplateDim templateDim;
                sumReportData = new ReportData((ReportData)reportData);
                List<TemplateDim> dimList = sumReportData.getDimList();
                int index = dimList.indexOf(templateDim = (TemplateDim)dimList.stream().filter(dim -> dim.getDimType() == DimensionType.ORG).findFirst().orElse(null));
                if (index != -1) {
                    sumReportData.getDimValList().set(index, sumOrgMemberId);
                }
                sumReportData.setReportId(sumPlanUpdateInfo.getSumPlanReport().getId());
                sumReportData.setId(DB.genGlobalLongId());
                sumReportData.setRemark(null);
                sumReportData.setEffectFlag(false);
                sumReportData.setSystemId(reportData.getSystemId());
                sumReportData.setMainTable(template.isMainTable());
                sumReportData.setAmountUnit(template.getAmountUnit());
                sumReportData.setPlanAmt(BigDecimal.ZERO);
                sumReportData.setLockAmt(BigDecimal.ZERO);
                sumReportData.setActAmt(BigDecimal.ZERO);
                sumReportData.setReportPlanAmt(BigDecimal.ZERO);
                sumReportData.setOriginalPlanAmt(BigDecimal.ZERO);
                sumReportData.setSourceIdList(new ArrayList<Long>(8));
                queryIndexInfo.updateIndex(new WarpBean<Long, ReportData>(sumReportData.getId(), dimensionInfoBean, sumReportData));
                sumPlanUpdateInfo.addSaveReportData(sumReportData);
            }
            List<Long> sourceIdList = sumReportData.getSourceIdList();
            if (!sourceIdList.contains(reportData.getId())) {
                sourceIdList.add(reportData.getId());
                sumPlanUpdateInfo.addSaveSourceIdEntryData(new SourceIdEntryData(sumReportData.getReportId(), sumReportData.getId(), reportData.getId()));
            }
            List<TemplateMetricType> templateMetricTypes = needSumMetricS.stream().map(MetricMember::getTemplateMetricType).collect(Collectors.toList());
            Consumer<ReportData> sumReportDataConsumer = Objects.equals(upperParam.getBusinessType(), "REBUILD_SUM_REPORT_DATA") ? this.rebuildSumReportDataConsumer(sumReportData, templateMetricTypes, amt -> sumStatus == SunReportSumStatus.SUM ? amt : amt.negate()) : this.getSumReportDataConsumer(sumReportData, templateMetricTypes, amt -> sumStatus == SunReportSumStatus.SUM ? amt : amt.negate());
            sumReportDataConsumer.accept((ReportData)reportData);
        };
    }

    private Consumer<Long> addOrUpdateReportSumRecord(SumPlanUpdateInfo sumPlanUpdateInfo, SunReportSumStatus sumStatus) {
        SumPlanReport sumPlanReport = sumPlanUpdateInfo.getSumPlanReport();
        if (Objects.isNull(sumPlanReport)) {
            return reportId -> {};
        }
        List<SumPlanReport.SunReportSumRecord> sunReportSumRecordList = sumPlanReport.getSunReportSumRecordList();
        Map reportSumRecordMap = sunReportSumRecordList.stream().filter(Objects::nonNull).collect(Collectors.toMap(SumPlanReport.SunReportSumRecord::getSunReportId, Function.identity(), (a, b) -> a));
        return reportId -> {
            SumPlanReport.SunReportSumRecord sunReportSumRecord = (SumPlanReport.SunReportSumRecord)reportSumRecordMap.get(reportId);
            if (Objects.nonNull(sunReportSumRecord)) {
                sunReportSumRecord.setSumStatus(sumStatus);
                sumPlanUpdateInfo.addUpdateReportSumRecord(sunReportSumRecord);
                return;
            }
            sunReportSumRecord = new SumPlanReport.SunReportSumRecord();
            sunReportSumRecord.setSunReportId((Long)reportId);
            sunReportSumRecord.setSumStatus(SunReportSumStatus.SUM);
            sumPlanUpdateInfo.addSaveReportSumRecord(sunReportSumRecord);
        };
    }

    private Function<Report, Set<Long>> getSkipSubjectMemIdSetFunction(List<Report> reportPlanList) {
        List planReportTemplateList = reportPlanList.stream().map(Report::getTemplate).collect(Collectors.toList());
        Set mainReportNotDetailSubjects = planReportTemplateList.stream().filter(ReportTemplate::isMainTable).map(ReportTemplate::getAccountSettings).flatMap(Collection::stream).filter(item -> item.getInputType() != ReportInputType.DETAIL_INPUT).map(TemplateAccountSetting::getAccountMemId).collect(Collectors.toSet());
        return planReport -> {
            ReportTemplate template = planReport.getTemplate();
            if (template.isMainTable()) {
                return Collections.emptySet();
            }
            return mainReportNotDetailSubjects;
        };
    }

    private Predicate<Report> needSkip(SumPlanReport sumPlanReport, SunReportSumStatus sumStatus) {
        List<SumPlanReport.SunReportSumRecord> sunReportSumRecordList = sumPlanReport.getSunReportSumRecordList();
        Map reportSumStatusMap = sunReportSumRecordList.stream().filter(Objects::nonNull).collect(Collectors.toMap(SumPlanReport.SunReportSumRecord::getSunReportId, Function.identity(), (a, b) -> a));
        return planReport -> {
            ReportTemplate template = planReport.getTemplate();
            TemplateType templateType = template.getTemplateType();
            if (templateType == TemplateType.DETAIL) {
                logger.info("\u660e\u7ec6\u8868\u4e0d\u6c47\u603b");
                return true;
            }
            Long planReportId = planReport.getId();
            if (!reportSumStatusMap.containsKey(planReportId)) {
                if (sumStatus == SunReportSumStatus.CANCEL) {
                    logger.info("\u7f16\u5236\u8868\u672a\u6c47\u603b\u8fc7\u65e0\u9700\u64a4\u56de");
                    return true;
                }
                logger.info("\u7f16\u5236\u8868:{}\u9996\u6b21\u6c47\u603b\u5230\u6c47\u603b\u8868\uff1a{}", (Object)planReportId, (Object)sumPlanReport.getNumber());
                return false;
            }
            SunReportSumStatus sunReportSumStatus = ((SumPlanReport.SunReportSumRecord)reportSumStatusMap.get(planReportId)).getSumStatus();
            if (sunReportSumStatus == sumStatus) {
                logger.info("\u6c47\u603b\u8868\u5df2" + (sunReportSumStatus == SunReportSumStatus.SUM ? "\u6c47\u603b" : "\u64a4\u56de") + "\u8fc7\u5f53\u524d\u7f16\u5236\u8868\uff0creportId\uff1a{}\uff0csumReportId:{}", (Object)planReportId, (Object)sumPlanReport.getId());
                return true;
            }
            return false;
        };
    }

    private List<List<Long>> descartes(List<List<Long>> dimScopeListS) {
        List<List<Long>> resultList = new ArrayList<List<Long>>(16);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(dimScopeListS)) {
            return resultList;
        }
        for (List<Long> currDimScopeList : dimScopeListS) {
            if (resultList.isEmpty()) {
                resultList = currDimScopeList.stream().map(item -> Collections.singletonList(item)).collect(Collectors.toList());
                continue;
            }
            resultList = resultList.stream().map(item -> currDimScopeList.stream().map(item2 -> {
                ArrayList<Long> item2List = new ArrayList<Long>((Collection<Long>)item);
                item2List.add((Long)item2);
                return item2List;
            }).collect(Collectors.toList())).flatMap(o -> o.stream()).collect(Collectors.toList());
        }
        return resultList;
    }

    private FpmOperateResult<SumPlanUpdateInfo> sdkReportPlanReportUpperSum(List<Report> reportPlanList, SumPlanReport sumPlanReport, SunReportSumStatus sumStatus, FundPlanSystem system, List<MetricMember> needSumMetricS) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan("sumOrSubDownReportDataToUpper");){
            SumPlanUpdateInfo sumPlanUpdateInfo = new SumPlanUpdateInfo(sumPlanReport);
            Predicate<Report> skipPlanReportIfNonMainTable = report -> !report.getTemplate().isMainTable();
            Predicate<ReportData> dirtyReportDataPredicate = reportData -> Objects.nonNull(reportData.isDirty()) && reportData.isDirty() != false;
            List<Long> allSourceIds = reportPlanList.stream().map(Report::getReportDataList).filter(Objects::nonNull).flatMap(Collection::stream).filter(dirtyReportDataPredicate).map(ReportData::getId).collect(Collectors.toList());
            Map<Long, List<ReportData>> sourceId2SumReportDataMap = this.getSourceId2ReportDataMap(sumPlanReport.getId(), allSourceIds);
            span.addTag("foreach sum Report");
            for (Report planReport : reportPlanList) {
                List<ReportData> reportDataList;
                Long planReportId = planReport.getId();
                logger.info("\u8ba1\u5212\u7f16\u5236\u5b50\u8868\u6570\u636e\u6c47\u603b\uff1areportId:{}", (Object)planReportId);
                if (skipPlanReportIfNonMainTable.test(planReport) || EmptyUtil.isEmpty(reportDataList = planReport.getReportDataList())) continue;
                span.addTag("foreach sum Report ReportDataSum");
                reportDataList.stream().filter(dirtyReportDataPredicate).forEach(data -> this.dealReportDataSum((ReportData)data, sumPlanUpdateInfo, needSumMetricS, sourceId2SumReportDataMap));
            }
            FpmOperateResult<SumPlanUpdateInfo> fpmOperateResult = FpmOperateResult.success(sumPlanUpdateInfo);
            return fpmOperateResult;
        }
    }

    private void dealReportDataSum(ReportData reportData, SumPlanUpdateInfo sumPlanUpdateInfo, List<MetricMember> needSumMetricS, Map<Long, List<ReportData>> sourceId2SumReportDataMap) {
        ReportData sumReportData;
        SumPlanReport sumPlanReport = sumPlanUpdateInfo.getSumPlanReport();
        if (Objects.isNull(sumPlanReport)) {
            return;
        }
        OrgMember sumOrgMember = sumPlanReport.getCompanyMemberList().get(0);
        Long sumOrgMemberId = sumOrgMember.getId();
        ReportTemplate template = sumPlanReport.getTemplate();
        List<TemplateMetricType> templateMetricTypes = needSumMetricS.stream().map(MetricMember::getTemplateMetricType).collect(Collectors.toList());
        List sumReportDataList = sourceId2SumReportDataMap.getOrDefault(reportData.getId(), new LinkedList());
        if (sumReportDataList.size() > 1) {
            logger.info("\u6c47\u603b\u8868\u4e2d\u6570\u636e\u5f02\u5e38\uff0c\u540c\u4e00\u7ef4\u5ea6\u7ec4\u5408\u4e0b\u5b58\u5728\u591a\u4e2a\u6570\u636e,\u3010{}\u3011,\u3010{}\u3011", (Object)reportData.getId(), sumReportDataList.stream().map(ReportData::getId).collect(Collectors.toList()));
            throw new KDBizException(ResManager.loadKDString((String)"\u6c47\u603b\u8868\u4e2d\u6570\u636e\u5f02\u5e38\uff0c\u540c\u4e00\u7ef4\u5ea6\u7ec4\u5408\u4e0b\u5b58\u5728\u591a\u4e2a\u6570\u636e", (String)"SumPlanService_4", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        if (sumReportDataList.size() == 1) {
            sumReportData = (ReportData)sumReportDataList.get(0);
            sumPlanUpdateInfo.addUpdateReportData(sumReportData);
        } else {
            TemplateDim templateDim;
            sumReportData = new ReportData(reportData);
            List<TemplateDim> dimList = sumReportData.getDimList();
            int index = dimList.indexOf(templateDim = (TemplateDim)dimList.stream().filter(dim -> dim.getDimType() == DimensionType.ORG).findFirst().orElse(null));
            if (index != -1) {
                sumReportData.getDimValList().set(index, sumOrgMemberId);
            }
            sumReportData.setReportId(sumPlanUpdateInfo.getSumPlanReport().getId());
            sumReportData.setId(DB.genGlobalLongId());
            sumReportData.setRemark(null);
            sumReportData.setEffectFlag(false);
            sumReportData.setSystemId(reportData.getSystemId());
            sumReportData.setMainTable(template.isMainTable());
            sumReportData.setAmountUnit(template.getAmountUnit());
            sumReportData.setPlanAmt(BigDecimal.ZERO);
            sumReportData.setLockAmt(BigDecimal.ZERO);
            sumReportData.setActAmt(BigDecimal.ZERO);
            sumReportData.setReportPlanAmt(BigDecimal.ZERO);
            sumReportData.setOriginalPlanAmt(BigDecimal.ZERO);
            sumReportData.setSourceIdList(new ArrayList<Long>(8));
            sumPlanReport.getReportDataList().add(sumReportData);
            sumPlanUpdateInfo.addSaveReportData(sumReportData);
        }
        List<Long> sourceIdList = sumReportData.getSourceIdList();
        if (!sourceIdList.contains(reportData.getId())) {
            sourceIdList.add(reportData.getId());
            sumPlanUpdateInfo.addSaveSourceIdEntryData(new SourceIdEntryData(sumReportData.getReportId(), sumReportData.getId(), reportData.getId()));
        }
        MetricValueUtils.updateSDKReportDataDiffAmt(templateMetricTypes, sumReportData, (BatchSaveSDKReportData)reportData);
    }

    private Map<Long, List<ReportData>> getSourceId2ReportDataMap(Long reportId, List<Long> sourceId) {
        IReportRepository iReportRepository = FpmServiceFactory.getBizService(IReportRepository.class);
        Map<Long, List<Long>> sourceId2ReportDataIdMap = iReportRepository.getSourceId2ReportDataIdMap(reportId, sourceId);
        List reportDataIds = sourceId2ReportDataIdMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(reportDataIds)) {
            return new HashMap<Long, List<ReportData>>(1);
        }
        IReportDataQueryService iReportDataQueryService = FpmServiceFactory.getBizService(IReportDataQueryService.class);
        LinkedList<ReportData> allReportDataList = new LinkedList<ReportData>();
        List splitList = ListUtils.splitList(reportDataIds, (long)1000L);
        for (List dataIds : splitList) {
            List<ReportData> queryReportDataList = iReportDataQueryService.queryReportData(t -> {
                t.setIdList(dataIds);
                t.setNeedDimIfValueIsNotEmpty(true);
            });
            allReportDataList.addAll(queryReportDataList);
        }
        Map reportDataMap = allReportDataList.stream().collect(Collectors.toMap(ReportData::getId, Function.identity(), (a1, a2) -> a1));
        HashMap<Long, List<ReportData>> sourceId2ReportDataMap = new HashMap<Long, List<ReportData>>(sourceId2ReportDataIdMap.size(), 1.0f);
        for (Map.Entry<Long, List<Long>> entry : sourceId2ReportDataIdMap.entrySet()) {
            List reportDataList = sourceId2ReportDataMap.computeIfAbsent(entry.getKey(), val -> new LinkedList());
            entry.getValue().stream().map(reportDataMap::get).filter(Objects::nonNull).forEach(reportDataList::add);
        }
        return sourceId2ReportDataMap;
    }

    private FpmOperateResult<SumPlanUpdateInfo> dealSumPlanReportChangeUpper(List<Report> reportPlanList, SumPlanReport sumPlanReport, FundPlanSystem fundPlanSystem) {
        SumPlanUpdateInfo sumPlanUpdateInfo = new SumPlanUpdateInfo(sumPlanReport);
        Predicate<Report> skipPlanReportIfNonMainTable = report -> !report.getTemplate().isMainTable();
        Predicate<ReportData> dirtyReportDataPredicate = reportData -> !reportData.isAuxiliaryInfo() && Objects.nonNull(reportData.isDirty()) && reportData.isDirty() != false;
        List<Long> allSourceIds = reportPlanList.stream().map(Report::getReportDataList).filter(Objects::nonNull).flatMap(Collection::stream).filter(dirtyReportDataPredicate).map(ReportData::getId).collect(Collectors.toList());
        Map<Long, List<ReportData>> sourceId2SumReportDataMap = this.getSourceId2ReportDataMap(sumPlanReport.getId(), allSourceIds);
        List<ReportData> sumReportDataList = sourceId2SumReportDataMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        QueryIndexInfo sumReportQueryIndexInfo = QueryIndexInfoMapGenerator.buildReportDataIndex(sumReportDataList, fundPlanSystem, rd -> !rd.isAuxiliaryInfo());
        for (Report planReport : reportPlanList) {
            List<ReportData> reportDataList;
            Long planReportId = planReport.getId();
            logger.info("\u8ba1\u5212\u7f16\u5236\u5b50\u8868\u6570\u636e\u6c47\u603b\uff1areportId:{}", (Object)planReportId);
            if (skipPlanReportIfNonMainTable.test(planReport) || EmptyUtil.isEmpty(reportDataList = planReport.getReportDataList())) continue;
            reportDataList.stream().filter(dirtyReportDataPredicate).forEach(data -> this.dealChangeReportDataSum((ReportData)data, sumPlanUpdateInfo, sourceId2SumReportDataMap, sumReportQueryIndexInfo, planReport.getTemplate()));
        }
        return FpmOperateResult.success(sumPlanUpdateInfo);
    }

    private void dealChangeReportDataSum(ReportData reportData, SumPlanUpdateInfo sumPlanUpdateInfo, Map<Long, List<ReportData>> sourceId2SumReportDataMap, QueryIndexInfo<Object, ReportData> sumReportQueryIndexInfo, ReportTemplate reportTemplate) {
        ReportData sumReportData;
        SumPlanReport sumPlanReport = sumPlanUpdateInfo.getSumPlanReport();
        if (Objects.isNull(sumPlanReport)) {
            return;
        }
        OrgMember sumOrgMember = sumPlanReport.getCompanyMemberList().get(0);
        Long sumOrgMemberId = sumOrgMember.getId();
        ReportTemplate template = sumPlanReport.getTemplate();
        List sumReportDataList = sourceId2SumReportDataMap.getOrDefault(reportData.getId(), new LinkedList());
        DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBean(reportData, reportTemplate);
        DimensionInfoHelper.replaceDimValue(dimensionInfoBean, sumOrgMember.getDimensionId(), sumOrgMemberId);
        if (sumReportDataList.size() == 1) {
            sumReportData = (ReportData)sumReportDataList.get(0);
            sumPlanUpdateInfo.addUpdateReportData(sumReportData);
        } else {
            if (sumReportDataList.size() > 1 || sumReportQueryIndexInfo.findList(dimensionInfoBean).size() > 1) {
                logger.info("\u6c47\u603b\u8868\u4e2d\u6570\u636e\u5f02\u5e38\uff0c\u540c\u4e00\u7ef4\u5ea6\u7ec4\u5408\u4e0b\u5b58\u5728\u591a\u4e2a\u6570\u636e,\u3010{}\u3011,\u3010{}\u3011", (Object)reportData.getId(), sumReportDataList.stream().map(ReportData::getId).collect(Collectors.toList()));
                throw new KDBizException(ResManager.loadKDString((String)"\u6c47\u603b\u8868\u4e2d\u6570\u636e\u5f02\u5e38\uff0c\u540c\u4e00\u7ef4\u5ea6\u7ec4\u5408\u4e0b\u5b58\u5728\u591a\u4e2a\u6570\u636e", (String)"SumPlanService_4", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            if (sumReportQueryIndexInfo.findList(dimensionInfoBean).size() == 1) {
                sumReportData = sumReportQueryIndexInfo.findList(dimensionInfoBean).get(0);
                sumReportData.setDimList(new ArrayList<TemplateDim>(reportData.getDimList()));
                sumReportData.setDimValList(new ArrayList<Object>(reportData.getDimValList()));
                int index = IntStream.range(0, sumReportData.getDimList().size()).filter(i -> sumReportData.getDimList().get(i).getDimType() == DimensionType.ORG).findAny().getAsInt();
                if (index != -1) {
                    sumReportData.getDimValList().set(index, sumOrgMemberId);
                }
                sumPlanUpdateInfo.addUpdateReportData(sumReportData);
            } else {
                TemplateDim templateDim;
                sumReportData = new ReportData(reportData);
                List<TemplateDim> dimList = sumReportData.getDimList();
                int index = dimList.indexOf(templateDim = (TemplateDim)dimList.stream().filter(dim -> dim.getDimType() == DimensionType.ORG).findFirst().orElse(null));
                if (index != -1) {
                    sumReportData.getDimValList().set(index, sumOrgMemberId);
                }
                sumReportData.setReportId(sumPlanUpdateInfo.getSumPlanReport().getId());
                sumReportData.setId(DB.genGlobalLongId());
                sumReportData.setRemark(null);
                sumReportData.setEffectFlag(false);
                sumReportData.setSystemId(reportData.getSystemId());
                sumReportData.setMainTable(template.isMainTable());
                sumReportData.setAmountUnit(template.getAmountUnit());
                sumReportData.setPlanAmt(BigDecimal.ZERO);
                sumReportData.setLockAmt(BigDecimal.ZERO);
                sumReportData.setActAmt(BigDecimal.ZERO);
                sumReportData.setReportPlanAmt(BigDecimal.ZERO);
                sumReportData.setOriginalPlanAmt(BigDecimal.ZERO);
                sumReportData.setSourceIdList(new ArrayList<Long>(8));
                sumPlanReport.getReportDataList().add(sumReportData);
                sumPlanUpdateInfo.addSaveReportData(sumReportData);
            }
        }
        List<Long> sourceIdList = sumReportData.getSourceIdList();
        if (!sourceIdList.contains(reportData.getId())) {
            sourceIdList.add(reportData.getId());
            sumPlanUpdateInfo.addSaveSourceIdEntryData(new SourceIdEntryData(sumReportData.getReportId(), sumReportData.getId(), reportData.getId()));
        }
        MetricValueUtils.incrementalUpdateReportDataAmt(Collections.singletonList(TemplateMetricType.PLANAMT), sumReportData, reportData);
    }
}

