/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.AnalysisReport;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.IDimensionMemberStrategy;
import org.apache.commons.collections.CollectionUtils;

public class SynthesisPeriodMemberStrategy
implements IDimensionMemberStrategy {
    private AnalysisReport analysisReport;

    public SynthesisPeriodMemberStrategy(AnalysisReport analysisReport) {
        this.analysisReport = analysisReport;
    }

    @Override
    public List<?> getMemberScope(Dimension dimension, TemplateDim periodDim) {
        if (!dimension.getDimType().isPeriodDim()) {
            return null;
        }
        ReportPeriodType reportPeriodType = this.analysisReport.getReportPeriodType();
        PeriodType periodType = reportPeriodType.getPeriodType();
        ArrayList<PeriodMember> reportPeriodMemList = new ArrayList<PeriodMember>(10);
        List<PeriodMember> periodList = dimension.getMemberList(PeriodMember.class);
        for (PeriodMember periodMember : periodList) {
            reportPeriodMemList.addAll(periodMember.getAllMemberByPeriodTypeAndPeriodId(periodType, reportPeriodType.getReportPeriodId()));
        }
        List<PeriodMember> periodMemberList = reportPeriodMemList.stream().filter(item -> periodDim.getMemberScope().contains(item.getId())).collect(Collectors.toList());
        if (this.analysisReport.getTemplate().getTemplateType().isDetail()) {
            return this.acquireScopeForDetail(periodMemberList);
        }
        return this.acquireScopeForFix(periodMemberList);
    }

    private List<Long> acquireScopeForFix(List<PeriodMember> periodMemberList) {
        if (!this.analysisReport.isContainDetailReportType()) {
            return periodMemberList.stream().map(DimMember::getId).collect(Collectors.toList());
        }
        List<Long> collect = periodMemberList.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).map(DimMember::getId).collect(Collectors.toList());
        collect.addAll(periodMemberList.stream().map(DimMember::getId).collect(Collectors.toList()));
        return collect;
    }

    private List<Long> acquireScopeForDetail(List<PeriodMember> periodMemberList) {
        ArrayList<Long> collect = new ArrayList<Long>(10);
        for (PeriodMember periodMember : periodMemberList) {
            if (periodMember.getChildren() != null && periodMember.getChildren().size() == 1 && periodMember.getChildren().get(0).getNumber().equals(periodMember.getNumber()) || CollectionUtils.isEmpty(periodMember.getChildren())) {
                collect.add(periodMember.getId());
                continue;
            }
            collect.addAll(periodMember.getAllChildMember().stream().map(DimMember::getId).collect(Collectors.toList()));
        }
        collect.addAll(periodMemberList.stream().map(DimMember::getId).collect(Collectors.toList()));
        return collect;
    }
}

