/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.dataproc.query.ShrekReportDataQueryDTO;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.AnalysisReport;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.service.impl.AbstractAnalysisReportDataService;
import kd.tmc.fpm.business.domain.service.impl.ShrekQueryConditionLogProcessorImpl;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class SynthesisShrekAnalysisReportDataService
extends AbstractAnalysisReportDataService {
    private final IReportDataQueryService reportDataQueryService = FpmServiceFactory.getBizService(IReportDataQueryService.class);

    public SynthesisShrekAnalysisReportDataService(FundPlanSystem fundPlanSystem, AnalysisReport analysisReport, Set<Long> queryAllDimensionIds) {
        super(fundPlanSystem, analysisReport, queryAllDimensionIds);
        this.addQueryConditionProcessor(new ShrekQueryConditionLogProcessorImpl());
    }

    @Override
    protected List<ReportData> queryReportDataList(Long reportTypeId, Long orgId, List<Dimension> dimensionList, List<List<Object>> dimValList) {
        ShrekReportDataQueryDTO queryDTO = new ShrekReportDataQueryDTO();
        queryDTO.setReportTypeId(reportTypeId);
        queryDTO.setOrgId(orgId);
        queryDTO.setDimIdList(dimensionList);
        queryDTO.setDimValIdList(dimValList);
        queryDTO.setMainTable(true);
        queryDTO.setEffectFlag(Boolean.TRUE);
        queryDTO.setSystem(this.fundPlanSystem);
        queryDTO.setQueryAllDimensionIds(this.queryAllDimensionIds);
        queryDTO.setDynamicCalculate(true);
        this.beforeSearch(queryDTO);
        if (!queryDTO.isNeedSearch()) {
            return new ArrayList<ReportData>();
        }
        List<ReportDataQueryResult> resultList = this.reportDataQueryService.queryReportDataByShrek(queryDTO);
        return ReportHelper.convert(resultList);
    }

    @Override
    protected List<ReportData> queryAllDimReportDataList(Long reportTypeId, Long orgId, List<Dimension> dimensionList, List<List<Object>> dimValList) {
        ShrekReportDataQueryDTO queryDTO = new ShrekReportDataQueryDTO();
        queryDTO.setReportTypeId(reportTypeId);
        queryDTO.setOrgId(orgId);
        queryDTO.setDimIdList(dimensionList);
        queryDTO.setDimValIdList(dimValList);
        queryDTO.setMainTable(true);
        queryDTO.setEffectFlag(Boolean.TRUE);
        queryDTO.setSystem(this.fundPlanSystem);
        queryDTO.setQueryAllDimensionIds(this.queryAllDimensionIds);
        queryDTO.setDynamicCalculate(true);
        queryDTO.setQueryAllDimData(true);
        this.beforeSearch(queryDTO);
        if (!queryDTO.isNeedSearch()) {
            return new ArrayList<ReportData>();
        }
        List<ReportDataQueryResult> resultList = this.reportDataQueryService.queryReportDataByShrek(queryDTO);
        return ReportHelper.convert(resultList);
    }

    @Override
    protected List<ReportData> queryReportDataList() {
        return null;
    }
}

