/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fpm.business.dataproc.query.ShrekReportDataQueryDTO;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.BillState;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.service.QueryConditionProcessor;
import kd.tmc.fpm.common.property.ReportProp;
import org.apache.commons.collections4.CollectionUtils;

public class SynthesisShrekQueryConditionProcessor
implements QueryConditionProcessor<ShrekReportDataQueryDTO> {
    private static final Log logger = LogFactory.getLog(SynthesisShrekQueryConditionProcessor.class);
    private AnalysisHeader header;

    public SynthesisShrekQueryConditionProcessor(AnalysisHeader analysisHeader) {
        this.header = analysisHeader;
    }

    @Override
    public void beforeSearch(ShrekReportDataQueryDTO shrekReportDataQueryDTO) {
        QFilter qFilter = new QFilter("billstatus", "in", this.header.getBillStateList().stream().map(BillState::getNumber).collect(Collectors.toSet()));
        qFilter.and(new QFilter("planstatus", "in", this.header.getReportStatusList().stream().map(ReportStatus::getVal).collect(Collectors.toSet())));
        qFilter.and(new QFilter("reportperiod.reporttype", "=", (Object)shrekReportDataQueryDTO.getReportTypeId()));
        qFilter.and(new QFilter("bodysys", "=", (Object)shrekReportDataQueryDTO.getSystem().getId()));
        qFilter.and(new QFilter("template.ismaintable", "=", (Object)"1"));
        qFilter.and(new QFilter("reportorg", "=", (Object)shrekReportDataQueryDTO.getOrgId()));
        DynamicObject[] needQueryReports = BusinessDataServiceHelper.load((String)"fpm_report", (String)String.join((CharSequence)",", ReportProp.getBillHeadProp()), (QFilter[])new QFilter[]{qFilter});
        if (needQueryReports == null || needQueryReports.length == 0) {
            shrekReportDataQueryDTO.setNeedSearch(false);
            return;
        }
        ArrayList<DynamicObject> filterReportDOList = new ArrayList<DynamicObject>(needQueryReports.length);
        for (DynamicObject needQueryReport : needQueryReports) {
            if ("sumplan".equals(needQueryReport.getString("reportplantype")) && !ReportStatus.ENABLE.getVal().equals(needQueryReport.getString("planstatus"))) continue;
            String orgName = needQueryReport.getString("reportorg.name");
            String reportPlanType = needQueryReport.getString("reportplantype");
            String planStatus = needQueryReport.getString("planstatus");
            String number = needQueryReport.getString("billno");
            logger.info(String.format("[SynthesisShrekQueryConditionProcessor] >>>>> After Query Filter Added Report:[number:[%s], orgName:[%s], reportPlanType:[%s], reportStatus:[%s]]", number, orgName, reportPlanType, planStatus));
            filterReportDOList.add(needQueryReport);
        }
        if (CollectionUtils.isEmpty(filterReportDOList)) {
            shrekReportDataQueryDTO.setNeedSearch(false);
            return;
        }
        String billStateStr = this.header.getBillStateList().stream().map(BillState::getName).collect(Collectors.joining(","));
        String reportStatusStr = this.header.getReportStatusList().stream().map(ReportStatus::getName).collect(Collectors.joining(","));
        String billNoStr = filterReportDOList.stream().map(o -> o.getString("billno")).collect(Collectors.joining(","));
        logger.info(String.format("[SynthesisShrekQueryConditionProcessor] >>>>> Synthesis MultiDimension Query via bill state:[%s] and report status:[%s], then get reports:[%s]", billStateStr, reportStatusStr, billNoStr));
        List<Long> reportPeriodIdList = filterReportDOList.stream().map(o -> o.getLong(String.join((CharSequence)".", "reportperiod", "id"))).distinct().collect(Collectors.toList());
        shrekReportDataQueryDTO.setEffectFlag(null);
        shrekReportDataQueryDTO.setEffectFlags(Arrays.asList("0", "1"));
        shrekReportDataQueryDTO.setAmountUnitList(AmountUnit.getAmountUnitList());
        shrekReportDataQueryDTO.setReportPeriodList(reportPeriodIdList);
    }
}

