/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DetailDataType;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.TemplateDimMemScopeType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.template.AuxiliaryField;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateBaseInfo;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateLayout;
import kd.tmc.fpm.business.domain.model.template.TemplateReportType;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.ITemplateService;
import kd.tmc.fpm.business.helper.TemplateInfoHelper;
import kd.tmc.fpm.business.mvc.service.dto.TemplateParamDTO;
import kd.tmc.fpm.business.utils.MetricValueUtils;
import kd.tmc.fpm.common.enums.DetailDimTypeEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.MetricMemberTypeEnum;
import kd.tmc.fpm.common.enums.RowColType;
import kd.tmc.fpm.common.utils.DispersionAnalysisUtils;

public class TemplateService
implements ITemplateService {
    private static final String CHECK_SUCCESS = "";
    private static final int STAT_ANALYSIS_TEMPLATE_MAX_COUNT = 10;
    private static Log LOGGER = LogFactory.getLog(TemplateService.class);

    @Override
    public FpmOperateResult<ReportTemplate> newTemplate(FundPlanSystem system, TemplateBaseInfo baseInfo) {
        FpmOperateResult<ReportTemplate> result = new FpmOperateResult<ReportTemplate>();
        ReportTemplate reportTemplate = new ReportTemplate();
        reportTemplate.fillBaseInfo(baseInfo);
        List<Dimension> mainDimList = system.getMainDimList();
        List<Dimension> detailDimList = system.getDetailDimList();
        if (baseInfo.getTemplateType() == TemplateType.DETAIL) {
            this.buildDetailDefaultDimInfo(mainDimList, detailDimList, reportTemplate);
        } else {
            this.buildFixDefaultDimInfo(mainDimList, reportTemplate);
        }
        result.setData(reportTemplate);
        return result;
    }

    private void buildDetailDefaultDimInfo(List<Dimension> mainDimList, List<Dimension> detailDimList, ReportTemplate reportTemplate) {
        List showDetailList;
        int i;
        TemplateLayout templateLayout = new TemplateLayout();
        reportTemplate.setDimLayout(templateLayout);
        templateLayout.setTemplateType(reportTemplate.getTemplateType());
        ArrayList<TemplateDim> pageDimList = new ArrayList<TemplateDim>(3);
        List<Object> finalColDimList = new ArrayList(10);
        ArrayList<TemplateLayout.LayoutInfo> layoutInfoList = new ArrayList<TemplateLayout.LayoutInfo>(10);
        for (i = 0; i < mainDimList.size(); ++i) {
            DimensionType dimType;
            Dimension dimObj = mainDimList.get(i);
            TemplateDim templateDim = new TemplateDim();
            TemplateLayout.LayoutInfo layoutInfo = new TemplateLayout.LayoutInfo();
            layoutInfo.setDimensionId(dimObj.getId());
            layoutInfo.setDimensionName(dimObj.getName());
            layoutInfo.setVisible(true);
            layoutInfo.setLevel(1);
            layoutInfo.setVisible(layoutInfo.isVisible());
            templateDim.setDimensionId(dimObj.getId());
            templateDim.setDimensionName(dimObj.getName());
            templateDim.setVisible(true);
            templateDim.setLevel(1);
            if (DimensionType.SUBJECTS == dimObj.getDimType()) {
                templateDim.setSequence(-2);
            }
            if ((dimType = dimObj.getDimType()) == DimensionType.METRIC) continue;
            if (DimensionType.ORG == dimType || DimensionType.SETTLEMENT_TYPE == dimType) {
                if (DimensionType.ORG == dimType && reportTemplate.getTemplateUse() == TemplateUseType.SUMMARY) {
                    layoutInfo.setDimLocation(DimLocation.COL);
                    finalColDimList.add(templateDim);
                } else {
                    layoutInfo.setDimLocation(DimLocation.PAGE);
                    pageDimList.add(templateDim);
                }
            } else {
                layoutInfo.setDimLocation(DimLocation.COL);
                finalColDimList.add(templateDim);
            }
            layoutInfoList.add(layoutInfo);
        }
        if (detailDimList.size() > 0 && (showDetailList = detailDimList.stream().filter(Dimension::isVisible).collect(Collectors.toList())).size() > 0) {
            for (int i2 = 0; i2 < showDetailList.size(); ++i2) {
                Dimension fieldObj = (Dimension)showDetailList.get(i2);
                TemplateDim templateDim = new TemplateDim();
                templateDim.setDimensionId(fieldObj.getId());
                templateDim.setDimensionName(fieldObj.getName());
                templateDim.setDetailDim(true);
                templateDim.setVisible(true);
                templateDim.setLevel(1);
                if (DetailDimType.PLAN_DATE == fieldObj.getDetailDimType()) {
                    templateDim.setSequence(-1);
                }
                templateDim.setDetailDataType(ITypeEnum.getByNumber(fieldObj.getMemberType().getNumber(), DetailDataType.class));
                finalColDimList.add(templateDim);
            }
        }
        finalColDimList = finalColDimList.stream().sorted(Comparator.comparingInt(TemplateDim::getSequence)).collect(Collectors.toList());
        for (i = 0; i < finalColDimList.size(); ++i) {
            ((TemplateDim)finalColDimList.get(i)).setSequence(i + 1);
        }
        templateLayout.setDimLayoutInfoList(layoutInfoList);
        reportTemplate.setPageDimList(pageDimList);
        reportTemplate.setColDimList(finalColDimList);
    }

    private void buildFixDefaultDimInfo(List<Dimension> mainDimList, ReportTemplate reportTemplate) {
        TemplateLayout templateLayout = new TemplateLayout();
        reportTemplate.setDimLayout(templateLayout);
        templateLayout.setTemplateType(reportTemplate.getTemplateType());
        ArrayList<TemplateDim> pageDimList = new ArrayList<TemplateDim>(3);
        ArrayList<TemplateLayout.LayoutInfo> layoutInfoList = new ArrayList<TemplateLayout.LayoutInfo>(10);
        for (int i = 0; i < mainDimList.size(); ++i) {
            Dimension dimension = mainDimList.get(i);
            TemplateLayout.LayoutInfo layoutInfo = new TemplateLayout.LayoutInfo();
            TemplateDim templateDim = new TemplateDim();
            layoutInfo.setDimensionId(dimension.getId());
            templateDim.setDimensionId(dimension.getId());
            templateDim.setSequence(i + 1);
            DimensionType dimType = dimension.getDimType();
            if (dimType == DimensionType.METRIC) continue;
            if (!this.isCustomDim(dimType)) {
                layoutInfo.setVisible(true);
                templateDim.setVisible(true);
            }
            if (DimensionType.ORG == dimType || this.isCustomDim(dimType) || DimensionType.CURRENCY == dimType) {
                layoutInfo.setLevel(0);
                layoutInfo.setDimLocation(DimLocation.PAGE);
                pageDimList.add(templateDim);
            } else if (DimensionType.SUBJECTS == dimType) {
                layoutInfo.setDimLocation(DimLocation.ROW);
                layoutInfo.setLevel(1);
            } else if (DimensionType.PERIOD == dimType) {
                layoutInfo.setDimLocation(DimLocation.COL);
                layoutInfo.setLevel(1);
            }
            layoutInfoList.add(layoutInfo);
        }
        templateLayout.setDimLayoutInfoList(layoutInfoList);
        reportTemplate.setPageDimList(pageDimList);
    }

    @Override
    public FpmOperateResult checkTemplate(TemplateParamDTO templateParamDTO) {
        String message;
        List<TemplateDim> pageDimList;
        List<TemplateAccountSetting> accountSettings;
        Optional<TemplateAccountSetting> first;
        ReportTemplate template = templateParamDTO.getTemplate();
        FundPlanSystem system = templateParamDTO.getSystem();
        List<ReportTemplate> subTemplateList = templateParamDTO.getSubTemplateList();
        String opType = templateParamDTO.getOpKey();
        TemplateUseType templateUse = template.getTemplateUse();
        List<TemplateDim> allTemplateDim = template.getAllTemplateDim();
        for (TemplateDim templateDim : allTemplateDim) {
            String result;
            Dimension detailDimension;
            List<Long> memberScope = templateDim.getMemberScope();
            if (templateDim.isVisible() && !templateDim.isDetailDim() && templateDim.getDimType() != DimensionType.ORG && templateDim.getDimType() != DimensionType.PERIOD && CollectionUtils.isEmpty(memberScope)) {
                return FpmOperateResult.error(String.format(ResManager.loadKDString((String)"%1$s\u7ef4\u5ea6\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateService_0", (String)"tmc-fpm-business", (Object[])new Object[0]), templateDim.getDimensionName()));
            }
            if (templateDim.isVisible() && templateDim.isDetailDim() && !(detailDimension = system.getDetailDimensionByDetailType(templateDim.getDetailDimType())).isVisible()) {
                return FpmOperateResult.error(String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u8ba1\u5212\u5b57\u6bb5\u3010%1$s\u3011\u5df2\u88ab\u8bbe\u7f6e\u4e3a\u4e0d\u53ef\u89c1\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"TemplateService_1", (String)"tmc-fpm-business", (Object[])new Object[0]), templateDim.getDimensionName()));
            }
            if (templateUse == TemplateUseType.SUMMARY && DimensionType.ORG == templateDim.getDimType() || (result = this.checkMemberScopeSize(100, template.getTemplateType(), templateDim)) == null || result.length() <= 0) continue;
            return FpmOperateResult.error(result);
        }
        TemplateInfoHelper.checkTemplateDimEntry(template);
        if (template.isMainTable() && (first = (accountSettings = template.getAccountSettings()).stream().filter(item -> ReportInputType.DETAIL_INPUT == item.getInputType() && (item.getChildTemplateId() == null || item.getChildTemplateId() == 0L)).findFirst()).isPresent()) {
            return FpmOperateResult.error(ResManager.loadKDString((String)"\u79d1\u76ee\u5c5e\u6027\u8bbe\u7f6e\u4e2d\u5b58\u5728\u586b\u62a5\u65b9\u5f0f\u4e3a\u660e\u7ec6\u586b\u62a5\u4e14\u5173\u8054\u5b50\u8868\u6a21\u677f\u4e3a\u7a7a\u7684\u79d1\u76ee\u3002", (String)"TemplateService_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        List<Long> reportPeriods = template.getReportPeriods();
        List<ReportPeriodType> reportTypeList = system.getReportTypeList();
        List unEnableList = reportTypeList.stream().filter(item -> reportPeriods.contains(item.getReportPeriodId()) && !item.isEnable()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(unEnableList)) {
            return FpmOperateResult.error(String.format(ResManager.loadKDString((String)"\u6a21\u677f\u4e2d\u5f15\u7528\u7684\u7f16\u62a5\u7c7b\u578b\u5df2\u5728\u4f53\u7cfb%1$s\u4e2d\u7981\u7528\uff0c\u8bf7\u5728\u6a21\u677f\u57fa\u672c\u4fe1\u606f\u4e2d\u8fdb\u884c\u8c03\u6574\u3002", (String)"TemplateService_3", (String)"tmc-fpm-business", (Object[])new Object[0]), system.getName()));
        }
        List<TemplateReportType> templateReportTypeList = template.getReportTypeList();
        if (!CollectionUtils.isEmpty(templateReportTypeList)) {
            List auxiliaryList = templateReportTypeList.stream().filter(item -> !CollectionUtils.isEmpty(item.getAuxiliaryFieldList())).filter(item -> item.getAuxiliaryFieldList().stream().anyMatch(aux -> !aux.isEnable())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(auxiliaryList)) {
                String name = auxiliaryList.stream().map(TemplateReportType::getAuxiliaryFieldList).flatMap(Collection::stream).map(AuxiliaryField::getName).collect(Collectors.joining(","));
                return FpmOperateResult.error(String.format(ResManager.loadKDString((String)"\u6a21\u677f\u4e2d\u5f15\u7528\u7684\u53c2\u8003\u8f85\u52a9\u5217\u5b57\u6bb5\u3010%1$s\u3011\u5df2\u7981\u7528\uff0c\u8bf7\u5728\u6a21\u677f\u57fa\u672c\u4fe1\u606f\u4e2d\u8fdb\u884c\u8c03\u6574\u3002", (String)"TemplateService_4", (String)"tmc-fpm-business", (Object[])new Object[0]), name));
            }
            String errorMsg = this.checkReferencePos(templateReportTypeList);
            if (EmptyUtil.isNoEmpty((String)errorMsg)) {
                return FpmOperateResult.error(errorMsg);
            }
        }
        if (template.isMainTable() && !CollectionUtils.isEmpty(subTemplateList)) {
            List mainDimList = template.getAllTemplateDim().stream().map(TemplateDim::getDimensionId).collect(Collectors.toList());
            List<TemplateAccountSetting> accountSettings2 = template.getAccountSettings();
            Map<Long, List<TemplateAccountSetting>> subTplIdAndSetMap = accountSettings2.stream().filter(item -> item.getChildTemplateId() != null && !item.getChildTemplateId().equals(0L)).collect(Collectors.groupingBy(TemplateAccountSetting::getChildTemplateId));
            for (ReportTemplate reportTemplate : subTemplateList) {
                List currDimIdList = reportTemplate.getAllTemplateDim().stream().map(TemplateDim::getDimensionId).collect(Collectors.toList());
                if (mainDimList.size() > currDimIdList.size() || !currDimIdList.containsAll(mainDimList)) {
                    return FpmOperateResult.error(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u6240\u5173\u8054\u7684\u5b50\u8868\u3010%1$s\u3011\u7ef4\u5ea6\u5c0f\u4e8e\u5f53\u524d\u6a21\u677f\u7ef4\u5ea6\u3002", (String)"TemplateService_5", (String)"tmc-fpm-business", (Object[])new Object[0]), reportTemplate.getNumber()));
                }
                if (opType.equals("releaseop") && !reportTemplate.isRelease()) {
                    return FpmOperateResult.error(String.format(ResManager.loadKDString((String)"\u6240\u5173\u8054\u7684\u5b50\u8868\u3010%1$s\u3011\u672a\u53d1\u5e03\u3002", (String)"TemplateService_6", (String)"tmc-fpm-business", (Object[])new Object[0]), reportTemplate.getNumber()));
                }
                TemplateDim subSubjectTplDim = reportTemplate.getAllTemplateDim().stream().filter(item -> item.getDimType() == DimensionType.SUBJECTS).findFirst().get();
                List<TemplateAccountSetting> acctSetting = subTplIdAndSetMap.get(reportTemplate.getId());
                List mainSpSubjectIdS = acctSetting.stream().map(TemplateAccountSetting::getAccountMemId).collect(Collectors.toList());
                ArrayList mainSpSubjectS = new ArrayList(mainSpSubjectIdS);
                mainSpSubjectS.removeAll(subSubjectTplDim.getMemberScope());
                if (!CollectionUtils.isEmpty(mainSpSubjectS)) {
                    Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
                    List<DimMember> allDimMemberList = subjectDim.getAllDimMemberList();
                    List collect = allDimMemberList.stream().filter(item -> mainSpSubjectS.contains(item.getId())).map(DimMember::getName).collect(Collectors.toList());
                    return FpmOperateResult.error(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u4e3b\u8868\u6a21\u677f\u7684\u8ba1\u5212\u79d1\u76ee\u3010%1$s\u3011\u6240\u5173\u8054\u7684\u5b50\u8868\u6a21\u677f\u4e2d\u4e0d\u542b\u8be5\u8ba1\u5212\u79d1\u76ee\uff0c\u8bf7\u786e\u8ba4\u6a21\u677f\u79d1\u76ee\u5c5e\u6027\u8bbe\u7f6e\u7684\u5173\u8054\u5b50\u8868\u6a21\u677f\u4fe1\u606f\u6216\u68c0\u67e5\u5173\u8054\u5b50\u8868\u6a21\u677f\u914d\u7f6e\u9879\u3002", (String)"TemplateService_7", (String)"tmc-fpm-business", (Object[])new Object[0]), String.join((CharSequence)";", collect)));
                }
                TemplateDim currencyTplDim = template.getAllTemplateDim().stream().filter(item -> item.getDimType() == DimensionType.CURRENCY).findFirst().get();
                TemplateDim subCurrencyTplDim = reportTemplate.getAllTemplateDim().stream().filter(item -> item.getDimType() == DimensionType.CURRENCY).findFirst().get();
                ArrayList<Long> mainSpCurrencyS = new ArrayList<Long>(currencyTplDim.getMemberScope());
                mainSpCurrencyS.removeAll(subCurrencyTplDim.getMemberScope());
                if (!CollectionUtils.isEmpty(mainSpCurrencyS)) {
                    return FpmOperateResult.error(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4e3b\u8868\u6a21\u677f\u4e0d\u5141\u8bb8\u5b58\u5728\u591a\u4e8e\u5173\u8054\u7684\u5b50\u8868\u6a21\u677f\u7684\u9002\u7528\u5e01\u79cd\u6210\u5458\u8303\u56f4\uff0c\u8bf7\u786e\u8ba4\u4e3b\u5b50\u8868\u6a21\u677f\u7684\u5e01\u79cd\u6210\u5458\u8303\u56f4\u3002", (String)"TemplateService_8", (String)"tmc-fpm-business", (Object[])new Object[0]));
                }
                List reportTypeIds = template.getReportTypeList().stream().map(TemplateReportType::getReportTypeId).collect(Collectors.toList());
                List subReportTypeIds = reportTemplate.getReportTypeList().stream().map(TemplateReportType::getReportTypeId).collect(Collectors.toList());
                ArrayList mainReportTypeIds = new ArrayList(reportTypeIds);
                mainReportTypeIds.removeAll(subReportTypeIds);
                if (CollectionUtils.isEmpty(mainReportTypeIds)) continue;
                return FpmOperateResult.error(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4e3b\u8868\u6a21\u677f\u4e0d\u5141\u8bb8\u5b58\u5728\u591a\u4e8e\u5173\u8054\u7684\u5b50\u8868\u6a21\u677f\u7684\u9002\u7528\u7f16\u62a5\u7c7b\u578b\u8303\u56f4\uff0c\u8bf7\u786e\u8ba4\u4e3b\u5b50\u8868\u6a21\u677f\u7684\u9002\u7528\u7f16\u62a5\u7c7b\u578b\u8303\u56f4\u3002", (String)"TemplateService_9", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
        }
        if ((pageDimList = template.getPageDimList()).size() > 2 && pageDimList.stream().filter(item -> item.getMemberScope().size() > 1).count() > 1L) {
            return FpmOperateResult.error(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5b58\u5728\u591a\u4e2a\u201c\u7ef4\u5ea6\u6210\u5458\u6570\u91cf\u8d85\u8fc7\u4e24\u4e2a\u53ca\u4ee5\u4e0a\u201d\u7684\u9875\u9762\u7ef4\uff0c\u8bf7\u786e\u8ba4\u9875\u9762\u7ef4\u7684\u7ef4\u5ea6\u6210\u5458\u4fe1\u606f\u6216\u8c03\u6574\u7ef4\u5ea6\u5e03\u5c40\u3002", (String)"TemplateService_10", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        if (template.isRemarkVisible()) {
            boolean hasDisable;
            List<Long> remarkFieldList = template.getRemarkFieldList();
            if (EmptyUtil.isEmpty(remarkFieldList)) {
                return FpmOperateResult.error(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u82e5\u5f00\u542f\u4e86\u663e\u793a\u5907\u6ce8\u5217\uff0c\u5219\u201c\u5907\u6ce8\u5217\u5b57\u6bb5\u9009\u62e9\u201d\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"TemplateService_11", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            List<AuxiliaryField> remarkEntityList = template.getRemarkEntityList();
            if (!CollectionUtils.isEmpty(remarkEntityList) && (hasDisable = remarkEntityList.stream().anyMatch(item -> !item.isEnable()))) {
                return FpmOperateResult.error(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5907\u6ce8\u5217\u5b57\u6bb5\u5df2\u7981\u7528\u3002", (String)"TemplateService_12", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
        }
        if (EmptyUtil.isNoEmpty((String)(message = this.checkForSumPlan(templateParamDTO, system)))) {
            return FpmOperateResult.error(message);
        }
        message = this.checkForReleaseOrAssign(templateParamDTO);
        if (EmptyUtil.isNoEmpty((String)message)) {
            return FpmOperateResult.error(message);
        }
        return FpmOperateResult.success();
    }

    private String checkReferencePos(List<TemplateReportType> templateReportTypeList) {
        Set referencePosIds = templateReportTypeList.stream().map(TemplateReportType::getReferencePosIds).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_member", (String)String.join((CharSequence)",", "id", "name", "enable"), (QFilter[])new QFilter[]{new QFilter("id", "in", referencePosIds)});
        if (query.size() != referencePosIds.size()) {
            return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u914d\u7f6e\u7684\u53c2\u8003\u6307\u6807\u5b58\u5728\u5df2\u5220\u9664\u7684\u7684\u5ea6\u91cf\u503c\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"TemplateService_13", (String)"tmc-fpm-business", (Object[])new Object[0]), new Object[0]);
        }
        List disableList = query.stream().filter(dy -> !dy.getBoolean("enable")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(disableList)) {
            return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u914d\u7f6e\u7684\u53c2\u8003\u6307\u6807\u3010%1$s\u3011\u4e3a\u4e0d\u53ef\u7528\u72b6\u6001\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"TemplateService_14", (String)"tmc-fpm-business", (Object[])new Object[0]), disableList.stream().map(dy -> dy.getString("name")).collect(Collectors.joining(",")));
        }
        for (TemplateReportType templateReportType : templateReportTypeList) {
            Long referenceReportTypeId = templateReportType.getReferenceReportTypeId();
            if (!EmptyUtil.isNoEmpty((Long)referenceReportTypeId) || !EmptyUtil.isEmpty(templateReportType.getReferencePosIds())) continue;
            return String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u914d\u7f6e\u4e86\u53c2\u8003\u7f16\u62a5\u7c7b\u578b\uff0c\u53c2\u8003\u6307\u6807\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"TemplateService_15", (String)"tmc-fpm-business", (Object[])new Object[0]), QueryServiceHelper.queryOne((String)"fpm_orgreporttype", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateReportType.getReportTypeId())}).getString("name"));
        }
        return CHECK_SUCCESS;
    }

    private String checkMemberScopeSize(int maxSize, TemplateType templateType, TemplateDim templateDim) {
        List<Long> memberScope = templateDim.getMemberScope();
        if (templateDim.getLocation() == DimLocation.PAGE && templateDim.getDimType() != DimensionType.ORG && memberScope.size() > maxSize) {
            return String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011\u7684\u7ef4\u5ea6\u6210\u5458\u6570\u91cf\u4e0d\u53ef\u8d85\u8fc7%3$s\u4e2a\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"TemplateService_16", (String)"tmc-fpm-business", (Object[])new Object[0]), RowColType.getName((String)templateDim.getLocation().getNumber()), templateDim.getDimensionName(), maxSize);
        }
        if (templateType != TemplateType.DETAIL && templateDim.getLocation() == DimLocation.COL && templateDim.getDimType() != DimensionType.PERIOD && memberScope.size() > maxSize) {
            return String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011\u7684\u7ef4\u5ea6\u6210\u5458\u6570\u91cf\u4e0d\u53ef\u8d85\u8fc7%3$s\u4e2a\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"TemplateService_17", (String)"tmc-fpm-business", (Object[])new Object[0]), RowColType.getName((String)templateDim.getLocation().getNumber()), templateDim.getDimensionName(), maxSize);
        }
        if (templateType == TemplateType.DETAIL && templateDim.getLocation() == DimLocation.COL && templateDim.isExpand() && memberScope.size() > maxSize) {
            return String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011\u7684\u7ef4\u5ea6\u6210\u5458\u6570\u91cf\u4e0d\u53ef\u8d85\u8fc7%3$s\u4e2a\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"TemplateService_18", (String)"tmc-fpm-business", (Object[])new Object[0]), RowColType.getName((String)templateDim.getLocation().getNumber()), templateDim.getDimensionName(), maxSize);
        }
        return CHECK_SUCCESS;
    }

    @Override
    public FpmOperateResult<ReportTemplate> updateDimLayout(ReportTemplate template, TemplateLayout layout) {
        TemplateType templateType = template.getTemplateType();
        if (TemplateType.DETAIL == templateType) {
            int i;
            Optional<TemplateDim> planDateColOpt;
            Map dimMap = template.getAllTemplateDim().stream().collect(Collectors.toMap(TemplateDim::getDimensionId, Function.identity()));
            template.setDimLayout(layout);
            List<TemplateLayout.LayoutInfo> layoutInfoList = layout.getColLayout();
            List<TemplateDim> colDimList = template.getColDimList();
            List<TemplateDim> finalColDimList = colDimList.stream().filter(TemplateDim::isDetailDim).collect(Collectors.toList());
            Optional<TemplateDim> planAmountColOpt = finalColDimList.stream().filter(item -> item.getDimensionName().equals(DetailDimTypeEnum.PLAN_AMOUNT.getName())).findFirst();
            if (planAmountColOpt.isPresent()) {
                TemplateDim planAmountColDim = planAmountColOpt.get();
                if (layoutInfoList.stream().filter(TemplateLayout.LayoutInfo::isExpand).findFirst().isPresent()) {
                    planAmountColDim.setVisible(false);
                }
            }
            if ((planDateColOpt = finalColDimList.stream().filter(item -> item.getDimensionName().equals(DetailDimTypeEnum.PLAN_DATE.getName())).findFirst()).isPresent()) {
                TemplateDim planDateColDim = planDateColOpt.get();
                planDateColDim.setSequence(-layoutInfoList.size());
            }
            for (i = layoutInfoList.size() - 1; i >= 0; --i) {
                TemplateDim oldTemplateDim;
                TemplateLayout.LayoutInfo layoutInfo = layoutInfoList.get(i);
                TemplateDim templateDim = new TemplateDim();
                Long dimensionId = layoutInfo.getDimensionId();
                templateDim.setDimensionId(layoutInfo.getDimensionId());
                templateDim.setDimensionName(layoutInfo.getDimensionName());
                templateDim.setLevel(layoutInfo.getLevel());
                templateDim.setDetailDim(false);
                templateDim.setLocation(DimLocation.COL);
                templateDim.setVisible(layoutInfo.isVisible());
                templateDim.setExpand(layoutInfo.isExpand());
                templateDim.setMemberScope(layoutInfo.getExpandMembers());
                TemplateDim dbTemplateDim = (TemplateDim)dimMap.get(dimensionId);
                if (Objects.nonNull(dbTemplateDim)) {
                    templateDim.setDimType(dbTemplateDim.getDimType());
                }
                if (EmptyUtil.isEmpty(templateDim.getMemberScope()) && dimMap.containsKey(layoutInfo.getDimensionId()) && (oldTemplateDim = (TemplateDim)dimMap.get(dimensionId)).getLocation() == templateDim.getLocation()) {
                    templateDim.setMemberScope(oldTemplateDim.getMemberScope());
                }
                if (layoutInfo.getDimensionName().equals(DimsionEnums.SUBJECT.getName())) {
                    templateDim.setSequence(-1 - layoutInfoList.size());
                } else {
                    templateDim.setSequence(i + 1 - layoutInfoList.size());
                }
                finalColDimList.add(0, templateDim);
            }
            finalColDimList = finalColDimList.stream().sorted(Comparator.comparingInt(TemplateDim::getSequence)).collect(Collectors.toList());
            for (i = 0; i < finalColDimList.size(); ++i) {
                ((TemplateDim)finalColDimList.get(i)).setSequence(i + 1);
            }
            template.setColDimList(finalColDimList);
        } else if (TemplateType.FIXED == templateType) {
            List<TemplateLayout.LayoutInfo> newColList;
            List<TemplateLayout.LayoutInfo> oldColList;
            Boolean colChange;
            List<TemplateLayout.LayoutInfo> newRowList;
            List<TemplateLayout.LayoutInfo> oldRowList;
            Boolean rowChange;
            List<TemplateLayout.LayoutInfo> newPageList;
            List<TemplateLayout.LayoutInfo> oldPageList = template.getDimLayout().getPageLayout();
            Boolean pageChange = this.compareBean(oldPageList, newPageList = layout.getPageLayout());
            if (pageChange.booleanValue()) {
                template.setPageDimList(new ArrayList<TemplateDim>(0));
            }
            if ((rowChange = this.compareBean(oldRowList = template.getDimLayout().getRowLayout(), newRowList = layout.getRowLayout())).booleanValue()) {
                template.getRowDimList().clear();
            }
            if ((colChange = this.compareBean(oldColList = template.getDimLayout().getColLayout(), newColList = layout.getColLayout())).booleanValue()) {
                template.getColDimList().clear();
            }
            template.setDimLayout(layout);
        }
        return FpmOperateResult.success(template);
    }

    private Boolean compareBean(List<TemplateLayout.LayoutInfo> oldPageList, List<TemplateLayout.LayoutInfo> newPageList) {
        Boolean isChange = Boolean.FALSE;
        if (oldPageList.size() > newPageList.size()) {
            isChange = Boolean.TRUE;
        } else {
            TemplateLayout.LayoutInfo oldLayout;
            TemplateLayout.LayoutInfo newLayout;
            oldPageList = oldPageList.stream().sorted(Comparator.comparing(TemplateLayout.LayoutInfo::getDimensionId)).collect(Collectors.toList());
            newPageList = newPageList.stream().sorted(Comparator.comparing(TemplateLayout.LayoutInfo::getDimensionId)).collect(Collectors.toList());
            for (int i = 0; i < oldPageList.size() && !(isChange = DispersionAnalysisUtils.isChange((Object)(newLayout = newPageList.get(i)), (Object)(oldLayout = oldPageList.get(i)))).booleanValue(); ++i) {
            }
        }
        return isChange;
    }

    private boolean isCustomDim(DimensionType dimensionType) {
        return DimensionType.ORG != dimensionType && DimensionType.CURRENCY != dimensionType && DimensionType.PERIOD != dimensionType && DimensionType.SUBJECTS != dimensionType;
    }

    private String checkOrgMemberByDimLocation(ReportTemplate template, TemplateDim orgDim, List<Long> memberScope) {
        if (orgDim.getDimType() != DimensionType.ORG) {
            return CHECK_SUCCESS;
        }
        if (orgDim.getScopeType() != TemplateDimMemScopeType.FIXED_MEMBER) {
            return CHECK_SUCCESS;
        }
        switch (orgDim.getLocation()) {
            case COL: {
                if (this.getSize(memberScope) <= 100) break;
                return ResManager.loadKDString((String)"\u4fdd\u5b58\u9884\u89c8\u5931\u8d25\uff0c\u5217\u7ef4\u3010\u7f16\u62a5\u4e3b\u4f53\u3011\u6210\u5458\u6570\u91cf\u4e0d\u53ef\u8d85\u8fc7100\u4e2a\uff0c\u8bf7\u786e\u8ba4\u6210\u5458\u8303\u56f4\u3002", (String)"TemplateService_19", (String)"tmc-fpm-business", (Object[])new Object[0]);
            }
            case ROW: {
                List<TemplateDim> rowDimList = template.getRowDimList();
                if (CollectionUtils.isEmpty(rowDimList) || rowDimList.size() != 2) break;
                TemplateDim levelOneRow = rowDimList.get(0);
                TemplateDim levelTwoRow = rowDimList.get(1);
                if (this.multi(this.getSize(levelOneRow.getMemberScope()), this.getSize(levelTwoRow.getMemberScope())) <= 10000) break;
                return ResManager.loadKDString((String)"\u4fdd\u5b58\u9884\u89c8\u5931\u8d25\uff0c\u4e00\u7ea7\u884c\u7ef4\u6210\u5458\u6570\u91cf*\u4e8c\u7ea7\u884c\u7ef4\u6210\u5458\u6570\u91cf\u4e0d\u53ef\u5927\u4e8e10000\uff0c\u8bf7\u786e\u8ba4\u6210\u5458\u8303\u56f4\u3002", (String)"TemplateService_20", (String)"tmc-fpm-business", (Object[])new Object[0]);
            }
            case PAGE: {
                if (this.getSize(memberScope) <= 20) break;
                return ResManager.loadKDString((String)"\u4fdd\u5b58\u9884\u89c8\u5931\u8d25\uff0c\u9875\u9762\u7ef4\u3010\u7f16\u62a5\u4e3b\u4f53\u3011\u6210\u5458\u6570\u91cf\u4e0d\u53ef\u8d85\u8fc720\u4e2a\uff0c\u8bf7\u786e\u8ba4\u6210\u5458\u8303\u56f4\u3002", (String)"TemplateService_21", (String)"tmc-fpm-business", (Object[])new Object[0]);
            }
        }
        return CHECK_SUCCESS;
    }

    private String checkStatAnalysisTemplate(ReportTemplate template, TemplateDim orgDim, FundPlanSystem system) {
        List<ReportTemplate> statAnalysisTemplateList = template.getStatAnalysisTemplateList();
        if (EmptyUtil.isEmpty(statAnalysisTemplateList)) {
            return CHECK_SUCCESS;
        }
        Map dimMap = system.getDimList().stream().collect(Collectors.toMap(Dimension::getId, Function.identity()));
        List templateDims = template.getDimLayout().getDimLayoutInfoList().stream().map(TemplateLayout.LayoutInfo::getDimensionId).collect(Collectors.toList());
        for (ReportTemplate analysisTemplate : statAnalysisTemplateList) {
            Set statAnalysisTemplateDims = analysisTemplate.getDimLayout().getDimLayoutInfoList().stream().map(TemplateLayout.LayoutInfo::getDimensionId).collect(Collectors.toSet());
            String dimNameStr = templateDims.stream().filter(item -> !statAnalysisTemplateDims.contains(item)).map(item -> ((Dimension)dimMap.get(item)).getName()).collect(Collectors.joining("\uff0c"));
            if (!kd.bos.util.StringUtils.isNotEmpty((String)dimNameStr)) continue;
            return String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u9884\u89c8\u5931\u8d25\uff0c\u5173\u8054\u7edf\u8ba1\u5206\u6790\u6a21\u677f %1$s \u7f3a\u5c11 %2$s \u7ef4\u5ea6 ", (String)"TemplateService_22", (String)"tmc-fpm-business", (Object[])new Object[0]), analysisTemplate.getName(), dimNameStr);
        }
        if (statAnalysisTemplateList.size() > 10) {
            return String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u9884\u89c8\u5931\u8d25\uff0c\u5173\u8054\u7edf\u8ba1\u5206\u6790\u6a21\u677f\u7684\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7%1$s\u5f20", (String)"TemplateService_23", (String)"tmc-fpm-business", (Object[])new Object[0]), 10);
        }
        TemplateDimMemScopeType scopeType = orgDim.getScopeType();
        if (scopeType != TemplateDimMemScopeType.FIXED_MEMBER) {
            return CHECK_SUCCESS;
        }
        for (ReportTemplate statTem : statAnalysisTemplateList) {
            List<TemplateDim> allTemplateDim = statTem.getAllTemplateDim();
            TemplateDim orgTemDim = allTemplateDim.stream().filter(templateDim -> DimensionType.ORG == templateDim.getDimType()).findFirst().get();
            TemplateDimMemScopeType dimScopeType = orgTemDim.getScopeType();
            if (dimScopeType != TemplateDimMemScopeType.FIXED_MEMBER) {
                return String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u9884\u89c8\u5931\u8d25\uff0c\u4e3b\u8868\u6a21\u677f\u3010%1$s\u3011\u7f16\u62a5\u4e3b\u4f53\u6210\u5458\u8303\u56f4\u7c7b\u578b\u4e3a\u3010\u56fa\u5b9a\u6210\u5458\u3011\uff0c\u5173\u8054\u7edf\u8ba1\u5206\u6790\u6a21\u677f\u7f16\u62a5\u4e3b\u4f53\u7684\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u7c7b\u578b\u4e5f\u53ea\u80fd\u662f\u3010\u56fa\u5b9a\u6210\u5458\u3011\u3002", (String)"TemplateService_24", (String)"tmc-fpm-business", (Object[])new Object[0]), template.getName());
            }
            List<Long> statMemberScope = orgTemDim.getMemberScope();
            List<Long> memberScope = orgDim.getMemberScope();
            if (memberScope.containsAll(statMemberScope)) continue;
            return String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u9884\u89c8\u5931\u8d25\uff0c\u5173\u8054\u7edf\u8ba1\u5206\u6790\u6a21\u677f\u3010%1$s\u3011\u7684\u7f16\u62a5\u4e3b\u4f53\u6210\u5458\u8303\u56f4\u672a\u5728\u4e3b\u8868\u7684\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u4e4b\u5185\uff0c\u8bf7\u786e\u8ba4\u7edf\u8ba1\u62a5\u8868\u6a21\u677f\u7684\u76f8\u5173\u914d\u7f6e\u540e\uff0c\u518d\u4fee\u6539\u6c47\u603b\u4e3b\u8868\u6a21\u677f\u3002", (String)"TemplateService_25", (String)"tmc-fpm-business", (Object[])new Object[0]), statTem.getName());
        }
        return CHECK_SUCCESS;
    }

    private String checkForSumPlan(TemplateParamDTO templateParamDTO, FundPlanSystem system) {
        String message;
        ReportTemplate template = templateParamDTO.getTemplate();
        TemplateUseType templateUse = template.getTemplateUse();
        if (templateUse != TemplateUseType.SUMMARY) {
            return CHECK_SUCCESS;
        }
        List<TemplateDim> allTemplateDim = template.getAllTemplateDim();
        TemplateDim orgDim = allTemplateDim.stream().filter(templateDim -> templateDim.getDimType() == DimensionType.ORG).findFirst().get();
        List<Long> memberScope = orgDim.getMemberScope();
        if (template.isMainTable() && EmptyUtil.isNoEmpty((String)(message = this.checkStatAnalysisTemplate(template, orgDim, system)))) {
            return message;
        }
        String errMessage = this.checkOrgMemberByDimLocation(template, orgDim, memberScope);
        if (EmptyUtil.isNoEmpty((String)errMessage)) {
            return errMessage;
        }
        return CHECK_SUCCESS;
    }

    @Override
    public String checkForReleaseOrAssign(TemplateParamDTO templateParamDTO) {
        String opKey = templateParamDTO.getOpKey();
        if (!Objects.equals(opKey, "releaseop") && !Objects.equals(opKey, "assignop")) {
            return CHECK_SUCCESS;
        }
        ReportTemplate template = templateParamDTO.getTemplate();
        String msg = this.checkValidReferenceMetric(template);
        if (EmptyUtil.isNoEmpty((String)msg)) {
            return msg;
        }
        if (!template.isMainTable()) {
            return CHECK_SUCCESS;
        }
        msg = this.preCheckForRelease(templateParamDTO);
        if (EmptyUtil.isNoEmpty((String)msg)) {
            return msg;
        }
        TemplateUseType templateUse = template.getTemplateUse();
        switch (templateUse) {
            case PLANING: {
                templateParamDTO.setType(TemplateParamDTO.CheckType.PLANING.getValue());
                templateParamDTO.setErrMsg(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u914d\u7f16\u62a5\u4e3b\u4f53\u3010%1$s\u3011\u5bf9\u5e94\u6a21\u677f\u3010%2$s\u3011\u7684\u7ef4\u5ea6\u7ec4\u5408\u6570\u91cf\uff08\u975e\u9690\u85cf\u7ef4\u5ea6\uff09\u5c0f\u4e8e\u4e0a\u7ea7\u5df2\u5206\u914d\u7684\u6c47\u603b\u6a21\u677f\u3010%3$s\u3011\u7684\u7ef4\u5ea6\u7ec4\u5408\uff0c\u8bf7\u786e\u8ba4\u6240\u5206\u914d\u6a21\u677f\u7684\u914d\u7f6e\u4fe1\u606f\u6216\u5206\u914d\u8303\u56f4", (String)"TemplateService_26", (String)"tmc-fpm-business", (Object[])new Object[0]));
                return this.checkReleaseForPlanning(templateParamDTO);
            }
            case SUMMARY: {
                templateParamDTO.setType(TemplateParamDTO.CheckType.SUMMARY.getValue());
                templateParamDTO.setErrMsg(ResManager.loadKDString((String)"\u4e0a\u7ea7\u6c47\u603b\u6a21\u677f\u3010%1$s\u3011\u7684\u7ef4\u5ea6\u7ec4\u5408\u6570\u91cf\uff08\u975e\u9690\u85cf\u7ef4\u5ea6\uff09\u4e0d\u53ef\u591a\u4e8e\u4e0b\u5c5e\u7f16\u62a5\u4e3b\u4f53\u3010%2$s\u3011\u6240\u5206\u914d\u7684\u6a21\u677f\u3010%3$s\u3011\u7684\u7ef4\u5ea6\u7ec4\u5408\uff0c\u8bf7\u786e\u8ba4\u6240\u5206\u914d\u6a21\u677f\u7684\u914d\u7f6e\u4fe1\u606f", (String)"TemplateService_27", (String)"tmc-fpm-business", (Object[])new Object[0]));
                return this.checkReleaseForSummary(templateParamDTO);
            }
        }
        return CHECK_SUCCESS;
    }

    private String preCheckForRelease(TemplateParamDTO templateParamDTO) {
        TemplateAccountSetting setting;
        Dimension subjectDim;
        DimMember member;
        List formulaEmptySetting;
        if (!Objects.equals(templateParamDTO.getOpKey(), "releaseop")) {
            return CHECK_SUCCESS;
        }
        FundPlanSystem system = templateParamDTO.getSystem();
        ReportTemplate template = templateParamDTO.getTemplate();
        if (template.isRelease()) {
            return ResManager.loadKDString((String)"\u5df2\u53d1\u5e03\u7684\u6a21\u677f\u4e0d\u80fd\u518d\u53d1\u5e03\u3002", (String)"TemplateService_28", (String)"tmc-fpm-business", (Object[])new Object[0]);
        }
        boolean fixed = template.getTemplateType().isFixed();
        if (fixed && !CollectionUtils.isEmpty(formulaEmptySetting = template.getAccountSettings().stream().filter(item -> Objects.nonNull((Object)item.getInputType())).filter(item -> ReportInputType.isFormula(item.getInputType().getNumber())).filter(item -> kd.bos.util.StringUtils.isEmpty((String)item.getFormula())).collect(Collectors.toList())) && Objects.nonNull(member = (subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS)).getDimMemberById((setting = (TemplateAccountSetting)formulaEmptySetting.get(0)).getAccountMemId()))) {
            String msg = ResManager.loadKDString((String)"\u53d1\u5e03\u5931\u8d25\uff0c\u516c\u5f0f\u9879\u8ba1\u5212\u79d1\u76ee\u201c%1$s\u201d\u5c1a\u672a\u8bbe\u7f6e\u516c\u5f0f\u8868\u8fbe\u5f0f\uff0c\u8bf7\u5148\u5728\u3010\u8ba1\u5212\u79d1\u76ee\u3011\u5b8c\u5584\u516c\u5f0f\u914d\u7f6e\uff0c\u7136\u540e\u5728\u6a21\u677f\u4e2d\u91cd\u9009\u8ba1\u5212\u79d1\u76ee\uff0c\u4e14\u201c\u79d1\u76ee\u5c5e\u6027\u8bbe\u7f6e\u201d\u4e2d\u9002\u7528\u516c\u5f0f\u503c\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u65b9\u53ef\u53d1\u5e03\u3002", (String)"TemplateService_45", (String)"tmc-fpm-business", (Object[])new Object[0]);
            return String.format(msg, member.getName());
        }
        TemplateUseType templateUse = template.getTemplateUse();
        if (templateUse == TemplateUseType.SUMMARY) {
            List<ReportTemplate> statAnalysisTemplateList = template.getStatAnalysisTemplateList();
            Optional<ReportTemplate> first = statAnalysisTemplateList.stream().filter(rt -> !rt.isRelease()).findFirst();
            if (first.isPresent()) {
                ReportTemplate statAnalysisTemplate = first.get();
                return String.format(ResManager.loadKDString((String)"\u53d1\u5e03\u5931\u8d25\uff0c\u4e3b\u8868\u6a21\u677f\u3010%1$s %2$s\u3011\u5173\u8054\u7684\u7edf\u8ba1\u5206\u6790\u6a21\u677f\u3010%3$s %4$s\u3011\u5c1a\u672a\u53d1\u5e03\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u53d1\u5e03\u3002", (String)"TemplateService_29", (String)"tmc-fpm-business", (Object[])new Object[0]), template.getNumber(), template.getName(), statAnalysisTemplate.getNumber(), statAnalysisTemplate.getName());
            }
            Optional<ReportTemplate> disable = statAnalysisTemplateList.stream().filter(rt -> !rt.isEnable()).findFirst();
            if (disable.isPresent()) {
                ReportTemplate statAnalysisTemplate = disable.get();
                return String.format(ResManager.loadKDString((String)"\u53d1\u5e03\u5931\u8d25\uff0c\u4e3b\u8868\u6a21\u677f\u3010%1$s %2$s\u3011\u5173\u8054\u7684\u7edf\u8ba1\u5206\u6790\u6a21\u677f\u3010%3$s %4$s\u3011\u975e\u201c\u53ef\u7528\u201d\u72b6\u6001\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u53d1\u5e03\u3002", (String)"TemplateService_30", (String)"tmc-fpm-business", (Object[])new Object[0]), template.getNumber(), template.getName(), statAnalysisTemplate.getNumber(), statAnalysisTemplate.getName());
            }
            return this.preCheckSumPlan(templateParamDTO);
        }
        return CHECK_SUCCESS;
    }

    private String preCheckSumPlan(TemplateParamDTO templateParamDTO) {
        List<SumPlanParamConfig> sumPlanParamConfigList = templateParamDTO.getSumPlanParamConfigList();
        if (EmptyUtil.isEmpty(sumPlanParamConfigList)) {
            return CHECK_SUCCESS;
        }
        ReportTemplate template = templateParamDTO.getTemplate();
        List<Long> userIdList = template.getUserIdList();
        Set reportTypeIdSet = template.getReportTypeList().stream().map(TemplateReportType::getReportTypeId).collect(Collectors.toSet());
        Set allAuditOrg = sumPlanParamConfigList.stream().filter(sum -> this.containsAny(reportTypeIdSet, sum.getReportPeriodTypeIdS())).map(SumPlanParamConfig::getConfigInfoList).flatMap(Collection::stream).filter(SumPlanParamConfigInfo::isSumAuditNode).map(SumPlanParamConfigInfo::getOrgMemberId).collect(Collectors.toSet());
        allAuditOrg.retainAll(userIdList);
        if (allAuditOrg.size() != userIdList.size()) {
            HashSet<Long> copy = new HashSet<Long>(userIdList);
            copy.removeAll(allAuditOrg);
            FundPlanSystem system = templateParamDTO.getSystem();
            Dimension dimension = system.getMainDimensionByDimType(DimensionType.ORG);
            String orgNames = dimension.getAllDimMemberList().stream().filter(dimMember -> copy.contains(dimMember.getId())).map(DimMember::getName).collect(Collectors.joining(","));
            return String.format(ResManager.loadKDString((String)"\u53d1\u5e03\u5931\u8d25\uff0c\u7f16\u62a5\u4e3b\u4f53\u3010%1$s\u3011\u672a\u5f00\u542f\u6c47\u603b\u5ba1\u6279\u8282\u70b9\uff0c\u8bf7\u786e\u8ba4\u540e\u53d1\u5e03", (String)"TemplateService_31", (String)"tmc-fpm-business", (Object[])new Object[0]), orgNames);
        }
        return CHECK_SUCCESS;
    }

    private <T> boolean containsAny(Collection<T> source, Collection<T> target) {
        for (T t : target) {
            if (!source.contains(t)) continue;
            return true;
        }
        return false;
    }

    private String checkReleaseForPlanning(TemplateParamDTO templateParamDTO) {
        String msg = this.checkAssignNodeNotSumNode(templateParamDTO);
        if (EmptyUtil.isNoEmpty((String)msg)) {
            return msg;
        }
        return this.checkUpperTemplateDimCombination(templateParamDTO);
    }

    private String checkUpperTemplateDimCombination(TemplateParamDTO templateParamDTO) {
        List<TemplateParamDTO.RelationTemplate> upperRelationTemplates = templateParamDTO.getUpperRelationTemplates();
        if (EmptyUtil.isEmpty(upperRelationTemplates)) {
            return CHECK_SUCCESS;
        }
        ReportTemplate template = templateParamDTO.getTemplate();
        for (TemplateParamDTO.RelationTemplate relationTemplate : upperRelationTemplates) {
            ReportTemplate mainTemplate = relationTemplate.getMainTemplate();
            List<ReportTemplate> subTemplate = relationTemplate.getSubTemplate();
            String errorMsg = this.checkReleaseForSummary(TemplateParamDTO.builder().downRelationTemplates(Collections.singletonList(new TemplateParamDTO.RelationTemplate(template, templateParamDTO.getSubTemplateList(), relationTemplate.getAssignMemberId()))).template(mainTemplate).subTemplateList(subTemplate).type(templateParamDTO.getType()).opKey(templateParamDTO.getOpKey()).system(templateParamDTO.getSystem()).errMsg(templateParamDTO.getErrMsg()).build());
            if (!EmptyUtil.isNoEmpty((String)errorMsg)) continue;
            return errorMsg;
        }
        return CHECK_SUCCESS;
    }

    private String checkAssignNodeNotSumNode(TemplateParamDTO templateParamDTO) {
        if (!Objects.equals(templateParamDTO.getOpKey(), "releaseop")) {
            return CHECK_SUCCESS;
        }
        ReportTemplate template = templateParamDTO.getTemplate();
        List<TemplateReportType> templateReportTypeList = template.getReportTypeList();
        Set temReportTypeIds = templateReportTypeList.stream().map(TemplateReportType::getReportTypeId).collect(Collectors.toSet());
        List<Long> userIdList = template.getUserIdList();
        if (CollectionUtils.isEmpty(userIdList)) {
            return CHECK_SUCCESS;
        }
        FundPlanSystem system = templateParamDTO.getSystem();
        Dimension dimension = system.getMainDimensionByDimType(DimensionType.ORG);
        List<ReportPeriodType> reportTypeList = system.getReportTypeList();
        Map reportTypeMap = reportTypeList.stream().collect(Collectors.toMap(ReportPeriodType::getReportPeriodId, Function.identity()));
        List<SumPlanParamConfig> sumPlanParamConfigList = templateParamDTO.getSumPlanParamConfigList();
        if (EmptyUtil.isEmpty(sumPlanParamConfigList)) {
            return CHECK_SUCCESS;
        }
        for (SumPlanParamConfig sumPlanParamConfig : sumPlanParamConfigList) {
            List<SumPlanParamConfigInfo> configInfoList;
            List<Long> reportTypeIds = sumPlanParamConfig.getReportPeriodTypeIdS();
            HashSet<Long> reportTypeIdSet = new HashSet<Long>(reportTypeIds);
            reportTypeIdSet.retainAll(temReportTypeIds);
            if (reportTypeIdSet.isEmpty() || EmptyUtil.isEmpty(configInfoList = sumPlanParamConfig.getConfigInfoList())) continue;
            Set orgMemberIds = configInfoList.stream().filter(SumPlanParamConfigInfo::isSumAuditNode).map(SumPlanParamConfigInfo::getOrgMemberId).collect(Collectors.toSet());
            orgMemberIds.retainAll(userIdList);
            if (orgMemberIds.isEmpty()) continue;
            String orgMemberName = orgMemberIds.stream().map(id -> dimension.getDimMemberByDimId(DimMember.class, (Long)id)).filter(Objects::nonNull).map(DimMember::getName).collect(Collectors.joining(","));
            String reportTypeName = reportTypeIdSet.stream().map(id -> (ReportPeriodType)reportTypeMap.get(id)).filter(Objects::nonNull).map(ReportPeriodType::getName).collect(Collectors.joining(","));
            return String.format(ResManager.loadKDString((String)"\u53d1\u5e03\u5931\u8d25\uff0c\u5df2\u5206\u914d\u7f16\u62a5\u4e3b\u4f53\u3010%1$s\u3011\u5728\u3010%2$s\u3011\u4e0b\u5df2\u5f00\u542f\u4f5c\u4e3a\u6c47\u603b\u5ba1\u6838\u8282\u70b9\uff0c\u4e0d\u652f\u6301\u4e3a\u5176\u53d1\u5e03\u201c\u6a21\u677f\u7528\u9014=\u8ba1\u5212\u7f16\u5236\u201d\u7684\u6a21\u677f\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c", (String)"TemplateService_32", (String)"tmc-fpm-business", (Object[])new Object[0]), orgMemberName, reportTypeName);
        }
        return CHECK_SUCCESS;
    }

    private String checkReleaseForSummary(TemplateParamDTO templateParamDTO) {
        String msg;
        List<TemplateParamDTO.RelationTemplate> upperRelationTemplates = templateParamDTO.getUpperRelationTemplates();
        if (EmptyUtil.isNoEmpty(upperRelationTemplates) && EmptyUtil.isNoEmpty((String)(msg = this.checkUpperTemplateDimCombination(templateParamDTO)))) {
            return msg;
        }
        List<TemplateParamDTO.RelationTemplate> downRelationTemplates = templateParamDTO.getDownRelationTemplates();
        if (EmptyUtil.isEmpty(downRelationTemplates)) {
            return CHECK_SUCCESS;
        }
        ReportTemplate template = templateParamDTO.getTemplate();
        List<ReportTemplate> subTemplateList = templateParamDTO.getSubTemplateList();
        List<TemplateDim> allTemplateDim = template.getAllTemplateDim();
        Set allTemplateDimIdSet = allTemplateDim.stream().map(TemplateDim::getDimensionId).collect(Collectors.toSet());
        FundPlanSystem system = templateParamDTO.getSystem();
        Dimension dimension = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        List<DimMember> subjectDimMemberList = dimension.getAllDimMemberList();
        Map<Long, DimMember> subjectDimMemberMap = subjectDimMemberList.stream().collect(Collectors.toMap(DimMember::getId, Function.identity()));
        Map<Long, DimMember> orgDimMemberMap = system.getMainDimensionByDimType(DimensionType.ORG).getAllDimMemberList().stream().collect(Collectors.toMap(DimMember::getId, Function.identity()));
        for (TemplateParamDTO.RelationTemplate relationTemplate : downRelationTemplates) {
            ReportTemplate relMainTemplate = relationTemplate.getMainTemplate();
            List<TemplateDim> relMainALlTemDims = relMainTemplate.getAllTemplateDim();
            Set relMainALlTemDimIdSet = relMainALlTemDims.stream().map(TemplateDim::getDimensionId).collect(Collectors.toSet());
            if (!relMainALlTemDimIdSet.containsAll(allTemplateDimIdSet)) {
                this.formatErrorMsg(templateParamDTO, template.getName(), relMainTemplate.getName(), relationTemplate.getAssignMemberId());
                return this.getErrorMessageByOpType(templateParamDTO);
            }
            if (EmptyUtil.isEmpty(subTemplateList)) continue;
            for (ReportTemplate subTemplate : subTemplateList) {
                Set dimensionIdSet = subTemplate.getAllTemplateDim().stream().filter(templateDim -> !templateDim.isDetailDim()).map(TemplateDim::getDimensionId).collect(Collectors.toSet());
                if (dimensionIdSet.size() == allTemplateDim.size()) continue;
                if (subTemplate.getTemplateType() == TemplateType.DETAIL) {
                    TemplateAccountSetting accountSetting = template.getAccountSettings().stream().filter(templateAccountSetting -> templateAccountSetting.getInputType() == ReportInputType.DETAIL_INPUT).filter(templateAccountSetting -> Objects.equals(templateAccountSetting.getChildTemplateId(), subTemplate.getId())).findFirst().get();
                    DimMember subjectMem = subjectDimMemberMap.get(accountSetting.getAccountMemId());
                    CheckResult checkResult = this.checkSubDetail(relationTemplate, subTemplate, subjectMem);
                    this.formatErrorMsg(templateParamDTO, subTemplate, checkResult, relationTemplate);
                    return this.getMessageFromResult(templateParamDTO, orgDimMemberMap, relationTemplate, subTemplate, checkResult);
                }
                CheckResult checkResult = this.checkSubFix(template, relationTemplate, subTemplate, subjectDimMemberMap);
                this.formatErrorMsg(templateParamDTO, subTemplate, checkResult, relationTemplate);
                return this.getMessageFromResult(templateParamDTO, orgDimMemberMap, relationTemplate, subTemplate, checkResult);
            }
        }
        return CHECK_SUCCESS;
    }

    private void formatErrorMsg(TemplateParamDTO templateParamDTO, ReportTemplate template, CheckResult checkResult, TemplateParamDTO.RelationTemplate relationTemplate) {
        if (checkResult.isSuccess()) {
            return;
        }
        this.formatErrorMsg(templateParamDTO, template.getName(), checkResult.getNotSuccessTemplateName(), relationTemplate.getAssignMemberId());
    }

    private void formatErrorMsg(TemplateParamDTO templateParamDTO, String sumTemplateName, String subLevelTemplateName, Long assignMemberId) {
        FundPlanSystem system = templateParamDTO.getSystem();
        Dimension dimension = system.getMainDimensionByDimType(DimensionType.ORG);
        String errMsg = templateParamDTO.getErrMsg();
        Optional<DimMember> first = dimension.getAllDimMemberList().stream().filter(mem -> Objects.equals(mem.getId(), assignMemberId)).findFirst();
        String name = first.isPresent() ? first.get().getName() : CHECK_SUCCESS;
        errMsg = templateParamDTO.getType() == TemplateParamDTO.CheckType.SUMMARY.getValue() ? String.format(errMsg, sumTemplateName, name, subLevelTemplateName) : String.format(errMsg, name, subLevelTemplateName, sumTemplateName);
        templateParamDTO.setErrMsg(errMsg);
    }

    private String getMessageFromResult(TemplateParamDTO templateParamDTO, Map<Long, DimMember> orgDimMemberMap, TemplateParamDTO.RelationTemplate relationTemplate, ReportTemplate reportTemplate, CheckResult checkResult) {
        if (checkResult.isSuccess()) {
            return CHECK_SUCCESS;
        }
        DimMember dimMember = orgDimMemberMap.get(relationTemplate.getAssignMemberId());
        if (EmptyUtil.isEmpty((String)templateParamDTO.getErrMsg())) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u4e0a\u7ea7\u6c47\u603b\u6a21\u677f\u3010%1$s\u3011\u7684\u7ef4\u5ea6\u7ec4\u5408\u6570\u91cf\uff08\u975e\u9690\u85cf\u7ef4\u5ea6\uff09\u4e0d\u53ef\u591a\u4e8e\u4e0b\u5c5e\u7f16\u62a5\u4e3b\u4f53\u3010%2$s\u3011\u6240\u5206\u914d\u7684\u6a21\u677f\u3010%3$s\u3011\u7684\u7ef4\u5ea6\u7ec4\u5408\uff0c\u8bf7\u786e\u8ba4\u6240\u5206\u914d\u6a21\u677f\u7684\u914d\u7f6e\u4fe1\u606f,\u8be6\u7ec6\u4fe1\u606f\uff1a%4$s", (String)"TemplateService_33", (String)"tmc-fpm-business", (Object[])new Object[0]), reportTemplate.getName(), dimMember.getName(), checkResult.getNotSuccessTemplateName(), checkResult.getDetailMsg());
            templateParamDTO.setErrMsg(errMsg);
        } else {
            String errMsg = String.format(ResManager.loadKDString((String)"\u8be6\u7ec6\u4fe1\u606f\uff1a%1$s", (String)"TemplateService_34", (String)"tmc-fpm-business", (Object[])new Object[0]), checkResult.getDetailMsg());
            templateParamDTO.setErrMsg(templateParamDTO.getErrMsg() + "\uff0c" + errMsg);
        }
        return this.getErrorMessageByOpType(templateParamDTO);
    }

    private String getErrorMessageByOpType(TemplateParamDTO templateParamDTO) {
        String errMsg = templateParamDTO.getErrMsg();
        String opKey = templateParamDTO.getOpKey();
        String prefix = CHECK_SUCCESS;
        switch (opKey) {
            case "releaseop": {
                prefix = ResManager.loadKDString((String)"\u53d1\u5e03\u5931\u8d25", (String)"TemplateService_35", (String)"tmc-fpm-business", (Object[])new Object[0]);
                prefix = prefix + ",";
                break;
            }
            case "assignop": {
                prefix = ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25", (String)"TemplateService_36", (String)"tmc-fpm-business", (Object[])new Object[0]);
                prefix = prefix + ",";
            }
        }
        if (EmptyUtil.isNoEmpty((String)errMsg)) {
            return prefix + errMsg;
        }
        return ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\uff0c\u4e0a\u7ea7\u6c47\u603b\u6a21\u677f\u7684\u7ef4\u5ea6\u7ec4\u5408\u6570\u91cf\uff08\u975e\u9690\u85cf\u7ef4\u5ea6\uff09\u4e0d\u53ef\u591a\u4e8e\u4e0b\u5c5e\u7f16\u62a5\u4e3b\u4f53\u6240\u5206\u914d\u7684\u6a21\u677f\u7684\u7ef4\u5ea6\u7ec4\u5408\uff0c\u8bf7\u786e\u8ba4\u6240\u5206\u914d\u6a21\u677f\u7684\u914d\u7f6e\u4fe1\u606f", (String)"TemplateService_37", (String)"tmc-fpm-business", (Object[])new Object[0]);
    }

    private CheckResult checkSubFix(ReportTemplate mainTemplate, TemplateParamDTO.RelationTemplate relationTemplate, ReportTemplate subTemplate, Map<Long, DimMember> subjectDimMemberMap) {
        TemplateAccountSetting templateAccountSetting = mainTemplate.getAccountSettings().stream().filter(as -> Objects.equals(as.getChildTemplateId(), subTemplate.getId())).findFirst().get();
        List<TemplateAccountSetting> subTemAsList = subTemplate.getAccountSettings();
        TemplateAccountSetting subTemAccountSetting = subTemAsList.stream().filter(as -> Objects.equals(as.getAccountMemId(), templateAccountSetting.getAccountMemId())).findFirst().get();
        HashSet<Long> allNeedCheck = new HashSet<Long>(8);
        this.getAllChildId(allNeedCheck, subTemAccountSetting);
        for (TemplateAccountSetting subTemAs : subTemAsList) {
            if (!allNeedCheck.contains(subTemAs.getAccountMemId())) {
                LOGGER.info("\u6c47\u603b\u5b50\u8868\u3010{}\u3011\u79d1\u76ee\u3010{}\u3011\u4e0d\u662f\u5173\u8054\u4e3b\u8868\u79d1\u76ee\u3010{}\u3011\u6216\u5b50\u7ea7\u79d1\u76ee\uff0c\u4e0d\u6821\u9a8c", new Object[]{subTemplate.getName(), subTemAs.getAccountMemId(), templateAccountSetting.getAccountMemId()});
                continue;
            }
            CheckResult result = this.checkSubDetail(relationTemplate, subTemplate, subjectDimMemberMap.get(subTemAs.getAccountMemId()));
            if (result.isSuccess()) continue;
            return result;
        }
        return CheckResult.success();
    }

    private void getAllChildId(Set<Long> allNeedCheck, TemplateAccountSetting templateAccountSetting) {
        allNeedCheck.add(templateAccountSetting.getAccountMemId());
        List<TemplateAccountSetting> children = templateAccountSetting.getChildren();
        if (EmptyUtil.isEmpty(children)) {
            return;
        }
        for (TemplateAccountSetting tas : children) {
            this.getAllChildId(allNeedCheck, tas);
        }
    }

    private CheckResult checkSubDetail(TemplateParamDTO.RelationTemplate relationTemplate, ReportTemplate subTemplate, DimMember subjectMem) {
        ReportTemplate relMainTemplate = relationTemplate.getMainTemplate();
        Optional<TemplateAccountSetting> first = relMainTemplate.getAccountSettings().stream().filter(ts -> Objects.equals(ts.getAccountMemId(), subjectMem.getId())).findFirst();
        List<TemplateDim> subTemplateDimList = subTemplate.getAllTemplateDim().stream().filter(td -> !td.isDetailDim()).collect(Collectors.toList());
        String msg = CHECK_SUCCESS;
        if (first.isPresent()) {
            TemplateAccountSetting relTemplateAs = first.get();
            if (relTemplateAs.getInputType() == ReportInputType.DETAIL_INPUT) {
                ReportTemplate relSubReportTemplate = relationTemplate.getSubTemplate().stream().filter(rt -> Objects.equals(rt.getId(), relTemplateAs.getChildTemplateId())).findFirst().get();
                Map relSubTemplateDimMap = relSubReportTemplate.getAllTemplateDim().stream().filter(td -> !td.isDetailDim()).collect(Collectors.toMap(TemplateDim::getDimensionId, Function.identity()));
                for (TemplateDim subTemDim : subTemplateDimList) {
                    if (subTemDim.getDimType() == DimensionType.SUBJECTS || subTemDim.getDimType() == DimensionType.ORG || subTemDim.getDimType() == DimensionType.PERIOD || subTemDim.getDimType() == DimensionType.CURRENCY) continue;
                    Long dimensionId = subTemDim.getDimensionId();
                    List<Long> subMemberScope = subTemDim.getMemberScope();
                    TemplateDim relSubTemDim = (TemplateDim)relSubTemplateDimMap.get(dimensionId);
                    if (EmptyUtil.isEmpty((Object)relSubTemDim)) {
                        msg = String.format(ResManager.loadKDString((String)"\u6c47\u603b\u5b50\u8868\u3010%1$s\u3011\u660e\u7ec6\u586b\u62a5\u79d1\u76ee\u3010%2$s\u3011\u5b58\u5728\u4e8e\u4e0b\u7ea7\u5b50\u8868\u3010%3$s\u3011\uff0c\u7ef4\u5ea6\u3010%4$s\u3011\u5728\u4e0b\u7ea7\u5b50\u8868\u4e2d\u4e0d\u5b58\u5728", (String)"TemplateService_38", (String)"tmc-fpm-business", (Object[])new Object[0]), subTemplate.getName(), subjectMem.getName(), relSubReportTemplate.getName(), subTemDim.getDimensionName());
                        LOGGER.info(msg);
                        return CheckResult.failure(msg, subjectMem.getName(), subTemDim.getDimensionName(), relSubReportTemplate.getName());
                    }
                    List<Long> relSubMemberScope = relSubTemDim.getMemberScope();
                    if (relSubMemberScope.containsAll(subMemberScope)) continue;
                    msg = String.format(ResManager.loadKDString((String)"\u6c47\u603b\u5b50\u8868\u3010%1$s\u3011\u660e\u7ec6\u586b\u62a5\u79d1\u76ee\u3010%2$s\u3011\u5b58\u5728\u4e8e\u4e0b\u7ea7\u5b50\u8868\u3010%3$s\u3011\uff0c\u4e0b\u7ea7\u5b50\u8868\u79d1\u76ee\u5bf9\u5e94\u7684\u7ef4\u5ea6\u3010%4$s\u3011\u7684\u6210\u5458\u7ec4\u5408\u8303\u56f4\u5c0f\u4e8e\u6c47\u603b\u5b50\u8868", (String)"TemplateService_39", (String)"tmc-fpm-business", (Object[])new Object[0]), subTemplate.getName(), subjectMem.getName(), relSubReportTemplate.getName(), subTemDim.getDimensionName());
                    LOGGER.info(msg);
                    return CheckResult.failure(msg, subjectMem.getName(), subTemDim.getDimensionName(), relSubReportTemplate.getName());
                }
                return CheckResult.success();
            }
            List<TemplateDim> relMainALlTemDims = relMainTemplate.getAllTemplateDim();
            Map relTemplateDimMap = relMainALlTemDims.stream().filter(td -> !td.isDetailDim()).collect(Collectors.toMap(TemplateDim::getDimensionId, Function.identity()));
            for (TemplateDim subTemDim : subTemplateDimList) {
                List<Long> memberScope;
                if (subTemDim.getDimType() == DimensionType.SUBJECTS || subTemDim.getDimType() == DimensionType.ORG || subTemDim.getDimType() == DimensionType.PERIOD || subTemDim.getDimType() == DimensionType.CURRENCY) continue;
                Long dimensionId = subTemDim.getDimensionId();
                TemplateDim relMainTemplateDim = (TemplateDim)relTemplateDimMap.get(dimensionId);
                if (EmptyUtil.isEmpty((Object)relMainTemplateDim) || EmptyUtil.isEmpty(memberScope = relMainTemplateDim.getMemberScope())) {
                    msg = String.format(ResManager.loadKDString((String)"\u6c47\u603b\u5b50\u8868\u3010%1$s\u3011\u660e\u7ec6\u586b\u62a5\u79d1\u76ee\u3010%2$s\u3011\u5b58\u5728\u4e8e\u4e0b\u7ea7\u4e3b\u8868\u3010%3$s\u3011,\u975e\u660e\u7ec6\u586b\u62a5\uff0c\u7ef4\u5ea6\u3010%4$s\u3011\u5728\u4e0b\u7ea7\u4e3b\u8868\u4e2d\u4e0d\u5b58\u5728", (String)"TemplateService_40", (String)"tmc-fpm-business", (Object[])new Object[0]), subTemplate.getName(), subjectMem.getName(), relMainTemplate.getName(), subTemDim.getDimensionName());
                    LOGGER.info(msg);
                    return CheckResult.failure(msg, subjectMem.getName(), subTemDim.getDimensionName(), relMainTemplate.getName());
                }
                if (memberScope.containsAll(subTemDim.getMemberScope())) continue;
                msg = String.format(ResManager.loadKDString((String)"\u6c47\u603b\u5b50\u8868\u3010%1$s\u3011\u660e\u7ec6\u586b\u62a5\u79d1\u76ee\u3010%2$s\u3011\u5b58\u5728\u4e8e\u4e0b\u7ea7\u4e3b\u8868\u3010%3$s\u3011\uff0c\u975e\u660e\u7ec6\u586b\u62a5\uff0c\u7ef4\u5ea6\u3010%4$s\u3011\u7684\u6210\u5458\u7ec4\u5408\u8303\u56f4\u5c0f\u4e8e\u6c47\u603b\u5b50\u8868", (String)"TemplateService_41", (String)"tmc-fpm-business", (Object[])new Object[0]), subTemplate.getName(), subjectMem.getName(), relMainTemplate.getName(), subTemDim.getDimensionName());
                LOGGER.info(msg);
                return CheckResult.failure(msg, subjectMem.getName(), subTemDim.getDimensionName(), relMainTemplate.getName());
            }
            return CheckResult.success();
        }
        return this.checkDetailInRelSubFixTemPlate(relationTemplate, subTemplate, subjectMem, subTemplateDimList);
    }

    private CheckResult checkDetailInRelSubFixTemPlate(TemplateParamDTO.RelationTemplate relationTemplate, ReportTemplate subTemplate, DimMember subjectMem, List<TemplateDim> subTemplateDimList) {
        String msg = CHECK_SUCCESS;
        for (ReportTemplate relSubTemplate : relationTemplate.getSubTemplate()) {
            if (relSubTemplate.getTemplateType() == TemplateType.DETAIL) {
                LOGGER.info("\u56fa\u5b9a\u5b50\u8868\u3010{}\u3011\u79d1\u76ee\u3010{}\u3011\u4e0d\u5728\u4e3b\u8868\u4e2d\uff0c\u5f53\u524d\u4e0b\u7ea7\u660e\u7ec6\u8868\u3010{}\u3011\u662f\u5426\u5305\u542b\u6b64\u79d1\u76ee\uff0c\u90fd\u4e0d\u6821\u9a8c", new Object[]{subTemplate.getName(), subjectMem.getName(), relSubTemplate.getName()});
                continue;
            }
            List<TemplateAccountSetting> relSubAccountSettings = relSubTemplate.getAccountSettings();
            if (CollectionUtils.isEmpty(relSubAccountSettings)) {
                LOGGER.info("\u56fa\u5b9a\u5b50\u8868\u3010{}\u3011\u79d1\u76ee\u3010{}\u3011\u4e0d\u5728\u4e3b\u8868\u79d1\u76ee\u8303\u56f4\u4e2d\uff0c\u5f53\u524d\u4e0b\u7ea7\u5b50\u8868\u3010{}\u3011\u4e3a\u660e\u7ec6\u8868\uff0c\u8df3\u8fc7", new Object[]{subTemplate.getName(), subjectMem.getName(), relSubTemplate.getName()});
                continue;
            }
            Optional<TemplateAccountSetting> relSubAsOptional = relSubAccountSettings.stream().filter(as -> Objects.equals(as.getAccountMemId(), subjectMem.getId())).findFirst();
            if (!relSubAsOptional.isPresent()) {
                LOGGER.info("\u56fa\u5b9a\u5b50\u8868\u3010{}\u3011\u79d1\u76ee\u3010{}\u3011\u4e0d\u5728\u4e3b\u8868\u79d1\u76ee\u8303\u56f4\u4e2d\uff0c\u5f53\u524d\u4e0b\u7ea7\u5b50\u8868\u3010{}\u3011\u4e3a\u56fa\u5b9a\u8868\uff0c\u79d1\u76ee\u8303\u56f4\u4e0d\u5305\u542b\u6b64\u8868\u79d1\u76ee\uff0c\u8df3\u8fc7", new Object[]{subTemplate.getName(), subjectMem.getName(), relSubTemplate.getName()});
                continue;
            }
            Map relSubAllTemplateDimMap = relSubTemplate.getAllTemplateDim().stream().filter(td -> !td.isDetailDim()).collect(Collectors.toMap(TemplateDim::getDimensionId, Function.identity()));
            for (TemplateDim subTemDim : subTemplateDimList) {
                List<Long> memberScope;
                if (subTemDim.getDimType() == DimensionType.SUBJECTS || subTemDim.getDimType() == DimensionType.ORG || subTemDim.getDimType() == DimensionType.PERIOD || subTemDim.getDimType() == DimensionType.CURRENCY) continue;
                Long dimensionId = subTemDim.getDimensionId();
                TemplateDim relSubTemplateDim = (TemplateDim)relSubAllTemplateDimMap.get(dimensionId);
                if (EmptyUtil.isEmpty((Object)relSubTemplateDim) || EmptyUtil.isEmpty(memberScope = relSubTemplateDim.getMemberScope())) {
                    msg = String.format(ResManager.loadKDString((String)"\u6c47\u603b\u56fa\u5b9a\u5b50\u8868\u3010%1$s\u3011\u79d1\u76ee\u3010%2$s\u3011\u4e0d\u5728\u4e0b\u7ea7\u4e3b\u8868\u79d1\u76ee\u8303\u56f4\u4e2d\uff0c\u5f53\u524d\u4e0b\u7ea7\u5b50\u8868\u3010%3$s\u3011\u4e3a\u56fa\u5b9a\u8868\uff0c\u5b58\u5728\u540c\u6837\u7684\u79d1\u76ee\uff0c\u4f46\u4e0d\u5b58\u5728\u7ef4\u5ea6\u3010%4$s\u3011", (String)"TemplateService_42", (String)"tmc-fpm-business", (Object[])new Object[0]), subTemplate.getName(), subjectMem.getName(), relSubTemplate.getName(), subTemDim.getDimensionName());
                    LOGGER.info(msg);
                    return CheckResult.failure(msg, subjectMem.getName(), subTemDim.getDimensionName(), relSubTemplate.getName());
                }
                if (!memberScope.containsAll(subTemDim.getMemberScope())) continue;
                msg = String.format(ResManager.loadKDString((String)"\u6c47\u603b\u56fa\u5b9a\u5b50\u8868\u3010%1$s\u3011\u79d1\u76ee\u3010%2$s\u3011\u4e0d\u5728\u4e3b\u8868\u79d1\u76ee\u8303\u56f4\u4e2d\uff0c\u5f53\u524d\u4e0b\u7ea7\u5b50\u8868\u3010%3$s\u3011\u4e3a\u56fa\u5b9a\u8868\uff0c\u5b58\u5728\u540c\u6837\u7684\u79d1\u76ee\uff0c\u7ef4\u5ea6\u3010%4$s\u3011\u7684\u6210\u5458\u8303\u56f4\u4e0d\u5927\u4e8e\u56fa\u5b9a\u6c47\u603b\u5b50\u8868\u7684\u7ef4\u5ea6\u6210\u5458\u8303\u56f4", (String)"TemplateService_43", (String)"tmc-fpm-business", (Object[])new Object[0]), subTemplate.getName(), subjectMem.getName(), relSubTemplate.getName(), subTemDim.getDimensionName());
                LOGGER.info(msg);
                return CheckResult.failure(msg, subjectMem.getName(), subTemDim.getDimensionName(), relSubTemplate.getName());
            }
            return CheckResult.success();
        }
        return CheckResult.success();
    }

    private <T> int getSize(Collection<T> collection) {
        return CollectionUtils.isEmpty(collection) ? 0 : collection.size();
    }

    private int multi(int size1, int size2) {
        if (size1 == 0) {
            return size2;
        }
        if (size2 == 0) {
            return size1;
        }
        return size1 * size2;
    }

    private String checkValidReferenceMetric(ReportTemplate reportTemplate) {
        for (TemplateReportType templateReportType : reportTemplate.getReportTypeList()) {
            List<MetricMember> metricMembers = templateReportType.getReferencePosList();
            if (EmptyUtil.isEmpty(metricMembers)) continue;
            Set needBaseMetricTypeSet = metricMembers.stream().filter(member -> member.getMetricType() == MetricMemberTypeEnum.ANALYSE).map(MetricMember::getValStr).filter(StringUtils::isNotEmpty).map(MetricValueUtils::splitFormulaBaseMetricType).flatMap(Collection::stream).map(MetricValueUtils::switchType).collect(Collectors.toSet());
            Set selectedBaseMetricTypeSet = metricMembers.stream().filter(member -> member.getMetricType() == MetricMemberTypeEnum.BASE).map(MetricMember::getTemplateMetricType).collect(Collectors.toSet());
            if (!selectedBaseMetricTypeSet.isEmpty() && selectedBaseMetricTypeSet.containsAll(needBaseMetricTypeSet)) continue;
            return ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u53c2\u8003\u671f\u95f4\u7684\u53c2\u8003\u6307\u6807\u4e2d\u82e5\u542b\u8ba1\u7b97\u7c7b\u7684\u6307\u6807\u6210\u5458\uff0c\u9700\u8981\u5c06\u5bf9\u5e94\u7684\u8ba1\u7b97\u56e0\u5b50\u57fa\u7840\u5ea6\u91cf\u4e5f\u9009\u62e9\u4e0a\u3002", (String)"TemplateService_44", (String)"tmc-fpm-business", (Object[])new Object[0]);
        }
        return CHECK_SUCCESS;
    }

    public static class CheckResult {
        private boolean success;
        private String notSuccessSubjectName;
        private String notSuccessDimName;
        private String notSuccessTemplateName;
        private String detailMsg;

        public CheckResult() {
        }

        public CheckResult(boolean success) {
            this.success = success;
        }

        public CheckResult(boolean success, String detailMsg, String notSuccessSubjectName, String notSuccessDimName, String notSuccessTemplateName) {
            this.success = success;
            this.detailMsg = detailMsg;
            this.notSuccessSubjectName = notSuccessSubjectName;
            this.notSuccessDimName = notSuccessDimName;
            this.notSuccessTemplateName = notSuccessTemplateName;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public String getNotSuccessSubjectName() {
            return this.notSuccessSubjectName;
        }

        public void setNotSuccessSubjectName(String notSuccessSubjectName) {
            this.notSuccessSubjectName = notSuccessSubjectName;
        }

        public String getNotSuccessDimName() {
            return this.notSuccessDimName;
        }

        public void setNotSuccessDimName(String notSuccessDimName) {
            this.notSuccessDimName = notSuccessDimName;
        }

        public String getNotSuccessTemplateName() {
            return this.notSuccessTemplateName;
        }

        public void setNotSuccessTemplateName(String notSuccessTemplateName) {
            this.notSuccessTemplateName = notSuccessTemplateName;
        }

        public static CheckResult success() {
            return new CheckResult(true);
        }

        public static CheckResult failure(String detailMsg, String subjectName, String dimName, String templateName) {
            return new CheckResult(false, detailMsg, subjectName, dimName, templateName);
        }

        public String getDetailMsg() {
            return this.detailMsg;
        }

        public void setDetailMsg(String detailMsg) {
            this.detailMsg = detailMsg;
        }
    }
}

