/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.helper;

import java.util.HashSet;
import java.util.Objects;
import java.util.function.Predicate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;

public class AnalysisInfoHelper {
    private static final Log logger = LogFactory.getLog(AnalysisInfoHelper.class);

    public static Predicate<AccountMember> getSubjectFilterByFlow(String flow) {
        HashSet<FlowType> flowTypes = new HashSet<FlowType>(8);
        if (Objects.equals(flow, FlowType.NONLIMIT.getNumber())) {
            flowTypes.add(FlowType.IN);
            flowTypes.add(FlowType.OUT);
        } else {
            flowTypes.add(FlowType.getByNumber(flow));
        }
        return accountMember -> {
            if (!flowTypes.contains((Object)accountMember.getFlowType())) {
                return false;
            }
            AccountMember parent = (AccountMember)accountMember.getParent();
            if (Objects.isNull(parent)) {
                return true;
            }
            return parent.getFlowType() != accountMember.getFlowType();
        };
    }
}

