/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.helper;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.ControlRequestUpdateInfo;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.service.IRelateReportDataManager;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.impl.ControlRequestUpdateRecordManager;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;

public class ControlStrategyUpdateInfoHelper {
    private static final Log logger = LogFactory.getLog(ControlStrategyUpdateInfoHelper.class);

    public static void insertControlUpdateInfoAndFillBackRequestId(ControlContext controlContext) {
        ControlStrategyUpdateInfoHelper.insertControlUpdateInfoAndFillBackRequestId(controlContext, true);
    }

    public static void insertControlUpdateInfoAndFillBackRequestId(ControlContext controlContext, boolean searchPre) {
        ControlRequestUpdateInfo controlRequestUpdateInfo = ControlRequestUpdateInfo.newInstance(controlContext.getPlanExecuteOpType());
        PlanExecuteOpType planExecuteOpType = controlContext.getPlanExecuteOpType();
        if (planExecuteOpType.isPositiveOp()) {
            ControlStrategyUpdateInfoHelper.fillControlUpdateInfo(controlContext, controlRequestUpdateInfo);
        }
        ControlRequestUpdateRecordManager instance = ControlRequestUpdateRecordManager.getInstance(controlRequestUpdateInfo);
        Long requestId = controlRequestUpdateInfo.getRequestId();
        controlContext.setRequestId(requestId);
        if (searchPre) {
            instance = ControlRequestUpdateRecordManager.getInstanceByRequestId(requestId, controlContext.getCurrentMinRequestId());
        }
        controlContext.setControlRequestUpdateRecordManager(instance);
    }

    private static void fillControlUpdateInfo(ControlContext controlContext, ControlRequestUpdateInfo controlRequestUpdateInfo) {
        PlanExecuteOpType planExecuteOpType = controlContext.getPlanExecuteOpType();
        for (ControlExecuteParam controlExecuteParam : controlContext.getControlExecuteParamList()) {
            List<ReportData> matchedReportDataList = controlExecuteParam.getMatchedReportDataList();
            if (EmptyUtil.isEmpty(matchedReportDataList)) continue;
            BigDecimal executeActAmount = controlExecuteParam.getExecuteActAmount();
            for (ReportData reportData : matchedReportDataList) {
                BigDecimal reportActAmount = reportData.getReportActAmount(executeActAmount);
                Long reportDataId = reportData.getId();
                Long reportId = reportData.getReportId();
                if (planExecuteOpType.isOccupy()) {
                    controlRequestUpdateInfo.addLockExecuteAmt(reportDataId, reportId, reportActAmount);
                    continue;
                }
                controlRequestUpdateInfo.addFactExecuteAmt(reportDataId, reportId, reportActAmount);
            }
        }
    }

    public static void fillBackConcurrentAmountInfo(ControlContext controlContext) {
        List<ControlExecuteParam> controlExecuteParamList = controlContext.getControlExecuteParamList();
        IRelateReportDataManager relateReportDataManager = controlContext.getRelateReportDataManager();
        ControlRequestUpdateRecordManager controlRequestUpdateRecordManager = controlContext.getControlRequestUpdateRecordManager();
        List<ControlRequestUpdateInfo> preControlRequestUpdateInfoList = controlRequestUpdateRecordManager.getPreControlRequestUpdateInfoList();
        List<ReportData> concurrentReportDataList = controlRequestUpdateRecordManager.getConcurrentReportDataList();
        Map<Long, ReportData> concurrentReportDataMap = concurrentReportDataList.stream().collect(Collectors.toMap(ReportData::getId, Function.identity(), (a, b) -> a));
        logger.info("\u5f53\u524drequestId:{}\u5b58\u5728\u5e76\u53d1\u63a7\u5236\uff0c\u524d\u9762\u5e76\u53d1\u5bf9\u8c61:{},\u5e76\u53d1\u6570\u636e\u96c6:{}", new Object[]{controlContext.getRequestId(), preControlRequestUpdateInfoList, concurrentReportDataList});
        Consumer<ReportData> consumer = ControlStrategyUpdateInfoHelper.updateReportDataConsumer(concurrentReportDataMap, preControlRequestUpdateInfoList);
        HashSet<String> mergeKeys = new HashSet<String>(128);
        for (ControlExecuteParam controlExecuteParam : controlExecuteParamList) {
            String mergeKey = controlExecuteParam.getMergeKey();
            if (EmptyUtil.isNoEmpty((String)mergeKey)) {
                mergeKey = String.join((CharSequence)mergeKey, controlExecuteParam.getReportTypeId().toString());
            }
            if (EmptyUtil.isNoEmpty((String)mergeKey) && mergeKeys.add(mergeKey)) continue;
            List<ReportData> relateReportDataList = controlExecuteParam.getRelateReportDataList();
            relateReportDataList.forEach(rd -> consumer.accept((ReportData)rd));
            relateReportDataManager.reCalculateRelateDataByDAGAndCompletionIndex(relateReportDataList);
        }
    }

    private static Consumer<ReportData> updateReportDataConsumer(Map<Long, ReportData> concurrentReportDataMap, List<ControlRequestUpdateInfo> preControlRequestUpdateInfoList) {
        HashSet dataIds = new HashSet(concurrentReportDataMap.size());
        return reportData -> {
            Long reportDataId = reportData.getId();
            if (!dataIds.add(reportDataId)) {
                return;
            }
            preControlRequestUpdateInfoList.stream().forEach(info -> ControlStrategyUpdateInfoHelper.updateAmount(info, reportData));
            ReportData updatedReportData = (ReportData)concurrentReportDataMap.get(reportDataId);
            if (Objects.isNull(updatedReportData)) {
                return;
            }
            reportData.setLockAmt(updatedReportData.getLockAmt());
            reportData.setHoldLockAmt(updatedReportData.getHoldLockAmt());
            reportData.setActAmt(updatedReportData.getActAmt());
            reportData.setHoldActAmt(updatedReportData.getHoldActAmt());
        };
    }

    private static void updateAmount(ControlRequestUpdateInfo controlRequestUpdateInfo, ReportData reportData) {
        reportData.addConcurrentAmt(controlRequestUpdateInfo.getLockExecuteAmt(reportData.getId()));
        reportData.addConcurrentAmt(controlRequestUpdateInfo.getFactExecuteAmt(reportData.getId()));
    }

    public static boolean needReCheck(ControlContext controlContext) {
        Long requestId = controlContext.getRequestId();
        ControlRequestUpdateRecordManager controlRequestUpdateRecordManager = controlContext.getControlRequestUpdateRecordManager();
        List<ControlRequestUpdateInfo> preControlRequestUpdateInfoList = controlRequestUpdateRecordManager.getPreControlRequestUpdateInfoList();
        List<ReportData> concurrentReportDataList = controlRequestUpdateRecordManager.getConcurrentReportDataList();
        if (EmptyUtil.isNoEmpty(concurrentReportDataList)) {
            logger.info("\u5f53\u524d\u8bf7\u6c42\uff1a{} \u5b58\u5728\u5e76\u53d1\u6570\u636e\u96c6\uff0c\u9700\u8981\u518d\u6b21\u68c0\u67e5\u63a7\u5236\u7b56\u7565\u3002\u3002\u3002", (Object)requestId);
            return true;
        }
        if (EmptyUtil.isEmpty(preControlRequestUpdateInfoList)) {
            logger.info("\u5f53\u524d\u8bf7\u6c42\uff1a{} \u524d\u4e0d\u5b58\u5728\u5e76\u53d1\u8bf7\u6c42\uff0c\u4e0d\u9700\u8981\u518d\u6b21\u6821\u9a8c\u63a7\u5236\u7b56\u7565\u3002\u3002\u3002", (Object)requestId);
            return false;
        }
        Set reportDataIds = preControlRequestUpdateInfoList.stream().map(ControlRequestUpdateInfo::getReportDataIds).flatMap(Collection::stream).collect(Collectors.toSet());
        HashSet waitDeleteReportIds = new HashSet(reportDataIds);
        HashSet<String> mergeKeys = new HashSet<String>(64);
        for (ControlExecuteParam controlExecuteParam : controlContext.getControlExecuteParamList()) {
            String mergeKey = controlExecuteParam.getMergeKey();
            if (EmptyUtil.isNoEmpty((String)mergeKey) && mergeKeys.contains(mergeKey)) continue;
            List<ReportData> matchedReportDataList = controlExecuteParam.getMatchedReportDataList();
            waitDeleteReportIds.removeAll(matchedReportDataList.stream().map(ReportData::getId).collect(Collectors.toSet()));
            if (waitDeleteReportIds.size() != reportDataIds.size()) {
                logger.info("\u5f53\u524d\u8bf7\u6c42\uff1a{} \u524d\u5b58\u5728\u5e76\u53d1\u8bf7\u6c42\uff0c\u4e14\u5b58\u5728\u5339\u914d\u5230\u76f8\u540c\u7684\u7f16\u5236\u6570\u636e\uff0c\u9700\u8981\u8fdb\u884c\u91cd\u65b0\u6821\u9a8c\u63a7\u5236\u7b56\u7565\u3002\u3002", (Object)requestId);
                return true;
            }
            List<ReportData> relateReportDataList = controlExecuteParam.getRelateReportDataList();
            waitDeleteReportIds.removeAll(relateReportDataList.stream().map(ReportData::getId).collect(Collectors.toSet()));
            if (waitDeleteReportIds.size() != reportDataIds.size()) {
                logger.info("\u5f53\u524d\u8bf7\u6c42\uff1a{} \u524d\u5b58\u5728\u5e76\u53d1\u8bf7\u6c42\uff0c\u4e14\u5b58\u5728\u5339\u914d\u5230\u76f8\u540c\u7684\u5173\u8054\u7684\u7f16\u5236\u6570\u636e\uff0c\u9700\u8981\u8fdb\u884c\u91cd\u65b0\u6821\u9a8c\u63a7\u5236\u7b56\u7565\u3002\u3002", (Object)requestId);
                return true;
            }
            mergeKeys.add(controlExecuteParam.getUniqueId());
        }
        return false;
    }
}

