/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.MapUtils;

public class CustomDimThreadLocalHelper {
    private static ThreadLocal<CustomDimInfo> customDimInfoThreadLocal = ThreadLocal.withInitial(() -> new CustomDimInfo());

    public static void clean() {
        customDimInfoThreadLocal.remove();
    }

    public static CustomDimInfo get() {
        return customDimInfoThreadLocal.get();
    }

    public static void set(CustomDimInfo customDimInfo) {
        customDimInfoThreadLocal.set(customDimInfo);
    }

    public static void set(Map<String, Long> customDimNumberIdMap) {
        customDimInfoThreadLocal.set(new CustomDimInfo(customDimNumberIdMap));
    }

    public static class CustomDimInfo {
        private Map<String, Long> customDimNumberIdMap;
        private Map<Long, String> customIdDimNumberMap;
        private Map<Long, Long> customDimMemberDimMap;

        public CustomDimInfo() {
            this(Collections.emptyMap());
        }

        public CustomDimInfo(Map<String, Long> customDimNumberIdMap) {
            this.customDimNumberIdMap = customDimNumberIdMap;
            this.customDimMemberDimMap = new HashMap<Long, Long>(216);
            this.customIdDimNumberMap = customDimNumberIdMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            this.init();
        }

        public Long getCustomDimIdByMemberId(Long memberId) {
            return this.customDimMemberDimMap.getOrDefault(memberId, 0L);
        }

        public String getDimNumberByMemberId(Long memberId) {
            return this.customIdDimNumberMap.getOrDefault(this.getCustomDimIdByMemberId(memberId), "");
        }

        private void init() {
            if (MapUtils.isEmpty(this.customDimNumberIdMap)) {
                return;
            }
            Collection<Long> customDimIds = this.customDimNumberIdMap.values();
            String dimIdProp = String.join((CharSequence)".", "dimension", "id");
            String selectFields = String.join((CharSequence)",", "id", dimIdProp);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_member", (String)selectFields, (QFilter[])new QFilter[]{new QFilter(dimIdProp, "in", customDimIds)});
            for (DynamicObject dy : query) {
                this.customDimMemberDimMap.putIfAbsent(dy.getLong("id"), dy.getLong(dimIdProp));
            }
        }
    }
}

