/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateLayout;
import kd.tmc.fpm.business.mvc.converter.TemplateVOConverter;
import kd.tmc.fpm.common.enums.DimsionEnums;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DimLayoutHelper {
    public static String getDimessionMemberType(DimLocation location, int level, DynamicObject dataEntity) {
        List<TemplateLayout.LayoutInfo> layoutInfoLst = DimLayoutHelper.getLayoutInfoByLocation(location, dataEntity);
        return DimLayoutHelper.obtainMemberType(level, layoutInfoLst);
    }

    public static String getDimessionMemberType(DimLocation location, int level, ReportTemplate template) {
        List<TemplateLayout.LayoutInfo> layoutInfoLst = DimLayoutHelper.getLayoutInfoByLocation(location, template.getDimLayout());
        return DimLayoutHelper.obtainMemberType(level, layoutInfoLst);
    }

    public static Long getDimessionId(DimLocation location, int level, DynamicObject dataEntity) {
        List<TemplateLayout.LayoutInfo> layoutInfoLst = DimLayoutHelper.getLayoutInfoByLocation(location, dataEntity);
        Long dimessionId = 0L;
        for (TemplateLayout.LayoutInfo layoutInfo : layoutInfoLst) {
            int currentLevel = layoutInfo.getLevel();
            if (level != currentLevel) continue;
            dimessionId = layoutInfo.getDimensionId();
            break;
        }
        return dimessionId;
    }

    public static List<TemplateLayout.LayoutInfo> getLayoutInfoByLocation(DimLocation location, DynamicObject dataEntity) {
        TemplateLayout templateLayout = TemplateVOConverter.convertDimLayoutInfo(dataEntity);
        return DimLayoutHelper.getLayoutInfoByLocation(location, templateLayout);
    }

    public static List<TemplateLayout.LayoutInfo> getLayoutInfoByLocation(DimLocation location, TemplateLayout templateLayout) {
        ArrayList<TemplateLayout.LayoutInfo> layoutInfoLst = new ArrayList<TemplateLayout.LayoutInfo>(0);
        if (templateLayout != null) {
            if (DimLocation.ROW.getNumber().equals(location.getNumber())) {
                layoutInfoLst.addAll(templateLayout.getRowLayout());
            } else if (DimLocation.COL.getNumber().equals(location.getNumber())) {
                layoutInfoLst.addAll(templateLayout.getColLayout());
            } else if (DimLocation.PAGE.getNumber().equals(location.getNumber())) {
                layoutInfoLst.addAll(templateLayout.getPageLayout());
            }
        }
        return layoutInfoLst;
    }

    public static Pair<String, String> memberOfPosition(DynamicObject dataEntity, String dimMember, DimsionEnums positionMember) {
        String attrName = null;
        String entryName = "colentryentity";
        DimLocation[] locations = DimLocation.values();
        int[] levels = new int[]{1, 2, 3};
        MutablePair pair = null;
        block0: for (DimLocation dimLocation : locations) {
            if (null != attrName) break;
            for (int level : levels) {
                String dimessionType = DimLayoutHelper.getDimessionMemberType(dimLocation, level, dataEntity);
                if (!positionMember.getNumber().equals(dimessionType)) continue;
                attrName = String.format(dimMember, level, dimLocation.getNumber().toLowerCase());
                entryName = DimLocation.COL.getNumber().equals(dimLocation.getNumber()) ? "colentryentity" : (DimLocation.ROW.getNumber().equals(dimLocation.getNumber()) ? "rowentryentity" : "pagedimentry");
                pair = new MutablePair((Object)attrName, (Object)entryName);
                continue block0;
            }
        }
        return pair;
    }

    public static boolean isIncludeDimOfLvNum(DynamicObject dataEntity, DimLocation location, Integer level) {
        boolean bool = false;
        List<TemplateLayout.LayoutInfo> layoutInfoLst = DimLayoutHelper.getLayoutInfoByLocation(location, dataEntity);
        for (TemplateLayout.LayoutInfo layoutInfo : layoutInfoLst) {
            if (layoutInfo.getLevel().compareTo(level) != 0) continue;
            bool = true;
            break;
        }
        return bool;
    }

    public static boolean isIncludeDimOfLvNum(ReportTemplate template, DimLocation location, Integer level) {
        boolean bool = false;
        List<TemplateLayout.LayoutInfo> layoutInfoLst = DimLayoutHelper.getLayoutInfoByLocation(location, template.getDimLayout());
        for (TemplateLayout.LayoutInfo layoutInfo : layoutInfoLst) {
            if (layoutInfo.getLevel().compareTo(level) != 0) continue;
            bool = true;
            break;
        }
        return bool;
    }

    public static String getDimessionName(DimLocation location, int level, DynamicObject dataEntity) {
        List<TemplateLayout.LayoutInfo> layoutInfoLst = DimLayoutHelper.getLayoutInfoByLocation(location, dataEntity);
        return DimLayoutHelper.obtainMemberName(level, layoutInfoLst);
    }

    private static String obtainMemberType(int level, List<TemplateLayout.LayoutInfo> layoutInfoLst) {
        return DimLayoutHelper.obtainMemberInfo(level, layoutInfoLst, "number");
    }

    private static String obtainMemberName(int level, List<TemplateLayout.LayoutInfo> layoutInfoLst) {
        return DimLayoutHelper.obtainMemberInfo(level, layoutInfoLst, "name");
    }

    private static String obtainMemberInfo(int level, List<TemplateLayout.LayoutInfo> layoutInfoLst, String memberProp) {
        TemplateLayout.LayoutInfo seekLayoutInfo = null;
        for (TemplateLayout.LayoutInfo layoutInfo : layoutInfoLst) {
            int currentLevel = layoutInfo.getLevel();
            if (level != currentLevel) continue;
            seekLayoutInfo = layoutInfo;
            break;
        }
        if (Objects.isNull(seekLayoutInfo) || Objects.isNull(seekLayoutInfo.getDimensionId())) {
            return null;
        }
        DynamicObject dc = TmcDataServiceHelper.loadSingleFromCache((Object)seekLayoutInfo.getDimensionId(), (String)"fpm_dimension", (String)memberProp);
        if (Objects.isNull(dc)) {
            return null;
        }
        return dc.getString(memberProp);
    }
}

