/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.helper;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaOperationVal;
import kd.tmc.fpm.business.spread.formula.FormulaOperatorSymbol;
import kd.tmc.fpm.business.spread.formula.IFormulaOperator;
import kd.tmc.fpm.business.spread.formula.enums.FormulaSymbolEnum;
import kd.tmc.fpm.common.utils.NumberUtils;
import org.apache.commons.collections.CollectionUtils;

public class FormulaHelper {
    private static final Log LOGGER = LogFactory.getLog(FormulaHelper.class);

    public static Formula getFormula(String excelFormula, ReportData leftCalcVal) {
        Formula formula = new Formula();
        FormulaOperationVal leftOperationVal = new FormulaOperationVal();
        leftOperationVal.setName(leftCalcVal.getId().toString());
        formula.setLeftVal(leftOperationVal);
        LinkedList<IFormulaOperator> operator = new LinkedList<IFormulaOperator>();
        excelFormula = excelFormula.replaceAll("SUM\\(", "\\(");
        String regEx = "[+\\-]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(excelFormula);
        String[] excelPostArr = p.split(excelFormula);
        ArrayList<String> symbolArr = new ArrayList<String>(excelPostArr.length - 1);
        for (int count = 0; count < excelPostArr.length; ++count) {
            if (!m.find()) continue;
            symbolArr.add(m.group());
        }
        for (int i = 0; i < excelPostArr.length; ++i) {
            String excelPost = excelPostArr[i];
            if (excelPost.matches("^(\\[)[0-9]+(])$")) {
                LOGGER.warn("ReportService getFormula warn, \u5f53\u524d\u516c\u5f0f\u79d1\u76eeID\u672a\u66ff\u6362\u4e3a\u6709\u6548\u6570\u636e\uff0c\u79d1\u76eeID:{}", (Object)excelPost);
                continue;
            }
            if (excelPost.contains("(")) {
                FormulaOperatorSymbol bracketLeft = new FormulaOperatorSymbol(FormulaSymbolEnum.BRACKET_LEFT);
                operator.add(bracketLeft);
            }
            String replaceId = excelPost.replaceAll("\\(", "").replaceAll("\\)", "");
            FormulaOperationVal rightVal = new FormulaOperationVal();
            if (StringUtils.isEmpty((String)replaceId)) {
                rightVal.setName("-1");
            } else {
                rightVal.setName(replaceId);
            }
            operator.add(rightVal);
            if (excelPost.contains(")")) {
                FormulaOperatorSymbol bracketRight = new FormulaOperatorSymbol(FormulaSymbolEnum.BRACKET_RIGHT);
                operator.add(bracketRight);
            }
            if (i >= symbolArr.size()) continue;
            FormulaOperatorSymbol addSymbol = new FormulaOperatorSymbol(FormulaSymbolEnum.getBySymbol((String)symbolArr.get(i)));
            operator.add(addSymbol);
        }
        formula.setOperator(operator);
        return formula;
    }

    public static Formula getFormula(List<String> excelFormulaList, ReportData leftCalcVal) {
        Formula formula = new Formula();
        FormulaOperationVal leftOperationVal = new FormulaOperationVal();
        leftOperationVal.setName(leftCalcVal.getId().toString());
        formula.setLeftVal(leftOperationVal);
        LinkedList<IFormulaOperator> operator = new LinkedList<IFormulaOperator>();
        for (String excelFormula : excelFormulaList) {
            excelFormula = excelFormula.replaceAll("SUM\\(", "");
            excelFormula = excelFormula.replaceAll("\\)", "");
            String regEx = "[+\\-]";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(excelFormula);
            String[] excelPostArr = p.split(excelFormula);
            ArrayList<String> symbolArr = new ArrayList<String>(excelPostArr.length - 1);
            for (int count = 0; count < excelPostArr.length; ++count) {
                if (!m.find()) continue;
                symbolArr.add(m.group());
            }
            for (int i = 0; i < excelPostArr.length; ++i) {
                String excelPost = excelPostArr[i];
                if (excelPost.matches("^(\\[)[0-9]+(])$")) {
                    LOGGER.warn("ReportService getFormula warn, \u5f53\u524d\u516c\u5f0f\u79d1\u76eeID\u672a\u66ff\u6362\u4e3a\u6709\u6548\u6570\u636e\uff0c\u79d1\u76eeID:{}", (Object)excelPost);
                    continue;
                }
                FormulaOperationVal rightVal = new FormulaOperationVal();
                rightVal.setName(excelPost);
                operator.add(rightVal);
                if (i >= symbolArr.size()) continue;
                FormulaOperatorSymbol addSymbol = new FormulaOperatorSymbol(FormulaSymbolEnum.getBySymbol((String)symbolArr.get(i)));
                operator.add(addSymbol);
            }
        }
        formula.setOperator(operator);
        return formula;
    }

    public static Formula parseSubject(AccountMember currentMember) {
        Formula resultFormula = new Formula();
        ReportInputType inputType = currentMember.getInputType();
        if (ReportInputType.SUMMARY == inputType) {
            List<DimMember> allChildMember = currentMember.getAllChildMember();
            if (CollectionUtils.isEmpty(allChildMember)) {
                return null;
            }
            Integer maxLevel = allChildMember.stream().map(DimMember::getLevel).max(Comparator.comparingInt(i -> i)).orElse(1);
            List<String> childMemberIds = allChildMember.stream().filter(item -> NumberUtils.equals((Integer)maxLevel, (Integer)item.getLevel())).map(item -> item.getId().toString()).collect(Collectors.toList());
            resultFormula = FormulaHelper.generateFormula(currentMember.getId().toString(), childMemberIds);
        } else if (ReportInputType.FORMULA == inputType) {
            resultFormula = FormulaHelper.parseSubjectFormula(currentMember.getId().toString(), currentMember.getFormula());
        }
        return resultFormula;
    }

    public static Formula parseSubjectFormula(String leftVal, String formula) {
        Formula resultFormula = new Formula();
        FormulaOperationVal leftOperationVal = new FormulaOperationVal();
        leftOperationVal.setName(leftVal);
        resultFormula.setLeftVal(leftOperationVal);
        LinkedList<IFormulaOperator> operator = new LinkedList<IFormulaOperator>();
        String targetFormulaStr = formula.replaceAll("\\(", "").replaceAll("\\)", "");
        String regEx = "[+\\-]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(targetFormulaStr);
        String[] accountIdArr = p.split(targetFormulaStr);
        ArrayList<String> symbolArr = new ArrayList<String>(accountIdArr.length - 1);
        for (int count = 0; count < accountIdArr.length; ++count) {
            if (!m.find()) continue;
            symbolArr.add(m.group());
        }
        for (int i = 0; i < accountIdArr.length; ++i) {
            String accountId = accountIdArr[i];
            FormulaOperationVal rightVal = new FormulaOperationVal();
            rightVal.setName(accountId.replace("[", "").replace("]", ""));
            operator.add(rightVal);
            if (i >= symbolArr.size()) continue;
            FormulaOperatorSymbol addSymbol = new FormulaOperatorSymbol(FormulaSymbolEnum.getBySymbol((String)symbolArr.get(i)));
            operator.add(addSymbol);
        }
        resultFormula.setOperator(operator);
        return resultFormula;
    }

    public static Formula getFormula(ReportData leftCalcVal, List<ReportData> dataValList) {
        List<String> rightValList = dataValList.stream().map(ReportData::getId).map(Object::toString).collect(Collectors.toList());
        return FormulaHelper.generateFormula(leftCalcVal.getId().toString(), rightValList);
    }

    public static Formula generateFormula(String leftVal, List<String> rightValList) {
        Formula formula = new Formula();
        FormulaOperationVal leftOperationVal = new FormulaOperationVal();
        leftOperationVal.setName(leftVal);
        formula.setLeftVal(leftOperationVal);
        LinkedList<IFormulaOperator> operator = new LinkedList<IFormulaOperator>();
        for (String rightVal : rightValList) {
            if (rightVal == null) continue;
            FormulaOperationVal rightFormula = new FormulaOperationVal();
            rightFormula.setName(rightVal);
            operator.add(rightFormula);
            FormulaOperatorSymbol addSymbol = new FormulaOperatorSymbol(FormulaSymbolEnum.PLUS);
            operator.add(addSymbol);
        }
        if (CollectionUtils.isNotEmpty(operator)) {
            operator.removeLast();
        }
        formula.setOperator(operator);
        return formula;
    }

    public static Map<String, FormulaSymbolEnum> getMapByFormula(String formula) {
        int count;
        HashMap<String, FormulaSymbolEnum> formulaMap = new HashMap<String, FormulaSymbolEnum>(8);
        String targetFormulaStr = formula.replaceAll("\\(", "").replaceAll("\\)", "");
        String regEx = "[+\\-]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(targetFormulaStr);
        String[] accountIdArr = p.split(targetFormulaStr);
        HashMap<Integer, String> symbolMap = new HashMap<Integer, String>(accountIdArr.length);
        symbolMap.put(count, FormulaSymbolEnum.PLUS.getSymbol());
        for (count = 1; count < accountIdArr.length; ++count) {
            if (!m.find()) continue;
            symbolMap.put(count, m.group());
        }
        for (int i = 0; i < accountIdArr.length; ++i) {
            String accountId = accountIdArr[i];
            String symbol = symbolMap.getOrDefault(i, FormulaSymbolEnum.PLUS.getSymbol());
            formulaMap.put(accountId.replace("[", "").replace("]", ""), FormulaSymbolEnum.getBySymbol(symbol));
        }
        return formulaMap;
    }

    public static Formula completeSettingFormulaBySystem(TemplateAccountSetting setting, Dimension subjectDim) {
        Set needFormulaSubjectIdSet = subjectDim.getAllDimMemberList().stream().filter(item -> {
            ReportInputType inputType = ((AccountMember)item).getInputType();
            return ReportInputType.SUMMARY == inputType || ReportInputType.FORMULA == inputType;
        }).map(DimMember::getId).collect(Collectors.toSet());
        Formula resultFormula = new Formula();
        FormulaOperationVal leftOperationVal = new FormulaOperationVal();
        leftOperationVal.setName(setting.getAccountMemId().toString());
        resultFormula.setLeftVal(leftOperationVal);
        LinkedList<IFormulaOperator> operator = new LinkedList<IFormulaOperator>();
        ReportInputType inputType = setting.getInputType();
        if (inputType == ReportInputType.SUMMARY) {
            List<TemplateAccountSetting> children = setting.getChildren();
            if (CollectionUtils.isEmpty(children)) {
                if (!needFormulaSubjectIdSet.contains(setting.getAccountMemId())) {
                    return null;
                }
                AccountMember currentMember = subjectDim.getDimMemberById(setting.getAccountMemId(), AccountMember.class);
                return FormulaHelper.parseSubject(currentMember);
            }
            for (int i = 0; i < children.size(); ++i) {
                TemplateAccountSetting childAcctSetting = children.get(i);
                FormulaOperationVal rightVal = new FormulaOperationVal();
                rightVal.setName(childAcctSetting.getAccountMemId().toString());
                operator.add(rightVal);
                if (i >= setting.getChildren().size() - 1) continue;
                FormulaOperatorSymbol addSymbol = new FormulaOperatorSymbol(FormulaSymbolEnum.PLUS);
                operator.add(addSymbol);
            }
            resultFormula.setOperator(operator);
        } else if (inputType == ReportInputType.FORMULA) {
            String formula = setting.getFormula();
            if (StringUtils.isEmpty((String)formula)) {
                if (!needFormulaSubjectIdSet.contains(setting.getAccountMemId())) {
                    return null;
                }
                AccountMember currentMember = subjectDim.getDimMemberById(setting.getAccountMemId(), AccountMember.class);
                return FormulaHelper.parseSubject(currentMember);
            }
            String targetFormulaStr = formula.replaceAll("\\(", "").replaceAll("\\)", "");
            String regEx = "\\+|\\-";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(targetFormulaStr);
            String[] accountIdArr = p.split(targetFormulaStr);
            ArrayList<String> symbolArr = new ArrayList<String>(accountIdArr.length - 1);
            for (int count = 0; count < accountIdArr.length; ++count) {
                if (!m.find()) continue;
                symbolArr.add(m.group());
            }
            for (int i = 0; i < accountIdArr.length; ++i) {
                String accountId = accountIdArr[i];
                FormulaOperationVal rightVal = new FormulaOperationVal();
                rightVal.setName(accountId.replace("[", "").replace("]", ""));
                operator.add(rightVal);
                if (i >= symbolArr.size()) continue;
                FormulaOperatorSymbol addSymbol = new FormulaOperatorSymbol(FormulaSymbolEnum.getBySymbol((String)symbolArr.get(i)));
                operator.add(addSymbol);
            }
            resultFormula.setOperator(operator);
        } else {
            if (!needFormulaSubjectIdSet.contains(setting.getAccountMemId())) {
                return null;
            }
            AccountMember currentMember = subjectDim.getDimMemberById(setting.getAccountMemId(), AccountMember.class);
            resultFormula = FormulaHelper.parseSubject(currentMember);
        }
        return resultFormula;
    }
}

