/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.helper;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import org.apache.commons.lang3.StringUtils;

public class MatchRuleHelper {
    public static final Set<DimensionType> ALLOW_DIMENSION_MEMBER_MAP_DIMENSION_TYPE_SET = Collections.unmodifiableSet(Arrays.asList(DimensionType.ORG, DimensionType.CURRENCY, DimensionType.SUBJECTS, DimensionType.SETTLEMENT_TYPE, DimensionType.COMPANY, DimensionType.CUSTOM).stream().collect(Collectors.toSet()));
    public static final Set<DimensionType> SYSTEM_DEFINE_DIMENSION_DIMENSION_TYPE_SET = Collections.unmodifiableSet(Arrays.asList(DimensionType.ORG, DimensionType.PERIOD, DimensionType.CURRENCY, DimensionType.SUBJECTS).stream().collect(Collectors.toSet()));
    public static final Set<DimensionType> CUSTOMER_DEFINE_DIMENSION_DIMENSION_TYPE_SET = Collections.unmodifiableSet(Arrays.asList(DimensionType.SETTLEMENT_TYPE, DimensionType.COMPANY, DimensionType.CUSTOM).stream().collect(Collectors.toSet()));
    public static final String ENTRY_SEPARTOR = ".";
    private Map<String, Map<String, IDataEntityProperty>> PROPERTY_MAP_CACHE = new HashMap<String, Map<String, IDataEntityProperty>>(8);

    public IDataEntityProperty getFieldType(String prop, String entityName) {
        IDataEntityProperty iDataEntityProperty;
        Map<String, IDataEntityProperty> iDataEntityPropertyMap;
        if (StringUtils.isEmpty((CharSequence)entityName)) {
            entityName = "fpm_matchrule";
        }
        if (Objects.isNull(iDataEntityPropertyMap = this.PROPERTY_MAP_CACHE.get(entityName))) {
            iDataEntityPropertyMap = new HashMap<String, IDataEntityProperty>(128);
            this.PROPERTY_MAP_CACHE.put(entityName, iDataEntityPropertyMap);
        }
        if (Objects.nonNull(iDataEntityProperty = iDataEntityPropertyMap.get(prop))) {
            return iDataEntityProperty;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        Collection<EntityType> entityTypeCollection = dataEntityType.getAllEntities().values();
        boolean isEntry = prop.indexOf(ENTRY_SEPARTOR) != -1;
        return this.getAndCacheProperty(prop, entityTypeCollection, isEntry, iDataEntityPropertyMap);
    }

    private IDataEntityProperty getAndCacheProperty(String prop, Collection<EntityType> entityTypes, boolean isEntry, Map<String, IDataEntityProperty> iDataEntityPropertyMap) {
        for (EntityType entityType : entityTypes) {
            String name = "";
            if (isEntry) {
                if (!EntryType.class.isAssignableFrom(entityType.getClass())) continue;
                name = isEntry ? entityType.getName() + ENTRY_SEPARTOR : "";
            } else if (EntryType.class.isAssignableFrom(entityType.getClass())) continue;
            DataEntityPropertyCollection properties = entityType.getProperties();
            for (IDataEntityProperty entityProperty : properties) {
                String propName = name + entityProperty.getName();
                if (iDataEntityPropertyMap.containsKey(propName)) continue;
                iDataEntityPropertyMap.put(propName, entityProperty);
                if (!StringUtils.equals((CharSequence)prop, (CharSequence)propName)) continue;
                return entityProperty;
            }
        }
        return null;
    }
}

