/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.ListUtils;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.SunReportSumStatus;
import kd.tmc.fpm.business.domain.enums.TemplateDimMemScopeType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.repository.dto.ReportBatchDataMapDTO;
import kd.tmc.fpm.business.mvc.repository.dto.ReportNeedPropDTO;
import kd.tmc.fpm.business.mvc.repository.impl.DetailPlanFieldsRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimMemberRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.TemplateRepository;
import kd.tmc.fpm.business.utils.DataSetUtil;
import kd.tmc.fpm.business.utils.DimensionMappingHelper;
import kd.tmc.fpm.common.enums.ReportPlanTypeEnum;
import kd.tmc.fpm.common.helper.FpmHelper;

public class ReportBatchDataMapHelper {
    public static ReportBatchDataMapDTO initReportNeedPropDTO(DataSet dsReport, ReportNeedPropDTO needProp, Map<Long, ReportTemplate> templateBakMap, boolean isSimple) {
        ReportBatchDataMapDTO reportBatchDataMap = new ReportBatchDataMapDTO();
        HashMap<Long, Long> parentTemplateIdMap = new HashMap<Long, Long>(8);
        HashMap<Long, Long> reportOrgMemberIdMap = new HashMap<Long, Long>(8);
        HashMap<Long, Long> reportPeriodSystemIdMap = new HashMap<Long, Long>(8);
        HashMap<Long, Long> reportIdSystemIdMap = new HashMap<Long, Long>(8);
        HashSet<Long> sumReportIds = new HashSet<Long>(8);
        ArrayList<Long> periodListReportIds = new ArrayList<Long>(8);
        ArrayList<Long> periodSystemIds = new ArrayList<Long>(8);
        for (Row row : dsReport.copy()) {
            Long referencePeriod;
            Long reportId = row.getLong("id");
            Long systemId = row.getLong("bodysys.id");
            boolean isSumPlan = ReportPlanTypeEnum.isSumPlan((String)row.getString("reportplantype"));
            reportPeriodSystemIdMap.put(row.getLong("reportperiod"), systemId);
            reportIdSystemIdMap.put(reportId, systemId);
            Object parentTemplateId = row.get("parenttemplate.id");
            if (EmptyUtil.isNoEmpty((Object)parentTemplateId)) {
                parentTemplateIdMap.put(reportId, (Long)parentTemplateId);
            }
            if (isSumPlan) {
                sumReportIds.add(reportId);
            }
            if (EmptyUtil.isNoEmpty((Long)(referencePeriod = row.getLong("referenceperiod.id")))) {
                reportPeriodSystemIdMap.put(referencePeriod, systemId);
            }
            if (needProp.isNeedCompanyMember()) {
                reportOrgMemberIdMap.put(reportId, row.getLong("reportorg.id"));
            }
            if (needProp.isNeedPeriodMember()) {
                periodListReportIds.add(reportId);
                periodSystemIds.add(systemId);
            }
            if (isSimple) continue;
            ReportBatchDataMapDTO.ReportDataMap dataMap = new ReportBatchDataMapDTO.ReportDataMap();
            dataMap.setSystemId(systemId);
            reportBatchDataMap.putReportDataMap(reportId, dataMap);
        }
        ReportBatchDataMapHelper.putTemplate(reportBatchDataMap, parentTemplateIdMap);
        if (isSimple) {
            ReportBatchDataMapHelper.putOrgDimMember(reportBatchDataMap, reportOrgMemberIdMap);
        } else {
            ReportBatchDataMapHelper.putOrgDimMember(reportBatchDataMap, reportOrgMemberIdMap, templateBakMap, sumReportIds, parentTemplateIdMap);
        }
        ReportBatchDataMapHelper.putSystemPeriodMemberMap(reportBatchDataMap, periodSystemIds);
        ReportBatchDataMapHelper.putReportPeriodType(reportBatchDataMap, reportPeriodSystemIdMap, reportIdSystemIdMap);
        ReportBatchDataMapHelper.putPeriodList(reportBatchDataMap, periodListReportIds);
        ReportBatchDataMapHelper.putSumRecords(reportBatchDataMap, sumReportIds);
        ReportBatchDataMapHelper.putReportAuxEntryMap(reportBatchDataMap);
        ReportBatchDataMapHelper.putReportSourceEntryMap(reportBatchDataMap);
        ReportBatchDataMapHelper.putMainAndDetailEntryDataSet(reportBatchDataMap);
        ReportBatchDataMapHelper.putDetailMapping(reportBatchDataMap);
        ReportBatchDataMapHelper.putExchangeRateMap(reportBatchDataMap);
        return reportBatchDataMap;
    }

    private static void putSystemPeriodMemberMap(ReportBatchDataMapDTO reportBatchDataMap, List<Long> periodSystemIds) {
        if (!periodSystemIds.isEmpty()) {
            Map<Long, List<DimMember>> periodDimMembers = new DimMemberRepository().getPeriodDimMembers(periodSystemIds);
            periodDimMembers.forEach(reportBatchDataMap::putSystemPeriodMemberMap);
        }
    }

    private static void putTemplate(ReportBatchDataMapDTO reportBatchDataMap, Map<Long, Long> parenTemplateIdMap) {
        if (!parenTemplateIdMap.isEmpty()) {
            Map templateMap = TmcDataServiceHelper.loadFromCache((Object[])parenTemplateIdMap.values().toArray(), (String)"fpm_template");
            templateMap.values().forEach(reportBatchDataMap::putTemplate);
        }
    }

    private static void putOrgDimMember(ReportBatchDataMapDTO reportBatchDataMap, Map<Long, Long> reportOrgIdMap) {
        if (reportOrgIdMap.isEmpty()) {
            return;
        }
        Map<Long, DimMember> orgDimMembers = new DimMemberRepository().getOrgDimMembers(new ArrayList<Long>(reportOrgIdMap.values()));
        orgDimMembers.forEach((k, v) -> reportBatchDataMap.putOrgDimMember((Long)k, Collections.singletonList((OrgMember)v)));
    }

    private static void putReportPeriodType(ReportBatchDataMapDTO reportBatchDataMap, Map<Long, Long> reportPeriodSystemIdMap, Map<Long, Long> reportIdSystemIdMap) {
        if (reportPeriodSystemIdMap.isEmpty()) {
            return;
        }
        List<FundPlanSystem> systems = new DimensionRepository().loadSystems(new HashSet<Long>(reportPeriodSystemIdMap.values()));
        Map<Long, FundPlanSystem> systemMap = systems.stream().collect(Collectors.toMap(FundPlanSystem::getId, d -> d));
        Map memberMap = TmcDataServiceHelper.loadFromCache((String)"fpm_member", (String)"reporttype.id", (QFilter[])new QFilter("id", "in", reportPeriodSystemIdMap.keySet()).toArray());
        for (DynamicObject dynamicObject : memberMap.values()) {
            long memberId = dynamicObject.getLong("id");
            Long systemId = reportPeriodSystemIdMap.get(memberId);
            FundPlanSystem fundPlanSystem = systemMap.get(systemId);
            long periodReportTypeId = dynamicObject.getLong("reporttype.id");
            ReportPeriodType reportPeriodType = fundPlanSystem.getReportTypeList().stream().filter(d -> d.getReportPeriodId().equals(periodReportTypeId)).findFirst().orElse(null);
            reportBatchDataMap.putReportPeriodType(dynamicObject.getLong("id"), reportPeriodType);
        }
        for (Map.Entry entry : reportIdSystemIdMap.entrySet()) {
            reportBatchDataMap.putReportSystemMap((Long)entry.getKey(), systemMap.get(entry.getValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void putPeriodList(ReportBatchDataMapDTO reportBatchDataMap, List<Long> reportIds) {
        if (reportIds.isEmpty()) {
            return;
        }
        String ids = reportIds.stream().map(String::valueOf).collect(Collectors.joining(","));
        String sql = String.format("select fid,fbasedataid from t_fpm_report_period where fid in (%s)", ids);
        DataSet dataSet = DB.queryDataSet((String)"queryReportPeriod", (DBRoute)DBRouteConst.TMC, (String)sql, (Object[])new Object[0]);
        try {
            for (Long reportId : reportIds) {
                DataSet dsCopy = dataSet.copy();
                DataSet dsReport = dsCopy.filter("fid = " + reportId);
                try {
                    HashSet<Long> periodList = new HashSet<Long>(8);
                    for (Row row : dsReport) {
                        periodList.add(row.getLong("fbasedataid"));
                    }
                    reportBatchDataMap.putPeriodList(reportId, periodList);
                }
                catch (Throwable throwable) {
                    DataSetUtil.closeDataSet(dsCopy, dsReport);
                    throw throwable;
                }
                DataSetUtil.closeDataSet(dsCopy, dsReport);
            }
        }
        catch (Throwable throwable) {
            DataSetUtil.closeDataSet(dataSet);
            throw throwable;
        }
        DataSetUtil.closeDataSet(dataSet);
    }

    private static void putSumRecords(ReportBatchDataMapDTO reportBatchDataMap, Set<Long> sumReportIds) {
        if (sumReportIds.isEmpty()) {
            return;
        }
        String selectFields = String.join((CharSequence)",", "id", "sumentry.sumorgreportid", "sumentry.sumstatus");
        DynamicObjectCollection sumEntryColl = QueryServiceHelper.query((String)"fpm_report", (String)selectFields, (QFilter[])new QFilter("id", "in", sumReportIds).toArray());
        Map<Long, List<DynamicObject>> sumEntryMap = sumEntryColl.stream().collect(Collectors.groupingBy(d -> d.getLong("id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : sumEntryMap.entrySet()) {
            Long reportId = entry.getKey();
            List<DynamicObject> sumEntrys = entry.getValue();
            ArrayList<SumPlanReport.SunReportSumRecord> sumInfoList = new ArrayList<SumPlanReport.SunReportSumRecord>(sumEntrys.size());
            for (DynamicObject sumEntryInfo : sumEntrys) {
                long sunReportId = sumEntryInfo.getLong("sumentry.sumorgreportid");
                if (sunReportId == 0L) continue;
                SumPlanReport.SunReportSumRecord sunReportSumRecord = new SumPlanReport.SunReportSumRecord();
                sunReportSumRecord.setSunReportId(sunReportId);
                sunReportSumRecord.setSumStatus(ITypeEnum.getByNumber(sumEntryInfo.getString("sumentry.sumstatus"), SunReportSumStatus.class));
                sumInfoList.add(sunReportSumRecord);
            }
            reportBatchDataMap.putSumRecords(reportId, sumInfoList);
        }
    }

    private static void putOrgDimMember(ReportBatchDataMapDTO reportBatchDataMap, Map<Long, Long> reportOrgMemberIdMap, Map<Long, ReportTemplate> templateBakMap, Set<Long> sumReportIds, Map<Long, Long> parentTemplateIdMap) {
        if (reportOrgMemberIdMap.isEmpty()) {
            return;
        }
        HashMap orgMemberDimensionMap = new HashMap(8);
        Map orgMemberMap = TmcDataServiceHelper.loadFromCache((String)"fpm_member", (String)"id,dimension.id", (QFilter[])new QFilter("id", "in", new HashSet<Long>(reportOrgMemberIdMap.values())).toArray());
        Map dimensionMap = orgMemberMap.values().stream().collect(Collectors.groupingBy(d -> d.getLong("dimension.id"), Collectors.mapping(m -> m.getLong("id"), Collectors.toList())));
        List<Dimension> dimensions = new DimensionRepository().loadMainDimension(new ArrayList<Long>(dimensionMap.keySet()));
        for (Dimension dimension : dimensions) {
            Long dimensionId = dimension.getId();
            List<Long> reportOrgMemberIds = dimensionMap.get(dimensionId);
            reportOrgMemberIds.forEach(d -> orgMemberDimensionMap.put(d, dimension));
        }
        for (Map.Entry entry : reportOrgMemberIdMap.entrySet()) {
            Long reportId = (Long)entry.getKey();
            Long reportOrgMemberId = (Long)entry.getValue();
            boolean isSumPlan = sumReportIds.contains(reportId);
            ArrayList<OrgMember> finalOrgMemberList = new ArrayList(2);
            Dimension dimension = (Dimension)orgMemberDimensionMap.get(reportOrgMemberId);
            OrgMember sumOrgMember = dimension.getDimMemberByDimId(OrgMember.class, reportOrgMemberId);
            if (isSumPlan) {
                TemplateDim orgTplDim;
                TemplateDimMemScopeType scopeType;
                Long parentTemplateId = parentTemplateIdMap.get(reportId);
                ReportTemplate targetTpl = templateBakMap.get(reportId);
                if (parentTemplateId != null) {
                    targetTpl = new TemplateRepository().loadTemplate(parentTemplateId);
                }
                if (TemplateDimMemScopeType.DIRECT_SUB_LEVEL == (scopeType = (orgTplDim = targetTpl.getAllTemplateDim().stream().filter(item -> item.getDimType() == DimensionType.ORG).findFirst().get()).getScopeType())) {
                    List<DimMember> childrenS = sumOrgMember.getChildren();
                    finalOrgMemberList.add(sumOrgMember);
                    finalOrgMemberList.addAll(childrenS.stream().map(item -> (OrgMember)item).collect(Collectors.toList()));
                } else if (TemplateDimMemScopeType.SUM_NODE_THIS_LEVEL == scopeType) {
                    finalOrgMemberList.add(sumOrgMember);
                } else {
                    List<DimMember> allDimMemberList = dimension.getAllDimMemberList();
                    finalOrgMemberList.addAll(allDimMemberList.stream().filter(item -> orgTplDim.getMemberScope().contains(item.getId())).map(item -> (OrgMember)item).collect(Collectors.toList()));
                }
            } else {
                finalOrgMemberList = Collections.singletonList(sumOrgMember);
            }
            reportBatchDataMap.putOrgDimMember(reportOrgMemberId, finalOrgMemberList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void putReportAuxEntryMap(ReportBatchDataMapDTO reportBatchDataMap) {
        Set<Long> reportIds = reportBatchDataMap.getReportDataReportIds();
        if (reportIds.isEmpty()) {
            return;
        }
        String ids = reportIds.stream().map(String::valueOf).collect(Collectors.joining(","));
        String sql = String.format("select fid,freportdataid,fbdtype,fcontent from t_fpm_report_auxiliary where fid in (%s)", ids);
        DataSet dataSet = DB.queryDataSet((String)"queryReportAuxiliary", (DBRoute)DBRouteConst.TMC, (String)sql, (Object[])new Object[0]);
        try {
            for (Long reportId : reportIds) {
                DataSet dsCopy = dataSet.copy();
                DataSet dsReport = dsCopy.filter("fid = " + reportId);
                try {
                    HashMap<Long, Map<Long, String>> reportDataAuxMap = new HashMap<Long, Map<Long, String>>(8);
                    for (Row row : dsReport) {
                        Long reportDataId = row.getLong("freportdataid");
                        Map auxValMap = reportDataAuxMap.computeIfAbsent(reportDataId, d -> new HashMap(8));
                        auxValMap.put(row.getLong("fbdtype"), row.getString("fcontent"));
                    }
                    reportBatchDataMap.getReportDataMap(reportId).setReportDataAuxMap(reportDataAuxMap);
                }
                catch (Throwable throwable) {
                    DataSetUtil.closeDataSet(dsCopy, dsReport);
                    throw throwable;
                }
                DataSetUtil.closeDataSet(dsCopy, dsReport);
            }
        }
        catch (Throwable throwable) {
            DataSetUtil.closeDataSet(dataSet);
            throw throwable;
        }
        DataSetUtil.closeDataSet(dataSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void putReportSourceEntryMap(ReportBatchDataMapDTO reportBatchDataMap) {
        Set<Long> reportIds = reportBatchDataMap.getReportDataReportIds();
        if (reportIds.isEmpty()) {
            return;
        }
        String ids = reportIds.stream().map(String::valueOf).collect(Collectors.joining(","));
        String sql = String.format("select fid,fmaindimdataid,fsourcedocid from t_fpm_rowdataid_save where fid in (%s)", ids);
        DataSet dataSet = DB.queryDataSet((String)"queryReportSourceId", (DBRoute)DBRouteConst.TMC, (String)sql, (Object[])new Object[0]);
        try {
            for (Long reportId : reportIds) {
                DataSet dsCopy = dataSet.copy();
                DataSet dsReport = dsCopy.filter("fid = " + reportId);
                try {
                    HashMap<Long, List<Long>> sourceIdMap = new HashMap<Long, List<Long>>(8);
                    for (Row row : dsReport) {
                        Long reportDataId = row.getLong("fmaindimdataid");
                        List sourceIds = sourceIdMap.computeIfAbsent(reportDataId, d -> new ArrayList(8));
                        sourceIds.add(row.getLong("fsourcedocid"));
                    }
                    reportBatchDataMap.getReportDataMap(reportId).setReportDataSourceIdMap(sourceIdMap);
                }
                catch (Throwable throwable) {
                    DataSetUtil.closeDataSet(dsCopy, dsReport);
                    throw throwable;
                }
                DataSetUtil.closeDataSet(dsCopy, dsReport);
            }
        }
        catch (Throwable throwable) {
            DataSetUtil.closeDataSet(dataSet);
            throw throwable;
        }
        DataSetUtil.closeDataSet(dataSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void putMainAndDetailEntryDataSet(ReportBatchDataMapDTO reportBatchDataMap) {
        Set<Long> reportIds = reportBatchDataMap.getReportDataReportIds();
        if (reportIds.isEmpty()) {
            return;
        }
        DataSet dsMainEntry = null;
        DataSet dsDetailEntry = null;
        List splitList = ListUtils.splitList(new ArrayList<Long>(reportIds), (long)5L);
        Iterator iterator = splitList.iterator();
        while (iterator.hasNext()) {
            List reportIdList = (List)iterator.next();
            try {
                Map entryPropMap = FpmHelper.getEntryPropertyS((String)"fpm_report", Arrays.asList("maindimentry", "detailentry"));
                Set entryPropertySet = (Set)entryPropMap.get("maindimentry");
                entryPropertySet.add("maindimentry.id");
                entryPropertySet.add("id");
                entryPropertySet.add("maindimentry.sourceid_tag");
                QFilter qFilter = new QFilter("id", "in", (Object)reportIdList);
                dsMainEntry = QueryServiceHelper.queryDataSet((String)"report.queryMainData", (String)"fpm_report", (String)String.join((CharSequence)",", entryPropertySet), (QFilter[])qFilter.toArray(), null);
                Set detailEntryPropertySet = (Set)entryPropMap.get("detailentry");
                detailEntryPropertySet.add("id");
                dsDetailEntry = QueryServiceHelper.queryDataSet((String)"report.queryDetailData", (String)"fpm_report", (String)String.join((CharSequence)",", detailEntryPropertySet), (QFilter[])qFilter.toArray(), null);
                for (Long reportId : reportIdList) {
                    DataSet dsMainEntryData = dsMainEntry.filter("id = " + reportId);
                    DataSet detailEntryData = dsDetailEntry.filter("id = " + reportId);
                    try {
                        DataSet mainEntryDataSet = dsMainEntryData.orderBy(new String[]{"maindimentry.id"});
                        DataSet detailEntryDataSet = detailEntryData.orderBy(new String[]{"detailentry.maindimdataid"});
                        reportBatchDataMap.getReportDataMap(reportId).setDataSets(new DataSet[]{mainEntryDataSet, detailEntryDataSet});
                    }
                    catch (Throwable throwable) {
                        DataSetUtil.closeDataSet(dsMainEntryData, detailEntryData);
                        throw throwable;
                    }
                    DataSetUtil.closeDataSet(dsMainEntryData, detailEntryData);
                }
            }
            catch (Throwable throwable) {
                DataSetUtil.closeDataSet(dsMainEntry, dsDetailEntry);
                throw throwable;
            }
            DataSetUtil.closeDataSet(dsMainEntry, dsDetailEntry);
        }
        return;
    }

    private static void putDetailMapping(ReportBatchDataMapDTO reportBatchDataMap) {
        Map<Long, ReportBatchDataMapDTO.ReportDataMap> reportDataMap = reportBatchDataMap.getReportDataMap();
        if (reportDataMap.isEmpty()) {
            return;
        }
        Set<Long> systemIds = reportDataMap.values().stream().map(ReportBatchDataMapDTO.ReportDataMap::getSystemId).collect(Collectors.toSet());
        Map<Long, Map<String, String>> detailMappingMap = DimensionMappingHelper.getReportPlanDetailMappingWithEntrys(systemIds);
        List<Dimension> detailDimList = new DetailPlanFieldsRepository().queryDetailDimenBySystemId(systemIds);
        Map<Long, List<Dimension>> dimensionMap = detailDimList.stream().collect(Collectors.groupingBy(Dimension::getSystemId));
        for (Map.Entry<Long, ReportBatchDataMapDTO.ReportDataMap> entry : reportDataMap.entrySet()) {
            ReportBatchDataMapDTO.ReportDataMap dataMap = entry.getValue();
            Long systemId = dataMap.getSystemId();
            dataMap.setDetailMapping(detailMappingMap.get(systemId));
            dataMap.setDetailDimList(dimensionMap.get(systemId));
        }
    }

    private static void putExchangeRateMap(ReportBatchDataMapDTO reportBatchDataMap) {
        Set<Long> reportIds = reportBatchDataMap.getReportDataReportIds();
        if (reportIds.isEmpty()) {
            return;
        }
        ArrayList<String> errMsg = new ArrayList<String>(4);
        String selectFields = String.join((CharSequence)",", "id", "exratetable.id", "exchangeratedate", "currencyrange.fbasedataid.id", "currencyrange.fbasedataid.sourceid");
        DynamicObjectCollection currencyRangeColl = QueryServiceHelper.query((String)"fpm_report", (String)selectFields, (QFilter[])new QFilter("id", "in", reportIds).toArray());
        Map<Long, List<DynamicObject>> currencyRangeMap = currencyRangeColl.stream().collect(Collectors.groupingBy(d -> d.getLong("id")));
        for (Map.Entry<Long, List<DynamicObject>> entry : currencyRangeMap.entrySet()) {
            List<DynamicObject> currencyRanges = entry.getValue();
            if (EmptyUtil.isEmpty(currencyRanges)) continue;
            Long reportId = entry.getKey();
            FundPlanSystem fundPlanSystem = reportBatchDataMap.getReportSystemMap(reportId);
            Long targetCurrencyId = fundPlanSystem.getCurrencyId();
            HashMap<Object, BigDecimal> exchangeRateMap = new HashMap<Object, BigDecimal>(currencyRanges.size());
            for (DynamicObject currencyRange : currencyRanges) {
                BigDecimal exchangeRate;
                long exchangeRateTableId = currencyRange.getLong("exratetable.id");
                Date exchangeRateDate = currencyRange.getDate("exchangeratedate");
                long sourceCurrencyId = currencyRange.getLong("currencyrange.fbasedataid.sourceid");
                if (sourceCurrencyId != targetCurrencyId) {
                    exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)exchangeRateDate);
                    if (exchangeRate == null) {
                        Map currencyMap = TmcDataServiceHelper.loadFromCache((String)"bd_currency", (String)"name", (QFilter[])new QFilter("id", "in", Arrays.asList(targetCurrencyId, sourceCurrencyId)).toArray());
                        errMsg.add(String.format(ResManager.loadKDString((String)"%1$s\u548c%2$s\u5e01\u79cd\u4e4b\u95f4\u7f3a\u5c11\u8f6c\u6362\u6c47\u7387\uff0c\u8bf7\u5148\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"ReportPoConverter_1", (String)"tmc-fpm-business", (Object[])new Object[0]), ((DynamicObject)currencyMap.get(sourceCurrencyId)).getString("name"), ((DynamicObject)currencyMap.get(targetCurrencyId)).getString("name")));
                        continue;
                    }
                } else {
                    exchangeRate = BigDecimal.ONE;
                }
                exchangeRateMap.put(currencyRange.getLong("currencyrange.fbasedataid.id"), exchangeRate);
            }
            reportBatchDataMap.getReportDataMap(reportId).setExchangeRateMap(exchangeRateMap);
        }
        if (errMsg.size() > 0) {
            throw new KDBizException(String.join((CharSequence)"\n", errMsg));
        }
    }
}

