/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.helper.StringHelper;
import org.apache.commons.collections4.MapUtils;

public class ReportMutexHelper {
    public static final Log logger = LogFactory.getLog(ReportMutexHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mainReportLockValidator(Long mainReportId) {
        ArrayList<String> reportIdS = new ArrayList<String>(1);
        ArrayList<String> requestSuccessIds = new ArrayList<String>(1);
        ArrayList<String> requestFailIds = new ArrayList<String>(1);
        reportIdS.add(mainReportId.toString());
        try {
            Map request = MutexServiceHelper.batchRequest(reportIdS, (String)"fpm_report", (String)"lockMainReport");
            for (Map.Entry entry : request.entrySet()) {
                String key = (String)entry.getKey();
                if (((Boolean)entry.getValue()).booleanValue()) {
                    requestSuccessIds.add(key);
                    continue;
                }
                requestFailIds.add(key);
            }
            if (requestFailIds.size() > 0) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            MutexServiceHelper.batchRelease(requestSuccessIds, (String)"fpm_report", (String)"lockMainReport");
        }
        return false;
    }

    public static String getMutexUserNameByOpKey(String dataId, String opKey, String entityKey) {
        return ReportMutexHelper.getMutexUserName(dataId, "op_" + opKey, entityKey);
    }

    public static String getMutexUserName(String dataId, String group, String entityKey) {
        Map<String, String> mutexUserInfo = ReportMutexHelper.getMutexUserInfo(dataId, group, entityKey);
        if (MapUtils.isEmpty(mutexUserInfo)) {
            return "";
        }
        String name = mutexUserInfo.get("name");
        if (EmptyUtil.isNoEmpty((String)name)) {
            return name;
        }
        String userid = mutexUserInfo.get("userid");
        if (StringUtils.isEmpty((Object)userid)) {
            return "";
        }
        Map userInfo = UserServiceHelper.getUserInfoByID((long)Long.parseLong(userid));
        if (MapUtils.isEmpty((Map)userInfo)) {
            return "";
        }
        return StringHelper.getStringValue(userInfo.get("name"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getMutexUserInfo(String dataId, String group, String entityKey) {
        try (DataMutex dataMutex = DataMutex.create();){
            Map map = dataMutex.getLockInfo(dataId, group, entityKey);
            return map;
        }
        catch (IOException e) {
            logger.warn("\u83b7\u53d6\u9501\u5b9a\u7528\u6237\u4fe1\u606f\u7528\u6237\u4fe1\u606f\u4fe1\u606f\u62a5\u9519", (Throwable)e);
            return Collections.emptyMap();
        }
    }
}

