/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.helper;

import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.service.sumreport.service.ISummaryConfigService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.common.utils.FpmAssertUtil;

public class ReportPlanSumHelper {
    private static final IReportRepository repository = FpmServiceFactory.getBizService(IReportRepository.class);
    private static final ISummaryConfigService summaryConfigService = FpmServiceFactory.getBizService(ISummaryConfigService.class);

    public static Report loadSimpleReport(Long reportId) {
        List<Report> reports = repository.loadSimpleReport(Collections.singleton(reportId), np -> {
            np.setNeedTemplate(true);
            np.setNeedPeriodMember(true);
            np.setNeedReportPeriodType(true);
        });
        return EmptyUtil.isNoEmpty(reports) ? reports.get(0) : null;
    }

    public static SumPlanParamConfig getSummaryParamConfig(Long reportId) {
        Report report = ReportPlanSumHelper.getSimpleReport(reportId);
        FpmAssertUtil.isNotNull((Object)report, (String)String.format(ResManager.loadKDString((String)"ID\u3010%1$s\u3011\u7684\u62a5\u8868\u4e0d\u5b58\u5728\u3002", (String)"SummaryConfigServiceImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]), reportId));
        return summaryConfigService.getSummaryParamConfig(report);
    }

    private static Report getSimpleReport(Long reportId) {
        String selectFields = "planstatus,bodysys.id,reportplantype,summaryconfigsnp,reportperiod.reporttype.id";
        DynamicObject reportObj = QueryServiceHelper.queryOne((String)"fpm_report", (String)selectFields, (QFilter[])new QFilter("id", "=", (Object)reportId).toArray());
        if (reportObj == null) {
            return null;
        }
        Report report = new Report();
        ReportPeriodType periodType = new ReportPeriodType();
        periodType.setReportPeriodId(reportObj.getLong("reportperiod.reporttype.id"));
        report.setReportPeriodType(periodType);
        report.setReportStatus(ReportStatus.getByVal(reportObj.getString("planstatus")));
        report.setSystemId(reportObj.getLong("bodysys.id"));
        long configSnapshotId = reportObj.getLong("summaryconfigsnp");
        if (EmptyUtil.isNoEmpty((Long)configSnapshotId)) {
            report.setSumParamConfigSnapshotId(configSnapshotId);
        }
        return report;
    }
}

