/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateReportType;
import kd.tmc.fpm.business.mvc.converter.TemplatePOConverter;
import kd.tmc.fpm.business.mvc.service.dto.TemplateParamDTO;

public class SumPlanRelationHelper {
    public static List<TemplateParamDTO.RelationTemplate> getRelationTemplate(ReportTemplate reportTemplate, FundPlanSystem system, boolean isUpper) {
        return SumPlanRelationHelper.getRelationTemplate(Collections.singletonList(reportTemplate), system, isUpper);
    }

    public static Map<Long, List<TemplateParamDTO.RelationTemplate>> getRelationTemplateToMap(Collection<ReportTemplate> reportTemplateList, FundPlanSystem system, boolean isUpper) {
        List<TemplateParamDTO.RelationTemplate> relationTemplateList = SumPlanRelationHelper.getRelationTemplate(reportTemplateList, system, isUpper);
        Set<Long> memberIds = reportTemplateList.stream().map(ReportTemplate::getUserIdList).flatMap(Collection::stream).collect(Collectors.toSet());
        Map<Long, DimMember> dimMemberMap = system.getMainDimensionByDimType(DimensionType.ORG).getAllDimMemberList().stream().collect(Collectors.toMap(DimMember::getId, Function.identity()));
        Map<Long, Set<Long>> memberMap = isUpper ? SumPlanRelationHelper.getAllParentMap(memberIds, dimMemberMap) : SumPlanRelationHelper.getAllChildMap(memberIds, dimMemberMap);
        HashMap<Long, List<TemplateParamDTO.RelationTemplate>> map = new HashMap<Long, List<TemplateParamDTO.RelationTemplate>>(reportTemplateList.size());
        for (ReportTemplate reportTemplate : reportTemplateList) {
            List<Long> userIdList = reportTemplate.getUserIdList();
            Set userIdSet = userIdList.stream().map(memberMap::get).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
            Set reportTypeIdSet = reportTemplate.getReportTypeList().stream().map(TemplateReportType::getReportTypeId).collect(Collectors.toSet());
            List relationTemplates = relationTemplateList.stream().filter(relationTemplate -> {
                ReportTemplate mainTemplate = relationTemplate.getMainTemplate();
                HashSet<Long> relationUserIdSet = new HashSet<Long>(mainTemplate.getUserIdList());
                Set relationReportTypeIdSet = mainTemplate.getReportTypeList().stream().map(TemplateReportType::getReportTypeId).collect(Collectors.toSet());
                relationUserIdSet.retainAll(userIdSet);
                relationReportTypeIdSet.retainAll(reportTypeIdSet);
                return EmptyUtil.isNoEmpty(relationUserIdSet) && EmptyUtil.isNoEmpty(relationReportTypeIdSet);
            }).collect(Collectors.toList());
            map.put(reportTemplate.getId(), relationTemplates);
        }
        return map;
    }

    public static List<TemplateParamDTO.RelationTemplate> getRelationTemplate(Collection<ReportTemplate> reportTemplateList, FundPlanSystem system, boolean isUpper) {
        Map<Long, Set<Long>> memberMap;
        Long systemId = system.getId();
        Map<Long, DimMember> dimMemberMap = system.getMainDimensionByDimType(DimensionType.ORG).getAllDimMemberList().stream().collect(Collectors.toMap(DimMember::getId, Function.identity()));
        Set<Long> memberIds = reportTemplateList.stream().map(ReportTemplate::getUserIdList).flatMap(Collection::stream).collect(Collectors.toSet());
        Map<Long, Set<Long>> map = memberMap = isUpper ? SumPlanRelationHelper.getAllParentMap(memberIds, dimMemberMap) : SumPlanRelationHelper.getAllChildMap(memberIds, dimMemberMap);
        if (CollectionUtils.isEmpty(memberMap)) {
            return Collections.emptyList();
        }
        String reportTypeProp = String.join((CharSequence)".", "reporttype", "fbasedataid");
        Set reportTypeSet = reportTemplateList.stream().map(ReportTemplate::getReportTypeList).flatMap(Collection::stream).map(TemplateReportType::getReportTypeId).collect(Collectors.toSet());
        TemplateUseType templateUseType = isUpper ? TemplateUseType.SUMMARY : TemplateUseType.PLANING;
        QFilter qFilter = new QFilter("model", "=", (Object)systemId).and("enable", "=", (Object)"1").and("ismaintable", "=", (Object)true).and("templateuses", "=", (Object)templateUseType.getNumber()).and(reportTypeProp, "in", reportTypeSet);
        Set memberIdSet = memberMap.entrySet().stream().map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toSet());
        String userProp = String.join((CharSequence)".", "user", "fbasedataid", "id");
        qFilter = qFilter.and(new QFilter(userProp, "in", memberIdSet));
        DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_template", (String)"id", (QFilter[])new QFilter[]{qFilter});
        DynamicObject[] dynamicObjects = TmcDataServiceHelper.load((Object[])Arrays.stream(load).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_template"));
        List subTemplateIdS = Arrays.stream(dynamicObjects).map(item -> item.getDynamicObjectCollection("subjecttentry")).flatMap(Collection::stream).map(o -> o.get("subtemplate.id")).filter(o -> o != null && !o.equals(0L)).collect(Collectors.toList());
        Map subTplDataMap = Arrays.stream(TmcDataServiceHelper.load((Object[])subTemplateIdS.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_template"))).collect(Collectors.toMap(item -> item.get("id"), Function.identity()));
        ArrayList<TemplateParamDTO.RelationTemplate> relationTemplateList = new ArrayList<TemplateParamDTO.RelationTemplate>(dynamicObjects.length);
        block0: for (DynamicObject templateDy : dynamicObjects) {
            ReportTemplate template = TemplatePOConverter.convertToTemplate(templateDy);
            Set childTemIds = template.getAccountSettings().stream().filter(as -> as.getInputType() == ReportInputType.DETAIL_INPUT).map(TemplateAccountSetting::getChildTemplateId).collect(Collectors.toSet());
            List<Long> userIdList = template.getUserIdList();
            ArrayList<ReportTemplate> subList = new ArrayList<ReportTemplate>(childTemIds.size());
            for (Long childTemId : childTemIds) {
                DynamicObject subTemplateDy = (DynamicObject)subTplDataMap.get(childTemId);
                if (EmptyUtil.isEmpty((DynamicObject)subTemplateDy)) continue;
                ReportTemplate childTem = TemplatePOConverter.convertToTemplate(subTemplateDy);
                subList.add(childTem);
            }
            HashSet<Long> userIdSet = new HashSet<Long>(userIdList);
            for (Map.Entry<Long, Set<Long>> entry : memberMap.entrySet()) {
                Set<Long> value = entry.getValue();
                userIdSet.retainAll(value);
                if (EmptyUtil.isEmpty(userIdSet)) continue;
                TemplateParamDTO.RelationTemplate relationTemplate = new TemplateParamDTO.RelationTemplate(template, subList, entry.getKey());
                relationTemplateList.add(relationTemplate);
                continue block0;
            }
        }
        return relationTemplateList;
    }

    public static Map<Long, Set<Long>> getAllChildMap(Collection<Long> memberIds, Map<Long, DimMember> dimMemberMap) {
        if (EmptyUtil.isEmpty(memberIds)) {
            return Collections.emptyMap();
        }
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(memberIds.size());
        for (Long memId : memberIds) {
            DimMember dimMember = dimMemberMap.get(memId);
            map.put(memId, dimMember.getAllChildMember().stream().map(DimMember::getId).collect(Collectors.toSet()));
        }
        return map;
    }

    public static Map<Long, Set<Long>> getAllParentMap(Collection<Long> memberIds, Map<Long, DimMember> dimMemberMap) {
        if (EmptyUtil.isEmpty(memberIds)) {
            return Collections.emptyMap();
        }
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(memberIds.size());
        for (Long memId : memberIds) {
            DimMember dimMember = dimMemberMap.get(memId);
            map.put(memId, dimMember.getAllParentMember().stream().map(DimMember::getId).collect(Collectors.toSet()));
        }
        return map;
    }

    public static OrgMember getParentSumOrg(OrgMember reportOrg, SumPlanParamConfig sumPlanParamConfig, FundPlanSystem fundPlanSystem) {
        OrgMember parentSumOrg = null;
        Long parentSumOrgId = SumPlanRelationHelper.getParentSumOrgId(reportOrg.getId(), sumPlanParamConfig);
        if (EmptyUtil.isNoEmpty((Long)parentSumOrgId)) {
            parentSumOrg = fundPlanSystem.getMainDimensionByDimType(DimensionType.ORG).getDimMemberById(parentSumOrgId, OrgMember.class);
        }
        return parentSumOrg;
    }

    public static Long getParentSumOrgId(Long reportOrgId, SumPlanParamConfig sumPlanParamConfig) {
        Long parentSumOrgId = null;
        if (sumPlanParamConfig != null) {
            List<SumPlanParamConfigInfo> configInfoList = sumPlanParamConfig.getConfigInfoList();
            Map configInfoMap = configInfoList.stream().collect(Collectors.toMap(SumPlanParamConfigInfo::getOrgMemberId, Function.identity(), (a, b) -> a));
            Long currOrgMemberId = reportOrgId;
            while (configInfoMap.containsKey(currOrgMemberId) && EmptyUtil.isNoEmpty((Long)((SumPlanParamConfigInfo)configInfoMap.get(currOrgMemberId)).getParentId())) {
                Long currParentOrgMemberId = ((SumPlanParamConfigInfo)configInfoMap.get(currOrgMemberId)).getParentId();
                if (configInfoMap.containsKey(currParentOrgMemberId) && ((SumPlanParamConfigInfo)configInfoMap.get(currParentOrgMemberId)).isSumAuditNode()) {
                    parentSumOrgId = currParentOrgMemberId;
                    break;
                }
                currOrgMemberId = currParentOrgMemberId;
            }
        }
        return parentSumOrgId;
    }

    public static List<Long> listAllParentSumOrgId(Long reportOrgId, SumPlanParamConfig sumPlanParamConfig) {
        LinkedList<Long> allParentSumOrgIds = new LinkedList<Long>();
        if (sumPlanParamConfig != null) {
            List<SumPlanParamConfigInfo> configInfoList = sumPlanParamConfig.getConfigInfoList();
            Map configInfoMap = configInfoList.stream().collect(Collectors.toMap(SumPlanParamConfigInfo::getOrgMemberId, Function.identity(), (a, b) -> a));
            Long currOrgMemberId = reportOrgId;
            while (configInfoMap.containsKey(currOrgMemberId) && EmptyUtil.isNoEmpty((Long)((SumPlanParamConfigInfo)configInfoMap.get(currOrgMemberId)).getParentId())) {
                Long currParentOrgMemberId = ((SumPlanParamConfigInfo)configInfoMap.get(currOrgMemberId)).getParentId();
                if (configInfoMap.containsKey(currParentOrgMemberId) && ((SumPlanParamConfigInfo)configInfoMap.get(currParentOrgMemberId)).isSumAuditNode()) {
                    allParentSumOrgIds.add(currParentOrgMemberId);
                }
                currOrgMemberId = currParentOrgMemberId;
            }
        }
        return allParentSumOrgIds;
    }
}

