/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mq;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.fpm.business.mq.IMessageConsumer;
import kd.tmc.fpm.common.enums.MQMsgBusinessStatusEnum;
import kd.tmc.fpm.common.enums.MQMsgStatusEnum;
import kd.tmc.fpm.common.property.TMCMQRecordProp;

public abstract class AbstractMessageConsumer
implements IMessageConsumer {
    protected static Log logger = LogFactory.getLog(AbstractMessageConsumer.class);

    protected void updateRecordStatus(DynamicObject recordObj, MQMsgStatusEnum msgStatus, Object errInfo) {
        recordObj.set(TMCMQRecordProp.HEAD_MSGSTATUS, (Object)msgStatus.getValue());
        if (msgStatus == MQMsgStatusEnum.FIN) {
            recordObj.set(TMCMQRecordProp.HEAD_BUSINESSSTATUS, (Object)MQMsgBusinessStatusEnum.SUCC.getValue());
        } else {
            recordObj.set(TMCMQRecordProp.HEAD_BUSINESSSTATUS, (Object)MQMsgBusinessStatusEnum.FAIL.getValue());
        }
        if (errInfo != null) {
            String errInfoTag = SerializationUtils.toJsonString((Object)errInfo);
            TextProp property = (TextProp)recordObj.getDataEntityType().getProperties().get((Object)TMCMQRecordProp.HEAD_ERRORMSG);
            int maxLength = property.getMaxLenth();
            String errMsg = "";
            if (errInfoTag != null && errInfoTag.length() > maxLength) {
                errMsg = errInfoTag.substring(0, maxLength);
            }
            recordObj.set(TMCMQRecordProp.HEAD_ERRORMSG, (Object)errMsg);
            recordObj.set(TMCMQRecordProp.HEAD_ERRORMSG_TAG, (Object)errInfoTag);
        }
        OperationServiceHelper.executeOperate((String)"save", (String)"tmc_mq_record", (DynamicObject[])new DynamicObject[]{recordObj}, (OperateOption)OperateOption.create());
    }
}

