/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mq;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.mq.GenFixedFreqReportConsumer;
import kd.tmc.fpm.business.mq.GenReportConsumer;
import kd.tmc.fpm.business.mq.IMessageConsumer;
import kd.tmc.fpm.business.mq.LocalSequentTaskConsumer;
import kd.tmc.fpm.business.mq.ReportSummaryConsumer;
import kd.tmc.fpm.business.mq.SumPlanOffSetAmtConsumer;
import kd.tmc.fpm.business.mq.TMCMQMessage;
import kd.tmc.fpm.common.enums.MQMsgStatusEnum;
import kd.tmc.fpm.common.property.TMCMQRecordProp;

public class FpmMQConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(FpmMQConsumer.class);
    private List<IMessageConsumer> consumerList = new ArrayList<IMessageConsumer>();

    public FpmMQConsumer() {
        this.consumerList.add(new ReportSummaryConsumer());
        this.consumerList.add(new GenReportConsumer());
        this.consumerList.add(new SumPlanOffSetAmtConsumer());
        this.consumerList.add(new LocalSequentTaskConsumer());
        this.consumerList.add(new GenFixedFreqReportConsumer());
    }

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker messageAcker) {
        TMCMQMessage tmcmqMessage = (TMCMQMessage)message;
        Long mqRecordId = tmcmqMessage.getMqRecordId();
        logger.info("[FpmMQConsumer] >>> \u5f00\u59cb\u6d88\u8d39 messageId: " + messageId + ", message: " + message);
        boolean exists = TmcDataServiceHelper.exists((Object)mqRecordId, (String)"tmc_mq_record");
        if (!exists) {
            logger.info("[FpmMQConsumer] >>> mq\u8868\u4e2d\u4e0d\u5b58\u5728\u6b64\u6d88\u606f\uff0cmessageId: " + messageId + ", message: " + message);
        }
        String prop = String.join((CharSequence)",", TMCMQRecordProp.HEAD_MSGSTATUS, TMCMQRecordProp.HEAD_BUSINESSTYPE);
        DynamicObject record = QueryServiceHelper.queryOne((String)"tmc_mq_record", (String)prop, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)mqRecordId)});
        String msgStatus = record.getString(TMCMQRecordProp.HEAD_MSGSTATUS);
        if (!MQMsgStatusEnum.SEND.getValue().equals(msgStatus) && !MQMsgStatusEnum.REP.getValue().equals(msgStatus)) {
            messageAcker.ack(messageId);
            return;
        }
        String type = record.getString(TMCMQRecordProp.HEAD_BUSINESSTYPE);
        for (IMessageConsumer consumer : this.consumerList) {
            if (!consumer.canApply(type)) continue;
            consumer.onMessage(message, messageId, resend, messageAcker);
            return;
        }
        logger.info("[FpmMQConsumer] >>> \u627e\u4e0d\u5230\u6d88\u8d39\u8005\u7c7b\u578b\uff0c\u4e22\u5f03\u6d88\u606f\uff1amessageId: " + messageId + ", message: " + message);
        messageAcker.discard(messageId);
    }
}

