/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mq;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.mq.MessageAcker;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mq.AbstractMessageConsumer;
import kd.tmc.fpm.business.mq.TMCMQMessage;
import kd.tmc.fpm.business.mvc.service.IReportBizService;
import kd.tmc.fpm.business.mvc.service.impl.ReportBizService;
import kd.tmc.fpm.business.mvc.service.report.generate.enums.ExecuteResult;
import kd.tmc.fpm.common.enums.MQBusinessTypeEnum;
import kd.tmc.fpm.common.enums.MQMsgStatusEnum;
import kd.tmc.fpm.common.enums.ReportPrepareExecResultEnum;
import kd.tmc.fpm.common.helper.StringHelper;
import kd.tmc.fpm.common.property.TMCMQRecordProp;
import org.apache.commons.collections.CollectionUtils;

public class GenReportConsumer
extends AbstractMessageConsumer {
    private IReportBizService reportBizService = new ReportBizService();

    @Override
    public boolean canApply(String type) {
        return MQBusinessTypeEnum.GEN_REPORT.getValue().equals(type);
    }

    public void onMessage(Object o, String messageId, boolean b, MessageAcker messageAcker) {
        TMCMQMessage tmcmqMessage = (TMCMQMessage)o;
        Long mqRecordId = tmcmqMessage.getMqRecordId();
        String prop = String.join((CharSequence)",", TMCMQRecordProp.HEAD_MSGSTATUS, TMCMQRecordProp.HEAD_BUSINESSSTATUS);
        DynamicObject recordObj = QueryServiceHelper.queryOne((String)"tmc_mq_record", (String)prop, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)mqRecordId)});
        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"tmc_mq_record");
        record.set("id", (Object)mqRecordId);
        record.set(TMCMQRecordProp.HEAD_MSGSTATUS, (Object)recordObj.getString(TMCMQRecordProp.HEAD_MSGSTATUS));
        record.set(TMCMQRecordProp.HEAD_BUSINESSSTATUS, recordObj.get(TMCMQRecordProp.HEAD_BUSINESSSTATUS));
        String msgStatus = record.getString(TMCMQRecordProp.HEAD_MSGSTATUS);
        if (!MQMsgStatusEnum.SEND.getValue().equals(msgStatus) && !MQMsgStatusEnum.REP.getValue().equals(msgStatus)) {
            messageAcker.ack(messageId);
            return;
        }
        try {
            Long recordId = (Long)tmcmqMessage.getMessageContent();
            DynamicObject dbData = TmcDataServiceHelper.loadSingle((Object)recordId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_reportpreparation"));
            FpmOperateResult<List<Long>> result = this.reportBizService.generateReportByPrepareId(recordId);
            DynamicObjectCollection entryColl = dbData.getDynamicObjectCollection("entryentity");
            DynamicObject newEntryData = entryColl.addNew();
            newEntryData.set("exectime", (Object)new Date());
            newEntryData.set("seq", (Object)1);
            String warnMessage = result.getWarnMessage();
            if (result.isSuccess()) {
                List<Long> dataList = result.getData();
                List reportIdList = dataList.stream().map(Object::toString).collect(Collectors.toList());
                newEntryData.set("execresult", (Object)(EmptyUtil.isEmpty((String)warnMessage) ? ReportPrepareExecResultEnum.SUCCESS.getValue() : ExecuteResult.SOME_SUCCESS.getNumber()));
                String successInfo = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u751f\u6210\u8d44\u91d1\u8ba1\u5212\u5355\u636e%1$s\u6761", (String)"GenReportConsumer_0", (String)"tmc-fpm-business", (Object[])new Object[0]), reportIdList.size());
                List<String> tipsInfoList = result.getTipsInfoList();
                if (CollectionUtils.isNotEmpty(tipsInfoList)) {
                    successInfo = String.format("%s;%s", successInfo, String.join((CharSequence)";", tipsInfoList));
                }
                if (EmptyUtil.isNoEmpty((String)warnMessage)) {
                    successInfo = String.format("%s, %s", successInfo, warnMessage);
                }
                newEntryData.set("execresultdetail", (Object)StringHelper.subStringAppendThreePoint((String)successInfo, (int)1000));
                newEntryData.set("planreportbillids_tag", (Object)String.join((CharSequence)";", reportIdList));
            } else {
                newEntryData.set("execresult", (Object)ReportPrepareExecResultEnum.FAIL.getValue());
                newEntryData.set("execresultdetail", (Object)StringHelper.subStringAppendThreePoint((String)String.join((CharSequence)";", result.getMessageList()), (int)1000));
            }
            newEntryData.set("opreateuser", (Object)RequestContext.get().getUserId());
            List entryCollList = entryColl.stream().filter(Objects::nonNull).sorted((o1, o2) -> {
                Date date1 = o1.getDate("exectime");
                Date date2 = o2.getDate("exectime");
                if (date1 == null || date2 == null) {
                    return 1;
                }
                return date1.compareTo(date2);
            }).collect(Collectors.toList());
            int tMaxSeq = entryColl.size();
            for (DynamicObject tEntryData : entryCollList) {
                tEntryData.set("seq", (Object)tMaxSeq--);
            }
            TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{dbData});
            this.updateRecordStatus(record, MQMsgStatusEnum.FIN, null);
        }
        catch (Exception e) {
            this.updateRecordStatus(record, MQMsgStatusEnum.ERR, e.getStackTrace());
            logger.error("[GenReportConsumer] >>>>> MQ\u6d88\u8d39\u5f02\u5e38\uff1a", (Throwable)e);
        }
        messageAcker.ack(messageId);
    }
}

