/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.controller.impl;

import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.message.service.pa.util.StringUtil;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.controller.impl.IFpmFormOperate;
import kd.tmc.fpm.business.mvc.view.IFpmFormView;

public abstract class AbstractFpmFormOperate<T>
implements IFpmFormOperate<T> {
    private IFpmFormView view;
    private String operateName;
    private String successMessage;
    private String defaultErrMessage;
    private String warnMessage;
    private boolean showSuccessMessage;

    public AbstractFpmFormOperate(IFpmFormView view) {
        this.view = view;
        this.showSuccessMessage = false;
    }

    public AbstractFpmFormOperate(IFpmFormView view, String operateName) {
        this.view = view;
        this.operateName = operateName = StringUtil.isEmpty((String)operateName) ? "" : operateName;
        this.successMessage = String.format(ResManager.loadKDString((String)"%1$s\u6210\u529f\u3002", (String)"AbstractFpmFormOperate_0", (String)"tmc-fpm-business", (Object[])new Object[0]), operateName);
        this.defaultErrMessage = String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\u3002", (String)"AbstractFpmFormOperate_1", (String)"tmc-fpm-business", (Object[])new Object[0]), operateName);
        this.showSuccessMessage = true;
    }

    public AbstractFpmFormOperate(IFpmFormView view, String operateName, Boolean showSuccessMessage) {
        this.view = view;
        this.operateName = operateName = StringUtil.isEmpty((String)operateName) ? "" : operateName;
        this.successMessage = String.format(ResManager.loadKDString((String)"%1$s\u6210\u529f\u3002", (String)"AbstractFpmFormOperate_2", (String)"tmc-fpm-business", (Object[])new Object[0]), operateName);
        this.defaultErrMessage = String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\u3002", (String)"AbstractFpmFormOperate_3", (String)"tmc-fpm-business", (Object[])new Object[0]), operateName);
        this.showSuccessMessage = showSuccessMessage;
    }

    public boolean isShowSuccessMessage() {
        return this.showSuccessMessage;
    }

    public void setShowSuccessMessage(boolean showSuccessMessage) {
        this.showSuccessMessage = showSuccessMessage;
    }

    public String getOperateName() {
        return this.operateName;
    }

    public void setOperateName(String operateName) {
        this.operateName = operateName;
    }

    public String getSuccessMessage() {
        return this.successMessage;
    }

    public void setSuccessMessage(String successMessage) {
        this.showSuccessMessage = Boolean.TRUE;
        this.successMessage = successMessage;
    }

    public String getWarnMessage() {
        return this.warnMessage;
    }

    public void setWarnMessage(String warnMessage) {
        this.showSuccessMessage = Boolean.FALSE;
        this.warnMessage = warnMessage;
    }

    public String getDefaultErrMessage() {
        return this.defaultErrMessage;
    }

    public void setDefaultErrMessage(String defaultErrMessage) {
        this.defaultErrMessage = defaultErrMessage;
    }

    @Override
    public void onOperateSuccess(FpmOperateResult<T> result) {
        String string = this.successMessage = EmptyUtil.isNoEmpty((String)result.getSuccessMessage()) ? result.getSuccessMessage() : this.successMessage;
        if (this.successMessage != null && this.showSuccessMessage) {
            this.view.showSuccessMessage(this.successMessage);
        }
    }

    @Override
    public void onOperateError(FpmOperateResult<T> result) {
        List<String> messageList = result.getMessageList();
        if (messageList != null && messageList.size() > 0) {
            this.view.showErrMessage(result.getMessageList());
        } else if (this.defaultErrMessage != null) {
            this.view.showErrMessage(Collections.singletonList(this.defaultErrMessage));
        }
    }

    @Override
    public void onOperateWarn(FpmOperateResult<T> result) {
        String warnMessage = result.getWarnMessage();
        if (EmptyUtil.isNoEmpty((String)warnMessage)) {
            this.view.showWarnMessage(warnMessage);
        }
    }

    @Override
    public void afterDoThings(FpmOperateResult<T> result) {
    }
}

