/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.controller.impl;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.cache.FpmPageCacheService;
import kd.tmc.fpm.business.cache.data.CacheCell;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.domain.enums.AnalysisReportType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateReportType;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.controller.BaseManageController;
import kd.tmc.fpm.business.mvc.controller.IAnalysisReportManageController;
import kd.tmc.fpm.business.mvc.controller.impl.AbstractFpmFormOperate;
import kd.tmc.fpm.business.mvc.repository.ITemplateRepository;
import kd.tmc.fpm.business.mvc.repository.impl.TemplateRepository;
import kd.tmc.fpm.business.mvc.service.IAnalysisReportManageService;
import kd.tmc.fpm.business.mvc.service.impl.AnalysisReportManagerService;
import kd.tmc.fpm.business.mvc.view.IAnalysisReportManageView;
import kd.tmc.fpm.business.mvc.view.IFpmFormView;
import kd.tmc.fpm.business.spread.datamanager.IReportDataManagerV2;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportDataManagerV2;
import kd.tmc.fpm.business.spread.generator.SpreadDataGeneratorFactory;
import kd.tmc.fpm.business.spread.generator.report.IReportSpreadDataGenerator;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Cell;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AnalysisReportManageController
extends BaseManageController
implements IAnalysisReportManageController {
    private static final Log logger = LogFactory.getLog(AnalysisReportManageController.class);
    private IAnalysisReportManageView view;
    private IAnalysisReportManageService service;
    private ITemplateRepository templateRepository;

    public AnalysisReportManageController(IAnalysisReportManageView view) {
        this.view = view;
        this.service = new AnalysisReportManagerService();
        this.templateRepository = new TemplateRepository();
    }

    @Override
    public void loadAnalysisReport(final AnalysisReportType reportType, final AnalysisHeader headerInfo) {
        this.doFormOperate(new AbstractFpmFormOperate<ReportDataManagerV2>((IFpmFormView)this.view, ResManager.loadKDString((String)"\u52a0\u8f7d\u62a5\u8868", (String)"AnalysisReportManageController_0", (String)"tmc-fpm-business", (Object[])new Object[0])){

            @Override
            public FpmOperateResult<ReportDataManagerV2> doOperate() {
                headerInfo.setAnalysisReportType(reportType);
                return AnalysisReportManageController.this.service.loadAnalysisReport(headerInfo, AnalysisReportManageController.this.getCacheService(AnalysisReportManageController.this.view.getPageId()));
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<ReportDataManagerV2> result) {
                super.onOperateSuccess(result);
                ReportDataManagerV2 data = result.getData();
                ReportCalcModel currCalcModel = data.getCurrCalcModel();
                IReportSpreadDataGenerator spreadDataGenerator = SpreadDataGeneratorFactory.createReportDataGenerator();
                Book book = spreadDataGenerator.generate(currCalcModel);
                List<Cell> needCacheCellList = book.getSheet().getCellList().stream().filter(item -> item.getCol() >= currCalcModel.getColOffset() && item.getRow() >= currCalcModel.getRowOffset()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(needCacheCellList)) {
                    CellDataSource ds = AnalysisReportManageController.this.getCellDataSource(AnalysisReportManageController.this.view.getPageId());
                    ds.saveMeta(needCacheCellList, CacheCell.getFixReportCachePropList(), currCalcModel);
                }
                AnalysisReportManageController.this.view.refreshBook(book);
                if (reportType.needSaveTemplate()) {
                    AnalysisReportManageController.this.setCache(reportType, data);
                }
            }

            @Override
            public void onOperateError(FpmOperateResult<ReportDataManagerV2> result) {
                super.onOperateError(result);
                AnalysisReportManageController.this.view.rebuildSpreadJs("{}");
                AnalysisReportManageController.this.release();
            }
        });
    }

    @Override
    public void loadSumPlanAnalysisReport(final Long templateId, final AnalysisHeader headerInfo) {
        this.doFormOperate(new AbstractFpmFormOperate<ReportModel>((IFpmFormView)this.view, ResManager.loadKDString((String)"\u52a0\u8f7d\u62a5\u8868", (String)"AnalysisReportManageController_1", (String)"tmc-fpm-business", (Object[])new Object[0])){

            @Override
            public FpmOperateResult<ReportModel> doOperate() {
                String managerJson = AnalysisReportManageController.this.view.getCache().get("sumplanbill_reportdata_manager_cache");
                if (StringUtils.isNotEmpty((CharSequence)managerJson)) {
                    List<ReportTemplate> reportTemplateList = AnalysisReportManageController.this.templateRepository.loadTemplateBak(Collections.singletonList(templateId));
                    ReportTemplate analysisTemplate = reportTemplateList.get(0);
                    if (TemplateType.FIXED == analysisTemplate.getTemplateType()) {
                        ReportDataManagerV2 reportDataManager = (ReportDataManagerV2)FpmSerializeUtil.deserialize((String)managerJson, ReportDataManagerV2.class);
                        ReportTemplate reportTemplate = reportDataManager.getReportTemplate();
                        List<TemplateReportType> reportTypeList = reportTemplate.getReportTypeList();
                        for (TemplateReportType templateReportType : reportTypeList) {
                            templateReportType.setAuxiliaryFieldList(Collections.emptyList());
                        }
                        analysisTemplate.setReportTypeList(reportTemplate.getReportTypeList());
                        return AnalysisReportManageController.this.service.loadSumPlanAnalysisReportModel(analysisTemplate, headerInfo);
                    }
                    return AnalysisReportManageController.this.service.loadSumPlanDetailAnalysisReportModel(analysisTemplate, headerInfo);
                }
                List<ReportTemplate> reportTemplateList = AnalysisReportManageController.this.templateRepository.loadTemplateBak(Collections.singletonList(templateId));
                return AnalysisReportManageController.this.service.loadSumPlanAnalysisReportModel(reportTemplateList.get(0), headerInfo);
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<ReportModel> result) {
                super.onOperateSuccess(result);
                ReportModel data = result.getData();
                IReportSpreadDataGenerator spreadDataGenerator = SpreadDataGeneratorFactory.createReportDataGenerator();
                Book book = spreadDataGenerator.generate(data.getReportCalcModelList().get(0));
                AnalysisReportManageController.this.view.refreshAnalysisBook(book);
                AnalysisReportManageController.this.renderCellStyle(book.getSheet().getCellList());
            }
        });
    }

    @Override
    public void loadAnalysisTemplate(final Long templateId) {
        this.doFormOperate(new AbstractFpmFormOperate<ReportTemplate>((IFpmFormView)this.view, ResManager.loadKDString((String)"\u52a0\u8f7d\u6a21\u677f", (String)"AnalysisReportManageController_2", (String)"tmc-fpm-business", (Object[])new Object[0])){

            @Override
            public FpmOperateResult<ReportTemplate> doOperate() {
                return AnalysisReportManageController.this.service.loadAnalysisTemplate(templateId);
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<ReportTemplate> result) {
                ReportTemplate template = result.getData();
                AnalysisReportManageController.this.view.initAnalysisTpl(template);
            }
        });
    }

    @Override
    public void loadSumPlanSubReport(final AnalysisHeader headerInfo) {
        this.doFormOperate(new AbstractFpmFormOperate<ReportModel>((IFpmFormView)this.view, ResManager.loadKDString((String)"\u52a0\u8f7d\u62a5\u8868", (String)"AnalysisReportManageController_3", (String)"tmc-fpm-business", (Object[])new Object[0])){

            @Override
            public FpmOperateResult<ReportModel> doOperate() {
                FpmPageCacheService cacheService = new FpmPageCacheService(AnalysisReportManageController.this.view.getCache().getPageId());
                AnalysisReportManageController.this.view.getCache().getAll().forEach((k, v) -> cacheService.put((String)k, (String)v));
                return AnalysisReportManageController.this.service.loadSumPlanSubReportReport(headerInfo, cacheService);
            }

            @Override
            public void onOperateSuccess(FpmOperateResult<ReportModel> result) {
                super.onOperateSuccess(result);
                ReportModel data = result.getData();
                IReportSpreadDataGenerator spreadDataGenerator = SpreadDataGeneratorFactory.createReportDataGenerator();
                Book book = spreadDataGenerator.generate(data.getReportCalcModelList().get(0));
                ReportCalcModel calcModel = data.getReportCalcModelList().get(0);
                List<Cell> needCacheCellList = book.getSheet().getCellList().stream().filter(item -> item.getCol() >= calcModel.getColOffset() && item.getRow() >= calcModel.getRowOffset()).collect(Collectors.toList());
                CellDataSource ds = AnalysisReportManageController.this.getCellDataSource(AnalysisReportManageController.this.view.getPageId());
                ds.saveMeta(needCacheCellList, CacheCell.getFixReportCachePropList(), calcModel);
                AnalysisReportManageController.this.view.refreshBook(book);
            }
        });
    }

    private void setCache(AnalysisReportType reportType, IReportDataManagerV2 manager) {
        String managerJson = FpmSerializeUtil.serialize((Object)manager);
        String jsonKey = String.format("%s_analysereportdatamanager_cache", reportType.getNumber());
        this.view.getCache().put(jsonKey, managerJson);
    }

    @Override
    public void release() {
        this.release(this.view.getPageId());
    }
}

